/*
 * Decompiled with CFR 0.152.
 */
package tdg.draw;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import tdg.Perspective;
import tdg.VC;
import tdg.draw.FillObj;
import tdg.draw.TextStyleObj;

public abstract class FillSfxObj
extends FillObj {
    public Image createOvalMask(Component c, Rectangle r) {
        Perspective persp = (Perspective)c;
        Image img = persp.createOffscreenImage(r.width, r.height);
        Graphics gos = img.getGraphics();
        gos.setColor(new Color(0, 0, 0));
        gos.fillRect(0, 0, r.width, r.height);
        gos.setColor(new Color(255, 255, 255));
        gos.fillOval(0, 0, r.width, r.height);
        gos.dispose();
        return img;
    }

    protected Image createPolygonMask(Component c, Polygon poly) {
        Perspective persp = (Perspective)c;
        Rectangle r = poly.getBounds();
        Image img = persp.createOffscreenImage(r.width, r.height);
        Graphics gos = img.getGraphics();
        gos.setColor(new Color(0, 0, 0));
        gos.fillRect(0, 0, r.width, r.height);
        gos.setColor(new Color(255, 255, 255));
        int[] xxpoints = new int[poly.npoints];
        int[] yypoints = new int[poly.npoints];
        int i = 0;
        while (i < poly.npoints) {
            xxpoints[i] = poly.xpoints[i] - r.x;
            yypoints[i] = poly.ypoints[i] - r.y;
            ++i;
        }
        gos.fillPolygon(xxpoints, yypoints, poly.npoints);
        gos.dispose();
        return img;
    }

    protected Image createAreaMask(Component c, Area area) {
        Perspective persp = (Perspective)c;
        Rectangle r = area.getBounds();
        BufferedImage img = (BufferedImage)persp.createOffscreenImage(r.width, r.height);
        Graphics2D gos = (Graphics2D)img.getGraphics();
        gos.setColor(new Color(0, 0, 0));
        gos.fillRect(0, 0, r.width, r.height);
        gos.setColor(new Color(255, 255, 255));
        AffineTransform transform = new AffineTransform();
        transform.translate(-r.x, -r.y);
        area = area.createTransformedArea(transform);
        gos.fill(area);
        gos.dispose();
        return img;
    }

    protected Image createGeneralPathMask(Component c, GeneralPath path) {
        Perspective persp = (Perspective)c;
        Rectangle r = path.getBounds();
        BufferedImage img = (BufferedImage)persp.createOffscreenImage(r.width, r.height);
        Graphics2D gos = (Graphics2D)img.getGraphics();
        gos.setColor(new Color(0, 0, 0));
        gos.fillRect(0, 0, r.width, r.height);
        gos.setColor(new Color(255, 255, 255));
        AffineTransform transform = new AffineTransform();
        transform.translate(-r.x, -r.y);
        path.transform(transform);
        gos.fill(path);
        gos.dispose();
        transform = new AffineTransform();
        transform.translate(r.x, r.y);
        path.transform(transform);
        return img;
    }

    public Image createTextMask(Component c, String szText, Rectangle rBounds, TextStyleObj textStyle, VC vc) {
        Perspective persp = (Perspective)c;
        Image img = persp.createOffscreenImage(rBounds.width, rBounds.height);
        return img;
    }

    private void fillClip(Graphics g, Component c, Image img, Image imgMask, Rectangle r) {
        this.applyFilter(g, c, img, imgMask, r, r, null);
    }

    public void fillOval(Graphics g, Component c, int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        Perspective persp = (Perspective)c;
        Rectangle r = new Rectangle(x, y, width, height);
        Image img = persp.createOffscreenImage(r.width, r.height);
        Graphics gos = img.getGraphics();
        this.fillSfxRect(gos, c, 0, 0, r.width, r.height);
        gos.dispose();
        this.applyFilter(g, c, img, this.createOvalMask(c, r), r, r, null);
        img.flush();
    }

    public void fillPolygon(Graphics g, Component c, Polygon p) {
        this.fillPolygon(g, c, p.xpoints, p.ypoints, p.npoints);
    }

    public void fillPolygon(Graphics g, Component c, GeneralPath p) {
        Rectangle r = p.getBounds();
        if (r.width <= 0 || r.height <= 0) {
            return;
        }
        Perspective persp = (Perspective)c;
        Image img = persp.createOffscreenImage(r.width, r.height);
        Graphics gos = img.getGraphics();
        this.fillSfxRect(gos, c, 0, 0, r.width, r.height);
        gos.dispose();
        this.applyFilter(g, c, img, this.createGeneralPathMask(c, p), r, r, null);
        img.flush();
    }

    public void fillPolygon(Graphics g, Component c, Area area) {
        Rectangle r = area.getBounds();
        if (r.width <= 0 || r.height <= 0) {
            return;
        }
        Perspective persp = (Perspective)c;
        Image img = persp.createOffscreenImage(r.width, r.height);
        Graphics gos = img.getGraphics();
        this.fillSfxRect(gos, c, 0, 0, r.width, r.height);
        gos.dispose();
        this.applyFilter(g, c, img, this.createAreaMask(c, area), r, r, null);
        img.flush();
    }

    public void fillPolygon(Graphics g, Component c, int[] nXPoints, int[] nYPoints, int nPoints) {
        Polygon poly = new Polygon(nXPoints, nYPoints, nPoints);
        Rectangle r = poly.getBounds();
        if (r.width <= 0 || r.height <= 0) {
            return;
        }
        Perspective persp = (Perspective)c;
        Image img = persp.createOffscreenImage(r.width, r.height);
        Graphics gos = img.getGraphics();
        this.fillSfxRect(gos, c, 0, 0, r.width, r.height);
        gos.dispose();
        this.applyFilter(g, c, img, this.createPolygonMask(c, poly), r, r, null);
        img.flush();
    }

    public void fillRect(Graphics g, Component c, int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        Perspective persp = (Perspective)c;
        Image img = persp.createOffscreenImage(width, height);
        Graphics gos = img.getGraphics();
        this.fillSfxRect(gos, c, 0, 0, width, height);
        gos.dispose();
        g.drawImage(img, x, y, null);
        img.flush();
    }

    public void fillShadedPolygon(Graphics g, Component c, int[] nXPoints, int[] nYPoints, int nPoints, int nShading) {
        this.fillPolygon(g, c, nXPoints, nYPoints, nPoints);
    }

    public abstract void copy(FillObj var1);

    protected abstract void fillSfxRect(Graphics var1, Component var2, int var3, int var4, int var5, int var6);
}

