/*
 * Decompiled with CFR 0.152.
 */
package tdg.draw;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import tdg.VC;
import tdg.draw.BlackBoxIF;
import tdg.draw.DetObj;
import tdg.draw.Detectiv;
import tdg.draw.IdentObj;
import tdg.draw.TextStyleObj;

public class DetLabel
extends DetObj {
    private Rectangle m_rBounds;
    private TextStyleObj m_TextStyle;
    private String m_szText;

    public DetLabel(Detectiv m_Detectiv, IdentObj id, String szText, Rectangle rBounds, TextStyleObj textStyle, BlackBoxIF blackBox) {
        this(m_Detectiv, id, szText, rBounds, textStyle, blackBox, false, true);
    }

    public DetLabel(Detectiv m_Detectiv, IdentObj id, String szText, Rectangle rBounds, TextStyleObj textStyle, BlackBoxIF blackBox, boolean bMoveable) {
        this(m_Detectiv, id, szText, rBounds, textStyle, blackBox, bMoveable, true);
    }

    public DetLabel(Detectiv m_Detectiv, IdentObj id, String szText, Rectangle rBounds, TextStyleObj textStyle, BlackBoxIF blackBox, boolean bMoveable, Rectangle rClip) {
        super(m_Detectiv, id, blackBox, rClip, bMoveable, true, true);
        this.m_rBounds = new Rectangle(rBounds.x, rBounds.y, rBounds.width, rBounds.height);
        this.m_TextStyle = new TextStyleObj(textStyle);
        this.m_szText = szText;
    }

    public DetLabel(Detectiv m_Detectiv, IdentObj id, String szText, Rectangle rBounds, TextStyleObj textStyle, BlackBoxIF blackBox, boolean bMoveable, boolean bDetectable) {
        super(m_Detectiv, id, blackBox, null, bMoveable, bDetectable, true);
        this.m_rBounds = new Rectangle(rBounds.x, rBounds.y, rBounds.width, rBounds.height);
        this.m_TextStyle = new TextStyleObj(textStyle);
        this.m_szText = szText;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DetLabel)) {
            return false;
        }
        DetLabel detLabel = (DetLabel)obj;
        return this.m_id.equals(detLabel.m_id);
    }

    public Rectangle getBounds() {
        return this.m_rBounds;
    }

    public String getLabelString() {
        return this.m_szText;
    }

    public void hilite(Graphics g, VC vc) {
        Rectangle dest = vc.virtToDest(this.m_rBounds);
        g.setXORMode(Color.yellow);
        g.drawRect(dest.x, dest.y, dest.width, dest.height);
        g.setPaintMode();
    }

    public boolean isPointInObj(int x, int y, VC vc) {
        return this.m_bDetectable && this.m_rBounds.contains(x, y);
    }

    public boolean isPointInObj(Point pt, VC vc) {
        return this.isPointInObj(pt.x, pt.y, vc);
    }

    public void paintIt(Graphics g, VC vc) {
        if (this.m_szText.length() > 0) {
            Rectangle rDest = vc.virtToDest(this.m_rBounds);
            this.m_blackBox.paint(g, this.m_szText, rDest, this.m_TextStyle, vc);
        }
    }

    public void setBounds(Rectangle rBounds) {
        this.m_rBounds = rBounds;
    }

    public Polygon getShape(VC vc) {
        return this.rectToPoly(this.m_rBounds);
    }
}

