/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import tdg.Assert;
import tdg.Perspective;
import tdg.draw.DetObj;
import tdg.draw.IdentObj;

public class ScrollLegend
implements Serializable {
    protected Perspective m_Perspective;
    protected Point m_ptScrollRect = null;
    public Rectangle m_rOldScroll = null;

    public ScrollLegend(Perspective perspective) {
        this.m_Perspective = perspective;
    }

    public void mousePressedScroll(Point ptPressed) {
        this.m_ptScrollRect = ptPressed;
        this.m_rOldScroll = null;
    }

    public void drawScroller(Graphics gx) {
        gx.setXORMode(Color.yellow);
        if (this.m_rOldScroll != null) {
            gx.drawRect(this.m_rOldScroll.x, this.m_rOldScroll.y, this.m_rOldScroll.width, this.m_rOldScroll.height);
        }
        gx.setPaintMode();
    }

    public void mouseReleasedScroll(MouseEvent evt, int obj, Graphics g) {
        if (obj == 66) {
            Rectangle rScroller = this.m_Perspective.m_VC.virtToDest(this.m_Perspective.getRect(this.m_Perspective.getLegendScroller()));
            this.drawScroller(g);
            if (this.m_rOldScroll != null) {
                int nNumItemsInLegend;
                boolean bHorz = this.m_Perspective.m_chart.m_Legend.isHorz();
                double fRatio = bHorz ? (double)(this.m_rOldScroll.y - rScroller.y) / (double)(rScroller.height - this.m_rOldScroll.height) : (double)(this.m_rOldScroll.x - rScroller.x) / (double)(rScroller.width - this.m_rOldScroll.width);
                int nStart = (int)Math.round(fRatio * (double)((nNumItemsInLegend = this.m_Perspective.m_chart.m_Legend.getNumItemsInLegend()) - this.m_Perspective.getLegendSeriesCount()));
                if (nStart < 0) {
                    nStart = 0;
                }
                this.m_Perspective.setLegendSeriesStart(nStart);
            }
            this.m_rOldScroll = null;
        }
    }

    public void mouseDraggedScroll(MouseEvent evt, IdentObj id, Graphics g) {
        int obj;
        int n = obj = id == null ? -3 : id.getObjectID();
        if (id.isLegendScrollerThumb()) {
            DetObj aDetObj = this.m_Perspective.m_selList.firstDetObjElement();
            Assert.assert(aDetObj);
            Rectangle rThumb = this.m_Perspective.m_VC.virtToDest(aDetObj.getBounds());
            Rectangle rScroller = this.m_Perspective.m_VC.virtToDest(this.m_Perspective.getRect(this.m_Perspective.getLegendScroller()));
            Point newPoint = new Point(evt.getX(), evt.getY());
            boolean bHorz = this.m_Perspective.m_chart.m_Legend.isHorz();
            if (bHorz) {
                int dy = newPoint.y - this.m_ptScrollRect.y;
                rThumb.y += dy;
                if (rThumb.y < rScroller.y) {
                    rThumb.y = rScroller.y;
                } else if (rThumb.y + rThumb.height > rScroller.y + rScroller.height) {
                    rThumb.y = rScroller.y + rScroller.height - rThumb.height;
                }
            } else {
                int dx = newPoint.x - this.m_ptScrollRect.x;
                rThumb.x += dx;
                if (rThumb.x < rScroller.x) {
                    rThumb.x = rScroller.x;
                } else if (rThumb.x + rThumb.width > rScroller.x + rScroller.width) {
                    rThumb.x = rScroller.x + rScroller.width - rThumb.width;
                }
            }
            g.setXORMode(Color.yellow);
            if (this.m_rOldScroll != null) {
                g.drawRect(this.m_rOldScroll.x, this.m_rOldScroll.y, this.m_rOldScroll.width, this.m_rOldScroll.height);
            }
            g.drawRect(rThumb.x, rThumb.y, rThumb.width, rThumb.height);
            g.setPaintMode();
            this.m_rOldScroll = rThumb;
        }
    }

    public boolean keyEditOfVDR(int nKeyCode) {
        boolean bHandled = false;
        switch (nKeyCode) {
            case 37: 
            case 38: {
                this.decrementScrollOffset();
                bHandled = true;
                break;
            }
            case 39: 
            case 40: {
                this.incrementScrollOffset();
                bHandled = true;
            }
        }
        return bHandled;
    }

    private void decrementScrollOffset() {
        if (this.m_Perspective.getLegendSeriesStart() > 0) {
            int nStart = this.m_Perspective.getLegendSeriesStart() - 1;
            if (nStart < 0) {
                nStart = 0;
            }
            this.m_Perspective.setLegendSeriesStart(nStart);
        }
    }

    private void incrementScrollOffset() {
        int nNumItemsInLegend;
        int nViewableSeries;
        int nSeriesOffset = this.m_Perspective.getLegendSeriesStart();
        if (nSeriesOffset + (nViewableSeries = this.m_Perspective.getLegendSeriesCount()) < (nNumItemsInLegend = this.m_Perspective.m_chart.m_Legend.getNumItemsInLegend())) {
            int nStart = nSeriesOffset + 1;
            if (nStart < 0) {
                nStart = 0;
            }
            this.m_Perspective.setLegendSeriesStart(nStart);
        }
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }
}

