/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Vector;
import tdg.Access;
import tdg.Assert;
import tdg.JChart_2D_Pie;
import tdg.JChart_Base;
import tdg.JGraphType;
import tdg.LegendObj;
import tdg.MarkerObj;
import tdg.MarkerTemplate;
import tdg.MarkerTemplateArray;
import tdg.Perspective;
import tdg.ReferenceLineObj;
import tdg.RelativeAxisObj;
import tdg.SeriesEnumerator;
import tdg.draw.BlackBoxIF;
import tdg.draw.BlackBoxObj;
import tdg.draw.DetLabel;
import tdg.draw.DetRect;
import tdg.draw.Detectiv;
import tdg.draw.IdentObj;
import tdg.draw.TextStyleObj;

public class LegendMarkersLabels
implements Serializable {
    public static final int LEFT_OF_TEXT = 0;
    public static final int RIGHT_OF_TEXT = 1;
    public static final int ABOVE_TEXT = 2;
    public static final int BELOW_TEXT = 3;
    public static final int UNDER_TEXT = 4;
    public static final boolean LEFT_TO_RIGHT = false;
    public static final boolean RIGHT_TO_LEFT = true;
    public int MKR_MARGIN;
    public int MIN_V_GAP;
    public int MIN_H_GAP;
    public int DOUBLE_MKR_MARGIN;
    protected static final int MIN_LABEL_HEIGHT = 1000;
    protected static final int ACCEPTABLE_TEXT_HEIGHT = 2000;
    protected static final int MIN_WIDTH_FOR_TEXT = 400;
    protected static final int MIN_HEIGHT_FOR_TEXT = 200;
    protected Perspective m_Perspective;
    protected Detectiv m_Detectiv;
    protected JChart_Base m_Chart;
    protected LegendObj m_Legend;
    protected Access m_Access;
    protected boolean m_nBiDirectionalText;
    protected Dimension m_dimMarkerCell;
    protected Dimension m_dimLabelCell;
    protected Vector m_vectStrLabels;
    protected Vector m_vectLabelID;
    protected Vector m_vectMarkerID;
    protected Vector m_vectMarkerTemplate;
    protected Vector m_vectMarkerBlackBox;
    RelativeAxisObj m_axis;
    protected boolean m_bTextAutofit;
    protected String m_szFontName;
    protected int m_nFontStyle;
    protected int m_nFontSize;
    protected int m_nFontSizeVC;
    protected int m_nMarkerPos;
    protected boolean m_bLabelsExist;
    protected TextStyleObj m_textStyle;
    protected int m_nMarkerSizePercentX;
    protected int m_nMarkerSizePercentY;
    protected boolean m_labelsTruncated = false;
    protected boolean m_drawLabels = true;
    protected boolean m_truncateTSO = false;
    protected int m_stopAtLine = -1;
    protected static final int markerMargin = 3;
    protected static final int minMarkerGap = 1;

    public LegendMarkersLabels(Perspective perspective, Access access, JChart_Base chart, LegendObj legend) {
        this.m_Perspective = perspective;
        this.m_Access = access;
        this.m_Chart = chart;
        this.m_Detectiv = this.m_Perspective.getDetectiv();
        this.m_Legend = legend;
        this.MKR_MARGIN = this.m_Perspective.getVC().destToVirtWidth(3);
        this.MIN_V_GAP = this.m_Perspective.getVC().destToVirtHeight(1);
        this.MIN_H_GAP = this.m_Perspective.getVC().destToVirtWidth(1);
        this.DOUBLE_MKR_MARGIN = 2 * this.MKR_MARGIN;
    }

    public void init() {
        this.initVectors(0);
        this.m_nMarkerPos = this.m_Perspective.getLegendMarkerPosition();
        this.m_nBiDirectionalText = this.m_Perspective.getBiDirectional();
        if (this.m_nBiDirectionalText) {
            if (this.m_nMarkerPos == 0) {
                this.m_nMarkerPos = 1;
            } else if (this.m_nMarkerPos == 1) {
                this.m_nMarkerPos = 0;
            }
        }
        this.m_bTextAutofit = this.m_Perspective.getLegendTextAutofit();
        IdentObj idLegendText = new IdentObj(14, 0);
        boolean bLegendFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(this.m_Perspective.getLegendText());
        if (bLegendFontSizeAbsolute) {
            this.m_nFontSize = this.m_Perspective.getFontSize(idLegendText);
            this.m_nFontSizeVC = this.m_Perspective.m_VC.destToVirtHeight(this.m_nFontSize);
        } else {
            this.m_nFontSizeVC = this.m_Perspective.getFontSizeVC(idLegendText);
            this.m_nFontSize = this.m_Perspective.m_VC.virtToDestHeight(this.m_nFontSizeVC);
        }
        this.m_nFontStyle = this.m_Perspective.getFontStyle(idLegendText);
        this.m_szFontName = this.m_Perspective.getFontName(idLegendText);
        this.m_textStyle = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_szFontName, this.m_nFontStyle, bLegendFontSizeAbsolute, this.m_nFontSize, this.m_nFontSizeVC, this.m_Perspective.getTextRotation(idLegendText), this.m_Perspective.getTextJustHoriz(idLegendText), this.m_Perspective.getTextJustVert(idLegendText), false, false, this.m_Perspective.getTextWrap(idLegendText));
        if (this.m_Perspective.getTextWrap(idLegendText)) {
            this.m_textStyle.setLegendTruncate(this.m_truncateTSO, this.m_stopAtLine);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void calcLabels() {
        block8: {
            block7: {
                if (!this.m_bLabelsExist || !this.m_drawLabels) break block7;
                id = new IdentObj(14);
                blackBoxLabel = new BlackBoxObj(this.m_Perspective, id);
                nSeriesStart = this.m_Legend.getSeriesStart();
                nSeriesRange = this.m_Legend.getSeriesRange();
                nCell = 0;
                idLgText = this.m_Perspective.getLegendText();
                fontSize = this.m_Perspective.getFontSizeAbsolute(idLgText) == false ? this.m_Perspective.getVC().virtToDestHeight(this.m_Perspective.getFontSizeVC(idLgText)) : this.m_Perspective.getFontSize(idLgText);
                fontStyle = TextStyleObj.getJavaFontStyle(this.m_Perspective.getFontStyle(idLgText));
                fontName = this.m_Perspective.getFontName(idLgText);
                g = this.m_Perspective.getGraphicsContext();
                font = new Font(fontName, fontStyle, fontSize);
                fm = g.getFontMetrics(font);
                v0 = truncate = this.m_Perspective.getTextWrap(idLgText) == false;
                if (!this.m_Perspective.getFontSizeAbsolute(idLgText) && this.m_Perspective.getLegendTextAutofit()) {
                    truncate = false;
                }
                this.m_labelsTruncated = false;
                nLabel = nSeriesStart;
                while (nLabel < nSeriesRange) {
                    szLabel = (String)this.m_vectStrLabels.elementAt(nLabel);
                    idLegendText = (IdentObj)this.m_vectLabelID.elementAt(nLabel);
                    rCell = this.m_Legend.getCellRect(nCell);
                    rLabel = this.calcLabelRect(rCell);
                    ++nCell;
                    if (truncate && fm != null && szLabel != null && rLabel.width < this.m_Perspective.m_VC.destToVirtWidth(fm.stringWidth(szLabel))) {
                        this.m_labelsTruncated = true;
                        szLabel = rLabel.width < 0 ? "" : TextStyleObj.truncateText(szLabel, fm, 2, this.m_Perspective.m_VC.virtToDestWidth(rLabel.width));
                    }
                    if (!truncate && !this.m_labelsTruncated) {
                        strs = new Vector<E>();
                        this.m_textStyle.extractLinesWordWrap(szLabel, strs, this.m_Perspective.m_VC.virtToDestWidth(rLabel.width), fm);
                        if (this.m_textStyle.isLegendTruncated()) {
                            this.m_labelsTruncated = true;
                        }
                    }
                    if (nLabel != nSeriesStart) ** GOTO lbl-1000
                    idText = new IdentObj(235);
                    if (this.m_Perspective.getDrillCallback().isDrillingEnabled() && this.m_Perspective.getTextString(idText) != null && this.m_Perspective.getDisplay(idText)) {
                        oldStyle = style = this.m_textStyle.getFontStyle();
                        this.m_textStyle.setFontStyle(style |= 4);
                        new DetLabel(this.m_Detectiv, idLegendText, szLabel, rLabel, this.m_textStyle, blackBoxLabel, false);
                        this.m_textStyle.setFontStyle(oldStyle);
                    } else lbl-1000:
                    // 2 sources

                    {
                        new DetLabel(this.m_Detectiv, idLegendText, szLabel, rLabel, this.m_textStyle, blackBoxLabel, false);
                    }
                    ++nLabel;
                }
                break block8;
            }
            this.m_labelsTruncated = true;
        }
    }

    public void calcMarkers() {
        int nSeriesStart = this.m_Legend.getSeriesStart();
        int nSeriesRange = this.m_Legend.getSeriesRange();
        int nCell = 0;
        int nMarker = nSeriesStart;
        while (nMarker < nSeriesRange) {
            IdentObj idLegendMarker = (IdentObj)this.m_vectMarkerID.elementAt(nMarker);
            MarkerTemplate markerTemplate = (MarkerTemplate)this.m_vectMarkerTemplate.elementAt(nMarker);
            BlackBoxIF blackBox = (BlackBoxIF)this.m_vectMarkerBlackBox.elementAt(nMarker);
            this.calcOneMarker(nCell, idLegendMarker, markerTemplate, blackBox, nMarker);
            ++nCell;
            ++nMarker;
        }
    }

    protected void calcOneMarker(int nCell, IdentObj id, MarkerTemplate markerTemplate, BlackBoxIF blackBox, int nMarker) {
        Rectangle rCell = this.m_Legend.getCellRect(nCell);
        Rectangle rMarker = this.calcMarkerRect(rCell);
        if (this.m_nMarkerPos == 4) {
            new DetRect(this.m_Detectiv, id, rMarker.x, rMarker.y, rMarker.width, rMarker.height, blackBox);
        } else {
            MarkerObj dline;
            if (markerTemplate.getMarkerType() == 4) {
                blackBox.setBorderColor(markerTemplate.getLineColor());
            }
            int nXCenter = rMarker.x + rMarker.width / 2;
            int nYCenter = rMarker.y + rMarker.height / 2;
            Point ptCenter = new Point(nXCenter, nYCenter);
            if (markerTemplate.getMarkerType() == 8) {
                IdentObj idMarker = new IdentObj(234);
                dline = new MarkerObj(this.m_Detectiv, idMarker, markerTemplate, ptCenter, this.m_nMarkerSizePercentX, this.m_nMarkerSizePercentY, blackBox, null, false);
            } else {
                dline = new MarkerObj(this.m_Detectiv, id, markerTemplate, ptCenter, this.m_nMarkerSizePercentX, this.m_nMarkerSizePercentY, blackBox, null, false);
            }
            if (markerTemplate.getMarkerType() == 4) {
                String szLabel = (String)this.m_vectStrLabels.elementAt(nMarker);
                dline.setReferenceLabel(szLabel);
            }
        }
    }

    protected void calcMarkerSize() {
        int markerSize = this.m_Perspective.getLegendMarkerSize();
        int nMaxMarkerWidthVC = this.m_Perspective.m_VC.destToVirtWidth(markerSize);
        int nMaxMarkerHeightVC = this.m_Perspective.m_VC.destToVirtHeight(markerSize);
        Rectangle rMarkerCell = new Rectangle(MarkerTemplate.MARKER_SQUARE);
        rMarkerCell.width = nMaxMarkerWidthVC;
        rMarkerCell.height = nMaxMarkerHeightVC;
        this.m_dimMarkerCell = new Dimension(rMarkerCell.width, rMarkerCell.height);
        Dimension dimCell = this.m_Legend.getDimCell();
        int maxHeight = dimCell.height;
        if (this.m_nMarkerPos == 2 || this.m_nMarkerPos == 3) {
            maxHeight = dimCell.height / 2;
        }
        if (rMarkerCell.height + this.MIN_V_GAP > maxHeight) {
            rMarkerCell.height = maxHeight;
            if (rMarkerCell.height > 2 * this.MIN_V_GAP) {
                rMarkerCell.height = maxHeight - this.MIN_V_GAP;
            }
            int markerH = this.m_Perspective.m_VC.virtToDestHeight(rMarkerCell.height);
            rMarkerCell.width = this.m_Perspective.m_VC.destToVirtWidth(markerH);
        }
        if (rMarkerCell.width + this.MIN_H_GAP > dimCell.width) {
            rMarkerCell.width = dimCell.width;
            if (rMarkerCell.width > 2 * this.MIN_H_GAP) {
                rMarkerCell.width = dimCell.width - this.MIN_H_GAP;
            }
            int markerW = this.m_Perspective.m_VC.virtToDestWidth(rMarkerCell.width);
            rMarkerCell.height = this.m_Perspective.m_VC.destToVirtHeight(markerW);
        }
        switch (this.m_nMarkerPos) {
            case 2: 
            case 3: {
                this.m_dimMarkerCell = new Dimension(dimCell.width, dimCell.height / 2);
                break;
            }
            case 0: 
            case 1: {
                this.m_dimMarkerCell = new Dimension(rMarkerCell.width, rMarkerCell.height);
                break;
            }
            default: {
                this.m_dimMarkerCell = new Dimension(dimCell);
            }
        }
        this.calcMarkerSizePercent(rMarkerCell);
    }

    public void calcMarkerSizePercent(Rectangle rMarkerCell) {
        boolean bSquareMarkers;
        Rectangle rDefaultMarkerCell = new Rectangle(MarkerTemplate.MARKER_SQUARE);
        double fWidthPercent = rMarkerCell.width;
        fWidthPercent /= (double)rDefaultMarkerCell.width;
        this.m_nMarkerSizePercentX = (int)(fWidthPercent *= 100.0);
        double fHeightPercent = rMarkerCell.height;
        fHeightPercent /= (double)rDefaultMarkerCell.height;
        this.m_nMarkerSizePercentY = (int)(fHeightPercent *= 100.0);
        if (this.m_nMarkerSizePercentX < 1) {
            this.m_nMarkerSizePercentX = 1;
        }
        if (this.m_nMarkerSizePercentY < 1) {
            this.m_nMarkerSizePercentY = 1;
        }
        if ((bSquareMarkers = this.m_Perspective.getSquareMarkers()) && this.m_nMarkerPos != 4) {
            double fDestY;
            double fDestX = this.m_Perspective.m_VC.virtToDestWidth((double)this.m_nMarkerSizePercentX);
            if (fDestX > (fDestY = this.m_Perspective.m_VC.virtToDestHeight((double)this.m_nMarkerSizePercentY))) {
                this.m_nMarkerSizePercentX = (int)((double)this.m_nMarkerSizePercentX * fDestY / fDestX);
            } else {
                this.m_nMarkerSizePercentY = (int)((double)this.m_nMarkerSizePercentY * fDestX / fDestY);
            }
            if (this.m_nMarkerSizePercentX < 1) {
                this.m_nMarkerSizePercentX = 1;
            }
            if (this.m_nMarkerSizePercentY < 1) {
                this.m_nMarkerSizePercentY = 1;
            }
        }
    }

    public Rectangle calcMarkerRect(Rectangle rCell) {
        Dimension dimCell = this.m_Legend.getDimCell();
        Point ptOffsets = this.calcMarkerOffsets();
        int nDx = rCell.x + ptOffsets.x;
        int nDy = rCell.y + ptOffsets.y;
        Rectangle rMarker = new Rectangle(this.m_dimMarkerCell);
        rMarker.translate(nDx, nDy);
        return rMarker;
    }

    public Point calcMarkerOffsets() {
        Dimension dimCell = this.m_Legend.getDimCell();
        int nXMarkerOffset = 0;
        int nYMarkerOffset = (dimCell.height - this.m_dimMarkerCell.height) / 2;
        if (nYMarkerOffset < 0) {
            nYMarkerOffset = 0;
        }
        if (this.m_bLabelsExist) {
            switch (this.m_nMarkerPos) {
                default: {
                    break;
                }
                case 1: {
                    nXMarkerOffset = this.m_dimLabelCell.width + this.MKR_MARGIN;
                    break;
                }
                case 2: {
                    nYMarkerOffset = this.m_dimMarkerCell.height;
                    break;
                }
                case 3: {
                    nYMarkerOffset = (dimCell.height / 2 - this.m_dimMarkerCell.height) / 2;
                }
                case 4: 
            }
            Assert.assert(nXMarkerOffset >= 0);
            Assert.assert(nYMarkerOffset >= 0);
        }
        return new Point(nXMarkerOffset, nYMarkerOffset);
    }

    public void setTruncateLabelsInTSO(boolean trunc, int stopAtLine) {
        this.m_truncateTSO = trunc;
        this.m_stopAtLine = stopAtLine;
    }

    public void setDrawLabels(boolean draw) {
        this.m_drawLabels = draw;
    }

    public boolean isLabelsTruncated() {
        return this.m_labelsTruncated;
    }

    protected void calcLabelSize() {
        Dimension dimCell = this.m_Legend.getDimCell();
        if (dimCell.width < this.DOUBLE_MKR_MARGIN || dimCell.height < 200) {
            this.m_bLabelsExist = false;
        } else {
            switch (this.m_nMarkerPos) {
                default: {
                    int nWidth = dimCell.width - this.m_dimMarkerCell.width - this.DOUBLE_MKR_MARGIN;
                    if (nWidth <= 0) {
                        nWidth = 0;
                        this.m_bLabelsExist = false;
                    }
                    this.m_dimLabelCell = new Dimension(nWidth, dimCell.height);
                    if (!this.m_nBiDirectionalText) break;
                    switch (this.m_textStyle.getHorizAlign()) {
                        case 0: {
                            this.m_textStyle.setHorizAlign(2);
                            break;
                        }
                        case 2: {
                            this.m_textStyle.setHorizAlign(0);
                        }
                    }
                    break;
                }
                case 2: 
                case 3: {
                    this.m_dimLabelCell = new Dimension(dimCell.width - this.DOUBLE_MKR_MARGIN, dimCell.height / 2);
                    break;
                }
                case 4: {
                    this.m_dimLabelCell = new Dimension(dimCell.width - this.DOUBLE_MKR_MARGIN, dimCell.height);
                }
            }
            Vector<String> m_szLargeDummyLabels = new Vector<String>(1);
            m_szLargeDummyLabels.addElement("THIS IS A VERY VERY LONG DUMMY LABEL SO THE TEXT BOXSIZE FOR THE LEGEND IS MAXIMIZED");
            Vector szLabelJust = null;
            szLabelJust = this.m_bTextAutofit ? this.m_vectStrLabels : this.m_vectStrLabels;
            Graphics gx = this.m_Perspective.getGraphicsContext();
            this.m_textStyle.formatAndAutofit(gx, this.m_Perspective, this.m_bTextAutofit, this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), this.m_nFontSizeVC, szLabelJust, this.m_dimLabelCell, this.m_Perspective.m_VC);
        }
    }

    private Point calcLabelOffsets() {
        Dimension dimCell = this.m_Legend.getDimCell();
        int nXLabelOffset = (dimCell.width - this.m_dimLabelCell.width) / 2;
        int nYLabelOffset = dimCell.height / 2 - this.m_dimLabelCell.height / 2;
        switch (this.m_nMarkerPos) {
            default: {
                nXLabelOffset = this.m_dimMarkerCell.width + this.MKR_MARGIN;
                break;
            }
            case 1: {
                nXLabelOffset = 0;
                break;
            }
            case 2: {
                nYLabelOffset = (dimCell.height / 2 - this.m_dimLabelCell.height) / 2;
                break;
            }
            case 3: {
                nYLabelOffset = this.m_dimMarkerCell.height;
            }
            case 4: 
        }
        if (nXLabelOffset < 0) {
            nXLabelOffset = 0;
        }
        if (nYLabelOffset < 0) {
            nYLabelOffset = 0;
        }
        return new Point(nXLabelOffset, nYLabelOffset);
    }

    public Rectangle calcLabelRect(Rectangle rCell) {
        Point ptLabelOffset = this.calcLabelOffsets();
        int nDx = rCell.x + ptLabelOffset.x;
        int nDy = rCell.y + ptLabelOffset.y;
        Rectangle rLabel = new Rectangle(this.m_dimLabelCell);
        rLabel.translate(nDx, nDy);
        return rLabel;
    }

    public void initVectors(int nSize) {
        this.m_bLabelsExist = false;
        this.m_vectStrLabels = new Vector(nSize);
        this.m_vectLabelID = new Vector(nSize);
        this.m_vectMarkerID = new Vector(nSize);
        this.m_vectMarkerTemplate = new Vector(nSize);
        this.m_vectMarkerBlackBox = new Vector(nSize);
    }

    public void loadReferenceLineVectors() {
        JGraphType gt = this.m_Perspective.getJGraphType();
        if (!(gt.isBLAType() || gt.isPolar() || gt.isRadarType() || gt.isScatter() || gt.isBubble() || gt.isParetoType())) {
            return;
        }
        Vector rlv = this.m_Perspective.getReferenceLineVector();
        if (rlv != null && !rlv.isEmpty()) {
            int i = 0;
            while (i < rlv.size()) {
                ReferenceLineObj rli = (ReferenceLineObj)rlv.elementAt(i);
                IdentObj idObj = rli.getIdentObj();
                int nIdx = rli.getIndex();
                int axis = rli.getAxisLineObjID();
                if (this.m_Perspective.getDisplay(this.m_Perspective.getReferenceLine(idObj, nIdx)) && rli.IsValidAxis() && this.m_Perspective.getDisplay(this.m_Perspective.getReferenceLineLegendText(idObj, nIdx))) {
                    IdentObj idText = new IdentObj(248, nIdx, axis);
                    idText.setMiscID(i);
                    this.m_vectLabelID.addElement(idText);
                    String szLabel = this.m_Perspective.getTextString(this.m_Perspective.getReferenceLine(idObj, nIdx));
                    this.m_vectStrLabels.addElement(szLabel);
                    IdentObj idLegendMarker = new IdentObj(249, nIdx, axis);
                    idLegendMarker.setMiscID(i);
                    this.m_vectMarkerID.addElement(idLegendMarker);
                    BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, idLegendMarker);
                    Color clr = this.m_Perspective.getFillColor(this.m_Perspective.getReferenceLine(idObj, nIdx));
                    blackBox.setFillColor(clr);
                    this.m_vectMarkerBlackBox.addElement(blackBox);
                    MarkerTemplate markerTemplate = new MarkerTemplate(MarkerTemplate.MARKER_LINE, 4, this.m_Perspective.getLineWidth(this.m_Perspective.getReferenceLine(idObj, nIdx)), clr);
                    int nLineWidth = markerTemplate.getLineWidth();
                    markerTemplate.setLineWidthVC(this.m_Perspective.m_VC.destToVirtWidth(nLineWidth));
                    markerTemplate.setLineStyle(this.m_Perspective.getLineStyle(this.m_Perspective.getReferenceLine(idObj, nIdx)));
                    this.m_vectMarkerTemplate.addElement(markerTemplate);
                }
                ++i;
            }
        }
    }

    public void loadDrillMarker() {
        IdentObj idText = new IdentObj(235);
        if (!this.m_Perspective.getDrillCallback().isDrillingEnabled() || this.m_Perspective.getTextString(idText) == null || !this.m_Perspective.getDisplay(idText)) {
            return;
        }
        this.m_vectLabelID.addElement(idText);
        String szLabel = this.m_Perspective.getTextString(idText);
        this.m_vectStrLabels.addElement(szLabel);
        IdentObj idDrillMarker = new IdentObj(234);
        this.m_vectMarkerID.addElement(idDrillMarker);
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, idDrillMarker);
        this.m_vectMarkerBlackBox.addElement(blackBox);
        MarkerTemplate markerTemplate = new MarkerTemplate(MarkerTemplate.MARKER_SQUARE, 8);
        this.m_vectMarkerTemplate.addElement(markerTemplate);
    }

    public void loadSeriesVectors() {
        boolean bOther = false;
        JChart_2D_Pie chart = null;
        JGraphType gt = this.m_Perspective.getJGraphType();
        if (gt.isPieType()) {
            chart = (JChart_2D_Pie)this.m_Chart;
            bOther = chart.getOtherPercentageFlag();
        }
        boolean bReverseSeries = this.m_Perspective.getReverseSeries();
        boolean bForwardSeries = this.m_Legend.getLegendReverse() == bReverseSeries;
        int nSeriesLooping = this.m_Perspective.getSeriesLooping();
        SeriesEnumerator sEnum = this.m_Chart.getResetSeriesEnumerator(bForwardSeries);
        while (sEnum.hasMoreElements()) {
            int nSeries = sEnum.nextSeries();
            boolean bDrawSeries = true;
            if (chart != null) {
                boolean bl = bDrawSeries = !chart.isSeriesPartOfOther(nSeries);
            }
            if (!bDrawSeries) continue;
            int nSeriesID = sEnum.seriesAt(nSeries);
            String szLabel = this.m_Perspective.getSeriesLabel(nSeries);
            this.m_vectStrLabels.addElement(szLabel);
            if (szLabel != null && !szLabel.equals("")) {
                this.m_bLabelsExist = true;
            }
            IdentObj idLegendText = new IdentObj(14, nSeriesID);
            this.m_vectLabelID.addElement(idLegendText);
            IdentObj idLegendMarker = new IdentObj(13, nSeriesID);
            this.m_vectMarkerID.addElement(idLegendMarker);
            IdentObj idSeries = new IdentObj(-3, nSeriesID % nSeriesLooping);
            idSeries.setSeriesID(nSeriesID);
            MarkerTemplate markerTemplate = this.getSeriesMarkerTemplate(idSeries);
            if (gt.isBubble() && !this.m_Perspective.getUseDefaultBubbleMarker()) {
                markerTemplate = MarkerTemplateArray.PRESET_CIRCLE;
            }
            this.m_vectMarkerTemplate.addElement(markerTemplate);
            BlackBoxIF blackBox = this.m_Chart.assignSeriesColor(nSeries);
            this.m_vectMarkerBlackBox.addElement(blackBox);
        }
        if (bOther) {
            this.loadPieOtherVectors();
        }
    }

    private void loadPieOtherVectors() {
        String szLabel = this.m_Perspective.PFJRes.getString("OTHER");
        this.m_vectStrLabels.addElement(szLabel);
        IdentObj idLegendText = new IdentObj(14, -1);
        this.m_vectLabelID.addElement(idLegendText);
        IdentObj idSeries = new IdentObj(-3, -1);
        idSeries.setSeriesID(-1);
        MarkerTemplate markerTemplate = this.getSeriesMarkerTemplate(idSeries);
        JGraphType gt = this.m_Perspective.getJGraphType();
        if (gt.isBubble() && !this.m_Perspective.getUseDefaultBubbleMarker()) {
            markerTemplate = MarkerTemplateArray.PRESET_CIRCLE;
        }
        this.m_vectMarkerTemplate.addElement(markerTemplate);
        IdentObj idLegendMarker = new IdentObj(-3, -1);
        this.m_vectMarkerID.addElement(idLegendMarker);
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, idLegendMarker);
        this.m_vectMarkerBlackBox.addElement(blackBox);
        this.m_bLabelsExist = true;
    }

    MarkerTemplate getSeriesMarkerTemplate(IdentObj idSeries) {
        MarkerTemplate markerTemplate = null;
        boolean bUseSeriesShapes = this.m_Perspective.getUseSeriesShapes();
        markerTemplate = bUseSeriesShapes ? (this.m_Perspective.getMarkerShape(idSeries) == 0 ? new MarkerTemplate(MarkerTemplate.MARKER_SQUARE) : this.m_Perspective.getMarkerTemplate(idSeries)) : new MarkerTemplate(MarkerTemplate.MARKER_SQUARE);
        return markerTemplate;
    }

    public void loadSpectralVectors() {
        boolean bExactColor = this.m_Perspective.getExactColorByHeight();
        if (bExactColor) {
            this.m_vectStrLabels = this.m_axis.getNumericLabels();
            int nNumLabels = this.m_vectStrLabels.size();
            int nLabel = 0;
            while (nLabel < nNumLabels) {
                IdentObj idLegendText = new IdentObj(14, nLabel);
                this.m_vectLabelID.addElement(idLegendText);
                ++nLabel;
            }
        } else {
            IdentObj idLegendText;
            String szLabel;
            double fMid;
            double fCurr;
            double fPrev;
            Vector dLabels = this.m_axis.getNumericLabelsAsDouble();
            int nNumLabels = dLabels.size();
            Assert.assert(nNumLabels > 1);
            int nLabel = 0;
            while (nLabel < nNumLabels - 1) {
                fPrev = (Double)dLabels.elementAt(nLabel);
                fCurr = (Double)dLabels.elementAt(nLabel + 1);
                fMid = (fPrev + fCurr) / 2.0;
                if (nLabel == 0) {
                    szLabel = "< " + fMid;
                } else {
                    double fOldPrev = (Double)dLabels.elementAt(nLabel - 1);
                    double fOldMid = (fOldPrev + fPrev) / 2.0;
                    szLabel = fOldMid + " - " + fMid;
                }
                this.m_vectStrLabels.addElement(szLabel);
                idLegendText = new IdentObj(14, nLabel);
                this.m_vectLabelID.addElement(idLegendText);
                ++nLabel;
            }
            fPrev = (Double)dLabels.elementAt(nNumLabels - 2);
            fCurr = (Double)dLabels.elementAt(nNumLabels - 1);
            fMid = (fPrev + fCurr) / 2.0;
            szLabel = "> " + fMid;
            this.m_vectStrLabels.addElement(szLabel);
            idLegendText = new IdentObj(14, nLabel);
            this.m_vectLabelID.addElement(idLegendText);
        }
        this.loadSpectralMarkerVectors();
        if (this.m_vectStrLabels.size() > 0) {
            this.m_bLabelsExist = true;
        }
    }

    public void loadSpectralMarkerVectors() {
        JChart_Base chart = this.m_Perspective.getGraphObject();
        Vector vectStrLabels = this.m_axis.getNumericLabelsAsDouble();
        int nLabel = 0;
        while (nLabel < this.m_vectStrLabels.size()) {
            IdentObj idLegendMarker = new IdentObj(18);
            idLegendMarker.setMiscID(nLabel);
            this.m_vectMarkerID.addElement(idLegendMarker);
            Double dLabel = (Double)vectStrLabels.elementAt(nLabel);
            double fValue = dLabel;
            double fRatio = this.m_axis.getValueRelCoord(fValue);
            BlackBoxIF blackBox = chart.getBlackBox(idLegendMarker, fRatio);
            this.m_vectMarkerBlackBox.addElement(blackBox);
            MarkerTemplate markerTemplate = new MarkerTemplate(MarkerTemplate.MARKER_SQUARE);
            this.m_vectMarkerTemplate.addElement(markerTemplate);
            ++nLabel;
        }
    }

    public int getMinWidth() {
        int nMinWidth = 0;
        if (this.m_Legend.getLayoutOrient() == 0) {
            FontMetrics fm = this.getLegendFontMetrics();
            Dimension dimlargeText = new Dimension(0, 0);
            int i = 0;
            while (i < this.m_vectStrLabels.size()) {
                String strText = (String)this.m_vectStrLabels.elementAt(i);
                if (strText != null && strText.length() > 0) {
                    int nWidth = fm.stringWidth(strText);
                    int nHeight = fm.getMaxAscent() + fm.getMaxDescent() + fm.getLeading() - fm.getLeading();
                    dimlargeText.width = Math.max(dimlargeText.width, nWidth);
                    dimlargeText.height = Math.max(dimlargeText.height, nHeight);
                }
                ++i;
            }
            nMinWidth = this.m_Perspective.m_VC.destToVirtWidth(dimlargeText.width) * 3 / 2 + this.m_Legend.DOUBLE_BOX_MARGIN_W + 200;
        }
        return nMinWidth;
    }

    private FontMetrics getLegendFontMetrics() {
        Graphics gx = this.m_Perspective.getGraphicsContext();
        if (gx == null) {
            Image imageOfChart = this.m_Perspective.createOffscreenImage(1, 1);
            gx = imageOfChart.getGraphics();
        }
        int nStyle = 0;
        nStyle += (this.m_nFontStyle & 1) != 0 ? 2 : 0;
        Font font = this.m_Perspective.m_fontCache.getFont(this.m_szFontName, nStyle += (this.m_nFontStyle & 2) != 0 ? 1 : 0, this.m_nFontSize);
        FontMetrics fm = gx.getFontMetrics(font);
        return fm;
    }

    public int getNumLabels() {
        int nNumLabels = 0;
        if (this.m_vectStrLabels != null) {
            nNumLabels = this.m_vectStrLabels.size();
        }
        return nNumLabels;
    }

    public Vector getLabels() {
        return this.m_vectStrLabels;
    }

    public double getPinPosFromMarker(IdentObj id) {
        int s = id.getSeriesID();
        if (s == -3) {
            s = 0;
        }
        double fInterval = this.getNumLabels() == 1 ? 1.0 : 1.0 / (double)(this.getNumLabels() - 1);
        double fPin = (double)s * fInterval;
        Assert.assert(fPin >= 0.0 && fPin <= 1.0);
        return fPin;
    }

    public void setY1Axis(RelativeAxisObj Y1Axis) {
        this.m_axis = Y1Axis;
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }

    public Dimension getDimLabelCell() {
        return this.m_dimLabelCell;
    }

    public TextStyleObj getTextStyleObj() {
        return this.m_textStyle;
    }
}

