/*
 * Decompiled with CFR 0.152.
 */
package model.datacontrol.jdbc;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import model.datacontrol.javabeans.SampleDataControlUtil;
import model.datacontrol.jdbc.AccessorDefinitionImpl;
import model.datacontrol.jdbc.DefinitionContextImpl;
import model.datacontrol.jdbc.Key;
import model.datacontrol.jdbc.TransactionManager;
import oracle.binding.AttributeContext;
import oracle.binding.DefinitionProviderDataControl;
import oracle.binding.ManagedDataControl;
import oracle.binding.OperationBinding;
import oracle.binding.OperationInfo;
import oracle.binding.RowContext;
import oracle.binding.TransactionalDataControl;
import oracle.binding.UpdateableDataControl;
import oracle.binding.meta.AccessorDefinition;
import oracle.binding.meta.ArrayListDefinitionContainer;
import oracle.binding.meta.AttributeDefinition;
import oracle.binding.meta.Definition;
import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.StructureDefinition;

public class JDBCDataControl
implements DefinitionProviderDataControl,
ManagedDataControl,
TransactionalDataControl,
UpdateableDataControl {
    private TransactionManager mTransactionManager;
    Collection mData;
    String mDataType;
    String jdbcURL;
    private static /* synthetic */ Class class$oracle$binding$meta$StructureDefinition;

    private /* synthetic */ void $init$() {
        this.mTransactionManager = null;
    }

    public JDBCDataControl() {
        this.$init$();
    }

    public String getJdbcURL() {
        return this.jdbcURL;
    }

    public void setJdbcURL(String string) {
        this.jdbcURL = string;
    }

    public void setDefinitionBuilder(String string) {
        DefinitionContextImpl.getInstance().setDefinitionBuilder(string);
    }

    public void beginRequest(HashMap hashMap) {
        this.mTransactionManager = new TransactionManager(this.getJdbcURL(), this);
        new OracleDatabaseBuilder();
    }

    public void endRequest(HashMap hashMap) {
        this.mTransactionManager.close();
        this.mTransactionManager = null;
    }

    public boolean resetState() {
        return true;
    }

    private void closeResultSet(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void closeStatement(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private ArrayList readMaps(StructureDefinition structureDefinition, String string, Object[] objectArray) {
        Connection connection = this.mTransactionManager.getConnection();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        ArrayList arrayList = new ArrayList();
        try {
            try {
                StringBuffer stringBuffer = this.buildSelectSQL(structureDefinition);
                if (string != null) {
                    stringBuffer.append(" where ");
                    stringBuffer.append(string);
                }
                preparedStatement = connection.prepareStatement(stringBuffer.toString());
                if (objectArray != null) {
                    int n = 0;
                    while (n < objectArray.length) {
                        preparedStatement.setObject(n + 1, objectArray[n]);
                        ++n;
                    }
                }
                resultSet = preparedStatement.executeQuery();
                ArrayListDefinitionContainer arrayListDefinitionContainer = (ArrayListDefinitionContainer)structureDefinition.getAttributeDefinitions();
                ArrayListDefinitionContainer arrayListDefinitionContainer2 = (ArrayListDefinitionContainer)structureDefinition.getAccessorDefinitions();
                while (resultSet.next()) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
                    int n = 0;
                    while (n < arrayListDefinitionContainer.size()) {
                        hashMap.put(((NamedDefinition)arrayListDefinitionContainer.item(n)).getName(), resultSet.getObject(n + 1));
                        ++n;
                    }
                    int n2 = arrayListDefinitionContainer2.size() - 1;
                    while (n2 >= 0) {
                        AccessorDefinitionImpl accessorDefinitionImpl = (AccessorDefinitionImpl)arrayListDefinitionContainer2.item(n2);
                        ArrayList arrayList2 = accessorDefinitionImpl.getSourceAttributes();
                        ArrayList arrayList3 = accessorDefinitionImpl.getDestinationAttributes();
                        Object[] objectArray2 = new Object[arrayList2.size()];
                        StringBuffer stringBuffer2 = new StringBuffer();
                        int n3 = 0;
                        while (n3 < objectArray2.length) {
                            objectArray2[n3] = hashMap.get(((AttributeDefinition)arrayList2.get(n3)).getName());
                            if (n3 > 0) {
                                stringBuffer2.append(" and ");
                            }
                            stringBuffer2.append(((AttributeDefinition)arrayList3.get(n3)).getName());
                            stringBuffer2.append("= :" + (n3 + 1));
                            ++n3;
                        }
                        hashMap.put(accessorDefinitionImpl.getName(), this.readMaps(accessorDefinitionImpl.getStructure(), stringBuffer2.toString(), objectArray2));
                        --n2;
                    }
                    arrayList.add(hashMap);
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                throw new RuntimeException(sQLException);
            }
            Object var23_21 = null;
            this.closeResultSet(resultSet);
            this.closeStatement(preparedStatement);
        }
        catch (Throwable throwable) {
            Object var23_22 = null;
            this.closeResultSet(resultSet);
            this.closeStatement(preparedStatement);
            throw throwable;
        }
        return arrayList;
    }

    StringBuffer buildSelectSQL(StructureDefinition structureDefinition) {
        StringBuffer stringBuffer = new StringBuffer("select ");
        StringBuffer stringBuffer2 = new StringBuffer(" from ");
        stringBuffer2.append(structureDefinition.getName());
        Iterator iterator = structureDefinition.getAttributeDefinitions().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            AttributeDefinition attributeDefinition = (AttributeDefinition)iterator.next();
            if (!bl) {
                stringBuffer.append(',');
            }
            bl = false;
            stringBuffer.append(attributeDefinition.getName());
        }
        stringBuffer.append(stringBuffer2);
        return stringBuffer;
    }

    private Map createMap(StructureDefinition structureDefinition) {
        ArrayListDefinitionContainer arrayListDefinitionContainer = (ArrayListDefinitionContainer)structureDefinition.getAttributeDefinitions();
        HashMap<String, Object> hashMap = new HashMap<String, Object>(arrayListDefinitionContainer.size());
        int n = 0;
        while (n < arrayListDefinitionContainer.size()) {
            hashMap.put(((AttributeDefinition)arrayListDefinitionContainer.get(n)).getName(), null);
            ++n;
        }
        return hashMap;
    }

    public Object getDataProvider() {
        return this.mData;
    }

    public String getName() {
        return "JDBCDataControl";
    }

    public boolean invokeOperation(Map map, OperationBinding operationBinding) {
        String string;
        OperationInfo operationInfo = operationBinding.getOperationInfo();
        if (operationInfo != null && (string = operationInfo.getOperationName()) != null && string.startsWith("load")) {
            this.mDataType = string.substring(4).toLowerCase();
            if (this.mData == null) {
                this.mData = this.loadData(this.mDataType);
            }
            SampleDataControlUtil.putValueInPath(map, operationInfo.getReturnName(), this.mData);
            return true;
        }
        return false;
    }

    public void release(int n) {
        this.mDataType = null;
        this.mData = null;
    }

    private Collection loadData(String string) {
        StructureDefinition structureDefinition;
        Class clazz = class$oracle$binding$meta$StructureDefinition;
        if (clazz == null) {
            clazz = class$oracle$binding$meta$StructureDefinition = JDBCDataControl.class$("oracle.binding.meta.StructureDefinition");
        }
        if ((structureDefinition = (StructureDefinition)this.getDefinition(string, clazz)) != null) {
            return this.readMaps(structureDefinition, null, null);
        }
        throw new RuntimeException("Invalid type:  " + string);
    }

    public void commitTransaction() {
        this.mTransactionManager.commit();
    }

    public boolean setAttributeValue(AttributeContext attributeContext, Object object) {
        return false;
    }

    public Object createRowData(RowContext rowContext) {
        String string = rowContext.getRowDataProviderType();
        Class clazz = class$oracle$binding$meta$StructureDefinition;
        if (clazz == null) {
            clazz = class$oracle$binding$meta$StructureDefinition = JDBCDataControl.class$("oracle.binding.meta.StructureDefinition");
        }
        StructureDefinition structureDefinition = (StructureDefinition)this.getDefinition(string, clazz);
        Map map = this.createMap(structureDefinition);
        Map map2 = (Map)rowContext.getMasterRowDataProvider();
        ArrayList<Map> arrayList = null;
        if (map2 == null) {
            arrayList = this.mData;
        } else {
            StructureDefinition structureDefinition2 = (StructureDefinition)structureDefinition.getDefinitionParent();
            Iterator iterator = structureDefinition2.getAccessorDefinitions().iterator();
            NamedDefinition namedDefinition = null;
            while (iterator.hasNext()) {
                namedDefinition = (AccessorDefinition)iterator.next();
                if (namedDefinition.getStructure().getName().equals(string)) break;
            }
            if ((arrayList = (Collection)map2.get(namedDefinition.getName())) == null) {
                arrayList = new ArrayList<Map>(4);
                map2.put(namedDefinition.getName(), arrayList);
            }
            ArrayList arrayList2 = ((AccessorDefinitionImpl)namedDefinition).getSourceAttributes();
            ArrayList arrayList3 = ((AccessorDefinitionImpl)namedDefinition).getDestinationAttributes();
            int n = 0;
            while (n < arrayList2.size()) {
                map.put(((AttributeDefinition)arrayList3.get(n)).getName(), map2.get(((AttributeDefinition)arrayList2.get(n)).getName()));
                ++n;
            }
        }
        arrayList.add(map);
        this.mTransactionManager.objectCreated(structureDefinition, map);
        return map;
    }

    public boolean isTransactionDirty() {
        return this.mTransactionManager.isTransactionDirty();
    }

    public Object registerDataProvider(RowContext rowContext) {
        String string = rowContext.getRowDataProviderType();
        Object object = rowContext.getRowDataProvider();
        Class clazz = class$oracle$binding$meta$StructureDefinition;
        if (clazz == null) {
            clazz = class$oracle$binding$meta$StructureDefinition = JDBCDataControl.class$("oracle.binding.meta.StructureDefinition");
        }
        StructureDefinition structureDefinition = (StructureDefinition)this.getDefinition(string, clazz);
        this.mTransactionManager.objectModified(structureDefinition, object, new Key(structureDefinition, (Map)object));
        return object;
    }

    public boolean removeRowData(RowContext rowContext) {
        Object object = rowContext.getRowDataProvider();
        String string = rowContext.getRowDataProviderType();
        Class clazz = class$oracle$binding$meta$StructureDefinition;
        if (clazz == null) {
            clazz = class$oracle$binding$meta$StructureDefinition = JDBCDataControl.class$("oracle.binding.meta.StructureDefinition");
        }
        StructureDefinition structureDefinition = (StructureDefinition)this.getDefinition(string, clazz);
        Key key = new Key(structureDefinition, (Map)object);
        Map map = (Map)rowContext.getMasterRowDataProvider();
        Collection collection = null;
        if (map == null) {
            collection = this.mData;
        } else {
            StructureDefinition structureDefinition2 = (StructureDefinition)structureDefinition.getDefinitionParent();
            Iterator iterator = structureDefinition2.getAccessorDefinitions().iterator();
            NamedDefinition namedDefinition = null;
            while (iterator.hasNext()) {
                namedDefinition = (AccessorDefinition)iterator.next();
                if (namedDefinition.getStructure().getName().equals(string)) break;
            }
            collection = (Collection)map.get(namedDefinition.getName());
        }
        if (collection.remove(object)) {
            this.mTransactionManager.objectDeleted(structureDefinition, object, key);
        }
        return false;
    }

    public void rollbackTransaction() {
        this.mTransactionManager.rollback();
        this.mData = null;
    }

    public void validate() {
    }

    public Definition getDefinition(String string, Class clazz) {
        if (clazz.getName().indexOf("StructureDefinition") >= 0 && this.mTransactionManager != null) {
            return DefinitionContextImpl.getInstance().findOrCreateStructureDefinition(string, this.mTransactionManager.getConnection());
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class OracleDatabaseBuilder {
        private static /* synthetic */ Class class$oracle$binding$meta$StructureDefinition;

        OracleDatabaseBuilder() {
            this.initDept();
        }

        private void initDept() {
            Class clazz = class$oracle$binding$meta$StructureDefinition;
            if (clazz == null) {
                clazz = class$oracle$binding$meta$StructureDefinition = OracleDatabaseBuilder.class$("oracle.binding.meta.StructureDefinition");
            }
            if (JDBCDataControl.this.getDefinition("dept", clazz) != null) {
                return;
            }
            this.createTables();
            this.populateTables();
            DefinitionContextImpl.getInstance().clearCache();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void createTables() {
            Connection connection = JDBCDataControl.this.mTransactionManager.getConnection();
            PreparedStatement preparedStatement = null;
            try {
                try {
                    preparedStatement = connection.prepareStatement("create table dept (deptno NUMBER(2) not null, dname VARCHAR2(14), loc VARCHAR2(14), hasmanager VARCHAR2(14), constraint dept_primary_key primary key (deptno))");
                    preparedStatement.executeQuery();
                    preparedStatement.close();
                    preparedStatement = connection.prepareStatement("create table emp (empno NUMBER(4) not null, ename VARCHAR2(14), job VARCHAR2(9), deptno NUMBER(2), constraint emp_primary_key primary key (empno), constraint emps foreign key (deptno) references dept (deptno))");
                    preparedStatement.executeQuery();
                    preparedStatement.close();
                    preparedStatement = connection.prepareStatement("create table inv (id NUMBER(4) not null, description VARCHAR2(14), dateacquired DATE, deptno NUMBER(2), constraint inv_primary_key primary key (id), constraint inventories foreign key (deptno) references dept (deptno))");
                    preparedStatement.executeQuery();
                    preparedStatement.close();
                    preparedStatement = null;
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException);
                }
                Object var6_3 = null;
            }
            catch (Throwable throwable) {
                Object var6_4 = null;
                try {
                    if (preparedStatement == null) throw throwable;
                    preparedStatement.close();
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (SQLException sQLException) {}
            if (preparedStatement == null) return;
            preparedStatement.close();
            return;
        }

        private void populateTables() {
            ArrayList<Map> arrayList = new ArrayList<Map>();
            arrayList.add(this.deptMap(1, "one", "Palo Alto", ""));
            arrayList.add(this.deptMap(2, "two", "San Francisco", null));
            arrayList.add(this.deptMap(3, "three", "San Jose", "x"));
            JDBCDataControl.this.mTransactionManager.writeMaps("dept", arrayList, false);
            ArrayList<Map> arrayList2 = new ArrayList<Map>();
            arrayList2.add(this.empMap(101, "A Emp", "Pres", 1));
            arrayList2.add(this.empMap(102, "B Emp", "Mgr", 1));
            arrayList2.add(this.empMap(103, "C Emp", "PM", 1));
            arrayList2.add(this.empMap(104, "A A", "Dev", 2));
            arrayList2.add(this.empMap(105, "B B", "Dev", 2));
            arrayList2.add(this.empMap(106, "C C", "Dev", 2));
            arrayList2.add(this.empMap(107, "C C", "QA", 3));
            JDBCDataControl.this.mTransactionManager.writeMaps("emp", arrayList2, false);
            ArrayList<Map> arrayList3 = new ArrayList<Map>();
            arrayList3.add(this.invMap(1, "PC", Date.valueOf("2004-01-01"), 1));
            arrayList3.add(this.invMap(2, "Notebook", Date.valueOf("2003-12-11"), 2));
            arrayList3.add(this.invMap(3, "Projector", Date.valueOf("2001-02-15"), 2));
            arrayList3.add(this.invMap(4, "PC", Date.valueOf("2002-07-22"), 3));
            arrayList3.add(this.invMap(5, "Whiteboard", Date.valueOf("1998-08-19"), 3));
            arrayList3.add(this.invMap(6, "Notebook", Date.valueOf("2004-03-05"), 3));
            JDBCDataControl.this.mTransactionManager.writeMaps("inv", arrayList3, false);
            try {
                JDBCDataControl.this.mTransactionManager.getConnection().commit();
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException);
            }
        }

        private Map deptMap(int n, String string, String string2, String string3) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
            hashMap.put("deptno", new Integer(n));
            hashMap.put("dname", string);
            hashMap.put("loc", string2);
            hashMap.put("hasmanager", string3);
            return hashMap;
        }

        private Map empMap(int n, String string, String string2, int n2) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
            hashMap.put("empno", new Integer(n));
            hashMap.put("ename", string);
            hashMap.put("job", string2);
            hashMap.put("deptno", new Integer(n2));
            return hashMap;
        }

        private Map invMap(int n, String string, Date date, int n2) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
            hashMap.put("id", new Integer(n));
            hashMap.put("description", string);
            hashMap.put("dateacquired", date);
            hashMap.put("deptno", new Integer(n2));
            return hashMap;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

