/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.jui;

import com.sun.java.util.collections.ArrayList;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;
import javax.swing.text.NumberFormatter;
import oracle.jbo.mom.xml.DefElement;
import oracle.jbo.uicli.jui.DateConvertor;
import oracle.jbo.uicli.jui.JUFormattedTextFieldBinding;
import oracle.jbo.uicli.jui.JUFormattedTextFieldDef;
import oracle.jbo.uicli.jui.JUTableCellEditor;
import oracle.jbo.uicli.jui.JUTableCellRenderer;
import oracle.jbo.uicli.jui.JUTableDef;
import oracle.jbo.uicli.jui.JUTableFormatEditor;
import oracle.jbo.uicli.jui.NumericConvertor;
import oracle.jbo.uicli.jui.RegExpFormatter;

public class JUFormatEditorPropDef
extends JUTableDef.JUEditorPropDef {
    public static final String PNAME_ActiveFormatter = "ActiveFormatter";
    public static final int DATE_FORMATTER = 0;
    public static final int MASK_FORMATTER = 1;
    public static final int DEFAULT_FORMATTER = 2;
    public static final int NUMBER_FORMATTER = 3;
    public static final int REGEXP_FORMATTER = 4;
    String mEditorName;
    JUFormattedTextFieldDef.DateFormatDef mDateFormatDef;
    JUFormattedTextFieldDef.MaskFormatDef mMaskFormatDef;
    JUFormattedTextFieldDef.NumberFormatDef mNumberFormatDef;
    JUFormattedTextFieldDef.RegExpFormatDef mRegExpFormatDef;
    JUFormattedTextFieldBinding.Convertor mConvertor;
    int mActiveFormatter;
    String mFormatString;
    private JUTableFormatEditor mTableCellFormatEditor;

    private /* synthetic */ void $init$() {
        this.mEditorName = "Formatted TextField";
        this.mDateFormatDef = new JUFormattedTextFieldDef.DateFormatDef();
        this.mMaskFormatDef = new JUFormattedTextFieldDef.MaskFormatDef();
        this.mNumberFormatDef = new JUFormattedTextFieldDef.NumberFormatDef();
        this.mRegExpFormatDef = new JUFormattedTextFieldDef.RegExpFormatDef();
        this.mConvertor = null;
        this.mActiveFormatter = 1;
        this.mFormatString = null;
    }

    public JUFormatEditorPropDef() {
        this.$init$();
    }

    public void setAttrName(String string) {
    }

    public JUTableCellRenderer getTableCellRenderer() {
        return null;
    }

    public JUTableCellEditor getTableCellEditor() {
        switch (this.getActiveFormatter()) {
            case 0: {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
                if (this.getDateFormatDef().getFormatString() != null && !this.getDateFormatDef().getFormatString().equals("")) {
                    simpleDateFormat.applyPattern(this.getDateFormatDef().getFormatString());
                }
                DateFormatter dateFormatter = new DateFormatter(simpleDateFormat);
                DefaultFormatterFactory defaultFormatterFactory = new DefaultFormatterFactory(dateFormatter);
                this.mConvertor = new DateConvertor();
                this.mTableCellFormatEditor = new JUTableFormatEditor(defaultFormatterFactory, this.mConvertor);
                break;
            }
            case 1: {
                MaskFormatter maskFormatter = new MaskFormatter();
                try {
                    maskFormatter.setMask(this.getMaskFormatDef().getFormatString());
                    DefaultFormatterFactory defaultFormatterFactory = new DefaultFormatterFactory(maskFormatter);
                    this.mTableCellFormatEditor = new JUTableFormatEditor(defaultFormatterFactory, this.mConvertor);
                }
                catch (ParseException parseException) {}
                break;
            }
            case 2: {
                DefaultFormatter defaultFormatter = new DefaultFormatter();
                DefaultFormatterFactory defaultFormatterFactory = new DefaultFormatterFactory(defaultFormatter);
                this.mTableCellFormatEditor = new JUTableFormatEditor(defaultFormatterFactory, this.mConvertor);
                break;
            }
            case 3: {
                String string = this.getNumberFormatDef().getFormatString();
                DecimalFormat decimalFormat = null;
                try {
                    decimalFormat = new DecimalFormat(string == null ? "" : string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                NumberFormatter numberFormatter = new NumberFormatter(decimalFormat);
                DefaultFormatterFactory defaultFormatterFactory = new DefaultFormatterFactory(numberFormatter);
                this.mConvertor = new NumericConvertor();
                this.mTableCellFormatEditor = new JUTableFormatEditor(defaultFormatterFactory, this.mConvertor);
                break;
            }
            case 4: {
                RegExpFormatter regExpFormatter = new RegExpFormatter();
                String string = this.getRegExpFormatDef().getPattern();
                int n = this.getRegExpFormatDef().getFlag();
                try {
                    Pattern pattern = null;
                    pattern = n != 0 ? Pattern.compile(string, n) : Pattern.compile(string);
                    regExpFormatter.setPattern(pattern);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    // empty catch block
                }
                DefaultFormatterFactory defaultFormatterFactory = new DefaultFormatterFactory(regExpFormatter);
                this.mTableCellFormatEditor = new JUTableFormatEditor(defaultFormatterFactory, this.mConvertor);
            }
        }
        return this.mTableCellFormatEditor;
    }

    public String getEditorName() {
        return this.mEditorName;
    }

    public void setEditorName(String string) {
        this.mEditorName = string;
    }

    public int getActiveFormatter() {
        return this.mActiveFormatter;
    }

    public void setActiveFormatter(int n) {
        this.mActiveFormatter = n;
    }

    public JUFormattedTextFieldDef.DateFormatDef getDateFormatDef() {
        return this.mDateFormatDef;
    }

    public void setDateFormatDef(JUFormattedTextFieldDef.DateFormatDef dateFormatDef) {
        this.mDateFormatDef = dateFormatDef;
    }

    public JUFormattedTextFieldDef.MaskFormatDef getMaskFormatDef() {
        return this.mMaskFormatDef;
    }

    public void setMaskFormatDef(JUFormattedTextFieldDef.MaskFormatDef maskFormatDef) {
        this.mMaskFormatDef = maskFormatDef;
    }

    public JUFormattedTextFieldDef.NumberFormatDef getNumberFormatDef() {
        return this.mNumberFormatDef;
    }

    public JUFormattedTextFieldDef.RegExpFormatDef getRegExpFormatDef() {
        return this.mRegExpFormatDef;
    }

    public void setNumberFormatDef(JUFormattedTextFieldDef.NumberFormatDef numberFormatDef) {
        this.mNumberFormatDef = numberFormatDef;
    }

    public void init(HashMap hashMap) {
        super.init(hashMap);
        Object v = hashMap.get(PNAME_ActiveFormatter);
        if (v != null) {
            this.mActiveFormatter = (Integer)v;
        }
        if ((v = hashMap.get("Name")) != null) {
            this.mEditorName = ((String)v).toString();
        }
    }

    public void loadChildrenFromXML(DefElement defElement) {
        super.loadChildrenFromXML(defElement);
        this.loadDateFormatDef(defElement);
        this.loadMaskFormatDef(defElement);
        this.loadNumberFormatDef(defElement);
        this.loadRegExpFormatDef(defElement);
    }

    void loadDateFormatDef(DefElement defElement) {
        ArrayList arrayList = defElement.getChildrenList("DateFormatDef");
        if (arrayList.size() > 0) {
            DefElement defElement2 = (DefElement)arrayList.get(0);
            this.mDateFormatDef = new JUFormattedTextFieldDef.DateFormatDef();
            this.mDateFormatDef.loadFromXML(defElement2);
        }
    }

    void loadMaskFormatDef(DefElement defElement) {
        ArrayList arrayList = defElement.getChildrenList("MaskFormatDef");
        if (arrayList.size() > 0) {
            DefElement defElement2 = (DefElement)arrayList.get(0);
            this.mMaskFormatDef = new JUFormattedTextFieldDef.MaskFormatDef();
            this.mMaskFormatDef.loadFromXML(defElement2);
        }
    }

    void loadNumberFormatDef(DefElement defElement) {
        ArrayList arrayList = defElement.getChildrenList("NumberFormatDef");
        if (arrayList.size() > 0) {
            DefElement defElement2 = (DefElement)arrayList.get(0);
            this.mNumberFormatDef = new JUFormattedTextFieldDef.NumberFormatDef();
            this.mNumberFormatDef.loadFromXML(defElement2);
        }
    }

    void loadRegExpFormatDef(DefElement defElement) {
        ArrayList arrayList = defElement.getChildrenList("RegExpFormatDef");
        if (arrayList.size() > 0) {
            DefElement defElement2 = (DefElement)arrayList.get(0);
            this.mRegExpFormatDef = new JUFormattedTextFieldDef.RegExpFormatDef();
            this.mRegExpFormatDef.loadFromXML(defElement2);
        }
    }

    protected void retrieveFromXML(DefElement defElement, HashMap hashMap) {
        super.retrieveFromXML(defElement, hashMap);
        JUFormatEditorPropDef.readXMLInt((DefElement)defElement, (String)PNAME_ActiveFormatter, (HashMap)hashMap);
        JUFormatEditorPropDef.readXMLString((DefElement)defElement, (String)"Name", (HashMap)hashMap);
    }
}

