/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.jui;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import oracle.jbo.uicli.jui.ConvertorBase;
import oracle.jbo.uicli.jui.JUFormattedTextFieldBinding;

class DateConvertor
extends ConvertorBase
implements JUFormattedTextFieldBinding.Convertor {
    static final String DEFAULT_DATE_FMT_STR = "MM-dd-yyyy";

    DateConvertor() {
        super(DEFAULT_DATE_FMT_STR);
    }

    public void updateFormatHint(String string) {
        this.setFormatHint(string);
    }

    public Object domainToObject(Object object) {
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof oracle.jbo.domain.Date) {
            java.sql.Date date = ((oracle.jbo.domain.Date)object).dateValue();
            return date;
        }
        if (object instanceof oracle.jbo.domain.Timestamp) {
            try {
                java.sql.Date date;
                java.sql.Date date2 = date = ((oracle.jbo.domain.Timestamp)object).dateValue();
                return date2;
            }
            catch (SQLException sQLException) {
                Object var6_6 = null;
                return var6_6;
            }
        }
        if (object instanceof String) {
            return this.getDateValue((String)object);
        }
        return object;
    }

    private Date getDateValue(String string) {
        try {
            String string2 = super.getFormatString();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            Date date = simpleDateFormat.parse(string);
            return date;
        }
        catch (ParseException parseException) {
            Date date = null;
            return date;
        }
    }

    public Object objectToDomain(Object object) {
        if (object instanceof Date) {
            Date date = (Date)object;
            if (date != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                Timestamp timestamp = new Timestamp(date.getTime());
                return timestamp;
            }
            return date;
        }
        return object;
    }
}

