/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.graph;

import java.awt.Component;
import java.io.InputStream;
import java.util.ArrayList;
import javax.swing.JPanel;
import oracle.adf.model.binding.DCBindingContainer;
import oracle.adf.model.binding.DCDataControl;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.dss.graph.Graph;
import oracle.dss.util.CubeDataDirector;
import oracle.dss.util.DataSource;
import oracle.dss.util.DefaultErrorHandler;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.RelationalDataDirector;
import oracle.dss.util.xml.BIIOException;
import oracle.dss.util.xml.BIParseException;
import oracle.dss.util.xml.BISAXException;
import oracle.jbo.DeleteEvent;
import oracle.jbo.InsertEvent;
import oracle.jbo.JboException;
import oracle.jbo.Row;
import oracle.jbo.RowSetIterator;
import oracle.jbo.common.JBOClass;
import oracle.jbo.uicli.binding.JUAccessorIteratorDef;
import oracle.jbo.uicli.graph.BIBeanDataAccessAdapter;
import oracle.jbo.uicli.graph.GraphDataFromCol;
import oracle.jbo.uicli.graph.JUGraphBinding;

public class JUMasterDetailGraphBinding
extends JUGraphBinding
implements DataSource {
    protected BIBeanDataAccessAdapter mAdapter;
    protected String mChildAccessorName;
    protected String[] mDataValueAttrNames;
    protected int mNumberOfColumnValuesPerMarker;
    protected String mSeriesLabelAttributeName;
    protected ArrayList mChildSeries;
    protected InputStream mGraphPropertiesStream;

    private /* synthetic */ void $init$() {
        this.mChildSeries = new ArrayList(10);
    }

    public JUMasterDetailGraphBinding(Graph graph, DCIteratorBinding dCIteratorBinding, String string, String string2, String[] stringArray, int n) {
        this(graph, dCIteratorBinding, string, string2, stringArray, n, (InputStream)null);
    }

    public JUMasterDetailGraphBinding(Graph graph, DCIteratorBinding dCIteratorBinding, String string, String string2, String[] stringArray, int n, String string3) {
        this(graph, dCIteratorBinding, string, string2, stringArray, n, JBOClass.getResourceAsStream((String)string3));
    }

    public JUMasterDetailGraphBinding(Graph graph, DCIteratorBinding dCIteratorBinding, String string, String string2, String[] stringArray, int n, InputStream inputStream) {
        super(graph, dCIteratorBinding, new String[]{string, string2});
        this.$init$();
        this.mAdapter = new BIBeanDataAccessAdapter(this);
        this.mChildAccessorName = string2;
        this.mDataValueAttrNames = stringArray;
        this.mNumberOfColumnValuesPerMarker = n;
        this.mSeriesLabelAttributeName = string;
        this.mGraphPropertiesStream = inputStream;
        this.init(graph, this.mGraphPropertiesStream);
    }

    protected void init(Graph graph, InputStream inputStream) {
        ErrorHandler errorHandler;
        if (inputStream != null && graph != null) {
            try {
                graph.readXML(inputStream, 0);
            }
            catch (BIParseException bIParseException) {
                throw new JboException((Throwable)bIParseException);
            }
            catch (BISAXException bISAXException) {
                throw new JboException((Throwable)bISAXException);
            }
            catch (BIIOException bIIOException) {
                throw new JboException((Throwable)bIIOException);
            }
        }
        if (graph != null && (errorHandler = graph.getErrorHandler()) != null && errorHandler instanceof DefaultErrorHandler) {
            DefaultErrorHandler defaultErrorHandler = (DefaultErrorHandler)errorHandler;
            defaultErrorHandler.setDebugMode(0);
        }
    }

    protected GraphDataFromCol getSeries(int n) {
        GraphDataFromCol graphDataFromCol;
        if (this.mChildSeries.size() == 0) {
            this.getIteratorBinding().executeQueryIfNeeded();
            Row[] rowArray = this.getIteratorBinding().getAllRowsInRange();
            this.updateSeries(rowArray);
        }
        if ((graphDataFromCol = (GraphDataFromCol)((Object)this.mChildSeries.get(n))) == null) {
            throw new JboException("Graph : Child series missing ");
        }
        return graphDataFromCol;
    }

    protected String getColumnLabel(int n) {
        GraphDataFromCol graphDataFromCol = this.getSeries(0);
        return graphDataFromCol.getColumnLabel(n);
    }

    protected int getColumnCount() {
        GraphDataFromCol graphDataFromCol = this.getSeries(0);
        int n = graphDataFromCol.getColumnCount();
        return n;
    }

    protected String getRowLabel(int n) {
        GraphDataFromCol graphDataFromCol = this.getSeries(n);
        return graphDataFromCol.getSeriesLabel();
    }

    protected long getRowCount() {
        return this.getEstimatedRowCount();
    }

    protected Object getValue(int n, int n2) {
        GraphDataFromCol graphDataFromCol = this.getSeries(n);
        return graphDataFromCol.getColumnValue(n2);
    }

    public void addControlToPanel(Object object, Object object2, Object object3) {
        ((JPanel)object).add((Component)object2, object3);
    }

    public void updateRowInserted(InsertEvent insertEvent) {
        this.notifyView();
    }

    public void updateRowDeleted(DeleteEvent deleteEvent) {
        this.notifyView();
    }

    public void updateValuesFromRows(Row[] rowArray, boolean bl) {
        super.updateValuesFromRows(rowArray, bl);
        if (!this.getBindingContainer().isFindMode()) {
            this.updateSeries(rowArray);
        }
        this.notifyView();
    }

    void updateSeries(Row[] rowArray) {
        if (rowArray == null) {
            return;
        }
        int n = 0;
        while (n < rowArray.length) {
            Object object = rowArray[n].getAttribute(this.mSeriesLabelAttributeName);
            if (object == null) {
                object = "";
            }
            DCDataControl dCDataControl = this.getIteratorBinding().getDataControl();
            DCBindingContainer dCBindingContainer = this.getBindingContainer();
            JUAccessorIteratorDef jUAccessorIteratorDef = new JUAccessorIteratorDef(this.mChildAccessorName, this.getIteratorBinding().getName());
            DCIteratorBinding dCIteratorBinding = jUAccessorIteratorDef.createIterBinding(dCDataControl, dCBindingContainer, null);
            RowSetIterator rowSetIterator = dCDataControl.createAccessorRowSetIterator(this.getIteratorBinding().getRowSetIterator(), rowArray[n], dCIteratorBinding, this.mChildAccessorName, null);
            dCIteratorBinding.executeQueryIfNeeded();
            GraphDataFromCol graphDataFromCol = this.createGraphDataFromCol((Graph)this.getControl(), dCIteratorBinding, this.mDataValueAttrNames, this.mNumberOfColumnValuesPerMarker, object.toString());
            this.mChildSeries.add(n, graphDataFromCol);
            ++n;
        }
    }

    protected GraphDataFromCol createGraphDataFromCol(Graph graph, DCIteratorBinding dCIteratorBinding, String[] stringArray, int n, String string) {
        return new GraphDataFromCol(graph, dCIteratorBinding, stringArray, n, string);
    }

    protected void notifyView() {
        super.refreshBIBeanAdapter(this.mAdapter);
    }

    public RelationalDataDirector createRelationalDataDirector() {
        return this.mAdapter;
    }

    public CubeDataDirector createCubeDataDirector() {
        return this.mAdapter;
    }

    public void releaseReferences() {
        this.mAdapter.releaseReferences();
        this.mAdapter = null;
        this.mGraphPropertiesStream = null;
        this.mChildSeries.clear();
    }
}

