/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import oracle.xml.async.DOMBuilder;
import oracle.xml.async.DOMBuilderErrorEvent;
import oracle.xml.async.DOMBuilderErrorListener;
import oracle.xml.async.DOMBuilderEvent;
import oracle.xml.async.DOMBuilderListener;
import oracle.xml.async.ResourceManager;
import oracle.xml.async.XSLTransformer;
import oracle.xml.async.XSLTransformerErrorEvent;
import oracle.xml.async.XSLTransformerErrorListener;
import oracle.xml.async.XSLTransformerEvent;
import oracle.xml.async.XSLTransformerListener;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XSLProcessor;
import oracle.xml.parser.v2.XSLStylesheet;

class oraxslDriver
implements DOMBuilderListener,
XSLTransformerListener,
DOMBuilderErrorListener,
XSLTransformerErrorListener {
    private boolean warnings = false;
    private OutputStream errors = System.err;
    private String xslinput;
    private String output;
    private boolean xmlpar = false;
    private Vector paramNames = new Vector();
    private Vector paramValues = new Vector();
    private boolean xmllist = false;
    private Vector xmlfiles = new Vector();
    private boolean xmldir = false;
    private String basedir = null;
    private boolean stylesheet = false;
    private boolean resultext = false;
    private int numXMLDocs = 1;
    private String extension;
    private int thrdNum = 1;
    private boolean serialize = false;
    private ResourceManager rm;
    private XMLDocument xsldoc = null;
    private URL xslURL = null;
    private boolean resdir = false;
    private String resultdir = null;
    private String omitExt = null;
    private String inclExt = null;
    private boolean matchExtension = false;
    private boolean debugFlag = false;
    private int version = 1;
    private XMLDocument[] xmldocs;
    private DOMBuilder tparser;
    private XSLTransformer processor;
    private XSLStylesheet xsl;
    private static final String newline = System.getProperty("line.separator");
    private static boolean verbose = false;
    private static long startTime;
    private static long endTime;
    private static final String usageMessage;

    oraxslDriver() {
    }

    private void showTask(String string) {
        if (verbose) {
            System.err.println(string);
        }
    }

    boolean stillActive() {
        return this.rm.activeFound();
    }

    void compile() {
        this.showTask(this.numXMLDocs + " XML document" + (this.numXMLDocs > 1 ? "s" : "") + " will be transformed" + " using XSLT stylesheet specified in " + this.xslinput + " with " + this.thrdNum + " thread" + (this.thrdNum > 1 ? "s" : ""));
        try {
            DOMParser dOMParser = new DOMParser();
            dOMParser.setPreserveWhitespace(true);
            this.xslURL = this.createURL(this.xslinput);
            this.showTask("Parsing file " + this.xslinput);
            dOMParser.setErrorStream(this.errors);
            dOMParser.setDebugMode(this.debugFlag);
            dOMParser.setAttribute("oracle.xdkjava.security.resolveEntityDefault", Boolean.TRUE);
            dOMParser.parse(this.xslURL);
            this.xsldoc = dOMParser.getDocument();
        }
        catch (Exception exception) {
            this.exitWithError("Error occurred while parsing " + this.xslinput + ": " + exception.getMessage());
        }
        this.xmldocs = new XMLDocument[this.numXMLDocs];
        this.rm = new ResourceManager(this.thrdNum);
        for (int i = 0; i < this.numXMLDocs; ++i) {
            this.rm.getResource();
            try {
                this.tparser = new DOMBuilder(i);
                URL uRL = this.basedir == null ? this.createURL((String)this.xmlfiles.elementAt(i)) : this.createURL(this.basedir + "/" + (String)this.xmlfiles.elementAt(i));
                if (uRL == null) {
                    this.exitWithError("File " + (String)this.xmlfiles.elementAt(i) + " not found");
                }
                if (this.serialize) continue;
                this.tparser.setPreserveWhitespace(true);
                if (this.basedir != null) {
                    URL uRL2 = this.createURL(this.basedir + "/");
                    this.tparser.setBaseURL(uRL2);
                }
                this.tparser.setDebugMode(this.debugFlag);
                this.tparser.setErrorStream(this.errors);
                this.tparser.addDOMBuilderListener(this);
                this.tparser.addDOMBuilderErrorListener(this);
                this.showTask("Parsing file " + this.xmlfiles.elementAt(i));
                this.tparser.parse(uRL);
                continue;
            }
            catch (Exception exception) {
                this.exitWithError("Error occurred while parsing " + (String)this.xmlfiles.elementAt(i) + ": " + exception.getMessage());
            }
        }
    }

    private URL createURL(String string) throws Exception {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            try {
                String string2 = file.getAbsolutePath();
                String string3 = System.getProperty("file.separator");
                if (string3.length() == 1) {
                    char c = string3.charAt(0);
                    if (c != '/') {
                        string2 = string2.replace(c, '/');
                    }
                    if (string2.charAt(0) != '/') {
                        string2 = '/' + string2;
                    }
                }
                string2 = "file://" + string2;
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException2) {
                this.exitWithError("Cannot create url for: " + string);
            }
        }
        return uRL;
    }

    public void domBuilderStarted(DOMBuilderEvent dOMBuilderEvent) {
    }

    public void domBuilderError(DOMBuilderEvent dOMBuilderEvent) {
    }

    public synchronized void domBuilderOver(DOMBuilderEvent dOMBuilderEvent) {
        DOMBuilder dOMBuilder = (DOMBuilder)dOMBuilderEvent.getSource();
        int n = dOMBuilder.getId();
        this.xmldocs[n] = dOMBuilder.getDocument();
        XSLTransformer xSLTransformer = new XSLTransformer(n);
        xSLTransformer.showWarnings(this.warnings);
        if (this.version == 1) {
            xSLTransformer.setXSLTVersion(XSLProcessor.XSLT10);
        } else if (this.version == 2) {
            xSLTransformer.setXSLTVersion(XSLProcessor.XSLT20);
        }
        try {
            Object object;
            Object object2;
            xSLTransformer.setErrorStream(this.errors);
            xSLTransformer.addXSLTransformerListener(this);
            xSLTransformer.addXSLTransformerErrorListener(this);
            XSLStylesheet xSLStylesheet = new XSLStylesheet(this.xsldoc, this.xslURL);
            if (this.xmlpar) {
                object2 = this.paramNames.elements();
                object = this.paramValues.elements();
                while (object2.hasMoreElements()) {
                    xSLStylesheet.setParam((String)object2.nextElement(), (String)object.nextElement());
                }
            }
            this.showTask("Transforming XML document specified in " + this.xmlfiles.elementAt(n));
            object2 = null;
            try {
                if (this.output != null) {
                    object2 = new FileOutputStream(this.output);
                } else if (!this.resultext) {
                    object2 = System.out;
                } else {
                    File file;
                    if (!this.resdir) {
                        object = new File((String)this.xmlfiles.elementAt(n));
                        file = new File(((File)object).getName() + "." + this.extension);
                    } else {
                        object = new File(this.basedir, (String)this.xmlfiles.elementAt(n));
                        file = new File(this.resultdir, ((File)object).getName() + "." + this.extension);
                    }
                    object2 = new FileOutputStream(file);
                }
            }
            catch (Exception exception) {
                this.exitWithError("Error occurred while generating output : " + exception.getMessage());
            }
            if (xSLStylesheet.xss.getXSLDebugProp() != null && xSLStylesheet.xss.getXSLDebugProp().debug()) {
                xSLStylesheet.getJDWPClassesIDs(this.xmldocs);
            }
            xSLTransformer.processXSL(xSLStylesheet, this.xmldocs[n], (OutputStream)object2);
        }
        catch (Exception exception) {
            this.exitWithError("Error occurred while processing " + this.xslinput + ": " + exception.getMessage());
        }
    }

    public void domBuilderErrorCalled(DOMBuilderErrorEvent dOMBuilderErrorEvent) {
        int n = ((DOMBuilder)dOMBuilderErrorEvent.getSource()).getId();
        this.exitWithError("Error occurred while parsing " + this.xmlfiles.elementAt(n) + ": " + dOMBuilderErrorEvent.getException().getMessage());
    }

    public void xslTransformerErrorCalled(XSLTransformerErrorEvent xSLTransformerErrorEvent) {
        int n = ((XSLTransformer)xSLTransformerErrorEvent.getSource()).getId();
        this.exitWithError("Error occurred while processing " + this.xmlfiles.elementAt(n) + ": " + xSLTransformerErrorEvent.getException().getMessage());
    }

    public void xslTransformerStarted(XSLTransformerEvent xSLTransformerEvent) {
    }

    public void xslTransformerError(XSLTransformerEvent xSLTransformerEvent) {
    }

    public void xslTransformerOver(XSLTransformerEvent xSLTransformerEvent) {
        this.rm.releaseResource();
    }

    void processArgs(String[] stringArray) throws Exception {
        String string;
        Object object;
        Object object2;
        String string2;
        int n;
        int n2 = stringArray.length;
        String string3 = null;
        int n3 = 61;
        block23: for (n = 0; n < n2 && (string2 = stringArray[n]).charAt(0) == '-'; ++n) {
            switch (string2.charAt(1)) {
                case 'h': {
                    this.printUsage(null);
                    System.exit(0);
                    continue block23;
                }
                case 'v': {
                    verbose = true;
                    DOMParser dOMParser = new DOMParser();
                    dOMParser.setAttribute("oracle.xdkjava.security.resolveEntityDefault", Boolean.TRUE);
                    object2 = dOMParser.getReleaseVersion();
                    this.showTask("Release version: " + (String)object2);
                    continue block23;
                }
                case 't': {
                    if (string2.length() > 2) {
                        string3 = string2.substring(2);
                        if (this.isFlag(string3)) {
                            this.printUsage("Missing <# of threads> after -t");
                        }
                    } else if (++n >= n2 || this.isFlag(string3 = stringArray[n])) {
                        this.printUsage("Missing <# of threads> after -t");
                    }
                    try {
                        this.thrdNum = Integer.parseInt(string3);
                        if (this.thrdNum > 0) continue block23;
                        this.printUsage("# of threads specified (" + this.thrdNum + ") is not positive");
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.printUsage(string3 + " is not a valid number");
                    }
                    continue block23;
                }
                case 'e': {
                    if (string2.length() > 2) {
                        string3 = string2.substring(2);
                        if (this.isFlag(string3)) {
                            this.printUsage("Missing <error log> after -e");
                        }
                    } else if (++n >= n2 || this.isFlag(string3 = stringArray[n])) {
                        this.printUsage("Missing <error log> after -e");
                    }
                    try {
                        this.errors = new FileOutputStream(string3);
                    }
                    catch (IOException iOException) {
                        this.printUsage("The specified error log " + string3 + " could not be opened for writing: " + iOException.getMessage());
                    }
                    continue block23;
                }
                case 'w': {
                    this.warnings = true;
                    continue block23;
                }
                case 'd': {
                    if (string2.equals("-debug")) {
                        this.debugFlag = true;
                        continue block23;
                    }
                    this.xmldir = true;
                    if (string2.length() > 2) {
                        string3 = string2.substring(2);
                        if (this.isFlag(string3)) {
                            this.printUsage("Missing <directory> after -d");
                        }
                    } else if (++n >= n2 || this.isFlag(string3 = stringArray[n])) {
                        this.printUsage("Missing <directory> after -d");
                    }
                    this.basedir = string3;
                    continue block23;
                }
                case 'l': {
                    this.xmllist = true;
                    if (string2.length() > 2) {
                        this.xmlfiles.addElement(string2.substring(2));
                    }
                    while (++n < n2 && !this.isFlag(string2 = stringArray[n])) {
                        this.xmlfiles.addElement(string2);
                    }
                    if (this.xmlfiles.isEmpty()) {
                        this.printUsage("Missing <xml file list> after -l");
                    }
                    --n;
                    this.numXMLDocs = this.xmlfiles.size();
                    continue block23;
                }
                case 'x': {
                    if (string2.length() > 2) {
                        string3 = string2.substring(2);
                        if (this.isFlag(string3)) {
                            this.printUsage("Missing <source extension> after -x");
                        }
                    } else if (++n >= n2 || this.isFlag(string3 = stringArray[n])) {
                        this.printUsage("Missing <source extension> after -x");
                    }
                    this.omitExt = string3;
                    this.matchExtension = true;
                    continue block23;
                }
                case 'i': {
                    if (string2.length() > 2) {
                        string3 = string2.substring(2);
                        if (this.isFlag(string3)) {
                            this.printUsage("Missing <source extension> after -i");
                        }
                    } else if (++n >= n2 || this.isFlag(string3 = stringArray[n])) {
                        this.printUsage("Missing <source extension> after -i");
                    }
                    this.inclExt = string3;
                    this.matchExtension = true;
                    continue block23;
                }
                case 's': {
                    this.stylesheet = true;
                    if (string2.length() > 2) {
                        string3 = string2.substring(2);
                        if (this.isFlag(string3)) {
                            this.printUsage("Missing <stylesheet> after -s");
                        }
                    } else if (++n >= n2 || this.isFlag(string3 = stringArray[n])) {
                        this.printUsage("Missing <stylesheet> after -s");
                    }
                    this.xslinput = string3;
                    continue block23;
                }
                case 'r': {
                    this.resultext = true;
                    if (string2.length() > 2) {
                        string3 = string2.substring(2);
                        if (this.isFlag(string3)) {
                            this.printUsage("Missing <result extension> after -r");
                        }
                    } else if (++n >= n2 || this.isFlag(string3 = stringArray[n])) {
                        this.printUsage("Missing <result extension> after -r");
                    }
                    this.extension = string3;
                    continue block23;
                }
                case 'o': {
                    this.resdir = true;
                    if (string2.length() > 2) {
                        string3 = string2.substring(2);
                        if (this.isFlag(string3)) {
                            this.printUsage("Missing <directory> after -R");
                        }
                    } else if (++n >= n2 || this.isFlag(string3 = stringArray[n])) {
                        this.printUsage("Missing <directory> after -R");
                    }
                    this.resultdir = string3;
                    continue block23;
                }
                case 'z': {
                    n3 = string2.charAt(2);
                    continue block23;
                }
                case 'p': {
                    this.xmlpar = true;
                    object = null;
                    int n4 = -1;
                    if (string2.length() > 2) {
                        object = string2.substring(2);
                        if (this.isFlag((String)object) || (n4 = ((String)object).indexOf(n3)) == -1) {
                            this.printUsage("Missing <param list> after -p");
                        }
                    } else if (++n >= n2 || this.isFlag((String)(object = stringArray[n])) || (n4 = ((String)object).indexOf(n3)) == -1) {
                        this.printUsage("Missing <param list> after -p");
                    }
                    do {
                        string = ((String)object).substring(0, n4);
                        String string4 = ((String)object).substring(n4 + 1, ((String)object).length());
                        if (string.length() == 0 || string4.length() == 0) {
                            this.printUsage("'" + (String)object + "'" + " is not a valid parameter definition");
                        }
                        this.paramNames.addElement(string);
                        this.paramValues.addElement(string4);
                    } while (++n < n2 && !this.isFlag((String)(object = stringArray[n])) && (n4 = ((String)object).indexOf(n3)) != -1);
                    --n;
                    continue block23;
                }
                case 'm': {
                    if (string2.length() > 2) {
                        string3 = string2.substring(2);
                        if (this.isFlag(string3)) {
                            this.printUsage("Missing <version #> after -m");
                        }
                    } else if (++n >= n2 || this.isFlag(string3 = stringArray[n])) {
                        this.printUsage("Missing <version #> after -m");
                    }
                    try {
                        this.version = Integer.parseInt(string3);
                        if (this.version > 0 && this.version <= 2) continue block23;
                        this.printUsage("version # specified (" + this.version + ") should be either 1 or 2");
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.printUsage(string3 + " is not a valid number");
                    }
                    continue block23;
                }
                default: {
                    this.printUsage("Unknown flag '-" + string2.charAt(1) + "'");
                }
            }
        }
        int n5 = n2 - n;
        if (!(this.xmldir || this.xmllist || this.stylesheet || this.resultext)) {
            if (n5 != 2 && n5 != 3) {
                this.printUsage("Number of arguments specified (" + n2 + ")" + " is illegal");
            }
            this.xmlfiles.addElement(stringArray[n]);
            this.xslinput = stringArray[n + 1];
            if (n2 > n + 2) {
                this.output = stringArray[n + 2];
            }
        } else {
            if (!this.xmllist && !this.xmldir) {
                this.printUsage("One of -l or -d options must be specified");
            } else if (!this.stylesheet) {
                this.printUsage("-s option not specified");
            } else if (!this.resultext) {
                this.printUsage("-r option not specified");
            } else if (this.matchExtension && (this.xmllist || !this.xmldir)) {
                this.printUsage("-i or -o option can not be specified here");
            } else if (this.inclExt != null && this.omitExt != null) {
                this.printUsage("both -i and -o options specified");
            }
            if (!this.xmllist) {
                object2 = new File(this.basedir);
                if (!((File)object2).isDirectory()) {
                    this.printUsage(this.basedir + " is not a directory");
                }
                this.showTask("Processing files in directory " + this.basedir);
                object = ((File)object2).list();
                String string5 = null;
                if (this.matchExtension) {
                    string5 = this.omitExt != null ? "." + this.omitExt : "." + this.inclExt;
                }
                boolean bl = false;
                for (int i = 0; i < ((String[])object).length; ++i) {
                    string = object[i];
                    if (this.matchExtension) {
                        bl = string.endsWith(string5);
                        if (this.omitExt != null && bl || this.inclExt != null && !bl) continue;
                    }
                    this.xmlfiles.addElement(string);
                }
                if (this.xmlfiles.isEmpty()) {
                    this.printUsage("No files in directory " + this.basedir + " were selected for processing");
                }
                this.numXMLDocs = this.xmlfiles.size();
            }
            if (n5 != 0) {
                this.printUsage("Number of arguments specified (" + n2 + ")" + " is illegal");
            }
        }
    }

    private boolean isFlag(String string) {
        return string.charAt(0) == '-';
    }

    private void printUsage(String string) {
        String string2 = "";
        if (string != null) {
            string2 = string2 + "oraxsl: " + string + newline + usageMessage;
            this.exitWithError(string2);
        } else {
            System.out.println(usageMessage);
        }
    }

    private void exitWithError(String string) {
        PrintWriter printWriter = new PrintWriter(this.errors);
        printWriter.println(string);
        printWriter.flush();
        System.exit(1);
    }

    static {
        usageMessage = "usage: oraxsl options* source? stylesheet? result?" + newline + "            -w                          Show warnings" + newline + "            -e <error log>              A file to write errors to" + newline + "            -l <xml file list>          List of files to transform" + newline + "            -d <directory>              Directory with files to " + "transform" + newline + "            -x <source extension>       Extensions to exclude " + newline + "            -i <source extension>       Extensions to include " + newline + "            -s <stylesheet>             Stylesheet to use" + newline + "            -r <result extension>       Extension to use for results" + newline + "            -o <result directory>       Directory to place results" + newline + "            -p <param list>             List of Params " + newline + "            -t <# of threads>           Number of threads to use" + newline + "            -v                          Verbose mode" + newline + "            -debug                      Debug mode" + newline + "            -m <version #>              XSLT Version, 1 or 2" + newline + "Please refer to the readme file for more information on the above options";
    }
}

