/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.commx.Channel;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.commx.GroupView;
import oracle.ias.cache.commx.MessageQueue;
import oracle.ias.cache.commx.NetworkAddress;
import oracle.ias.cache.commx.ReplyInfo;
import oracle.ias.cache.groupv2.Address;
import oracle.ias.cache.groupv2.Client;
import oracle.ias.cache.groupv2.Configuration;
import oracle.ias.cache.groupv2.ConnectionOwner;
import oracle.ias.cache.groupv2.Distributor;
import oracle.ias.cache.groupv2.EndPointConnection;
import oracle.ias.cache.groupv2.GcommException;
import oracle.ias.cache.groupv2.GcommReplyInfo;
import oracle.ias.cache.groupv2.GcommSerializable;
import oracle.ias.cache.groupv2.MemberID;
import oracle.ias.cache.groupv2.Packet;
import oracle.ias.cache.groupv2.PacketHolder;
import oracle.ias.cache.groupv2.SequenceToken;
import oracle.ias.cache.groupv2.View;

public class GroupMember
implements Channel {
    static final String LOGGER_NAME = "oracle.ias.cache.groupv2.GroupMember";
    private Configuration config_;
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.groupv2.GroupMember");
    private Client client_;
    private Distributor distributor_;

    public static GroupMember create(Configuration configuration) throws GroupException {
        return GroupMember.create(configuration, null, null);
    }

    public static GroupMember create(Configuration configuration, MessageQueue messageQueue, Object object) throws GroupException {
        GroupMember groupMember = new GroupMember(configuration, messageQueue, object);
        return groupMember;
    }

    public void leave() throws GroupException {
        if (this.client_ != null) {
            this.client_.disconnect();
        }
        if (this.distributor_ != null) {
            this.distributor_.shutdown(false);
        }
    }

    public MemberID[] getMemberList() throws GroupException {
        return this.client_.getMemberList();
    }

    public GcommReplyInfo send(MemberID memberID, Serializable serializable, InputStream inputStream, String string, int n, long l) throws GroupException {
        GcommReplyInfo gcommReplyInfo = null;
        switch (n) {
            case 0: {
                gcommReplyInfo = this.client_.send(memberID, serializable, inputStream, string, false, l, false);
                break;
            }
            case 1: {
                gcommReplyInfo = this.client_.send(memberID, serializable, inputStream, string, true, l, false);
                break;
            }
            case 2: {
                gcommReplyInfo = this.client_.send(memberID, serializable, inputStream, string, true, l, true);
                break;
            }
        }
        return gcommReplyInfo;
    }

    public Packet getMessage(int n) throws GroupException {
        PacketHolder packetHolder = this.client_.dequeue(2, n);
        if (packetHolder != null) {
            Packet packet = packetHolder.getPacket();
            if (packet.getViewId() > this.client_.getViewManager().getCurrentView().getViewID()) {
                this.client_.enqueue(2, packetHolder);
                return null;
            }
            EndPointConnection endPointConnection = packetHolder.getOrigin();
            if (packet.isRegistered()) {
                if (this.logger_.isLoggable(Level.FINEST)) {
                    this.logger_.log(Level.FINEST, "Reply to sender " + packet);
                }
                Packet packet2 = new Packet(packet.getType(), this.getID());
                packet2.setAck(packet.getSequence());
                packet2.setAsReply();
                packet2.setViewId(packet.getViewId());
                packet2.setForRegistered();
                packet2.setDestination(packet.getOrigin());
                packet2.setBlockReceiver();
                this.client_.enqueue(0, PacketHolder.wrap(packet2, endPointConnection));
            }
            return packet;
        }
        return null;
    }

    public MemberID getID() {
        return this.client_.getID();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Member ID=");
        stringBuffer.append(this.getID());
        stringBuffer.append("\r\nConfiguration: ");
        stringBuffer.append(this.config_);
        stringBuffer.append("\r\nClient: ");
        stringBuffer.append(this.client_);
        if (this.distributor_ != null) {
            stringBuffer.append("\r\nDistributor: ");
            stringBuffer.append(this.distributor_);
        }
        return stringBuffer.toString();
    }

    protected boolean isADistributor() {
        boolean bl = false;
        if (this.distributor_ != null) {
            bl = true;
        }
        return bl;
    }

    protected boolean isACoordinator() {
        boolean bl = false;
        if (this.distributor_ != null) {
            bl = this.distributor_.isACoordinator();
        }
        return bl;
    }

    private GroupMember(Configuration configuration) throws GroupException {
        this(configuration, null, null);
    }

    private GroupMember(Configuration configuration, MessageQueue messageQueue, Object object) throws GroupException {
        this.config_ = configuration;
        if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "Configuration: " + configuration);
        }
        int n = 0;
        while (n++ < this.config_.getMaxSystemInitRetry()) {
            if (n > 1 && this.logger_.isLoggable(Level.INFO)) {
                this.logger_.info("Retry (" + n + ") GroupMember initialization");
            }
            this.startDistributor(false, null, null, null);
            try {
                this.client_ = new Client(this, this.config_, messageQueue, object);
                this.client_.init();
                return;
            }
            catch (GroupException groupException) {
                if (this.client_ != null) {
                    this.client_.cleanup();
                    this.client_ = null;
                }
                Object var6_6 = null;
                if (this.client_ != null) {
                    this.client_.getID();
                }
                if (this.logger_.isLoggable(Level.INFO)) {
                    this.logger_.log(Level.INFO, "Cause of client (id=" + var6_6 + ") initialization failure: ", groupException.getCause());
                }
                if (this.logger_.isLoggable(Level.WARNING)) {
                    this.logger_.log(Level.WARNING, "Failed to register. Retry=" + n);
                }
                try {
                    Thread.sleep(this.config_.getMaxInitRetryDelay());
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (n >= this.config_.getMaxSystemInitRetry()) {
            if (this.logger_.isLoggable(Level.SEVERE)) {
                this.logger_.severe("Unable to find or become a group distributor after reaching retry limit:" + (n - 1));
            }
            if (this.distributor_ != null) {
                this.distributor_.shutdown(false);
                this.distributor_ = null;
            }
            throw new GcommException(GcommException.INITRETRY);
        }
    }

    boolean startDistributor(boolean bl, View view, MemberID memberID, SequenceToken sequenceToken) {
        boolean bl2;
        block8: {
            bl2 = false;
            try {
                if (this.distributor_ == null) {
                    if (this.logger_.isLoggable(Level.INFO)) {
                        this.logger_.log(Level.INFO, "Attempt to start distributor failover=" + bl + " in " + ConnectionOwner.getVMId());
                    }
                    this.distributor_ = new Distributor(this, this.config_);
                    this.distributor_.init(bl, view, memberID, sequenceToken);
                    if (this.logger_.isLoggable(Level.INFO)) {
                        this.logger_.log(Level.INFO, "Distributor is initialized successfully");
                    }
                    bl2 = true;
                }
            }
            catch (GroupException groupException) {
                if (this.distributor_ != null) {
                    try {
                        this.distributor_.shutdown(false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.distributor_ = null;
                }
                if (!this.logger_.isLoggable(Level.INFO)) break block8;
                this.logger_.info("Distributor exists locally or resides remotely");
            }
        }
        return bl2;
    }

    public NetworkAddress getLocalAddress() {
        Address address;
        block2: {
            address = null;
            try {
                address = new Address(this.client_.getID(), this.getGlobalPosition(), this.config_.getCacheName(), this.config_.getTag());
            }
            catch (GroupException groupException) {
                if (!this.logger_.isLoggable(Level.SEVERE)) break block2;
                this.logger_.log(Level.SEVERE, "Internal local address error", groupException);
            }
        }
        return address;
    }

    public String getTag() {
        String string = null;
        byte[] byArray = (byte[])this.config_.getTag();
        if (byArray != null) {
            string = GcommSerializable.bytesToString(byArray);
        }
        return string;
    }

    public int getGlobalPosition() {
        int n = 0;
        MemberID memberID = this.client_.getID();
        View view = this.client_.getViewManager().getCurrentView();
        n = view.indexOfMember(memberID);
        return n;
    }

    public String getGlobalUid() {
        return this.client_.getID().toString();
    }

    public boolean isAlive(String string) {
        boolean bl = false;
        if (string == null) {
            return false;
        }
        MemberID memberID = MemberID.parse(string);
        View view = this.client_.getViewManager().getCurrentView();
        bl = view.contains(memberID);
        return bl;
    }

    public boolean isValidTag(String string) {
        boolean bl = false;
        if (string == null) {
            return false;
        }
        try {
            View view = this.client_.getViewManager().getCurrentView();
            bl = view.containsTag(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public void close() {
        try {
            this.leave();
        }
        catch (GroupException groupException) {
            // empty catch block
        }
    }

    public boolean hasReceivedAll(Object object) {
        Long l = (Long)object;
        return this.client_.hasAll(l);
    }

    public GroupView getView() throws GroupException {
        View view = this.client_.getViewManager().getCurrentView();
        return view;
    }

    public ReplyInfo multicast(Serializable serializable, long l) throws GroupException {
        return this.send(null, serializable, null, null, 0, 600000L);
    }

    public ReplyInfo multicast(Serializable serializable, int n, long l, long l2) throws GroupException {
        return this.send(null, serializable, null, null, n, l2);
    }

    public ReplyInfo multicast(Serializable serializable, int n, long l, long l2, boolean bl) throws GroupException {
        return this.send(null, serializable, null, null, n, l2);
    }

    public void send(NetworkAddress networkAddress, Serializable serializable) throws GroupException {
        this.send((MemberID)networkAddress.getMemberID(), serializable, null, null, 0, 600000L);
    }

    public void send(NetworkAddress networkAddress, Serializable serializable, long l) throws GroupException {
        this.send((MemberID)networkAddress.getMemberID(), serializable, null, null, 0, 600000L);
    }

    public void send(NetworkAddress networkAddress, Serializable serializable, long l, String string) throws GroupException {
        this.send((MemberID)networkAddress.getMemberID(), serializable, null, string, 0, 600000L);
    }

    public long[][] getIOCounters(boolean bl) {
        return null;
    }

    void dump() {
        this.logger_.log(Level.WARNING, this.toString());
    }

    public String[] getPacketTypeNames() {
        return Packet.TYPE_NAMES;
    }
}

