/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.groupv2.ConnectionOwner;
import oracle.ias.cache.groupv2.MemberID;
import oracle.ias.cache.groupv2.Packet;
import oracle.ias.cache.groupv2.ReceiptHolder;
import oracle.ias.cache.groupv2.View;

class ClientReceiptHolder
extends ReceiptHolder {
    static final String LOGGER_NAME = "oracle.ias.cache.groupv2.ClientReceiptHolder";
    private View v_;
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.groupv2.ClientReceiptHolder");

    ClientReceiptHolder(ConnectionOwner connectionOwner, View view, Packet packet) throws GroupException {
        this(connectionOwner, view, null, null, packet);
    }

    ClientReceiptHolder(ConnectionOwner connectionOwner, View view, MemberID[] memberIDArray, MemberID[] memberIDArray2, Packet packet) throws GroupException {
        super(connectionOwner, packet);
        this.v_ = view;
        boolean[] blArray = this.v_.getMemberMap(memberIDArray, memberIDArray2);
        this.bs_ = blArray == null || blArray.length <= 0 ? new boolean[0] : (boolean[])blArray.clone();
        this.totalExpected_ = this.getTotalPending();
    }

    synchronized int addReceipt(Packet packet) {
        int n = 0;
        MemberID memberID = MemberID.parse(packet.getOrigin());
        int n2 = this.v_.indexOfMember(memberID);
        if (n2 < 0 || n2 >= this.bs_.length) {
            if (this.logger_.isLoggable(Level.SEVERE)) {
                this.logger_.log(Level.SEVERE, "Unknown recipient " + packet.toString(true));
            }
            n = this.getTotalPending();
            return n;
        }
        ++this.totalArrival_;
        if (!this.bs_[n2] && !this.parent_.getID().equals(this.v_.getMemberByIndex(n2)) && this.logger_.isLoggable(Level.SEVERE)) {
            this.logger_.log(Level.SEVERE, "Receipt already clear " + packet.toString(true));
        }
        this.bs_[n2] = false;
        n = this.getTotalPending();
        if (n == 0) {
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "Got all receipts for ack=" + packet.getAck());
            }
            this.notifyAll();
        } else if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "Clear receipt for " + memberID + ", ack=" + packet.getAck() + ", total=" + n);
        }
        return n;
    }

    synchronized void removeMember(MemberID memberID) {
        if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "removing receipt for " + memberID + " sq=" + this.tag_);
        }
        int n = 0;
        int n2 = this.v_.indexOfMember(memberID);
        if (n2 < 0 || n2 >= this.bs_.length) {
            if (this.logger_.isLoggable(Level.SEVERE)) {
                this.logger_.log(Level.SEVERE, "Unknown recipient " + memberID);
            }
            return;
        }
        if (!this.bs_[n2]) {
            return;
        }
        this.bs_[n2] = false;
        n = this.getTotalPending();
        if (n == 0) {
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "Got all receipts for ack=" + this.tag_);
            }
            this.notifyAll();
        } else if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "Remove receipt for " + memberID + ", sq=" + this.tag_ + ", total=" + n);
        }
    }

    synchronized void removeNonExistMembersFrom(View view) {
        if (this.v_.getViewID() == view.getViewID()) {
            return;
        }
        MemberID[] memberIDArray = this.v_.getNonExistMembersOf(view);
        if (memberIDArray == null || memberIDArray.length <= 0) {
            return;
        }
        for (int i = 0; i < memberIDArray.length; ++i) {
            this.removeMember(memberIDArray[i]);
        }
    }

    synchronized int removeDistributor(MemberID memberID) {
        int n = this.getTotalPending();
        int n2 = this.v_.indexOfDistributor(memberID);
        if (n2 < 0) {
            if (this.logger_.isLoggable(Level.SEVERE)) {
                this.logger_.log(Level.SEVERE, "Unknown distributor " + memberID);
            }
            return n;
        }
        int[] nArray = this.v_.getAllMemberIndexOf(memberID);
        if (nArray == null) {
            return n;
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.bs_[nArray[i]] = false;
        }
        n = this.getTotalPending();
        if (n == 0) {
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "Got all receipts for ack=" + this.tag_);
            }
            this.notifyAll();
        } else if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "Remove receipts of distributor for sq=" + this.tag_ + ", pending=" + n);
        }
        return n;
    }

    synchronized MemberID[] getPendingMembers() {
        MemberID[] memberIDArray = null;
        Vector<MemberID> vector = new Vector<MemberID>();
        for (int i = 0; i < this.bs_.length; ++i) {
            MemberID memberID;
            if (!this.bs_[i] || (memberID = this.v_.getMemberByIndex(i)) == null) continue;
            vector.addElement(memberID);
        }
        if (vector.size() > 0) {
            memberIDArray = new MemberID[vector.size()];
            vector.toArray(memberIDArray);
        }
        return memberIDArray;
    }

    void logExpiredRecipients() {
        for (int i = 0; i < this.bs_.length; ++i) {
            if (!this.bs_[i] || !this.logger_.isLoggable(Level.SEVERE)) continue;
            this.logger_.log(Level.SEVERE, "Expired recipient " + this.v_.getMemberByIndex(i) + " of " + this.terminatorPacket_);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ReceiptHolder based on VID=");
        stringBuffer.append(this.v_.getViewID());
        stringBuffer.append(", pending=[");
        for (int i = 0; i < this.bs_.length; ++i) {
            if (!this.bs_[i]) continue;
            stringBuffer.append(this.v_.getMemberByIndex(i));
            stringBuffer.append(" ");
        }
        stringBuffer.append("], ");
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }
}

