/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import oracle.ias.cache.CacheInternal;
import oracle.ias.cache.Task;
import oracle.ias.cache.ThreadPool;

class WorkerThread
extends Thread {
    static ThreadGroup WORKER_GRP = new ThreadGroup("Worker-Thread-Group");
    int id;
    volatile boolean shouldRun = true;
    volatile boolean stop = false;

    WorkerThread(int n) {
        super(WORKER_GRP, "Worker-" + n);
        this.id = n;
        this.setDaemon(true);
    }

    void setShouldRun(boolean bl) {
        this.shouldRun = bl;
    }

    boolean isShouldRun() {
        return this.shouldRun;
    }

    boolean isStop() {
        return this.stop;
    }

    public void run() {
        try {
            Task task;
            while (this.shouldRun && (task = ThreadPool.taskQ.getTask()) != null) {
                ThreadPool.setBusy(this.id, true);
                task.execute();
                ThreadPool.setBusy(this.id, false);
            }
        }
        catch (Exception exception) {
            CacheInternal.exceptionLog("[Mem] ", exception);
            ThreadPool.setBusy(this.id, false);
        }
        this.stop = true;
    }
}

