/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import oracle.ias.cache.CacheCtx;

class RegionTable {
    static final int BUCKCNT = 13;
    static final int BUCKLENGTH = 10;
    String[][] regionTable = new String[13][10];
    CacheCtx[][] ctxTable = new CacheCtx[13][10];
    CacheCtx[] ctxList;
    CacheCtx defaultCtx;
    int[] maxSize = new int[13];
    int[] currSize = new int[13];

    RegionTable() {
        this.ctxList = new CacheCtx[0];
        for (int i = 0; i < 13; ++i) {
            this.maxSize[i] = 10;
            this.currSize[i] = 0;
        }
    }

    CacheCtx getCtx(String string) {
        int n = string.indexOf("/");
        if (n <= 0) {
            n = string.length();
        }
        String string2 = string.substring(0, n);
        int n2 = this.hashName(string2) % 13;
        String[] stringArray = this.regionTable[n2];
        for (int i = 0; i < this.currSize[n2]; ++i) {
            if (!string2.equals(stringArray[i])) continue;
            return this.ctxTable[n2][i];
        }
        return null;
    }

    CacheCtx[] getCtxList() {
        return this.ctxList;
    }

    void setDefaultCtx(CacheCtx cacheCtx) {
        this.defaultCtx = cacheCtx;
        this.ctxList = this.buildCtxList();
    }

    synchronized void setCtx(String string, CacheCtx cacheCtx) {
        int n = this.hashName(string) % 13;
        int n2 = this.currSize[n];
        for (int i = 0; i < this.currSize[n]; ++i) {
            if (this.regionTable[n][i] != null) continue;
            n2 = i;
            break;
        }
        if (n2 >= this.currSize[n]) {
            int n3 = n;
            this.currSize[n3] = this.currSize[n3] + 1;
            if (this.currSize[n] == this.maxSize[n]) {
                this.growBucket(n);
            }
        }
        this.regionTable[n][n2] = new String(string);
        this.ctxTable[n][n2] = cacheCtx;
        this.ctxList = this.buildCtxList();
    }

    synchronized CacheCtx removeCtx(String string) {
        boolean bl = false;
        CacheCtx cacheCtx = null;
        int n = string.indexOf("/") - 1;
        if (n <= 0) {
            n = string.length();
            bl = true;
        }
        String string2 = string.substring(0, n);
        int n2 = this.hashName(string2) % 13;
        for (int i = 0; i < this.currSize[n2]; ++i) {
            if (!string.equals(this.regionTable[n2][i])) continue;
            cacheCtx = this.ctxTable[n2][i];
            if (!bl) break;
            this.regionTable[n2][i] = null;
            this.ctxTable[n2][i] = null;
            if (this.currSize[n2] != i + 1) break;
            for (int j = i; j >= 0 && this.regionTable[n2][j] == null; --j) {
                int n3 = n2;
                this.currSize[n3] = this.currSize[n3] - 1;
            }
            break;
        }
        if (bl) {
            this.ctxList = this.buildCtxList();
        }
        return cacheCtx;
    }

    private void growBucket(int n) {
        int n2 = this.maxSize[n] + 10;
        String[] stringArray = new String[n2];
        CacheCtx[] cacheCtxArray = new CacheCtx[n2];
        for (int i = 0; i < this.maxSize[n]; ++i) {
            stringArray[i] = this.regionTable[n][i];
            cacheCtxArray[i] = this.ctxTable[n][i];
        }
        this.regionTable[n] = stringArray;
        this.ctxTable[n] = cacheCtxArray;
        this.maxSize[n] = n2;
    }

    private CacheCtx[] buildCtxList() {
        int n;
        int n2 = 1;
        int n3 = 0;
        for (n = 0; n < 13; ++n) {
            n3 += this.currSize[n];
        }
        CacheCtx[] cacheCtxArray = new CacheCtx[n3 + 1];
        cacheCtxArray[0] = this.defaultCtx;
        for (n = 0; n < 13; ++n) {
            for (int i = 0; i < this.currSize[n]; ++i) {
                if (this.ctxTable[n][i] == null) continue;
                cacheCtxArray[n2++] = this.ctxTable[n][i];
            }
        }
        return cacheCtxArray;
    }

    private int hashName(Object object) {
        int n = object.hashCode();
        return n & Integer.MAX_VALUE;
    }
}

