/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.CacheCtx;
import oracle.ias.cache.Net;

class FileLock {
    static final String LOCK_NAME = "_lock_";
    private static final int WAIT_TIME = 50;
    private static final int DEFAULT_RETRY = 1000;
    private static final int READ_RETRY = 100;
    private static final char SEPARATOR = '_';
    private static final String LOGGER_NAME = "oracle.ias.cache.FileLock";
    private static Logger s_logger = Logger.getLogger("oracle.ias.cache.FileLock");
    private boolean locked = false;
    private File lock;
    private File owner;
    private boolean local;
    private Net net;
    private CacheCtx cacheCtx;

    FileLock(String string, boolean bl, CacheCtx cacheCtx) {
        this.local = bl;
        this.cacheCtx = cacheCtx;
        this.net = cacheCtx.getNet();
        this.lock = new File(string, LOCK_NAME);
    }

    void cleanLock(String string) {
        boolean bl;
        long l = -1L;
        long l2 = -1L;
        int n = 0;
        String[] stringArray = null;
        File file = new File(string, LOCK_NAME);
        if (s_logger.isLoggable(Level.FINEST)) {
            s_logger.log(Level.FINEST, "[Dsk] FileLock cleaning " + file);
        }
        while ((bl = file.exists()) && n < 100) {
            try {
                stringArray = file.list();
                if (stringArray != null && stringArray.length != 0) {
                    break;
                }
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            ++n;
        }
        if (!bl) {
            return;
        }
        if (n != 100) {
            if (this.net.isAlive(stringArray[0])) {
                if (s_logger.isLoggable(Level.FINEST)) {
                    s_logger.log(Level.FINEST, "[Dsk] FileLock found live process " + l + " holds " + file);
                }
            } else {
                if (s_logger.isLoggable(Level.INFO)) {
                    s_logger.log(Level.INFO, "[Dsk] FileLock found dead " + file + " uid=" + l);
                }
                this.deleteLock(file, new File(file, stringArray[0]));
            }
        } else {
            if (s_logger.isLoggable(Level.INFO)) {
                s_logger.log(Level.INFO, "[Dsk] FileLock found an uncompleted dead " + file);
            }
            this.deleteLock(file, null);
        }
    }

    private boolean createLockFile(String string) {
        boolean bl;
        block8: {
            try {
                this.owner = new File(this.lock, this.net.getGlobalUid());
                bl = this.lock.mkdir();
                if (!bl) break block8;
                try {
                    bl = this.owner.mkdir();
                    if (!bl && s_logger.isLoggable(Level.INFO)) {
                        s_logger.log(Level.INFO, "[Dsk] FileLock fail to create " + this.owner);
                    }
                }
                catch (Exception exception) {
                    if (s_logger.isLoggable(Level.INFO)) {
                        s_logger.log(Level.INFO, "[Dsk] FileLock creating " + this.owner, exception);
                    }
                    bl = false;
                }
                if (!bl && !this.lock.delete() && s_logger.isLoggable(Level.INFO)) {
                    s_logger.log(Level.INFO, "[Dsk] FileLock fail to delete failed " + this.lock);
                }
                return bl;
            }
            catch (Exception exception) {
                if (s_logger.isLoggable(Level.INFO)) {
                    s_logger.log(Level.INFO, "[Dsk] FileLock creating " + this.lock, exception);
                }
                bl = false;
            }
        }
        return bl;
    }

    boolean getLock(String string, int n) {
        if (this.local) {
            return true;
        }
        if (n <= 0) {
            n = 1000;
        }
        int n2 = 0;
        while (!this.locked) {
            if (s_logger.isLoggable(Level.FINEST)) {
                s_logger.log(Level.FINEST, "[Dsk] FileLock getting " + string + " " + this.lock + " retry=" + n2);
            }
            this.locked = this.createLockFile(string);
            if (this.locked) break;
            if (++n2 == n) {
                return false;
            }
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        }
        if (s_logger.isLoggable(Level.FINEST)) {
            s_logger.log(Level.FINEST, "[Dsk] FileLock got lock " + this.lock);
        }
        return true;
    }

    void releaseLock() {
        if (this.local) {
            return;
        }
        this.deleteLock(this.lock, this.owner);
        this.locked = false;
        if (s_logger.isLoggable(Level.FINEST)) {
            s_logger.log(Level.FINEST, "[Dsk] FileLock released " + this.lock);
        }
    }

    private void deleteLock(File file, File file2) {
        if (file2 != null && file2.exists() && !file2.delete() && s_logger.isLoggable(Level.INFO)) {
            s_logger.log(Level.INFO, "[Dsk] FileLock can not delete owner " + file2);
        }
        if (!file.delete() && s_logger.isLoggable(Level.INFO)) {
            s_logger.log(Level.INFO, "[Dsk] FileLock can not delete lock " + file);
        }
    }

    boolean exists() {
        return this.lock.exists();
    }
}

