/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.PrintGraphics;
import java.awt.Shape;
import java.util.Stack;
import oracle.bali.ewt.graphics.FontUtils;
import oracle.bali.ewt.print.PrintGraphicsProxy;

public class StackPrintGraphics
extends PrintGraphicsProxy {
    private static final Color _DEFAULT_XOR_COLOR = new Color(0);
    private int _currXOrigin = 0;
    private int _currYOrigin = 0;
    private Color _currXORColor = _DEFAULT_XOR_COLOR;
    private Stack _stateStack = new Stack();

    public StackPrintGraphics(Graphics graphics) {
        this(graphics, (PrintGraphics)((Object)graphics));
        Font font;
        Color color = graphics.getColor();
        if (color == null) {
            this.setColor(Color.black);
        }
        if ((font = graphics.getFont()) == null) {
            this.setFont(FontUtils.getDefaultSansSerifFont());
        }
    }

    public StackPrintGraphics(Graphics graphics, PrintGraphics printGraphics) {
        super(graphics, printGraphics);
        this.create();
    }

    public synchronized Graphics create() {
        this._stateStack.push(new GraphicsState(this.getGraphics(), this._currXOrigin, this._currYOrigin, this._currXORColor));
        this._currXOrigin = 0;
        this._currYOrigin = 0;
        return this;
    }

    public synchronized void translate(int n, int n2) {
        this._currXOrigin += n;
        this._currYOrigin += n2;
        super.translate(n, n2);
    }

    public synchronized void setXORMode(Color color) {
        this._currXORColor = color;
        super.setXORMode(color);
    }

    public synchronized void dispose() {
        Graphics graphics = this.getGraphics();
        graphics.translate(-this._currXOrigin, -this._currYOrigin);
        GraphicsState graphicsState = (GraphicsState)this._stateStack.pop();
        graphicsState.apply(graphics);
        this._currXOrigin = graphicsState.getXOrigin();
        this._currYOrigin = graphicsState.getYOrigin();
        if (this._stateStack.empty()) {
            super.dispose();
        }
    }

    private void _indent() {
        int n = this._stateStack.size();
        int n2 = 0;
        while (n2 < n) {
            System.out.print(" ");
            ++n2;
        }
    }

    private class GraphicsState {
        private int _xOrigin;
        private int _yOrigin;
        private Color _color;
        private Font _font;
        private Shape _clipShape;
        private Color _xorColor;

        public GraphicsState(Graphics graphics, int n, int n2, Color color) {
            this._xOrigin = n;
            this._yOrigin = n2;
            this._xorColor = color;
            this._color = graphics.getColor();
            this._font = graphics.getFont();
            this._clipShape = graphics.getClip();
        }

        public void apply(Graphics graphics) {
            graphics.setColor(this._color);
            graphics.setFont(this._font);
            graphics.setClip(this._clipShape);
            if (this._xorColor != _DEFAULT_XOR_COLOR) {
                graphics.setXORMode(this._xorColor);
            }
        }

        public int getXOrigin() {
            return this._xOrigin;
        }

        public int getYOrigin() {
            return this._yOrigin;
        }
    }
}

