/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.olaf.OracleFieldCaret;
import oracle.bali.ewt.olaf.OracleUIUtils;

public class OracleTextFieldUI
extends BasicTextFieldUI {
    private static final String _UNEDITABLE_BACKGROUND = "control";

    public static ComponentUI createUI(JComponent jComponent) {
        return new OracleTextFieldUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setOpaque(true);
        OracleTextFieldUI.__initializeBackground(jComponent);
        OracleUIUtils.putPaintContext(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        OracleUIUtils.removePaintContext(jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            OracleUIUtils.fillBackground(graphics, jComponent);
        }
        this.paint(graphics, jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = super.getMinimumSize(jComponent);
        dimension.width += ((Component)jComponent).getFontMetrics(jComponent.getFont()).charWidth('m');
        return dimension;
    }

    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        OracleTextFieldUI.__fixBackground(propertyChangeEvent, "TextField.background");
    }

    protected void paintBackground(Graphics graphics) {
    }

    private OracleTextFieldUI() {
    }

    static void __initializeBackground(JComponent jComponent) {
        JTextComponent jTextComponent = (JTextComponent)jComponent;
        if (!(!(jComponent.getBackground() instanceof UIResource) || jTextComponent.isEditable() && jTextComponent.isEnabled())) {
            jComponent.setBackground(UIManager.getColor(_UNEDITABLE_BACKGROUND));
        }
    }

    static void __fixBackground(PropertyChangeEvent propertyChangeEvent, String string) {
        if ("editable".equals(propertyChangeEvent.getPropertyName()) || "enabled".equals(propertyChangeEvent.getPropertyName())) {
            JComponent jComponent = (JComponent)propertyChangeEvent.getSource();
            boolean bl = Boolean.TRUE.equals(propertyChangeEvent.getNewValue());
            if (jComponent.getBackground() instanceof UIResource) {
                UIDefaults uIDefaults = OracleUIUtils.getUIDefaults(jComponent);
                jComponent.setBackground(uIDefaults.getColor(bl ? string : _UNEDITABLE_BACKGROUND));
            }
        }
    }

    protected Caret createCaret() {
        return new OracleFieldCaret();
    }
}

