/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.header;

import java.awt.event.KeyEvent;
import java.beans.PropertyVetoException;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderKeyHandler;
import oracle.bali.ewt.selection.OneDSelection;

public class StandardHeaderKeyHandler
implements HeaderKeyHandler {
    private static HeaderKeyHandler _sManager;

    public static HeaderKeyHandler getHeaderKeyHandler() {
        if (_sManager == null) {
            _sManager = new StandardHeaderKeyHandler();
        }
        return _sManager;
    }

    public void handleKeyEvent(Header header, KeyEvent keyEvent) {
        if (keyEvent.isConsumed() || keyEvent.isAltDown()) {
            return;
        }
        OneDSelection oneDSelection = header.getSelection();
        int n = header.getFocusItem();
        int n2 = -1;
        int n3 = header.getAnchorItem();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = keyEvent.isControlDown();
        boolean bl4 = keyEvent.isShiftDown();
        int n4 = keyEvent.getID();
        if (keyEvent.getKeyCode() == 32) {
            if (n4 == 401) {
                header.setArmedItem(n);
                n2 = n;
                bl2 = true;
                if (keyEvent.isControlDown()) {
                    bl = true;
                }
            } else if (n4 == 402) {
                header.setArmedItem(-1);
            }
        } else if (n4 == 401) {
            switch (keyEvent.getKeyCode()) {
                case 40: {
                    n2 = this.down(header, n, keyEvent);
                    break;
                }
                case 38: {
                    n2 = this.up(header, n, keyEvent);
                    break;
                }
                case 37: {
                    n2 = this.left(header, n, keyEvent);
                    break;
                }
                case 39: {
                    n2 = this.right(header, n, keyEvent);
                    break;
                }
                case 35: {
                    n2 = this.end(header, n, keyEvent);
                    break;
                }
                case 36: {
                    n2 = this.home(header, n, keyEvent);
                }
            }
        }
        if (n2 == -1 || n2 == n && !bl2) {
            return;
        }
        keyEvent.consume();
        header.freezeRepaints();
        try {
            if (bl2) {
                if (oneDSelection.contains(n2)) {
                    if (bl) {
                        oneDSelection = oneDSelection.subtract(n2);
                    }
                } else {
                    oneDSelection = oneDSelection.add(n2);
                }
                header.setAnchorItem(n2);
            } else if (bl4 && n3 != -1) {
                oneDSelection = bl3 ? oneDSelection.add(n2) : new OneDSelection(n3, n2);
            } else if (!bl3) {
                oneDSelection = new OneDSelection(n2, n2);
                header.setAnchorItem(n2);
            }
            try {
                header.setSelection(oneDSelection);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            header.setFocusItem(n2);
            Object var14_13 = null;
            header.unfreezeRepaints();
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            header.unfreezeRepaints();
            throw throwable;
        }
        header.scrollItemIntoView(n2);
    }

    protected int left(Header header, int n, KeyEvent keyEvent) {
        if (header.getOrientation() == 1) {
            return n;
        }
        keyEvent.consume();
        int n2 = n == -1 ? header.getNextVisibleItem(-1) : header.getPreviousVisibleItem(n);
        if (n2 == -1) {
            return n;
        }
        return n2;
    }

    protected int right(Header header, int n, KeyEvent keyEvent) {
        if (header.getOrientation() == 1) {
            return n;
        }
        keyEvent.consume();
        int n2 = n == -1 ? header.getNextVisibleItem(-1) : header.getNextVisibleItem(n);
        if (n2 == -1) {
            return n;
        }
        return n2;
    }

    protected int up(Header header, int n, KeyEvent keyEvent) {
        if (header.getOrientation() == 0) {
            return n;
        }
        keyEvent.consume();
        int n2 = n == -1 ? header.getNextVisibleItem(-1) : header.getPreviousVisibleItem(n);
        if (n2 == -1) {
            return n;
        }
        return n2;
    }

    protected int down(Header header, int n, KeyEvent keyEvent) {
        if (header.getOrientation() == 0) {
            return n;
        }
        keyEvent.consume();
        int n2 = n == -1 ? header.getNextVisibleItem(-1) : header.getNextVisibleItem(n);
        if (n2 == -1) {
            return n;
        }
        return n2;
    }

    protected int home(Header header, int n, KeyEvent keyEvent) {
        keyEvent.consume();
        return header.getNextVisibleItem(-1);
    }

    protected int end(Header header, int n, KeyEvent keyEvent) {
        keyEvent.consume();
        int n2 = header.getItemCount();
        return header.getPreviousVisibleItem(n2);
    }

    protected StandardHeaderKeyHandler() {
    }
}

