/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.model.TwoDModel;

public abstract class DirectInputHandler
extends CellInputHandler {
    private int _column;
    private int _row;
    private boolean _inCell;

    public void mousePressed(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        super.mousePressed(mouseEvent, grid, n, n2);
        this._column = n;
        this._row = n2;
        this._inCell = true;
        grid.paintCell(n, n2);
    }

    public void mouseReleased(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        super.mouseReleased(mouseEvent, grid, n, n2);
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && this._column == n && this._row == n2 && this._inCell) {
            this.updateValue(grid, n, n2);
        }
        this._column = -1;
        this._row = -1;
        this._inCell = false;
    }

    public void mouseDragged(MouseEvent mouseEvent, Grid grid, int n, int n2) {
        super.mouseDragged(mouseEvent, grid, n, n2);
        boolean bl = this._inCell;
        boolean bl2 = this._inCell = mouseEvent.getX() >= 0 && mouseEvent.getX() <= grid.getColumnWidth(n) && mouseEvent.getY() >= 0 && mouseEvent.getY() <= grid.getRowHeight(n2);
        if (bl != this._inCell) {
            grid.paintCell(n, n2);
        }
    }

    public void keyReleased(KeyEvent keyEvent, Grid grid, int n, int n2) {
        super.keyReleased(keyEvent, grid, n, n2);
        if (keyEvent.getKeyCode() == 32) {
            this.updateValue(grid, n, n2);
            keyEvent.consume();
        }
    }

    protected final void updateValue(Grid grid, int n, int n2) {
        if (grid.fireCancelableCellEvent(n, n2, 2001)) {
            grid.repaintCell(n, n2);
            return;
        }
        TwoDModel twoDModel = grid.getModel();
        twoDModel.setData(n, n2, this.getNewValue(grid, n, n2, twoDModel.getData(n, n2)));
        grid.fireCellEvent(n, n2, 2002);
    }

    protected abstract Object getNewValue(Grid var1, int var2, int var3, Object var4);

    protected DirectInputHandler() {
    }
}

