/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.basic;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeButtonDecoration;
import oracle.bali.ewt.dTree.DTreeDeferringParent;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeLineDecoration;
import oracle.bali.ewt.dTree.DTreeStackingDecoration;
import oracle.bali.ewt.elaf.EWTTreeUI;
import oracle.bali.ewt.elaf.basic.TreeDropHighlightPainter;
import oracle.bali.ewt.painter.LinePainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.TextPainter;
import oracle.bali.ewt.util.ImmInsets;

public abstract class BasicEWTTreeUI
extends EWTTreeUI {
    private Painter _itemPainter;
    private Painter _afterItemPainter;
    private Painter _beforeItemPainter;
    private Painter _textPainter;
    private ImmInsets _selectionInsets = new ImmInsets(1, 1, 1, 1);
    private ImmInsets _focusInsets = new ImmInsets(2, 2, 2, 2);

    public Rectangle getEditBounds(JComponent jComponent, PaintContext paintContext, DTreeItem dTreeItem) {
        Painter painter = this.getTextPainter();
        Dimension dimension = painter.getMinimumSize(paintContext);
        Dimension dimension2 = dTreeItem.getSize();
        ImmInsets immInsets = this.getSelectionInsets();
        ImmInsets immInsets2 = this.getFocusInsets();
        dimension.height += immInsets.top + immInsets.bottom + immInsets2.top + immInsets2.bottom;
        dimension.width += immInsets.left + immInsets.right + immInsets2.left + immInsets2.right;
        return new Rectangle(immInsets.left + immInsets2.left + dimension2.width - dimension.width, (dimension2.height - dimension.height) / 2, dimension.width, dimension.height);
    }

    public Painter getItemPainter(JComponent jComponent, DTreeItem dTreeItem) {
        Painter painter = this._getItemPainter();
        DTree dTree = (DTree)jComponent;
        DTreeItem dTreeItem2 = dTree.getDropHighlightItem();
        if (dTreeItem2 == dTreeItem) {
            int n = dTree.getDropHighlightStyle();
            if (n == 2) {
                if (this._beforeItemPainter == null) {
                    this._beforeItemPainter = new TreeDropHighlightPainter(this._getItemPainter(), true);
                }
                painter = this._beforeItemPainter;
            } else if (n == 3) {
                if (this._afterItemPainter == null) {
                    this._afterItemPainter = new TreeDropHighlightPainter(this._getItemPainter(), false);
                }
                painter = this._afterItemPainter;
            }
        }
        return painter;
    }

    public int getDeferredChildHeight(JComponent jComponent, PaintContext paintContext, DTreeDeferringParent dTreeDeferringParent, int n) {
        Font font = paintContext.getPaintFont();
        FontMetrics fontMetrics = null;
        if (font == null || (fontMetrics = paintContext.getFontMetrics(font)) == null) {
            return 0;
        }
        int n2 = fontMetrics.getAscent() + fontMetrics.getDescent();
        ImmInsets immInsets = this.getSelectionInsets();
        ImmInsets immInsets2 = this.getFocusInsets();
        return Math.max(n, n2 += immInsets.top + immInsets.bottom + immInsets2.top + immInsets2.bottom);
    }

    public Icon getExpansionButtonIcon(JComponent jComponent, DTreeItem dTreeItem) {
        String string = dTreeItem.isExpanded() ? "Tree.expandedIcon" : "Tree.collapsedIcon";
        return ((DTree)jComponent).getUIDefaults().getIcon(string);
    }

    public Image getMultiItemDragImage(JComponent jComponent) {
        return (Image)((DTree)jComponent).getUIDefaults().get("EWTTree.multiItemDrag");
    }

    public void installUI(JComponent jComponent) {
        DTree dTree = (DTree)jComponent;
        UIDefaults uIDefaults = dTree.getUIDefaults();
        jComponent.setOpaque(true);
        LookAndFeel.installColorsAndFont(jComponent, "Tree.background", "Tree.foreground", "Tree.font");
        DTreeButtonDecoration dTreeButtonDecoration = new DTreeButtonDecoration();
        if (this.isLineDrawn()) {
            DTreeLineDecoration dTreeLineDecoration = new DTreeLineDecoration(new LinePainter(true, this.isLineDotted()), new LinePainter(false, this.isLineDotted()), uIDefaults.getColor("darkIntensity"));
            dTree.setDecoration(new DTreeStackingDecoration(dTreeLineDecoration, dTreeButtonDecoration));
        } else {
            dTree.setDecoration(dTreeButtonDecoration);
        }
    }

    protected abstract Painter createItemPainter();

    protected ImmInsets getSelectionInsets() {
        return this._selectionInsets;
    }

    protected ImmInsets getFocusInsets() {
        return this._focusInsets;
    }

    protected boolean isLineDotted() {
        return false;
    }

    protected boolean isLineDrawn() {
        return true;
    }

    private Painter _getItemPainter() {
        if (this._itemPainter == null) {
            this._itemPainter = this.createItemPainter();
        }
        return this._itemPainter;
    }

    public Painter getTextPainter() {
        if (this._textPainter == null) {
            this._textPainter = this.createTextPainter();
        }
        return this._textPainter;
    }

    protected Painter createTextPainter() {
        return new TextPainter();
    }
}

