/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.chooser.color.BaseColorEditor;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.share.nls.StringUtils;

class RGBComponent
extends BaseColorEditor {
    private static final String _KEY_RED = "COLORCHOOSER.RED_LABEL";
    private static final String _KEY_GREEN = "COLORCHOOSER.GREEN_LABEL";
    private static final String _KEY_BLUE = "COLORCHOOSER.BLUE_LABEL";
    private static final String _KEY_RED_DESC = "COLORCHOOSER.RED_DESCRIPTION";
    private static final String _KEY_GREEN_DESC = "COLORCHOOSER.GREEN_DESCRIPTION";
    private static final String _KEY_BLUE_DESC = "COLORCHOOSER.BLUE_DESCRIPTION";
    private static final String _RED_NAME = "Red_Box";
    private static final String _GREEN_NAME = "Green_Box";
    private static final String _BLUE_NAME = "Blue_Box";
    private boolean _ignoreEvents;
    private JLabel _redLabel;
    private JLabel _blueLabel;
    private JLabel _greenLabel;
    private NumericSpinBox _red;
    private NumericSpinBox _green;
    private NumericSpinBox _blue;

    public RGBComponent() {
        Insets insets;
        Listener listener = new Listener();
        this._red = new NumericSpinBox(0, 255);
        this._red.addChangeListener(listener);
        this._red.setName(_RED_NAME);
        this._green = new NumericSpinBox(0, 255);
        this._green.addChangeListener(listener);
        this._green.setName(_GREEN_NAME);
        this._blue = new NumericSpinBox(0, 255);
        this._blue.addChangeListener(listener);
        this._blue.setName(_BLUE_NAME);
        this._redLabel = new JLabel(" ");
        this._redLabel.setLabelFor(this._red);
        this._greenLabel = new JLabel(" ");
        this._greenLabel.setLabelFor(this._green);
        this._blueLabel = new JLabel(" ");
        this._blueLabel.setLabelFor(this._blue);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets = new Insets(0, 0, 3, 12);
        this.setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this._redLabel, gridBagConstraints);
        this.add(this._redLabel);
        gridBagConstraints.gridwidth = 0;
        insets.right = 0;
        gridBagLayout.setConstraints(this._red, gridBagConstraints);
        this.add(this._red);
        gridBagConstraints.gridwidth = -1;
        insets.right = 12;
        gridBagLayout.setConstraints(this._greenLabel, gridBagConstraints);
        this.add(this._greenLabel);
        gridBagConstraints.gridwidth = 0;
        insets.right = 0;
        gridBagLayout.setConstraints(this._green, gridBagConstraints);
        this.add(this._green);
        gridBagConstraints.gridwidth = -1;
        insets.bottom = 0;
        insets.right = 12;
        gridBagLayout.setConstraints(this._blueLabel, gridBagConstraints);
        this.add(this._blueLabel);
        gridBagConstraints.gridwidth = 0;
        insets.right = 0;
        gridBagLayout.setConstraints(this._blue, gridBagConstraints);
        this.add(this._blue);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._redLabel.setEnabled(bl);
        this._blueLabel.setEnabled(bl);
        this._greenLabel.setEnabled(bl);
        this._red.setEnabled(bl);
        this._green.setEnabled(bl);
        this._blue.setEnabled(bl);
    }

    protected void colorChanged(Color color) {
        this._ignoreEvents = true;
        int[] nArray = ColorUtils.colorToRGB(color);
        this._red.setIntValue(nArray[0]);
        this._green.setIntValue(nArray[1]);
        this._blue.setIntValue(nArray[2]);
        this._ignoreEvents = false;
    }

    protected void updateLabels(Locale locale) {
        String string = BaseColorEditor.__getTranslatedString(locale, _KEY_RED);
        this._redLabel.setText(StringUtils.stripMnemonic((String)string));
        this._redLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        string = BaseColorEditor.__getTranslatedString(locale, _KEY_GREEN);
        this._greenLabel.setText(StringUtils.stripMnemonic((String)string));
        this._greenLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        string = BaseColorEditor.__getTranslatedString(locale, _KEY_BLUE);
        this._blueLabel.setText(StringUtils.stripMnemonic((String)string));
        this._blueLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
    }

    protected void updateAccessibleNames() {
        String string = this.__getTranslatedString(_KEY_RED_DESC);
        this._red.getAccessibleContext().setAccessibleName(string);
        string = this.__getTranslatedString(_KEY_GREEN_DESC);
        this._green.getAccessibleContext().setAccessibleName(string);
        string = this.__getTranslatedString(_KEY_BLUE_DESC);
        this._blue.getAccessibleContext().setAccessibleName(string);
    }

    private void _updateColor() {
        this.storeColor(ColorUtils.rgbToColor(this._red.getIntValue(), this._green.getIntValue(), this._blue.getIntValue()));
    }

    private class Listener
    implements ChangeListener {
        private Listener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (!RGBComponent.this._ignoreEvents) {
                RGBComponent.this._updateColor();
            }
        }
    }
}

