/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.button;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultButtonModel;
import javax.swing.Timer;
import oracle.bali.ewt.spinBox.SpinAccelerator;

public abstract class ContinuousButtonModel
extends DefaultButtonModel
implements ActionListener {
    private AbstractButton _button;
    private SpinAccelerator _accelerator;
    private int _delay;
    private transient Timer _timer;
    private transient boolean _spinning;
    private static final int _DEFAULT_DELAY = 200;

    protected ContinuousButtonModel(AbstractButton abstractButton) {
        this(abstractButton, 200, null);
    }

    protected ContinuousButtonModel(AbstractButton abstractButton, int n, SpinAccelerator spinAccelerator) {
        this._button = abstractButton;
        this._delay = n;
        this._accelerator = spinAccelerator;
    }

    public AbstractButton getButton() {
        return this._button;
    }

    public int getDelay() {
        return this._delay;
    }

    public SpinAccelerator getAccelerator() {
        return this._accelerator;
    }

    public Timer getTimer() {
        if (this._timer == null) {
            this._timer = new Timer(this.getDelay(), this);
        }
        return this._timer;
    }

    public void stopTimer() {
        Timer timer = this._timer;
        if (timer != null && timer.isRunning()) {
            timer.stop();
        }
    }

    public void setArmedState(boolean bl) {
        if (bl) {
            this.setArmed(true);
            super.setPressed(true);
        } else {
            this.setArmed(false);
            this.setPressed(false);
        }
    }

    public void setPressed(boolean bl) {
        if (bl != this.isPressed()) {
            super.setPressed(bl);
            this._updateSpinning(bl);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this._doPulse(false);
    }

    public void setEnabled(boolean bl) {
        if (bl != this.isEnabled()) {
            if (!bl) {
                this.setArmed(false);
                this.setPressed(false);
            }
            super.setEnabled(bl);
        }
    }

    protected abstract void processPulse();

    private void _updateSpinning(boolean bl) {
        this._spinning = bl;
        if (bl) {
            this._timer = this.getTimer();
            this._doPulse(true);
        } else {
            this.stopTimer();
        }
    }

    private void _doPulse(boolean bl) {
        boolean bl2 = this._spinning;
        if (bl2) {
            SpinAccelerator spinAccelerator = this.getAccelerator();
            int n = this.getDelay();
            if (spinAccelerator != null) {
                if (bl) {
                    spinAccelerator.reset();
                } else {
                    spinAccelerator.advance();
                }
                n = spinAccelerator.getInterval();
            }
            this.processPulse();
            if (this.isEnabled()) {
                if (bl) {
                    this._timer.setInitialDelay(n);
                    this._timer.start();
                } else {
                    this._timer.setDelay(n);
                }
            }
        }
    }
}

