/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import oracle.i18n.text.OraUnicodeProperty;

public class OraNormalizer {
    private static final int SBase = 44032;
    private static final int LBase = 4352;
    private static final int VBase = 4449;
    private static final int TBase = 4519;
    private static final int LCount = 19;
    private static final int VCount = 21;
    private static final int TCount = 28;
    private static final int NCount = 588;
    private static final int SCount = 11172;
    private static OraUnicodeProperty UnicodePropTable = null;
    private static OraNormalizer cache = null;

    private OraNormalizer() {
        UnicodePropTable = OraUnicodeProperty.getInstance();
    }

    public static synchronized OraNormalizer getInstance() {
        if (cache == null) {
            cache = new OraNormalizer();
        }
        return cache;
    }

    public void canonicalSort(char[] cArray) {
        UnicodePropTable.canonicalSort(cArray);
    }

    public String compose(String string) {
        return UnicodePropTable.compose(string);
    }

    public static String decomposeHangul(char c) {
        int n = c - 44032;
        if (n < 0 || n >= 11172) {
            return String.valueOf(c);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 4352 + n / 588;
        int n3 = 4449 + n % 588 / 28;
        int n4 = 4519 + n % 28;
        stringBuffer.append((char)n2);
        stringBuffer.append((char)n3);
        if (n4 != 4519) {
            stringBuffer.append((char)n4);
        }
        return stringBuffer.toString();
    }

    public static String composeHangul(String string) {
        int n = string.length();
        if (n == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c = string.charAt(0);
        stringBuffer.append(c);
        for (int i = 1; i < n; ++i) {
            int n2;
            int n3;
            char c2 = string.charAt(i);
            int n4 = c - 4352;
            if (0 <= n4 && n4 < 19 && 0 <= (n3 = c2 - 4449) && n3 < 21) {
                c = (char)(44032 + (n4 * 21 + n3) * 28);
                stringBuffer.setCharAt(stringBuffer.length() - 1, c);
                continue;
            }
            n3 = c - 44032;
            if (0 <= n3 && n3 < 11172 && n3 % 28 == 0 && 0 <= (n2 = c2 - 4519) && n2 <= 28) {
                c = (char)(c + n2);
                stringBuffer.setCharAt(stringBuffer.length() - 1, c);
                continue;
            }
            c = c2;
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }
}

