/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security;

import java.security.Principal;
import java.util.Iterator;
import javax.security.auth.Subject;
import oracle.adf.share.logging.ADFLogger;

public class ADFSecurityUtil {
    private static ADFLogger _adfSecLogger = null;
    private static boolean _isAnyoneRoleEnable = ADFSecurityUtil.getEnableAnyoneRole();
    private static boolean _wildcard = ADFSecurityUtil.getWildcardFlag();

    public static ADFLogger getADFLogger() {
        if (_adfSecLogger == null) {
            _adfSecLogger = ADFLogger.createADFLogger("oracle.adf.share.security");
        }
        return _adfSecLogger;
    }

    public static boolean hasAnyoneRole(Subject subject) {
        if (subject != null) {
            Iterator<Principal> iterator = subject.getPrincipals().iterator();
            while (iterator.hasNext()) {
                Principal principal = iterator.next();
                if (!principal.getName().equals("anyone")) continue;
                return true;
            }
        }
        return false;
    }

    static boolean getWildcardFlag() {
        String string = null;
        try {
            string = System.getProperty("oracle.adf.security.wildcard.enable");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string == null || !string.equals(Boolean.FALSE.toString());
    }

    public static boolean isWildcardEnable() {
        return _wildcard;
    }

    static boolean getEnableAnyoneRole() {
        String string = null;
        try {
            string = System.getProperty("oracle.adf.security.anyone.enable");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string == null || !string.equals(Boolean.FALSE.toString());
    }

    static boolean isAnyoneRoleEnabled() {
        return _isAnyoneRoleEnable;
    }
}

