/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging;

import java.io.ObjectStreamException;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.adf.share.logging.ADFLogRecord;

public class ADFLogger {
    private Logger _log;
    private static final String sLoggingFilePath = "logging.config.file.path";
    private static boolean sInitialized = false;
    public static Level INTERNAL_ERROR = ADFLoggerLevel.ra$INTERNAL_ERROR();
    public static Level ERROR = ADFLoggerLevel.ra$ERROR();
    public static Level TRACE = ADFLoggerLevel.ra$TRACE();
    public static Level NOTIFICATION = ADFLoggerLevel.ra$NOTIFICATION();
    public static Level WARNING = ADFLoggerLevel.ra$WARNING();

    private /* synthetic */ void $init$() {
        this._log = null;
    }

    private ADFLogger(String string) {
        this.$init$();
        this._log = Logger.getLogger(string);
    }

    private ADFLogger(Logger logger) {
        this.$init$();
        if (logger == null) {
            throw new IllegalArgumentException("Logger required");
        }
        this._log = logger;
    }

    private ADFLogger(String string, String string2) {
        this.$init$();
        this._log = Logger.getLogger(string, string2);
    }

    private static long getSize(String string) {
        return string == null ? Long.MAX_VALUE : Long.parseLong(string);
    }

    public Logger getLogger() {
        return this._log;
    }

    public static ADFLogger createADFLogger(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Logger Name required");
        }
        Logger logger = Logger.getLogger(string);
        return new ADFLogger(logger);
    }

    public static ADFLogger createADFLogger(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Logger Name required");
        }
        Logger logger = Logger.getLogger(string, string2);
        return new ADFLogger(logger);
    }

    public static ADFLogger createADFLogger(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class required");
        }
        String string = clazz.getName();
        return ADFLogger.createADFLogger(string);
    }

    public static ADFLogger createADFLogger(Class clazz, String string) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class required");
        }
        String string2 = clazz.getName();
        return ADFLogger.createADFLogger(string2, string);
    }

    public static ADFLogger createADFLogger(Package package_) {
        if (package_ == null) {
            throw new IllegalArgumentException("Package required");
        }
        String string = package_.getName();
        return ADFLogger.createADFLogger(string);
    }

    public static ADFLogger createADFLogger(Package package_, String string) {
        if (package_ == null) {
            throw new IllegalArgumentException("Package required");
        }
        String string2 = package_.getName();
        return ADFLogger.createADFLogger(string2, string);
    }

    public static ADFLogger getAnonymousLogger() {
        return new ADFLogger(Logger.getAnonymousLogger());
    }

    public static ADFLogger getAnonymousLogger(String string) {
        return new ADFLogger(Logger.getAnonymousLogger(string));
    }

    public ResourceBundle getResourceBundle() {
        return this._log.getResourceBundle();
    }

    public String getResourceBundleName() {
        return this._log.getResourceBundleName();
    }

    public void setFilter(Filter filter) throws SecurityException {
        this._log.setFilter(filter);
    }

    public Filter getFilter() {
        return this._log.getFilter();
    }

    public void log(LogRecord logRecord) {
        this._log.log(logRecord);
    }

    public void log(String string) {
        this.log(ADFLoggerLevel.TRACE, string);
    }

    public void log(Level level, String string) {
        if (this.isLoggable(level)) {
            ADFLogRecord aDFLogRecord = new ADFLogRecord(level, string);
            this.doLog(aDFLogRecord);
        }
    }

    public void log(Level level, String string, Object object) {
        if (this.isLoggable(level)) {
            ADFLogRecord aDFLogRecord = new ADFLogRecord(level, string);
            Object[] objectArray = new Object[]{object};
            aDFLogRecord.setParameters(objectArray);
            this.doLog(aDFLogRecord);
        }
    }

    public void log(Level level, String string, Object[] objectArray) {
        if (this.isLoggable(level)) {
            ADFLogRecord aDFLogRecord = new ADFLogRecord(level, string);
            aDFLogRecord.setParameters(objectArray);
            this.doLog(aDFLogRecord);
        }
    }

    public void log(Level level, String string, Throwable throwable) {
        if (this.isLoggable(level)) {
            ADFLogRecord aDFLogRecord = new ADFLogRecord(level, string);
            aDFLogRecord.setThrown(throwable);
            this.doLog(aDFLogRecord);
        }
    }

    public void logp(Level level, String string, String string2, String string3) {
        if (this.isLoggable(level)) {
            ADFLogRecord aDFLogRecord = new ADFLogRecord(level, string3);
            aDFLogRecord.setSourceClassName(string);
            aDFLogRecord.setSourceMethodName(string2);
            this.doLog(aDFLogRecord);
        }
    }

    public void logp(Level level, String string, String string2, String string3, Object object) {
        if (this.isLoggable(level)) {
            ADFLogRecord aDFLogRecord = new ADFLogRecord(level, string3);
            aDFLogRecord.setSourceClassName(string);
            aDFLogRecord.setSourceMethodName(string2);
            Object[] objectArray = new Object[]{object};
            aDFLogRecord.setParameters(objectArray);
            this.doLog(aDFLogRecord);
        }
    }

    public void logp(Level level, String string, String string2, String string3, Object[] objectArray) {
        if (this.isLoggable(level)) {
            ADFLogRecord aDFLogRecord = new ADFLogRecord(level, string3);
            aDFLogRecord.setSourceClassName(string);
            aDFLogRecord.setSourceMethodName(string2);
            aDFLogRecord.setParameters(objectArray);
            this.doLog(aDFLogRecord);
        }
    }

    public void logp(Level level, String string, String string2, String string3, Throwable throwable) {
        if (this.isLoggable(level)) {
            ADFLogRecord aDFLogRecord = new ADFLogRecord(level, string3);
            aDFLogRecord.setSourceClassName(string);
            aDFLogRecord.setSourceMethodName(string2);
            aDFLogRecord.setThrown(throwable);
            this.doLog(aDFLogRecord);
        }
    }

    public void logp(Level level, String string, String string2, String string3, Object[] objectArray, Throwable throwable) {
        if (this.isLoggable(level)) {
            ADFLogRecord aDFLogRecord = new ADFLogRecord(level, string3);
            aDFLogRecord.setSourceClassName(string);
            aDFLogRecord.setSourceMethodName(string2);
            aDFLogRecord.setParameters(objectArray);
            aDFLogRecord.setThrown(throwable);
            this.doLog(aDFLogRecord);
        }
    }

    public void logrb(Level level, String string, String string2, String string3, String string4) {
        if (this.isLoggable(level)) {
            ADFLogRecord aDFLogRecord = new ADFLogRecord(level, string4);
            aDFLogRecord.setSourceClassName(string);
            aDFLogRecord.setSourceMethodName(string2);
            this.doLog(aDFLogRecord, string3);
        }
    }

    public void logrb(Level level, String string, String string2, String string3, String string4, Object object) {
        if (this.isLoggable(level)) {
            ADFLogRecord aDFLogRecord = new ADFLogRecord(level, string4);
            aDFLogRecord.setSourceClassName(string);
            aDFLogRecord.setSourceMethodName(string2);
            Object[] objectArray = new Object[]{object};
            aDFLogRecord.setParameters(objectArray);
            this.doLog(aDFLogRecord, string3);
        }
    }

    public void logrb(Level level, String string, String string2, String string3, String string4, Object[] objectArray) {
        if (this.isLoggable(level)) {
            ADFLogRecord aDFLogRecord = new ADFLogRecord(level, string4);
            aDFLogRecord.setSourceClassName(string);
            aDFLogRecord.setSourceMethodName(string2);
            aDFLogRecord.setParameters(objectArray);
            this.doLog(aDFLogRecord, string3);
        }
    }

    public void logrb(Level level, String string, String string2, String string3, String string4, Throwable throwable) {
        if (this.isLoggable(level)) {
            ADFLogRecord aDFLogRecord = new ADFLogRecord(level, string4);
            aDFLogRecord.setSourceClassName(string);
            aDFLogRecord.setSourceMethodName(string2);
            aDFLogRecord.setThrown(throwable);
            this.doLog(aDFLogRecord, string3);
        }
    }

    public void logrb(Level level, String string, String string2, String string3, String string4, Object[] objectArray, Throwable throwable) {
        if (this.isLoggable(level)) {
            ADFLogRecord aDFLogRecord = new ADFLogRecord(level, string4);
            aDFLogRecord.setSourceClassName(string);
            aDFLogRecord.setSourceMethodName(string2);
            aDFLogRecord.setParameters(objectArray);
            aDFLogRecord.setThrown(throwable);
            this.doLog(aDFLogRecord, string3);
        }
    }

    public void entering(String string, String string2) {
        this._log.entering(string, string2);
    }

    public void entering(String string, String string2, Object object) {
        this._log.entering(string, string2, object);
    }

    public void entering(String string, String string2, Object[] objectArray) {
        this._log.entering(string, string2, objectArray);
    }

    public void exiting(String string, String string2) {
        this._log.exiting(string, string2);
    }

    public void exiting(String string, String string2, Object object) {
        this._log.exiting(string, string2, object);
    }

    public void throwing(String string, String string2, Throwable throwable) {
        this._log.throwing(string, string2, throwable);
    }

    public void severe(String string) {
        this.log(Level.SEVERE, string);
    }

    public void warning(String string) {
        this.log(Level.WARNING, string);
    }

    public void info(String string) {
        this.log(Level.INFO, string);
    }

    public void config(String string) {
        this.log(Level.CONFIG, string);
    }

    public void fine(String string) {
        this.log(Level.FINE, string);
    }

    public void finer(String string) {
        this.log(Level.FINER, string);
    }

    public void finest(String string) {
        this.log(Level.FINEST, string);
    }

    public void throwing(Level level, String string, String string2, Throwable throwable) {
        this.logp(level, string, string2, "", throwable);
    }

    public void severe(String string, String string2, String string3) {
        this.logp(Level.SEVERE, string, string2, string3);
    }

    public void severe(String string, String string2, String string3, Object object) {
        this.logp(Level.SEVERE, string, string2, string3, object);
    }

    public void severe(String string, String string2, String string3, Object[] objectArray) {
        this.logp(Level.SEVERE, string, string2, string3, objectArray);
    }

    public void warning(String string, String string2, String string3) {
        this.logp(Level.WARNING, string, string2, string3);
    }

    public void warning(String string, String string2, String string3, Object object) {
        this.logp(Level.WARNING, string, string2, string3, object);
    }

    public void warning(String string, String string2, String string3, Object[] objectArray) {
        this.logp(Level.WARNING, string, string2, string3, objectArray);
    }

    public void info(String string, String string2, String string3) {
        this.logp(Level.INFO, string, string2, string3);
    }

    public void info(String string, String string2, String string3, Object object) {
        this.logp(Level.INFO, string, string2, string3, object);
    }

    public void info(String string, String string2, String string3, Object[] objectArray) {
        this.logp(Level.INFO, string, string2, string3, objectArray);
    }

    public void config(String string, String string2, String string3) {
        this.logp(Level.CONFIG, string, string2, string3);
    }

    public void config(String string, String string2, String string3, Object object) {
        this._log.logp(Level.CONFIG, string, string2, string3, object);
    }

    public void config(String string, String string2, String string3, Object[] objectArray) {
        this.logp(Level.CONFIG, string, string2, string3, objectArray);
    }

    public void fine(String string, String string2, String string3) {
        this.logp(Level.FINE, string, string2, string3);
    }

    public void fine(String string, String string2, String string3, Object object) {
        this.logp(Level.FINE, string, string2, string3, object);
    }

    public void fine(String string, String string2, String string3, Object[] objectArray) {
        this.logp(Level.FINE, string, string2, string3, objectArray);
    }

    public void finer(String string, String string2, String string3) {
        this.logp(Level.FINER, string, string2, string3);
    }

    public void finer(String string, String string2, String string3, Object object) {
        this.logp(Level.FINER, string, string2, string3, object);
    }

    public void finer(String string, String string2, String string3, Object[] objectArray) {
        this.logp(Level.FINER, string, string2, string3, objectArray);
    }

    public void finest(String string, String string2, String string3) {
        this.logp(Level.FINEST, string, string2, string3);
    }

    public void finest(String string, String string2, String string3, Object object) {
        this.logp(Level.FINEST, string, string2, string3, object);
    }

    public void finest(String string, String string2, String string3, Object[] objectArray) {
        this.logp(Level.FINEST, string, string2, string3, objectArray);
    }

    public void logp(Level level, String string, String string2, String string3, Object object, Object object2, Object object3) {
        this.logp(level, string, string2, string3, new Object[]{object, object2, object3});
    }

    public void setLevel(Level level) throws SecurityException {
        this._log.setLevel(level);
    }

    public Level getLevel() {
        return this._log.getLevel();
    }

    public boolean isLoggable(Level level) {
        return this._log.isLoggable(level);
    }

    public String getName() {
        return this._log.getName();
    }

    public void addHandler(Handler handler) throws SecurityException {
        this._log.addHandler(handler);
    }

    public void removeHandler(Handler handler) throws SecurityException {
        this._log.removeHandler(handler);
    }

    public Handler[] getHandlers() {
        return this._log.getHandlers();
    }

    public void setUseParentHandlers(boolean bl) {
        this._log.setUseParentHandlers(bl);
    }

    public boolean getUseParentHandlers() {
        return this._log.getUseParentHandlers();
    }

    public Logger getParent() {
        return this._log.getParent();
    }

    public void setParent(Logger logger) {
        this._log.setParent(logger);
    }

    private ResourceBundle findResourceBundle(String string) {
        if (string == null) {
            return null;
        }
        Locale locale = Locale.getDefault();
        return ResourceBundle.getBundle(string, locale);
    }

    private void doLog(LogRecord logRecord, String string) {
        logRecord.setLoggerName(this._log.getName());
        if (string != null) {
            logRecord.setResourceBundleName(string);
            logRecord.setResourceBundle(this.findResourceBundle(string));
        }
        this.log(logRecord);
    }

    private void doLog(LogRecord logRecord) {
        logRecord.setLoggerName(this._log.getName());
        String string = this._log.getResourceBundleName();
        if (string != null) {
            logRecord.setResourceBundleName(string);
            logRecord.setResourceBundle(this._log.getResourceBundle());
        }
        this._log.log(logRecord);
    }

    public void internal(Throwable throwable) {
        this.internal("", throwable);
    }

    public void internal(String string, Throwable throwable) {
        this.log(ADFLoggerLevel.INTERNAL_ERROR, string, throwable);
    }

    public void internal(String string, Object object) {
        this.log(ADFLoggerLevel.INTERNAL_ERROR, string, object);
    }

    public void internal(String string, Object[] objectArray) {
        this.log(ADFLoggerLevel.INTERNAL_ERROR, string, objectArray);
    }

    public void severe(Throwable throwable) {
        this.severe("", throwable);
    }

    public void severe(String string, Throwable throwable) {
        this.log(Level.SEVERE, string, throwable);
    }

    public void severe(String string, Object object) {
        this.log(Level.SEVERE, string, object);
    }

    public void severe(String string, Object[] objectArray) {
        this.log(Level.SEVERE, string, objectArray);
    }

    public void warning(Throwable throwable) {
        this.warning("", throwable);
    }

    public void warning(String string, Throwable throwable) {
        this.log(Level.WARNING, string, throwable);
    }

    public void warning(String string, Object object) {
        this.log(Level.WARNING, string, object);
    }

    public void warning(String string, Object[] objectArray) {
        this.log(Level.WARNING, string, objectArray);
    }

    public void info(Throwable throwable) {
        this.info("", throwable);
    }

    public void info(String string, Throwable throwable) {
        this.log(Level.INFO, string, throwable);
    }

    public void info(String string, Object object) {
        this.log(Level.INFO, string, object);
    }

    public void info(String string, Object[] objectArray) {
        this.log(Level.INFO, string, objectArray);
    }

    public void fine(Throwable throwable) {
        this.fine("", throwable);
    }

    public void fine(String string, Throwable throwable) {
        this.log(Level.FINE, string, throwable);
    }

    public void fine(String string, Object object) {
        this.log(Level.FINE, string, object);
    }

    public void fine(String string, Object[] objectArray) {
        this.log(Level.FINE, string, objectArray);
    }

    public void finer(Throwable throwable) {
        this.finer("", throwable);
    }

    public void finer(String string, Throwable throwable) {
        this.log(Level.FINER, string, throwable);
    }

    public void finer(String string, Object object) {
        this.log(Level.FINER, string, object);
    }

    public void finer(String string, Object[] objectArray) {
        this.log(Level.FINER, string, objectArray);
    }

    public void finest(Throwable throwable) {
        this.finest("", throwable);
    }

    public void finest(String string, Throwable throwable) {
        this.log(Level.FINEST, string, throwable);
    }

    public void finest(String string, Object object) {
        this.log(Level.FINEST, string, object);
    }

    public void finest(String string, Object[] objectArray) {
        this.log(Level.FINEST, string, objectArray);
    }

    public boolean isInternal() {
        return this.isLoggable(ADFLoggerLevel.INTERNAL_ERROR);
    }

    public boolean isSevere() {
        return this.isLoggable(Level.SEVERE);
    }

    public boolean isWarning() {
        return this.isLoggable(Level.WARNING);
    }

    public boolean isInfo() {
        return this.isLoggable(Level.INFO);
    }

    public boolean isConfig() {
        return this.isLoggable(Level.CONFIG);
    }

    public boolean isFine() {
        return this.isLoggable(Level.FINE);
    }

    public boolean isFiner() {
        return this.isLoggable(Level.FINER);
    }

    public boolean isFinest() {
        return this.isLoggable(Level.FINEST);
    }

    private static class ADFLoggerLevel
    extends Level {
        private int currentADFLevel;
        private String adfName;
        private static Level INTERNAL_ERROR = new ADFLoggerLevel("INTERNAL_ERROR", Level.SEVERE.intValue() + 100);
        private static Level ERROR = Level.SEVERE;
        private static Level WARNING = Level.WARNING;
        private static Level NOTIFICATION = Level.INFO;
        private static Level TRACE = Level.FINE;

        private ADFLoggerLevel(String string, int n) {
            super(string, n, null);
            this.currentADFLevel = n;
            this.adfName = string;
        }

        private Object readResolve() throws ObjectStreamException {
            return new ADFLoggerLevel(this.adfName, this.currentADFLevel);
        }

        static /* synthetic */ Level ra$ERROR() {
            return ERROR;
        }

        static /* synthetic */ Level ra$NOTIFICATION() {
            return NOTIFICATION;
        }

        static /* synthetic */ Level ra$WARNING() {
            return WARNING;
        }
    }
}

