/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.pool;

import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Stack;
import java.util.TimerTask;
import oracle.adf.share.ADFContext;
import oracle.jbo.pool.ResourcePool;
import oracle.jbo.pool.ResourcePoolManager;

public class ResourcePoolMonitor
extends TimerTask {
    private final ResourcePoolManager mPoolManager;
    private WeakReference mLoaderRef;
    private final long mInterval;

    protected ResourcePoolMonitor(ResourcePoolManager resourcePoolManager, ClassLoader classLoader, long l) {
        this.mPoolManager = resourcePoolManager;
        this.mLoaderRef = new WeakReference<ClassLoader>(classLoader);
        this.mInterval = l;
        new Stack();
    }

    ClassLoader getClassLoader() {
        return (ClassLoader)this.mLoaderRef.get();
    }

    public void run() {
        ADFContext.getCurrent().removeAsCurrent();
        Stack stack = null;
        try {
            try {
                stack = new Stack();
                this.initializeThreadContext(stack);
                Object var2_2 = null;
                Enumeration enumeration = this.mPoolManager.getResourcePools();
                while (enumeration.hasMoreElements()) {
                    var2_2 = enumeration.nextElement();
                    if (!(var2_2 instanceof ResourcePool)) continue;
                    ((ResourcePool)var2_2).wakeup(this.mPoolManager);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
                Object var6_5 = null;
                this.mPoolManager.createPoolMonitor();
                if (stack != null) {
                    this.resetThreadContext(stack);
                }
            }
            Object var6_4 = null;
            this.mPoolManager.createPoolMonitor();
            if (stack != null) {
                this.resetThreadContext(stack);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.mPoolManager.createPoolMonitor();
            if (stack != null) {
                this.resetThreadContext(stack);
            }
            throw throwable;
        }
    }

    protected void initializeThreadContext(Stack stack) {
        stack.push(Thread.currentThread().getContextClassLoader());
        this.setLoader((ClassLoader)this.mLoaderRef.get());
    }

    protected void resetThreadContext(Stack stack) {
        this.setLoader((ClassLoader)stack.pop());
    }

    private void setLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            PrivilegedActionAdapter privilegedActionAdapter = new PrivilegedActionAdapter();
            privilegedActionAdapter.loader = classLoader;
            AccessController.doPrivileged(privilegedActionAdapter);
        }
    }

    public class PrivilegedActionAdapter
    implements PrivilegedAction {
        ClassLoader loader;

        public Object run() {
            Thread.currentThread().setContextClassLoader(this.loader);
            return null;
        }

        PrivilegedActionAdapter() {
        }
    }
}

