/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.pool;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import oracle.jbo.JboException;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.pool.ResourcePool;
import oracle.jbo.pool.ResourcePoolMonitor;

public class ResourcePoolManager {
    private static final ResourcePoolManager mInstance = new ResourcePoolManager();
    protected final Integer mLock;
    private Timer mTimer;
    private Hashtable mResourcePools;
    private ResourcePoolMonitor mPoolMonitor;

    private /* synthetic */ void $init$() {
        this.mLock = new Integer(0);
        this.mResourcePools = new Hashtable(10);
        this.mPoolMonitor = null;
    }

    public static ResourcePoolManager getManagerInstance() {
        return mInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timer getResourcePoolTimer() {
        Integer n = this.mLock;
        synchronized (n) {
            if (this.mTimer == null) {
                this.mTimer = new Timer(true);
            }
        }
        return this.mTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getResourcePool(Object object) {
        Integer n = this.mLock;
        synchronized (n) {
            Object v = this.mResourcePools.get(object);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourcePool(Object object, Object object2) {
        Integer n = this.mLock;
        synchronized (n) {
            if (this.mResourcePools.get(object) != null) {
                throw new JboException("Specified application pool already exists");
            }
            this.mResourcePools.put(object, object2);
            if (this.mResourcePools.size() == 1) {
                this.createPoolMonitor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResourcePool(Object object) {
        Integer n = this.mLock;
        synchronized (n) {
            Object v = this.mResourcePools.remove(object);
            if (v != null && v instanceof ResourcePool) {
                ((ResourcePool)v).removeResources();
                if (this.mResourcePools.size() <= 0) {
                    this.removePoolMonitor();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getResourcePools() {
        Integer n = this.mLock;
        synchronized (n) {
            Enumeration enumeration = this.mResourcePools.elements();
            return enumeration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getResourcePoolKeys() {
        Integer n = this.mLock;
        synchronized (n) {
            Enumeration enumeration = this.mResourcePools.keys();
            return enumeration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Integer n = this.mLock;
        synchronized (n) {
            Enumeration enumeration = this.getResourcePools();
            while (enumeration.hasMoreElements()) {
                ResourcePool resourcePool = (ResourcePool)enumeration.nextElement();
                resourcePool.removeResources();
                resourcePool.wakeup(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createPoolMonitor() {
        Integer n = this.mLock;
        synchronized (n) {
            if (this.mResourcePools.size() <= 0) {
                return;
            }
            long l = this.getMonitorSleepInterval();
            this.mPoolMonitor = (ResourcePoolMonitor)AccessController.doPrivileged(new 2(this, l));
            this.getResourcePoolTimer().schedule((TimerTask)this.mPoolMonitor, l);
        }
    }

    public void classLoaderShuttingDown() {
        Object t;
        if (this.mPoolMonitor != null && (t = AccessController.doPrivileged(new 1())) == this.mPoolMonitor.getClassLoader()) {
            this.removePoolMonitor();
        }
    }

    protected void removePoolMonitor() {
        if (this.mPoolMonitor != null) {
            this.mPoolMonitor.cancel();
            this.mPoolMonitor = null;
            this.mTimer.cancel();
            this.mTimer = null;
        }
    }

    protected int getMonitorSleepInterval() {
        return Integer.valueOf(PropertyMetadata.ENV_AMPOOL_MONITOR_SLEEP_INTERVAL.pDefault);
    }

    public static final int getProperty(String string, Hashtable hashtable, int n) {
        int n2 = -1;
        String string2 = null;
        if (hashtable != null) {
            string2 = (String)hashtable.get(string);
        }
        n2 = string2 != null ? Integer.parseInt(string2) : JboEnvUtil.getPropertyAsInt(string, n);
        return n2;
    }

    public ResourcePoolManager() {
        this.$init$();
    }

    public final class 2
    implements PrivilegedAction {
        private final /* synthetic */ long v$interval;
        final /* synthetic */ ResourcePoolManager this$0;

        public Object run() {
            return new ResourcePoolMonitor(this.this$0, Thread.currentThread().getContextClassLoader(), this.v$interval);
        }

        public /* synthetic */ 2(ResourcePoolManager resourcePoolManager, long l) {
            this.v$interval = l;
            this.this$0 = resourcePoolManager;
        }
    }

    public final class 1
    implements PrivilegedAction {
        public Object run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

