/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.mom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.jbo.JboException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.mom.LongRunningStatementHandle;

public class LongRunningStatementMonitor
extends Thread {
    private List handleList;
    private volatile boolean mShutDownFlag;
    private static final int CHECK_TIME_DURATION = 1000;

    private /* synthetic */ void $init$() {
        this.mShutDownFlag = false;
    }

    public LongRunningStatementMonitor() {
        super("BC4J_LongRunningStatementMonitor");
        this.$init$();
        this.handleList = Collections.synchronizedList(new ArrayList());
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitor(LongRunningStatementHandle longRunningStatementHandle) {
        if (longRunningStatementHandle != null) {
            List list = this.handleList;
            synchronized (list) {
                this.handleList.add(longRunningStatementHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.mShutDownFlag = false;
        try {
            while (!this.mShutDownFlag) {
                ArrayList<LongRunningStatementHandle> arrayList = new ArrayList<LongRunningStatementHandle>();
                if (!this.handleList.isEmpty()) {
                    List list = this.handleList;
                    synchronized (list) {
                        long l = System.currentTimeMillis();
                        Iterator iterator = this.handleList.iterator();
                        while (iterator.hasNext()) {
                            LongRunningStatementHandle longRunningStatementHandle = (LongRunningStatementHandle)iterator.next();
                            if (l <= longRunningStatementHandle.getExpiryTime() && longRunningStatementHandle.getState() == 1) continue;
                            if (l > longRunningStatementHandle.getExpiryTime()) {
                                arrayList.add(longRunningStatementHandle);
                            }
                            iterator.remove();
                        }
                    }
                    if (!arrayList.isEmpty()) {
                        Iterator iterator = arrayList.iterator();
                        while (iterator.hasNext()) {
                            LongRunningStatementHandle longRunningStatementHandle = (LongRunningStatementHandle)iterator.next();
                            longRunningStatementHandle.cancel();
                            iterator.remove();
                        }
                    }
                }
                try {
                    LongRunningStatementMonitor longRunningStatementMonitor = this;
                    synchronized (longRunningStatementMonitor) {
                        if (!this.mShutDownFlag) {
                            this.wait(1000L);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new JboException(exception);
        }
        Diagnostic.println("Thread " + this.getName() + " exiting");
    }

    public synchronized void stopGracefully() {
        Diagnostic.println("Notifying thread " + this.getName() + " to terminate");
        this.mShutDownFlag = true;
        this.notify();
    }

    protected void finalize() throws Throwable {
        this.stopGracefully();
        super.finalize();
    }
}

