/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common.ampool;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import oracle.adf.share.ADFContext;
import oracle.jbo.ApplicationModule;
import oracle.jbo.ApplicationPoolSvcMsgContext;
import oracle.jbo.ConnectionMetadata;
import oracle.jbo.JboException;
import oracle.jbo.SessionData;
import oracle.jbo.Transaction;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.common.UserAznUtil;
import oracle.jbo.common.ampool.AMStatistics;
import oracle.jbo.common.ampool.ApplicationPool;
import oracle.jbo.common.ampool.ApplicationPoolException;
import oracle.jbo.common.ampool.ApplicationPoolLogger;
import oracle.jbo.common.ampool.ConnectionStrategy;
import oracle.jbo.common.ampool.EnvInfoProvider;
import oracle.jbo.common.ampool.PoolMgr;
import oracle.jbo.common.ampool.SessionCookie;
import oracle.jbo.common.ampool.SessionCookieFactory;
import oracle.jbo.common.ampool.SessionCookieImpl;
import oracle.jbo.common.ampool.Statistics;
import oracle.jbo.pool.AgeHistogram;
import oracle.jbo.pool.RecentlyUsedLinkedList;
import oracle.jbo.pool.RecentlyUsedLinkedListElement;
import oracle.jbo.pool.ResourcePool;
import oracle.jbo.pool.ResourcePoolLogger;

public class ApplicationPoolImpl
extends ResourcePool
implements ApplicationPool {
    public static int CREATION_POLICY_SERIAL = 0;
    public static int CREATION_POLICY_ROUND_ROBIN = 1;
    public static int MAX_HANDLE_POLICY_SPILL = 0;
    public static int MAX_HANDLE_POLICY_ERROR = 1;
    private static long mSignatureCounter = 0L;
    private static int mAppModuleIdCounter = 0;
    private static final Object mStaticLock = new Object();
    private final long mSignature;
    private String mName;
    private Hashtable mUserData;
    private int mSessionId;
    private Hashtable mEnvironment;
    private volatile String mUserName;
    private volatile String mPassword;
    private volatile String mConnectString;
    private transient RecentlyUsedLinkedList mReferencedList;
    private transient RecentlyUsedLinkedList mUnrefAvailList;
    private transient RecentlyUsedLinkedList mRefAvailList;
    private volatile transient ConnectionStrategy mStrategy;
    private volatile transient SessionCookieFactory mSessionCookieFactory;
    private transient int mReferencingSessionCount;
    private transient HashMap mInstanceInfo;
    private transient HashMap mSessionCookieInfo;
    private transient long mTimeCreated;
    private volatile transient int mUseExclusive;
    private static final int REUSE_REFERENCED_INSTANCE = 1;
    private static final int RECYCLE_UNREFERENCED_INSTANCE = 2;
    private static final int RECYCLE_REFERENCED_INSTANCE = 3;
    private static final int CREATE_NEW_INSTANCE = 4;
    private static final int SHARE_INSTANCE = 5;
    static final int RESET_RECONNECT_FLAG = 1;
    static final int RESET_REMOVE_STATE_FLAG = 2;
    static final int RESET_REMOVE_FLAG = 4;
    static final int RESET_MANAGE_SNAPSHOTS_FLAG = 8;
    static final int RESET_RELEASE_FLAG = 16;
    static final int RESET_MANAGED_FLAGS = 9;
    static final int RESET_UNMANAGED_FLAGS = 18;
    private static final String SESSION_COOKIE = "jbo.envinfoprovider";
    private static final String SVC_MSG_CONTEXT = "_jbo.applicationpoolsvcmsgcontext_";
    private static final String PENDING_CONTEXT = "_jbo.applicationpoolpendingcontext_";
    private static /* synthetic */ Class class$oracle$jbo$common$ampool$AMPoolMessageBundle;

    private /* synthetic */ void $init$() {
        this.mSessionId = 0;
        this.mReferencedList = new RecentlyUsedLinkedList();
        this.mUnrefAvailList = new RecentlyUsedLinkedList();
        this.mRefAvailList = new RecentlyUsedLinkedList();
        this.mReferencingSessionCount = 0;
        this.mInstanceInfo = new HashMap(10);
        this.mSessionCookieInfo = new HashMap(10);
        this.mTimeCreated = -1;
        this.mUseExclusive = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationPoolImpl() {
        this.$init$();
        long l = 0L;
        Object object = mStaticLock;
        synchronized (object) {
            l = mSignatureCounter++;
        }
        this.mSignature = System.currentTimeMillis() + l;
    }

    public long getSignature() {
        return this.mSignature;
    }

    private String getNextSessionId() {
        String string = null;
        string = String.valueOf(this.mSessionId++);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        Integer n = this.mLock;
        synchronized (n) {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)this.mEnvironment);
            super.initialize(properties);
            if (this.mInstanceInfo == null) {
                this.mInstanceInfo = new HashMap(10);
            }
            if (this.mSessionCookieInfo == null) {
                this.mSessionCookieInfo = new HashMap(10);
            }
            if (this.mReferencedList == null) {
                this.mReferencedList = new RecentlyUsedLinkedList();
            }
            if (this.mUnrefAvailList == null) {
                this.mUnrefAvailList = new RecentlyUsedLinkedList();
            }
            if (this.mRefAvailList == null) {
                this.mRefAvailList = new RecentlyUsedLinkedList();
            }
            this.mReferencingSessionCount = 0;
            this.mTimeCreated = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(String string, String string2, String string3, Hashtable hashtable) {
        Integer n = this.mLock;
        synchronized (n) {
            this.mName = string;
            this.mEnvironment = (Hashtable)hashtable.clone();
            this.mConnectString = string3;
            this.initialize();
            if (hashtable != null) {
                String string4 = (String)hashtable.get("user");
                String string5 = (String)hashtable.get("password");
                if (string4 != null) {
                    this.setUserName(string4);
                }
                if (string5 != null) {
                    this.setPassword(string5);
                }
            }
            if (string2 != null) {
                this.mEnvironment.put("jbo.applicationmoduleclassname", string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionStrategy getConnectionStrategy() {
        if (this.mStrategy == null) {
            Integer n = this.mLock;
            synchronized (n) {
                if (this.mStrategy == null) {
                    String string = this.getConnectionStrategyClassName();
                    try {
                        Class clazz = JBOClass.forName(string);
                        this.mStrategy = (ConnectionStrategy)clazz.newInstance();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new JboException(classNotFoundException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new JboException(illegalAccessException);
                    }
                    catch (InstantiationException instantiationException) {
                        throw new JboException(instantiationException);
                    }
                }
            }
        }
        return this.mStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionStrategy(ConnectionStrategy connectionStrategy) {
        Integer n = this.mLock;
        synchronized (n) {
            if (connectionStrategy != null) {
                this.mStrategy = connectionStrategy;
                this.mEnvironment.put(PropertyMetadata.ENV_AMPOOL_CONNECTION_STRATEGY_CLASS_NAME.pName, connectionStrategy.getClass().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionCookieFactory getSessionCookieFactory() {
        if (this.mSessionCookieFactory == null) {
            Integer n = this.mLock;
            synchronized (n) {
                if (this.mSessionCookieFactory == null) {
                    String string = this.getSessionCookieFactoryClassName();
                    try {
                        Class clazz = JBOClass.forName(string);
                        this.mSessionCookieFactory = (SessionCookieFactory)clazz.newInstance();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new JboException(classNotFoundException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new JboException(illegalAccessException);
                    }
                    catch (InstantiationException instantiationException) {
                        throw new JboException(instantiationException);
                    }
                }
            }
        }
        return this.mSessionCookieFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSessionCookieFactory(SessionCookieFactory sessionCookieFactory) {
        Integer n = this.mLock;
        synchronized (n) {
            if (sessionCookieFactory != null) {
                this.mSessionCookieFactory = sessionCookieFactory;
                this.mEnvironment.put(PropertyMetadata.ENV_AMPOOL_COOKIE_FACTORY_CLASS_NAME.pName, sessionCookieFactory.getClass().getName());
            }
        }
    }

    public int getMaxPoolSize() {
        return this.getProperty(PropertyMetadata.ENV_AMPOOL_MAX_POOL_SIZE.pName, this.getEnvironment(), Integer.valueOf(PropertyMetadata.ENV_AMPOOL_MAX_POOL_SIZE.pDefault));
    }

    public int getInitPoolSize() {
        return this.getProperty(PropertyMetadata.ENV_AMPOOL_INIT_POOL_SIZE.pName, this.getEnvironment(), Integer.valueOf(PropertyMetadata.ENV_AMPOOL_INIT_POOL_SIZE.pDefault));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionCookie createSessionCookie(String string, String string2, Properties properties) {
        SessionCookie sessionCookie = this.getSessionCookieFactory().createSessionCookie(string, string2, this, properties);
        SessionCookieInfo sessionCookieInfo = null;
        boolean bl = false;
        Integer n = this.mLock;
        synchronized (n) {
            sessionCookieInfo = (SessionCookieInfo)this.mSessionCookieInfo.get((Object)sessionCookie);
            if (sessionCookieInfo == null) {
                sessionCookie.setInfoObject(new SessionCookieInfo(sessionCookie));
                this.mSessionCookieInfo.put((Object)sessionCookie, sessionCookie.getInfoObject());
            } else {
                bl = true;
            }
        }
        if (bl && sessionCookie != sessionCookieInfo.mCookie) {
            Object object = sessionCookieInfo.mCookie.getSyncLock();
            synchronized (object) {
                Integer n2 = this.mLock;
                synchronized (n2) {
                    sessionCookieInfo = (SessionCookieInfo)this.mSessionCookieInfo.get((Object)sessionCookie);
                    if (sessionCookieInfo != null) {
                        Class clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
                        if (clazz == null) {
                            clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolImpl.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
                        }
                        ApplicationPoolException applicationPoolException = new ApplicationPoolException(clazz, "30012", new Object[]{sessionCookie.getSessionId(), sessionCookie.getApplicationId(), this.getName()});
                        applicationPoolException.setSessionCookie(sessionCookieInfo.mCookie);
                        throw applicationPoolException;
                    }
                    sessionCookie.setInfoObject(new SessionCookieInfo(sessionCookie));
                    this.mSessionCookieInfo.put((Object)sessionCookie, sessionCookie.getInfoObject());
                }
            }
        }
        return sessionCookie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionCookie(SessionCookie sessionCookie) {
        boolean bl = false;
        SessionCookieInfo sessionCookieInfo = null;
        this.validateSessionCookie(sessionCookie);
        Integer n = this.mLock;
        synchronized (n) {
            sessionCookieInfo = (SessionCookieInfo)this.mSessionCookieInfo.get((Object)sessionCookie);
            if (sessionCookieInfo == null) {
                sessionCookieInfo = new SessionCookieInfo(sessionCookie);
                sessionCookie.setInfoObject(sessionCookieInfo);
                this.mSessionCookieInfo.put((Object)sessionCookie, (Object)sessionCookieInfo);
            } else {
                bl = true;
            }
        }
        if (bl) {
            Object object = sessionCookieInfo.mCookie.getSyncLock();
            synchronized (object) {
                if (sessionCookieInfo.mApplicationModule != null && !this.isAvailable(sessionCookieInfo.mApplicationModule)) {
                    Class clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
                    if (clazz == null) {
                        clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolImpl.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
                    }
                    throw new ApplicationPoolException(clazz, "30010", new Object[]{sessionCookie.getSessionId(), sessionCookie.getApplicationId()});
                }
                if (sessionCookie.getLastUpdateLong() > sessionCookieInfo.mCookie.getLastUpdateLong()) {
                    if (sessionCookieInfo.mApplicationModule != null) {
                        this.resetApplicationModule(sessionCookieInfo.mCookie, 19);
                    }
                    sessionCookie.copyInto(sessionCookieInfo.mCookie);
                    if (sessionCookie.getPassivationId() != -1 && !sessionCookieInfo.mIsReferencingState) {
                        sessionCookieInfo.mIsReferencingState = true;
                        Integer n2 = this.mLock;
                        synchronized (n2) {
                            ++this.mReferencingSessionCount;
                        }
                    }
                } else if (sessionCookieInfo.mCookie.getLastUpdateLong() > sessionCookie.getLastUpdateLong()) {
                    sessionCookieInfo.mCookie.copyInto(sessionCookie);
                }
                sessionCookieInfo.mCookie = sessionCookie;
                sessionCookie.setInfoObject(sessionCookieInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void removeSessionCookie(SessionCookie sessionCookie) {
        Object object = sessionCookie.getSyncLock();
        synchronized (object) {
            boolean bl = false;
            ApplicationModule applicationModule = null;
            SessionCookieInfo sessionCookieInfo = null;
            ApplicationModuleInfo applicationModuleInfo = null;
            Integer n = this.mLock;
            synchronized (n) {
                sessionCookieInfo = (SessionCookieInfo)sessionCookie.getInfoObject();
                this.validateSessionCookieInPool(sessionCookie, sessionCookieInfo);
                if (this.useApplicationModule(sessionCookie, false) != null) {
                    Class clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
                    if (clazz == null) {
                        clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolImpl.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
                    }
                    throw new ApplicationPoolException(clazz, "30014", new Object[]{sessionCookie.getSessionId(), sessionCookie.getApplicationId(), this.getName()});
                }
                applicationModule = sessionCookieInfo.mApplicationModule;
                if (applicationModule != null) {
                    this.setAvailable(applicationModule, false);
                    applicationModuleInfo = (ApplicationModuleInfo)this.mInstanceInfo.get((Object)applicationModule);
                    bl = true;
                } else {
                    sessionCookie.setInfoObject(null);
                    this.mSessionCookieInfo.remove((Object)sessionCookie);
                }
            }
            if (bl) {
                Integer n2;
                try {
                    ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext = new ApplicationPoolSvcMsgContext();
                    applicationModule = this.resetApplicationModule(sessionCookie, sessionCookieInfo, applicationModule, applicationModuleInfo, 9, applicationPoolSvcMsgContext);
                    Object var11_9 = null;
                    n2 = this.mLock;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    Integer n3 = this.mLock;
                    synchronized (n3) {
                        if (this.mInstanceInfo.get((Object)applicationModule) != null) {
                            this.setAvailable(applicationModule, true);
                        }
                        if (sessionCookieInfo != null) {
                            sessionCookieInfo.resetState();
                        }
                        sessionCookie.resetStateInternal();
                        sessionCookie.setInfoObject(null);
                        this.mSessionCookieInfo.remove((Object)sessionCookie);
                    }
                    throw throwable;
                }
                synchronized (n2) {
                    if (this.mInstanceInfo.get((Object)applicationModule) != null) {
                        this.setAvailable(applicationModule, true);
                    }
                    if (sessionCookieInfo != null) {
                        sessionCookieInfo.resetState();
                    }
                    sessionCookie.resetStateInternal();
                    sessionCookie.setInfoObject(null);
                    this.mSessionCookieInfo.remove((Object)sessionCookie);
                }
                {
                    catch (Throwable throwable) {
                        if (Diagnostic.isOn()) {
                            Diagnostic.println("An exception occured while removing the SessionCookie");
                        }
                        Object var11_10 = null;
                        Integer n4 = this.mLock;
                        synchronized (n4) {
                            if (this.mInstanceInfo.get((Object)applicationModule) != null) {
                                this.setAvailable(applicationModule, true);
                            }
                            if (sessionCookieInfo != null) {
                                sessionCookieInfo.resetState();
                            }
                            sessionCookie.resetStateInternal();
                            sessionCookie.setInfoObject(null);
                            this.mSessionCookieInfo.remove((Object)sessionCookie);
                        }
                    }
                }
            }
        }
    }

    public String getApplicationModuleClass() {
        return (String)this.getEnvironment().get("jbo.applicationmoduleclassname");
    }

    public String getConnectString() {
        return this.mConnectString;
    }

    public Hashtable getEnvironment() {
        return this.mEnvironment;
    }

    private ApplicationModule findUnreferencedAvailInstance() {
        ApplicationModule applicationModule = null;
        RecentlyUsedLinkedListElement recentlyUsedLinkedListElement = this.mUnrefAvailList.getMRUElement();
        if (recentlyUsedLinkedListElement != null) {
            applicationModule = (ApplicationModule)recentlyUsedLinkedListElement.getRefObject();
            Diagnostic.ASSERT(!this.isReferenced(applicationModule) && this.isAvailable(applicationModule), "ILLEGAL STATE:  UNAVAILABLE OR REFERENCED APPMODULE IN AVAILABLE, UNREFERENCED LIST");
        }
        return applicationModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findAvailableInstance(SessionCookie sessionCookie, SessionCookieInfo sessionCookieInfo, SessionCookieInfo sessionCookieInfo2, ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext, boolean bl, Object[] objectArray) {
        int n = -1;
        ApplicationModule applicationModule = null;
        if (!this.isUseExclusive()) {
            Properties properties = new Properties();
            properties.put(SESSION_COOKIE, sessionCookie);
            properties.put(SVC_MSG_CONTEXT, applicationPoolSvcMsgContext);
            applicationModule = (ApplicationModule)super.useResource(properties);
        }
        Integer n2 = this.mLock;
        synchronized (n2) {
            this.validateSessionCookieAvailable(sessionCookieInfo);
            ApplicationModuleInfo applicationModuleInfo = null;
            if (!this.isUseExclusive()) {
                applicationModuleInfo = (ApplicationModuleInfo)this.mInstanceInfo.get(applicationModule);
                n = 5;
            } else if (bl) {
                this.allocateResource();
                n = 4;
            } else if (sessionCookieInfo.mApplicationModule != null && this.isAvailable(sessionCookieInfo.mApplicationModule)) {
                applicationModule = sessionCookieInfo.mApplicationModule;
                applicationModuleInfo = (ApplicationModuleInfo)this.mInstanceInfo.get((Object)applicationModule);
                this.mReferencedList.touchElement(applicationModuleInfo);
                n = 1;
            } else {
                int n3 = this.getRecycleThreshold();
                applicationModule = this.findUnreferencedAvailInstance();
                if (applicationModule == null && this.getResourceCount() >= n3) {
                    applicationModule = this.findReferencedAvailInstance();
                }
                if (applicationModule == null) {
                    applicationModule = (ApplicationModule)this.allocateResource();
                }
                if (applicationModule != null) {
                    if (!this.isReferenced(applicationModule)) {
                        applicationModuleInfo = (ApplicationModuleInfo)this.mInstanceInfo.get((Object)applicationModule);
                        n = 2;
                    } else {
                        applicationModuleInfo = (ApplicationModuleInfo)this.mInstanceInfo.get((Object)applicationModule);
                        SessionCookie sessionCookie2 = this.getReferencingSessionCookie(applicationModule);
                        this.setSessionCookieAvailable(sessionCookie2, false);
                        sessionCookieInfo2.mCookie = sessionCookie2;
                        sessionCookieInfo2.mCookieInfo = (SessionCookieInfo)sessionCookie2.getInfoObject();
                        this.disassociateSessionCookie(applicationModule, applicationModuleInfo, sessionCookieInfo2.mCookie, sessionCookieInfo2.mCookieInfo, false);
                        n = 3;
                    }
                } else {
                    n = 4;
                }
            }
            if (applicationModule != null) {
                sessionCookieInfo2.mConnectionMetadata = applicationModuleInfo.mConnectionMetadata;
                this.associateSessionCookie(applicationModule, applicationModuleInfo, sessionCookie, sessionCookieInfo);
                if (this.isUseExclusive()) {
                    this.setAvailable(applicationModule, false);
                }
                this.mReferencedList.addElement(applicationModuleInfo);
            }
            sessionCookieInfo2.mApplicationModule = applicationModule;
            objectArray[0] = applicationModuleInfo;
        }
        return n;
    }

    private ApplicationModule findReferencedAvailInstance() {
        ApplicationModule applicationModule = null;
        RecentlyUsedLinkedListElement recentlyUsedLinkedListElement = this.mRefAvailList.getLRUElement();
        if (recentlyUsedLinkedListElement != null) {
            applicationModule = (ApplicationModule)recentlyUsedLinkedListElement.getRefObject();
            Diagnostic.ASSERT(this.isAvailable(applicationModule), "ILLEGAL STATE:  UNAVAILABLE APPMODULE IN REF,AVAIL LIST");
        }
        return applicationModule;
    }

    protected final Object getResourceDetails(Object object) {
        HashMap hashMap = new HashMap();
        Object var3_3 = null;
        hashMap.put((Object)SESSION_COOKIE, (Object)this.getReferencingSessionCookie((ApplicationModule)object));
        hashMap.put((Object)PENDING_CONTEXT, (Object)new Boolean(this.getPendingContext((ApplicationModule)object)));
        return hashMap;
    }

    protected void prepareForGCRemove(ArrayList arrayList, Object object) {
        SessionCookie sessionCookie = this.getReferencingSessionCookie((ApplicationModule)object);
        if (sessionCookie != null) {
            this.setSessionCookieAvailable(sessionCookie, false);
        }
        super.prepareForGCRemove(arrayList, object);
    }

    protected void beforeResourceFinalized(Object object) {
        ApplicationModuleInfo applicationModuleInfo;
        ApplicationModule applicationModule = (ApplicationModule)object;
        SessionCookie sessionCookie = this.getReferencingSessionCookie(applicationModule);
        if (sessionCookie != null) {
            this.disassociateSessionCookie(applicationModule, sessionCookie, false);
            this.setSessionCookieAvailable(sessionCookie, false);
        }
        if ((applicationModuleInfo = (ApplicationModuleInfo)this.mInstanceInfo.get(object)) != null) {
            this.mRefAvailList.removeElement(applicationModuleInfo.mRefAvailListElement);
            this.mUnrefAvailList.removeElement(applicationModuleInfo.mUnrefAvailListElement);
            this.mInstanceInfo.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object seekLRUAvailableResource(Object object) {
        Integer n = this.mLock;
        synchronized (n) {
            Object object2 = null;
            if (object == null) {
                RecentlyUsedLinkedListElement recentlyUsedLinkedListElement = this.mUnrefAvailList.getLRUElement();
                if (recentlyUsedLinkedListElement == null) {
                    recentlyUsedLinkedListElement = this.mRefAvailList.getLRUElement();
                }
                if (recentlyUsedLinkedListElement != null) {
                    object2 = recentlyUsedLinkedListElement.getRefObject();
                }
            } else {
                ApplicationModuleInfo applicationModuleInfo = (ApplicationModuleInfo)this.mInstanceInfo.get(object);
                RecentlyUsedLinkedListElement recentlyUsedLinkedListElement = applicationModuleInfo.mUnrefAvailListElement;
                if (!recentlyUsedLinkedListElement.isInList()) {
                    recentlyUsedLinkedListElement = applicationModuleInfo.mRefAvailListElement;
                }
                if (recentlyUsedLinkedListElement.isInList() && (recentlyUsedLinkedListElement = recentlyUsedLinkedListElement.getLessRecentlyUsedElement()) != null) {
                    object2 = recentlyUsedLinkedListElement.getRefObject();
                }
            }
            Object object3 = object2;
            return object3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object seekMRUAvailableResource(Object object) {
        Integer n = this.mLock;
        synchronized (n) {
            Object object2 = null;
            if (object == null) {
                RecentlyUsedLinkedListElement recentlyUsedLinkedListElement = this.mUnrefAvailList.getMRUElement();
                if (recentlyUsedLinkedListElement == null) {
                    recentlyUsedLinkedListElement = this.mRefAvailList.getMRUElement();
                }
                if (recentlyUsedLinkedListElement != null) {
                    object2 = recentlyUsedLinkedListElement.getRefObject();
                }
            } else {
                ApplicationModuleInfo applicationModuleInfo = (ApplicationModuleInfo)this.mInstanceInfo.get(object);
                RecentlyUsedLinkedListElement recentlyUsedLinkedListElement = applicationModuleInfo.mUnrefAvailListElement;
                if (!recentlyUsedLinkedListElement.isInList()) {
                    recentlyUsedLinkedListElement = applicationModuleInfo.mRefAvailListElement;
                }
                if (recentlyUsedLinkedListElement.isInList() && (recentlyUsedLinkedListElement = recentlyUsedLinkedListElement.getMoreRecentlyUsedElement()) != null) {
                    object2 = recentlyUsedLinkedListElement.getRefObject();
                }
            }
            Object object3 = object2;
            return object3;
        }
    }

    protected final void finalizeResource(Object object, Object object2) {
        block8: {
            super.finalizeResource(object, object2);
            ApplicationModule applicationModule = (ApplicationModule)object;
            SessionCookie sessionCookie = (SessionCookie)((HashMap)object2).get((Object)SESSION_COOKIE);
            boolean bl = (Boolean)((HashMap)object2).get((Object)PENDING_CONTEXT);
            try {
                if (sessionCookie != null) {
                    ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext = new ApplicationPoolSvcMsgContext();
                    applicationPoolSvcMsgContext.setApplicationModuleRemoved(true);
                    SessionCookieInfo sessionCookieInfo = (SessionCookieInfo)sessionCookie.getInfoObject();
                    this.manageReferencingState(sessionCookie, sessionCookieInfo, applicationModule, null, applicationPoolSvcMsgContext);
                }
                Object var11_8 = null;
                if (sessionCookie != null) {
                    this.setSessionCookieAvailable(sessionCookie, true);
                }
            }
            catch (Throwable throwable) {
                Object var11_9 = null;
                if (sessionCookie != null) {
                    this.setSessionCookieAvailable(sessionCookie, true);
                }
                throw throwable;
            }
            if (!bl) {
                ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext = new ApplicationPoolSvcMsgContext();
                this.buildRemoveMessage((ApplicationModule)object, applicationPoolSvcMsgContext);
                try {
                    this.sendPoolMessage(applicationPoolSvcMsgContext, null, null, (ApplicationModule)object, null);
                }
                catch (Throwable throwable) {
                    if (!Diagnostic.isOn()) break block8;
                    Diagnostic.println("An exception occured while removing the AM");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void manageReferencingState(SessionCookie sessionCookie, SessionCookieInfo sessionCookieInfo, ApplicationModule applicationModule, ApplicationModuleInfo applicationModuleInfo, ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext) {
        Object object = sessionCookie.getSyncLock();
        synchronized (object) {
            if (!sessionCookie.isActivationRequired(applicationModule) && !sessionCookie.isFailoverEnabled()) {
                this.doFailover(applicationModule, sessionCookie, applicationPoolSvcMsgContext);
            }
            if (applicationPoolSvcMsgContext.getRequest() != null) {
                this.sendPoolMessage(applicationPoolSvcMsgContext, sessionCookie, sessionCookieInfo, applicationModule, applicationModuleInfo);
            }
        }
    }

    public void checkin(ApplicationModule applicationModule) {
        SessionCookie sessionCookie = this.getReferencingSessionCookie(applicationModule);
        sessionCookie.releaseApplicationModule(1);
        this.removeSessionCookie(sessionCookie);
    }

    public void releaseApplicationModule(SessionCookie sessionCookie, boolean bl) {
        this.releaseApplicationModule(sessionCookie, bl ? 3 : 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseApplicationModule(SessionCookie sessionCookie, int n) {
        ApplicationModule applicationModule = null;
        ApplicationModuleInfo applicationModuleInfo = null;
        SessionCookieInfo sessionCookieInfo = null;
        boolean bl = (n & 4) > 0 || !this.isAMPoolingEnabled();
        int n2 = 0xFFFFFFFB & n;
        boolean bl2 = false;
        if (!this.isUseExclusive()) {
            this.doSharedCheckin(sessionCookie, bl);
        } else {
            Integer n3 = this.mLock;
            synchronized (n3) {
                sessionCookieInfo = (SessionCookieInfo)sessionCookie.getInfoObject();
                this.validateSessionCookieInPool(sessionCookie, sessionCookieInfo);
                applicationModule = sessionCookieInfo.mApplicationModule;
                if (applicationModule == null || this.isAvailable(applicationModule)) {
                    Class clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
                    if (clazz == null) {
                        clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolImpl.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
                    }
                    throw new ApplicationPoolException(clazz, "30004", new Object[]{this.mName});
                }
                applicationModuleInfo = (ApplicationModuleInfo)this.mInstanceInfo.get((Object)applicationModule);
                bl = bl || (this.getState(applicationModule) & 8) > 0;
            }
            ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext = null;
            switch (n2) {
                case 3: {
                    this.doManagedCheckin(sessionCookie, sessionCookieInfo, applicationModule, applicationModuleInfo, bl);
                    break;
                }
                case 1: {
                    this.doUnmanagedCheckin(sessionCookie, sessionCookieInfo, applicationModule, applicationModuleInfo, bl);
                    break;
                }
                case 2: {
                    this.doLogout(applicationModule);
                    applicationPoolSvcMsgContext = new ApplicationPoolSvcMsgContext();
                    if (sessionCookie.isFailoverEnabled()) {
                        this.doFailover(applicationModule, sessionCookie, applicationPoolSvcMsgContext);
                        bl2 = true;
                    }
                }
                case 0: {
                    if (applicationPoolSvcMsgContext == null) {
                        applicationPoolSvcMsgContext = new ApplicationPoolSvcMsgContext();
                    }
                    if (!bl2) {
                        this.doPassivateHint(sessionCookie, applicationPoolSvcMsgContext);
                    }
                    this.sendPoolMessage(applicationPoolSvcMsgContext, sessionCookie, sessionCookieInfo, applicationModule, applicationModuleInfo);
                    this.setState(applicationModule, (byte)36, null);
                    sessionCookieInfo.touch();
                    break;
                }
                default: {
                    Class clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
                    if (clazz == null) {
                        clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolImpl.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
                    }
                    throw new ApplicationPoolException(clazz, "30020", new Object[]{sessionCookie.getSessionId(), sessionCookie.getApplicationId()});
                }
            }
        }
    }

    private void doLogout(ApplicationModule applicationModule) {
        Hashtable hashtable = applicationModule.getSession().getEnvironment();
        if (JboEnvUtil.isUserAuthenticated(hashtable)) {
            UserAznUtil.logout(hashtable);
        }
    }

    private void doPassivateHint(SessionCookie sessionCookie, ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext) {
        this.initMessageJDBCContext(sessionCookie, sessionCookie.getEnvInfoProvider(), applicationPoolSvcMsgContext);
        applicationPoolSvcMsgContext.passivateState(-1, null, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSharedCheckin(SessionCookie sessionCookie, boolean bl) {
        ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext = new ApplicationPoolSvcMsgContext();
        ApplicationModule applicationModule = null;
        boolean bl2 = false;
        ApplicationModuleInfo applicationModuleInfo = null;
        SessionCookieInfo sessionCookieInfo = null;
        Integer n = this.mLock;
        synchronized (n) {
            sessionCookieInfo = (SessionCookieInfo)sessionCookie.getInfoObject();
            this.validateSessionCookieInPool(sessionCookie, sessionCookieInfo);
            applicationModule = sessionCookieInfo.mApplicationModule;
            if (applicationModule == null) {
                Class clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolImpl.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
                }
                throw new ApplicationPoolException(clazz, "30004", new Object[]{this.mName});
            }
            applicationModuleInfo = (ApplicationModuleInfo)this.mInstanceInfo.get((Object)applicationModule);
            bl = bl || (this.getState(applicationModule) & 8) > 0;
            this.disassociateSessionCookie(applicationModule, applicationModuleInfo, sessionCookie, sessionCookieInfo, true);
            sessionCookie.resetStateInternal();
            Properties properties = new Properties();
            properties.put(SESSION_COOKIE, sessionCookie);
            properties.put(SVC_MSG_CONTEXT, applicationPoolSvcMsgContext);
            super.releaseResource(applicationModule, properties);
            if (this.isInstanceAliveInternal(applicationModule)) {
                if (bl) {
                    this.buildRemoveMessage(applicationModule, applicationPoolSvcMsgContext);
                    applicationModuleInfo.mPendingContext = true;
                    this.removeResource(applicationModule);
                }
                bl2 = true;
            }
        }
        if (bl2) {
            this.sendPoolMessage(applicationPoolSvcMsgContext, sessionCookie, sessionCookieInfo, applicationModule, applicationModuleInfo);
        }
        sessionCookieInfo.touch();
    }

    private void doUnmanagedCheckin(SessionCookie sessionCookie, SessionCookieInfo sessionCookieInfo, ApplicationModule applicationModule, ApplicationModuleInfo applicationModuleInfo, boolean bl) {
        this.doLogout(applicationModule);
        ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext = new ApplicationPoolSvcMsgContext();
        this.resetApplicationModule(sessionCookie, sessionCookieInfo, applicationModule, applicationModuleInfo, 0x12 | (bl ? 4 : 0), applicationPoolSvcMsgContext);
        sessionCookieInfo.touch();
    }

    void resetApplicationModule(SessionCookie sessionCookie, int n) {
        ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext = new ApplicationPoolSvcMsgContext();
        this.resetApplicationModule(sessionCookie, n, applicationPoolSvcMsgContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ApplicationModule resetApplicationModule(SessionCookie sessionCookie, int n, ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext) {
        ApplicationModule applicationModule = null;
        ApplicationModuleInfo applicationModuleInfo = null;
        SessionCookieInfo sessionCookieInfo = null;
        Integer n2 = this.mLock;
        synchronized (n2) {
            sessionCookieInfo = (SessionCookieInfo)sessionCookie.getInfoObject();
            this.validateSessionCookieInPool(sessionCookie, sessionCookieInfo);
            applicationModule = sessionCookieInfo.mApplicationModule;
            if (applicationModule == null) {
                ApplicationModule applicationModule2 = null;
                return applicationModule2;
            }
            applicationModuleInfo = (ApplicationModuleInfo)this.mInstanceInfo.get((Object)applicationModule);
            this.setAvailable(applicationModule, false);
        }
        return this.resetApplicationModule(sessionCookie, sessionCookieInfo, applicationModule, applicationModuleInfo, n, applicationPoolSvcMsgContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ApplicationModule resetApplicationModule(SessionCookie sessionCookie, SessionCookieInfo sessionCookieInfo, ApplicationModule applicationModule, ApplicationModuleInfo applicationModuleInfo, int n, ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext) {
        Integer n2;
        if (applicationModule == null) {
            return null;
        }
        boolean bl = false;
        boolean bl2 = false;
        try {
            if ((n & 1) > 0) {
                this.reconnect(applicationModule, sessionCookie, false, applicationPoolSvcMsgContext);
            }
            if ((n & 2) > 0) {
                int n3 = sessionCookie.getPassivationId() != -1 ? sessionCookie.getPassivationId() : ((SessionCookieImpl)sessionCookie).mPrevPassivationId;
                this.removeState(n3, applicationPoolSvcMsgContext);
                sessionCookie.setPassivationId(-1);
                int n4 = sessionCookie.getReservedPassivationId();
                this.removeState(n4, applicationPoolSvcMsgContext);
                sessionCookie.setReservedPassivationId(-1);
            }
            if ((n & 4) > 0) {
                Integer n5 = this.mLock;
                synchronized (n5) {
                    this.disassociateSessionCookie(applicationModule, applicationModuleInfo, sessionCookie, sessionCookieInfo, true);
                    sessionCookie.resetStateInternal();
                }
                bl = true;
                this.buildRemoveMessage(applicationModule, applicationPoolSvcMsgContext);
                applicationModuleInfo.mPendingContext = true;
                this.removeResource(applicationModule);
            } else if (sessionCookie.isConnectionPoolingEnabled()) {
                if ((n & 8) > 0) {
                    applicationPoolSvcMsgContext.resetState(4);
                } else {
                    applicationPoolSvcMsgContext.resetState(0);
                }
                this.disconnect(applicationModule, false, sessionCookie, applicationPoolSvcMsgContext);
            } else if ((n & 8) > 0) {
                applicationPoolSvcMsgContext.resetState(5);
            } else {
                applicationPoolSvcMsgContext.resetState(1);
            }
            this.sendPoolMessage(applicationPoolSvcMsgContext, sessionCookie, sessionCookieInfo, applicationModule, applicationModuleInfo);
            Object var13_12 = null;
            n2 = this.mLock;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            Integer n6 = this.mLock;
            synchronized (n6) {
                applicationModuleInfo = (ApplicationModuleInfo)this.mInstanceInfo.get((Object)applicationModule);
                if (applicationModuleInfo != null) {
                    this.disassociateSessionCookie(applicationModule, applicationModuleInfo, sessionCookie, sessionCookieInfo, true);
                    sessionCookie.resetStateInternal();
                    if ((n & 0x10) > 0) {
                        try {
                            applicationModuleInfo.mCanFinalizeResource = false;
                            super.releaseResource(applicationModule, null);
                            if (bl && (this.getState(applicationModule) & 8) == 0) {
                                this.setState(applicationModule, (byte)8, null);
                            }
                            Object var16_18 = null;
                            applicationModuleInfo.mCanFinalizeResource = true;
                        }
                        catch (Throwable throwable2) {
                            Object var16_19 = null;
                            applicationModuleInfo.mCanFinalizeResource = true;
                            throw throwable2;
                        }
                        if (this.mInstanceInfo.containsKey((Object)applicationModule) && (this.getState(applicationModule) & 8) > 0) {
                            bl2 = true;
                        }
                    }
                }
            }
            if (bl2) {
                this.removeResourceInternal(applicationModule);
            }
            throw throwable;
        }
        synchronized (n2) {
            applicationModuleInfo = (ApplicationModuleInfo)this.mInstanceInfo.get((Object)applicationModule);
            if (applicationModuleInfo != null) {
                this.disassociateSessionCookie(applicationModule, applicationModuleInfo, sessionCookie, sessionCookieInfo, true);
                sessionCookie.resetStateInternal();
                if ((n & 0x10) > 0) {
                    try {
                        applicationModuleInfo.mCanFinalizeResource = false;
                        super.releaseResource(applicationModule, null);
                        if (bl && (this.getState(applicationModule) & 8) == 0) {
                            this.setState(applicationModule, (byte)8, null);
                        }
                        Object var16_16 = null;
                        applicationModuleInfo.mCanFinalizeResource = true;
                    }
                    catch (Throwable throwable) {
                        Object var16_17 = null;
                        applicationModuleInfo.mCanFinalizeResource = true;
                        throw throwable;
                    }
                    if (this.mInstanceInfo.containsKey((Object)applicationModule) && (this.getState(applicationModule) & 8) > 0) {
                        bl2 = true;
                    }
                }
            }
        }
        if (bl2) {
            this.removeResourceInternal(applicationModule);
        }
        return applicationModule;
    }

    protected boolean canFinalizeResource(Object object) {
        ApplicationModuleInfo applicationModuleInfo = (ApplicationModuleInfo)this.mInstanceInfo.get(object);
        return super.canFinalizeResource(object) && applicationModuleInfo.mCanFinalizeResource;
    }

    private void buildRemoveMessage(ApplicationModule applicationModule, ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext) {
        applicationPoolSvcMsgContext.setApplicationModuleRemoved(true);
        applicationPoolSvcMsgContext.resetState(4);
        applicationPoolSvcMsgContext.removeApplicationModule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkinWithSessionState(ApplicationModule applicationModule) {
        SessionCookie sessionCookie = this.getReferencingSessionCookie(applicationModule);
        StringBuffer stringBuffer = null;
        Object object = sessionCookie.getSyncLock();
        synchronized (object) {
            sessionCookie.releaseApplicationModule(3);
            stringBuffer = new StringBuffer(sessionCookie.getSessionId());
            String string = sessionCookie.getValue();
            if (string != null) {
                stringBuffer.append('-').append(string);
            }
            this.removeSessionCookie(sessionCookie);
        }
        return stringBuffer.toString();
    }

    /*
     * Exception decompiling
     */
    public void refreshAMStatistics() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 2[TRYBLOCK]], but top level block is 20[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApplicationModule doCheckout(SessionCookie sessionCookie, SessionCookieInfo sessionCookieInfo, int n) {
        ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext = new ApplicationPoolSvcMsgContext();
        SessionCookieInfo sessionCookieInfo2 = new SessionCookieInfo();
        Object[] objectArray = new ApplicationModuleInfo[1];
        int n2 = this.findAvailableInstance(sessionCookie, sessionCookieInfo, sessionCookieInfo2, applicationPoolSvcMsgContext, n == 0, objectArray);
        ApplicationModule applicationModule = sessionCookieInfo2.mApplicationModule;
        SessionCookie sessionCookie2 = sessionCookieInfo2.mCookie;
        SessionCookieInfo sessionCookieInfo3 = sessionCookieInfo2.mCookieInfo;
        ConnectionMetadata connectionMetadata = sessionCookieInfo2.mConnectionMetadata;
        ApplicationModule applicationModule2 = null;
        try {
            applicationModule2 = this.prepareApplicationModule(applicationModule, (ApplicationModuleInfo)objectArray[0], sessionCookie, sessionCookieInfo, n2, sessionCookie2, sessionCookieInfo3, connectionMetadata, applicationPoolSvcMsgContext);
        }
        catch (Throwable throwable) {
            this.logPoolEvent((byte)9);
            if (n2 == 5) {
                super.releaseResource(applicationModule, null);
            }
            if (n2 != 4 && n > 0 && applicationPoolSvcMsgContext.getJDBCConnectException() == null && applicationPoolSvcMsgContext.getAuthException() == null) {
                if (Diagnostic.isOn()) {
                    Diagnostic.println("An exception occured during checkout.");
                    Diagnostic.println("Retrying checkout.");
                }
                ApplicationModule applicationModule3 = this.doCheckout(sessionCookie, sessionCookieInfo, --n);
                return applicationModule3;
            }
            Class clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolImpl.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
            }
            ApplicationPoolException applicationPoolException = new ApplicationPoolException(clazz, "30003", new Object[]{this.mName}, new Exception[]{new JboException(throwable)});
            throw applicationPoolException;
        }
        applicationModule2.getSession().getEnvironment().put("jbo.sessioncookie", sessionCookie);
        Integer n3 = this.mLock;
        synchronized (n3) {
            if (this.isUseExclusive()) {
                this.logPoolEvent((byte)3);
                if (n2 == 3) {
                    this.logPoolEvent((byte)6);
                } else if (n2 == 2) {
                    this.logPoolEvent((byte)7);
                } else if (n2 == 1) {
                    this.logPoolEvent((byte)8);
                }
                this.incrementRefCount(applicationModule2);
            }
        }
        return applicationModule2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApplicationModule prepareApplicationModule(ApplicationModule applicationModule, ApplicationModuleInfo applicationModuleInfo, SessionCookie sessionCookie, SessionCookieInfo sessionCookieInfo, int n, SessionCookie sessionCookie2, SessionCookieInfo sessionCookieInfo2, ConnectionMetadata connectionMetadata, ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext) {
        Boolean bl;
        ApplicationModuleInfo applicationModuleInfo2 = applicationModuleInfo;
        switch (n) {
            case 1: {
                this.reuseReferencedInstance(sessionCookie, sessionCookieInfo, applicationModule, applicationPoolSvcMsgContext);
                break;
            }
            case 3: {
                try {
                    applicationPoolSvcMsgContext = this.recycleReferencedInstance(sessionCookie, sessionCookieInfo, applicationModule, applicationModuleInfo, connectionMetadata, sessionCookie2, sessionCookieInfo2, applicationPoolSvcMsgContext);
                    Object var16_11 = null;
                    this.setSessionCookieAvailable(sessionCookie2, true);
                    break;
                }
                catch (Throwable throwable) {
                    Object var16_12 = null;
                    this.setSessionCookieAvailable(sessionCookie2, true);
                    throw throwable;
                }
            }
            case 2: {
                this.recycleUnreferencedInstance(sessionCookie, sessionCookieInfo, applicationModule, connectionMetadata, applicationPoolSvcMsgContext);
                break;
            }
            case 4: {
                try {
                    Properties properties = new Properties();
                    properties.put(SESSION_COOKIE, sessionCookie);
                    properties.put(SVC_MSG_CONTEXT, applicationPoolSvcMsgContext);
                    applicationModule = (ApplicationModule)this.createResource(properties);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new JboException(exception);
                }
                Integer n2 = this.mLock;
                synchronized (n2) {
                    applicationModuleInfo2 = (ApplicationModuleInfo)this.mInstanceInfo.get((Object)applicationModule);
                    this.associateSessionCookie(applicationModule, applicationModuleInfo2, sessionCookie, sessionCookieInfo);
                    this.setAvailable(applicationModule, false);
                    this.mReferencedList.addElement(applicationModuleInfo2);
                }
                int n3 = sessionCookie.getPassivationId();
                if (n3 != -1) {
                    this.activateState(n3, sessionCookie, applicationPoolSvcMsgContext);
                    break;
                }
                this.prepareSession(applicationModule, sessionCookie, applicationPoolSvcMsgContext);
            }
        }
        if (((SessionCookieImpl)sessionCookie).mIsPiggybackReservePassivationId) {
            applicationPoolSvcMsgContext.reservePassivationId();
        }
        if ((bl = (Boolean)sessionCookie.getUserData().get("__jbo.bundledexcmode")) != null) {
            applicationPoolSvcMsgContext.setBundledExceptionMode(bl);
        }
        this.sendPoolMessage(applicationPoolSvcMsgContext, sessionCookie, sessionCookieInfo, applicationModule, applicationModuleInfo2);
        return applicationModule;
    }

    private void reuseReferencedInstance(SessionCookie sessionCookie, SessionCookieInfo sessionCookieInfo, ApplicationModule applicationModule, ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext) {
        Diagnostic.println("Reusing a cached session application module instance");
        ConnectionMetadata connectionMetadata = sessionCookieInfo.mConnectionMetadata;
        this.reconnect(applicationModule, sessionCookie, true, applicationPoolSvcMsgContext);
        if (sessionCookie.isActivationRequired(applicationModule)) {
            int n = sessionCookie.getPassivationId();
            this.activateState(n, sessionCookie, applicationPoolSvcMsgContext);
        } else {
            applicationPoolSvcMsgContext.hintPrepareSession(null, connectionMetadata);
        }
    }

    private ApplicationPoolSvcMsgContext recycleReferencedInstance(SessionCookie sessionCookie, SessionCookieInfo sessionCookieInfo, ApplicationModule applicationModule, ApplicationModuleInfo applicationModuleInfo, ConnectionMetadata connectionMetadata, SessionCookie sessionCookie2, SessionCookieInfo sessionCookieInfo2, ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext) {
        Diagnostic.println("Recycling a referenced, available pool instance");
        this.manageReferencingState(sessionCookie2, sessionCookieInfo2, applicationModule, applicationModuleInfo, applicationPoolSvcMsgContext);
        ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext2 = new ApplicationPoolSvcMsgContext();
        if (!this.compareConnectionMetadata(connectionMetadata, sessionCookieInfo.mConnectionMetadata)) {
            applicationPoolSvcMsgContext2.resetState(4);
            this.disconnect(applicationModule, false, sessionCookie2, applicationPoolSvcMsgContext2);
            this.connect(applicationModule, sessionCookie, applicationPoolSvcMsgContext2);
        } else {
            this.reconnect(applicationModule, sessionCookie, false, applicationPoolSvcMsgContext2);
            applicationPoolSvcMsgContext2.resetState(7);
        }
        int n = sessionCookie.getPassivationId();
        if (n != -1) {
            this.activateState(n, sessionCookie, applicationPoolSvcMsgContext2);
        } else {
            this.prepareSession(applicationModule, sessionCookie, applicationPoolSvcMsgContext2);
        }
        return applicationPoolSvcMsgContext2;
    }

    private void recycleUnreferencedInstance(SessionCookie sessionCookie, SessionCookieInfo sessionCookieInfo, ApplicationModule applicationModule, ConnectionMetadata connectionMetadata, ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext) {
        Diagnostic.println("Recycling an unreferenced, available pool instance");
        if (!this.compareConnectionMetadata(connectionMetadata, sessionCookieInfo.mConnectionMetadata)) {
            this.disconnect(applicationModule, false, sessionCookie, applicationPoolSvcMsgContext);
            this.connect(applicationModule, sessionCookie, applicationPoolSvcMsgContext);
        } else {
            this.reconnect(applicationModule, sessionCookie, false, applicationPoolSvcMsgContext);
        }
        int n = sessionCookie.getPassivationId();
        if (n != -1) {
            this.activateState(n, sessionCookie, applicationPoolSvcMsgContext);
        } else {
            this.prepareSession(applicationModule, sessionCookie, applicationPoolSvcMsgContext);
        }
    }

    private void removeDeadInstance(ApplicationModule applicationModule) {
        Diagnostic.println("A dead application module instance was detected");
        Diagnostic.println("The application module instance was removed from the pool");
        this.removeResource(applicationModule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doManagedCheckin(SessionCookie sessionCookie, SessionCookieInfo sessionCookieInfo, ApplicationModule applicationModule, ApplicationModuleInfo applicationModuleInfo, boolean bl) {
        Integer n;
        this.doLogout(applicationModule);
        boolean bl2 = false;
        try {
            ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext = new ApplicationPoolSvcMsgContext();
            boolean bl3 = sessionCookie.isFailoverEnabled();
            if (bl3 || bl) {
                Diagnostic.println("Application Module failover is enabled");
                this.doFailover(applicationModule, sessionCookie, applicationPoolSvcMsgContext);
            } else {
                this.doPassivateHint(sessionCookie, applicationPoolSvcMsgContext);
            }
            if (bl) {
                sessionCookie.setActivationRequired(true);
                this.buildRemoveMessage(applicationModule, applicationPoolSvcMsgContext);
                applicationModuleInfo.mPendingContext = true;
                this.removeResource(applicationModule);
            } else if (sessionCookie.isConnectionPoolingEnabled()) {
                this.disconnect(applicationModule, true, sessionCookie, applicationPoolSvcMsgContext);
            }
            this.sendPoolMessage(applicationPoolSvcMsgContext, sessionCookie, sessionCookieInfo, applicationModule, applicationModuleInfo);
            Object var10_9 = null;
            n = this.mLock;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            Integer n2 = this.mLock;
            synchronized (n2) {
                bl = bl || (this.getState(applicationModule) & 8) > 0;
                applicationModuleInfo = (ApplicationModuleInfo)this.mInstanceInfo.get((Object)applicationModule);
                if (applicationModuleInfo != null) {
                    if (!bl) {
                        this.mReferencedList.touchElement(applicationModuleInfo);
                    }
                    try {
                        applicationModuleInfo.mCanFinalizeResource = false;
                        super.releaseResource(applicationModule, null);
                        if (bl && (this.getState(applicationModule) & 8) == 0) {
                            this.setState(applicationModule, (byte)8, null);
                        }
                        Object var13_15 = null;
                        applicationModuleInfo.mCanFinalizeResource = true;
                    }
                    catch (Throwable throwable2) {
                        Object var13_16 = null;
                        applicationModuleInfo.mCanFinalizeResource = true;
                        throw throwable2;
                    }
                    if ((this.getState(applicationModule) & 8) > 0) {
                        bl2 = true;
                    }
                }
            }
            if (bl2) {
                this.removeResourceInternal(applicationModule);
            }
            throw throwable;
        }
        synchronized (n) {
            bl = bl || (this.getState(applicationModule) & 8) > 0;
            applicationModuleInfo = (ApplicationModuleInfo)this.mInstanceInfo.get((Object)applicationModule);
            if (applicationModuleInfo != null) {
                if (!bl) {
                    this.mReferencedList.touchElement(applicationModuleInfo);
                }
                try {
                    applicationModuleInfo.mCanFinalizeResource = false;
                    super.releaseResource(applicationModule, null);
                    if (bl && (this.getState(applicationModule) & 8) == 0) {
                        this.setState(applicationModule, (byte)8, null);
                    }
                    Object var13_13 = null;
                    applicationModuleInfo.mCanFinalizeResource = true;
                }
                catch (Throwable throwable) {
                    Object var13_14 = null;
                    applicationModuleInfo.mCanFinalizeResource = true;
                    throw throwable;
                }
                if ((this.getState(applicationModule) & 8) > 0) {
                    bl2 = true;
                }
            }
        }
        if (bl2) {
            this.removeResourceInternal(applicationModule);
        }
        sessionCookieInfo.touch();
    }

    public ApplicationModule createNewInstance() throws Exception {
        return (ApplicationModule)this.createResource(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object instantiateResource(Properties properties) {
        ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext = null;
        SessionCookie sessionCookie = null;
        ApplicationModule applicationModule = null;
        if (properties != null) {
            sessionCookie = (SessionCookie)properties.get(SESSION_COOKIE);
            applicationPoolSvcMsgContext = (ApplicationPoolSvcMsgContext)properties.get(SVC_MSG_CONTEXT);
        }
        applicationModule = sessionCookie != null ? this.getConnectionStrategy().createApplicationModule(sessionCookie, sessionCookie.getEnvInfoProvider()) : this.getConnectionStrategy().createApplicationModule(this.getEnvironment());
        ApplicationModuleInfo applicationModuleInfo = new ApplicationModuleInfo(applicationModule);
        Integer n = this.mLock;
        synchronized (n) {
            this.mInstanceInfo.put((Object)applicationModule, (Object)applicationModuleInfo);
        }
        if (sessionCookie != null && applicationPoolSvcMsgContext != null) {
            this.connect(applicationModule, sessionCookie, applicationPoolSvcMsgContext);
        }
        return applicationModule;
    }

    public ApplicationModule checkout() throws Exception {
        SessionCookie sessionCookie = this.createSessionCookie(this.getName(), this.getNextSessionId(), null);
        return sessionCookie.useApplicationModule(false);
    }

    public void releaseInstances() {
        this.removeResources();
    }

    protected void releaseInstance(ApplicationModule applicationModule) {
        this.removeResource(applicationModule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList removeResources() {
        ArrayList arrayList = null;
        Integer n = this.mLock;
        synchronized (n) {
            arrayList = super.removeResources();
            this.mInstanceInfo.clear();
            Iterator iterator = this.mSessionCookieInfo.values().iterator();
            while (iterator.hasNext()) {
                ((SessionCookieInfo)iterator.next()).mApplicationModule = null;
            }
            this.mReferencedList.reset();
            this.mRefAvailList.reset();
            this.mUnrefAvailList.reset();
        }
        int n2 = arrayList.size();
        int n3 = 0;
        while (n3 < n2) {
            block7: {
                ApplicationModule applicationModule = (ApplicationModule)arrayList.get(n3);
                ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext = new ApplicationPoolSvcMsgContext();
                applicationPoolSvcMsgContext.setApplicationModuleRemoved(true);
                applicationPoolSvcMsgContext.resetState(4);
                applicationPoolSvcMsgContext.removeApplicationModule();
                try {
                    this.sendPoolMessage(applicationPoolSvcMsgContext, null, applicationModule);
                }
                catch (Throwable throwable) {
                    if (!Diagnostic.isOn()) break block7;
                    Diagnostic.println("An exception occured while removing the AM");
                }
            }
            ++n3;
        }
        return arrayList;
    }

    public int getAvailableInstanceCount() {
        return this.getAvailableResourceCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getReferencedResourceCount() {
        Integer n = this.mLock;
        synchronized (n) {
            int n2 = this.mReferencedList.getSize();
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getReferencingSessionCount() {
        Integer n = this.mLock;
        synchronized (n) {
            int n2 = this.mReferencingSessionCount;
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getSessionCount() {
        Integer n = this.mLock;
        synchronized (n) {
            int n2 = this.mSessionCookieInfo.size();
            return n2;
        }
    }

    public int getAvailableNumPools() {
        return this.getAvailableResourceCount();
    }

    public int getInstanceCount() {
        return this.getResourceCount();
    }

    public ApplicationModule getInstance(int n) {
        return (ApplicationModule)this.getResource(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationModule checkout(String string) {
        String string2 = SessionCookieImpl.parseSessionId(string);
        SessionCookie sessionCookie = this.getSessionCookieFactory().createSessionCookie(this.getName(), string2, this, null);
        Integer n = this.mLock;
        synchronized (n) {
            SessionCookieInfo sessionCookieInfo = (SessionCookieInfo)sessionCookie.getInfoObject();
            if (sessionCookieInfo != null) {
                sessionCookie = sessionCookieInfo.mCookie;
            }
        }
        if (sessionCookie == null) {
            sessionCookie = this.createSessionCookie(this.getName(), string2, null);
            int n2 = SessionCookieImpl.parsePassivationId(string);
            if (n2 != -1) {
                sessionCookie.setPassivationId(n2);
            }
        }
        return sessionCookie.useApplicationModule(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationModule useApplicationModule(SessionCookie sessionCookie, boolean bl) {
        ApplicationModule applicationModule = null;
        SessionCookieInfo sessionCookieInfo = null;
        Integer n = this.mLock;
        synchronized (n) {
            sessionCookieInfo = (SessionCookieInfo)sessionCookie.getInfoObject();
            this.validateSessionCookieInPool(sessionCookie, sessionCookieInfo);
            ApplicationModule applicationModule2 = sessionCookieInfo.mApplicationModule;
            if (this.isUseExclusive()) {
                if (applicationModule2 != null && !this.isAvailable(applicationModule2) && this.getRefCount(applicationModule2) > 0) {
                    applicationModule = applicationModule2;
                }
            } else {
                applicationModule = applicationModule2;
            }
        }
        if (applicationModule == null && bl) {
            applicationModule = this.doCheckout(sessionCookie, sessionCookieInfo, 1);
        } else if (bl) {
            this.setState(applicationModule, (byte)4, null);
        }
        sessionCookieInfo.touch();
        return applicationModule;
    }

    public String getPoolName() {
        return this.getName();
    }

    public String getName() {
        return this.mName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getUserData() {
        Integer n = this.mLock;
        synchronized (n) {
            Hashtable hashtable = this.mUserData;
            return hashtable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserData(Hashtable hashtable) {
        Integer n = this.mLock;
        synchronized (n) {
            this.mUserData = hashtable;
        }
    }

    public String getUserName() {
        return this.mUserName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserName(String string) {
        Integer n = this.mLock;
        synchronized (n) {
            this.mUserName = string;
        }
    }

    public String getPassword() {
        return this.mPassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPassword(String string) {
        Integer n = this.mLock;
        synchronized (n) {
            this.mPassword = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitAndSyncCache(ApplicationModule applicationModule) {
        Integer n = this.mLock;
        synchronized (n) {
            int n2 = applicationModule.getTransaction().commitAndSaveChangeSet();
            if (n2 >= 0) {
                Transaction transaction = null;
                boolean bl = true;
                ApplicationModule applicationModule2 = null;
                ApplicationModuleInfo applicationModuleInfo = null;
                int n3 = this.getResourceCount();
                int n4 = 0;
                while (n4 < n3) {
                    applicationModule2 = (ApplicationModule)this.getResource(n4);
                    if (applicationModule2 != null) {
                        SessionCookie sessionCookie;
                        applicationModuleInfo = (ApplicationModuleInfo)this.mInstanceInfo.get((Object)applicationModule2);
                        if (applicationModule2 != applicationModule && (sessionCookie = this.getReferencingSessionCookie(applicationModule2)) != null && !sessionCookie.isActivationRequired(applicationModule2)) {
                            transaction = applicationModule2.getTransaction();
                            if (!transaction.isConnected()) {
                                bl = false;
                                transaction.reconnect();
                            }
                            transaction.applyChangeSet(n2);
                            if (!bl) {
                                transaction.disconnect(true);
                            }
                            bl = true;
                        }
                    }
                    ++n4;
                }
                applicationModule.getTransaction().removeChangeSet(n2);
            }
        }
    }

    private SessionCookie getReferencingSessionCookie(ApplicationModule applicationModule) {
        ApplicationModuleInfo applicationModuleInfo = (ApplicationModuleInfo)this.mInstanceInfo.get((Object)applicationModule);
        return applicationModuleInfo.mReferencingSessionCookie;
    }

    private boolean getPendingContext(ApplicationModule applicationModule) {
        ApplicationModuleInfo applicationModuleInfo = (ApplicationModuleInfo)this.mInstanceInfo.get((Object)applicationModule);
        return applicationModuleInfo.mPendingContext;
    }

    private Iterator getReferencingSessionCookies(ApplicationModule applicationModule) {
        ApplicationModuleInfo applicationModuleInfo = (ApplicationModuleInfo)this.mInstanceInfo.get((Object)applicationModule);
        return applicationModuleInfo.mReferencingSessionCookies.keySet().iterator();
    }

    private boolean isReferenced(ApplicationModule applicationModule) {
        ApplicationModuleInfo applicationModuleInfo = (ApplicationModuleInfo)this.mInstanceInfo.get((Object)applicationModule);
        return applicationModuleInfo.mReferencingSessionCookie != null;
    }

    private void associateSessionCookie(ApplicationModule applicationModule, ApplicationModuleInfo applicationModuleInfo, SessionCookie sessionCookie, SessionCookieInfo sessionCookieInfo) {
        if (this.isUseExclusive()) {
            applicationModuleInfo.mReferencingSessionCookies.put((Object)sessionCookie, null);
            if (applicationModuleInfo.mReferencingSessionCookie == null) {
                applicationModuleInfo.mReferencingSessionCookie = sessionCookie;
            }
        }
        sessionCookieInfo.mApplicationModule = applicationModule;
        if (!sessionCookieInfo.mIsReferencingState) {
            sessionCookieInfo.mIsReferencingState = true;
            ++this.mReferencingSessionCount;
        }
    }

    private void disassociateSessionCookie(ApplicationModule applicationModule, SessionCookie sessionCookie, boolean bl) {
        this.disassociateSessionCookie(applicationModule, (ApplicationModuleInfo)this.mInstanceInfo.get((Object)applicationModule), sessionCookie, (SessionCookieInfo)sessionCookie.getInfoObject(), bl);
    }

    private void disassociateSessionCookie(ApplicationModule applicationModule, ApplicationModuleInfo applicationModuleInfo, SessionCookie sessionCookie, SessionCookieInfo sessionCookieInfo, boolean bl) {
        applicationModuleInfo.mReferencingSessionCookies.remove((Object)sessionCookie);
        if (sessionCookie.equals(applicationModuleInfo.mReferencingSessionCookie)) {
            applicationModuleInfo.mReferencingSessionCookie = null;
            Iterator iterator = this.getReferencingSessionCookies(applicationModule);
            if (iterator.hasNext()) {
                SessionCookie sessionCookie2 = (SessionCookie)iterator.next();
                this.associateSessionCookie(applicationModule, applicationModuleInfo, sessionCookie2, (SessionCookieInfo)sessionCookie2.getInfoObject());
            }
        }
        this.mReferencedList.removeElement(applicationModuleInfo);
        if (applicationModuleInfo.mRefAvailListElement.isInList()) {
            this.mRefAvailList.removeElement(applicationModuleInfo.mRefAvailListElement);
            this.mUnrefAvailList.touchElement(applicationModuleInfo.mUnrefAvailListElement);
        }
        sessionCookieInfo.mApplicationModule = null;
        if (bl) {
            sessionCookieInfo.resetState();
        }
    }

    private void doFailover(ApplicationModule applicationModule, SessionCookie sessionCookie, ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext) {
        int n;
        int n2 = sessionCookie.getReservedPassivationId();
        int n3 = n = sessionCookie.getPassivationId() != -1 ? sessionCookie.getPassivationId() : ((SessionCookieImpl)sessionCookie).mPrevPassivationId;
        if (sessionCookie.isActivationRequired(applicationModule)) {
            return;
        }
        this.initMessageJDBCContext(sessionCookie, sessionCookie.getEnvInfoProvider(), applicationPoolSvcMsgContext);
        if (n2 != -1) {
            applicationPoolSvcMsgContext.passivateState(n2, null, 0);
            sessionCookie.setReservedPassivationId(-1);
        } else {
            applicationPoolSvcMsgContext.passivateState(-1, null, 0);
        }
        this.removeState(n, applicationPoolSvcMsgContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInstanceAliveInternal(ApplicationModule applicationModule) {
        Integer n = this.mLock;
        synchronized (n) {
            ApplicationModuleInfo applicationModuleInfo = (ApplicationModuleInfo)this.mInstanceInfo.get((Object)applicationModule);
            boolean bl = applicationModuleInfo.mIsInstanceAlive;
            return bl;
        }
    }

    protected boolean isInstanceAlive(ApplicationModule applicationModule) {
        boolean bl = true;
        try {
            applicationModule.getSession().getVersion();
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    public boolean validateSessionCookieInPool(SessionCookie sessionCookie) {
        SessionCookieInfo sessionCookieInfo = (SessionCookieInfo)sessionCookie.getInfoObject();
        return this.validateSessionCookieInPool(sessionCookie, sessionCookieInfo);
    }

    private boolean validateSessionCookieInPool(SessionCookie sessionCookie, SessionCookieInfo sessionCookieInfo) {
        if (sessionCookieInfo == null) {
            Class clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolImpl.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
            }
            throw new ApplicationPoolException(clazz, "30006", new Object[]{sessionCookie.getSessionId(), sessionCookie.getApplicationId(), this.getName()});
        }
        return this.validateSessionCookie(sessionCookie);
    }

    public boolean validateSessionCookie(SessionCookie sessionCookie) {
        if (this.getSignature() != sessionCookie.getPoolSignature()) {
            Class clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolImpl.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
            }
            throw new ApplicationPoolException(clazz, "30006", new Object[]{sessionCookie.getSessionId(), sessionCookie.getApplicationId(), this.getName()});
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isApplicationModuleReleased(SessionCookie sessionCookie) {
        boolean bl = true;
        Integer n = this.mLock;
        synchronized (n) {
            SessionCookieInfo sessionCookieInfo = (SessionCookieInfo)sessionCookie.getInfoObject();
            this.validateSessionCookieInPool(sessionCookie, sessionCookieInfo);
            ApplicationModule applicationModule = sessionCookieInfo.mApplicationModule;
            if (applicationModule != null) {
                bl = (this.getState(applicationModule) & 0x20) > 0;
            }
        }
        return bl;
    }

    protected void notifyApplicationModuleReleased(ApplicationModule applicationModule, boolean bl) {
        applicationModule.getSession().getEnvironment().remove("jbo.sessioncookie");
    }

    protected void prepareSharedResource(Object object, Properties properties) {
        super.prepareSharedResource(object, properties);
        SessionCookie sessionCookie = null;
        ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext = null;
        if (properties != null) {
            sessionCookie = (SessionCookie)properties.get(SESSION_COOKIE);
            applicationPoolSvcMsgContext = (ApplicationPoolSvcMsgContext)properties.get(SVC_MSG_CONTEXT);
        }
        if (sessionCookie != null) {
            this.reconnect((ApplicationModule)object, sessionCookie, false, applicationPoolSvcMsgContext);
            this.prepareSession((ApplicationModule)object, sessionCookie, applicationPoolSvcMsgContext);
        }
    }

    protected void resourceStateChanged(Object object, byte by, byte by2) {
        super.resourceStateChanged(object, by, by2);
        ApplicationModuleInfo applicationModuleInfo = (ApplicationModuleInfo)this.mInstanceInfo.get(object);
        boolean bl = (by2 & 0x20) != (by & 0x20);
        boolean bl2 = (by & 0x20) > 0;
        by = (byte)(by & 0x1F);
        by2 = (byte)(by2 & 0x1F);
        if (by != by2) {
            switch (by) {
                case 2: {
                    if (by2 == 8) break;
                    if (applicationModuleInfo.isInList()) {
                        this.mUnrefAvailList.removeElement(applicationModuleInfo.mUnrefAvailListElement);
                        this.mRefAvailList.touchElement(applicationModuleInfo.mRefAvailListElement);
                        break;
                    }
                    this.mRefAvailList.removeElement(applicationModuleInfo.mRefAvailListElement);
                    this.mUnrefAvailList.touchElement(applicationModuleInfo.mUnrefAvailListElement);
                    break;
                }
                case 4: 
                case 8: {
                    this.mRefAvailList.removeElement(applicationModuleInfo.mRefAvailListElement);
                    this.mUnrefAvailList.removeElement(applicationModuleInfo.mUnrefAvailListElement);
                    break;
                }
            }
        }
        if (bl) {
            this.notifyApplicationModuleReleased((ApplicationModule)object, bl2);
        } else if (Diagnostic.isOn()) {
            Diagnostic.println("ApplicationPoolImpl.resourceStateChanged wasn't release related. No notify invoked.");
        }
    }

    public void setAvailable(ApplicationModule applicationModule) {
        super.setAvailable(applicationModule);
    }

    public boolean isAvailable(ApplicationModule applicationModule) {
        return super.isAvailable(applicationModule);
    }

    public long getCreationTimeMillis(ApplicationModule applicationModule) {
        return super.getCreationTimeMillis(applicationModule);
    }

    public long getTimeToCreateMillis(ApplicationModule applicationModule) {
        return super.getTimeToCreateMillis(applicationModule);
    }

    protected int getMinAvailableSize() {
        return this.getProperty(PropertyMetadata.ENV_AMPOOL_MIN_AVAIL_SIZE.pName, this.getEnvironment(), Integer.parseInt(PropertyMetadata.ENV_AMPOOL_MIN_AVAIL_SIZE.pDefault));
    }

    protected int getMaxAvailableSize() {
        return this.getProperty(PropertyMetadata.ENV_AMPOOL_MAX_AVAIL_SIZE.pName, this.getEnvironment(), Integer.parseInt(PropertyMetadata.ENV_AMPOOL_MAX_AVAIL_SIZE.pDefault));
    }

    protected int getMaxInactiveAge() {
        return this.getProperty(PropertyMetadata.ENV_AMPOOL_MAX_INACTIVE_AGE.pName, this.getEnvironment(), Integer.parseInt(PropertyMetadata.ENV_AMPOOL_MAX_INACTIVE_AGE.pDefault));
    }

    protected int getTimeToLive() {
        return this.getProperty(PropertyMetadata.ENV_AMPOOL_TIME_TO_LIVE.pName, this.getEnvironment(), Integer.parseInt(PropertyMetadata.ENV_AMPOOL_TIME_TO_LIVE.pDefault));
    }

    protected int getRecycleThreshold() {
        return this.getProperty(PropertyMetadata.ENV_POOL_RECYCLE_THRESHOLD.pName, this.getEnvironment(), Integer.parseInt(PropertyMetadata.ENV_POOL_RECYCLE_THRESHOLD.pDefault));
    }

    protected ResourcePoolLogger createPoolLogger() {
        return new ApplicationPoolLogger(this);
    }

    public Statistics getStatistics() {
        return ((ApplicationPoolLogger)this.mLogger).getStatistics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AMStatistics[] getAMStatistics() {
        HashMap hashMap;
        Integer n = this.mLock;
        synchronized (n) {
            hashMap = (HashMap)this.mInstanceInfo.clone();
        }
        if (hashMap.isEmpty()) {
            return new AMStatistics[0];
        }
        int n2 = hashMap.values().size();
        AMStatistics[] aMStatisticsArray = new AMStatistics[n2];
        Iterator iterator = hashMap.values().iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            ApplicationModuleInfo applicationModuleInfo = (ApplicationModuleInfo)iterator.next();
            if (applicationModuleInfo == null) continue;
            aMStatisticsArray[n3++] = applicationModuleInfo.mStatistics;
        }
        return aMStatisticsArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AMStatistics getAMStatistics(int n) {
        HashMap hashMap;
        Integer n2 = this.mLock;
        synchronized (n2) {
            hashMap = (HashMap)this.mInstanceInfo.clone();
        }
        int n3 = hashMap.values().size();
        Iterator iterator = hashMap.values().iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            ApplicationModuleInfo applicationModuleInfo = (ApplicationModuleInfo)iterator.next();
            if (applicationModuleInfo == null) {
                return null;
            }
            if (applicationModuleInfo.mId != n) continue;
            return applicationModuleInfo.mStatistics;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void computeSessionAgeHistogram(AgeHistogram var1_1) {
        var2_2 = null;
        var6_3 = this.mLock;
        synchronized (var6_3) {
            var2_2 = ((HashMap)this.mSessionCookieInfo.clone()).values().iterator();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var6_3
            if (true) ** GOTO lbl24
        }
        do {
            var3_4 = (SessionCookieInfo)var2_2.next();
            var4_5 = false;
            var5_6 = var1_1.mAges.length - 1;
            while (var5_6 >= 0) {
                if (var3_4.getLastUpdate().before(var1_1.mAges[var5_6])) {
                    v1 = var5_6 + 1;
                    var1_1.mBuckets[v1] = var1_1.mBuckets[v1] + 1;
                    var4_5 = true;
                    break;
                }
                --var5_6;
            }
            if (var4_5) continue;
            var1_1.mBuckets[0] = var1_1.mBuckets[0] + 1;
lbl24:
            // 3 sources

        } while (var2_2.hasNext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void computeAppModuleAgeHistograms(AgeHistogram var1_1, AgeHistogram var2_2) {
        var3_3 = null;
        var9_4 = this.mLock;
        synchronized (var9_4) {
            var3_3 = ((HashMap)this.mInstanceInfo.clone()).values().iterator();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var9_4
            if (true) ** GOTO lbl37
        }
        do {
            if ((var4_5 = (ApplicationModuleInfo)var3_3.next()).isInList()) {
                var5_6 = false;
                var6_7 = var1_1.mAges.length - 1;
                while (var6_7 >= 0) {
                    if (var4_5.getLastUpdate().before(var1_1.mAges[var6_7])) {
                        v1 = var6_7 + 1;
                        var1_1.mBuckets[v1] = var1_1.mBuckets[v1] + 1;
                        var5_6 = true;
                        break;
                    }
                    --var6_7;
                }
                if (var5_6) continue;
                var1_1.mBuckets[0] = var1_1.mBuckets[0] + 1;
                continue;
            }
            var7_8 = false;
            var8_9 = var2_2.mAges.length - 1;
            while (var8_9 >= 0) {
                if (var4_5.getLastUpdate().before(var2_2.mAges[var8_9])) {
                    v2 = var8_9 + 1;
                    var2_2.mBuckets[v2] = var2_2.mBuckets[v2] + 1;
                    var7_8 = true;
                    break;
                }
                --var8_9;
            }
            if (var7_8) continue;
            var2_2.mBuckets[0] = var2_2.mBuckets[0] + 1;
lbl37:
            // 5 sources

        } while (var3_3.hasNext());
    }

    protected long getMaxWaitTime() {
        return 10000L;
    }

    protected boolean compareConnectionMetadata(ConnectionMetadata connectionMetadata, ConnectionMetadata connectionMetadata2) {
        boolean bl = false;
        if (connectionMetadata != null) {
            bl = !this.isDynamicJDBCCredentials() ? true : connectionMetadata.equals(connectionMetadata2);
        }
        return bl;
    }

    public Object useResource(Properties properties) {
        return null;
    }

    public void releaseResource(Object object, Properties properties) {
    }

    protected boolean isDoFailover() {
        return true;
    }

    public boolean isDynamicJDBCCredentials() {
        return this.getProperty(PropertyMetadata.ENV_AMPOOL_DYNAMIC_JDBC_CREDENTIALS.pName, this.mEnvironment, Boolean.valueOf(PropertyMetadata.ENV_AMPOOL_DYNAMIC_JDBC_CREDENTIALS.pDefault));
    }

    public boolean isAMPoolingEnabled() {
        return this.getProperty(PropertyMetadata.ENV_AMPOOL_DO_AM_POOLING.pName, this.mEnvironment, Boolean.valueOf(PropertyMetadata.ENV_AMPOOL_DO_AM_POOLING.pDefault));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUseExclusive() {
        if (this.mUseExclusive == -1) {
            Integer n = this.mLock;
            synchronized (n) {
                this.mUseExclusive = this.getProperty(PropertyMetadata.ENV_AMPOOL_IS_USE_EXCLUSIVE.pName, this.mEnvironment, Boolean.valueOf(PropertyMetadata.ENV_AMPOOL_IS_USE_EXCLUSIVE.pDefault)) ? 0 : 1;
            }
        }
        return this.mUseExclusive == 0;
    }

    protected boolean isDoConnectionPooling() {
        return false;
    }

    protected void connect(ApplicationModule applicationModule, Hashtable hashtable) {
    }

    private void initializeCookieJDBCProps(SessionCookie sessionCookie) {
        try {
            if (this.getUserName() != null && sessionCookie.getEnvironment("jbo.jdbc.username") == null) {
                sessionCookie.setEnvironment("jbo.jdbc.username", this.getUserName());
            }
            if (this.getPassword() != null && sessionCookie.getEnvironment("jbo.jdbc.password") == null) {
                sessionCookie.setEnvironment("jbo.jdbc.password", this.getPassword());
            }
            if (this.getConnectString() != null && sessionCookie.getEnvironment("jbo.jdbc.connectstring") == null) {
                sessionCookie.setEnvironment("jbo.jdbc.connectstring", this.getConnectString());
            }
        }
        catch (ApplicationPoolException applicationPoolException) {
            // empty catch block
        }
    }

    private void connect(ApplicationModule applicationModule, SessionCookie sessionCookie, ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext) {
        this.initializeCookieJDBCProps(sessionCookie);
        this.initMessageJDBCContext(sessionCookie, sessionCookie.getEnvInfoProvider(), applicationPoolSvcMsgContext);
        applicationPoolSvcMsgContext.connect();
    }

    protected void reconnect(ApplicationModule applicationModule, Hashtable hashtable) {
    }

    private void reconnect(ApplicationModule applicationModule, SessionCookie sessionCookie, boolean bl, ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext) {
        this.initializeCookieJDBCProps(sessionCookie);
        this.initMessageJDBCContext(sessionCookie, sessionCookie.getEnvInfoProvider(), applicationPoolSvcMsgContext);
        applicationPoolSvcMsgContext.setRetainState(bl);
        applicationPoolSvcMsgContext.reconnect();
        this.reconnect(applicationModule, sessionCookie.getEnvironment());
    }

    protected void disconnect(ApplicationModule applicationModule, boolean bl, Hashtable hashtable) {
    }

    private void disconnect(ApplicationModule applicationModule, boolean bl, SessionCookie sessionCookie, ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext) {
        this.initializeCookieJDBCProps(sessionCookie);
        this.initMessageJDBCContext(sessionCookie, sessionCookie.getEnvInfoProvider(), applicationPoolSvcMsgContext);
        applicationPoolSvcMsgContext.disconnect(bl);
        this.disconnect(applicationModule, bl, sessionCookie.getEnvironment());
    }

    protected String getConnectionStrategyClassName() {
        return this.getProperty(PropertyMetadata.ENV_AMPOOL_CONNECTION_STRATEGY_CLASS_NAME.pName, this.getEnvironment(), PropertyMetadata.ENV_AMPOOL_CONNECTION_STRATEGY_CLASS_NAME.pDefault);
    }

    protected String getSessionCookieFactoryClassName() {
        String string = this.getProperty(PropertyMetadata.ENV_AMPOOL_COOKIE_FACTORY_CLASS_NAME.pName, this.getEnvironment(), PropertyMetadata.ENV_AMPOOL_COOKIE_FACTORY_CLASS_NAME.pDefault);
        if (PropertyMetadata.ENV_AMPOOL_COOKIE_FACTORY_CLASS_NAME.pDefault.equals(string)) {
            int n = ADFContext.getCurrent().getContextType();
            if (n == 2) {
                string = "oracle.jbo.http.HttpSessionCookieFactory";
            } else if (n == 3) {
                string = "oracle.jbo.portlet.PortletSessionCookieFactory";
            }
        }
        return string;
    }

    private String getProperty(String string, Hashtable hashtable, String string2) {
        String string3 = (String)hashtable.get(string);
        if (string3 == null) {
            string3 = JboEnvUtil.getProperty(string, string2);
        }
        return string3;
    }

    private boolean getProperty(String string, Hashtable hashtable, boolean bl) {
        boolean bl2 = true;
        String string2 = (String)hashtable.get(string);
        bl2 = string2 != null ? Boolean.valueOf(string2) : JboEnvUtil.getPropertyAsBoolean(string, bl);
        return bl2;
    }

    private int getProperty(String string, Hashtable hashtable, int n) {
        return PoolMgr.getProperty(string, hashtable, n);
    }

    private void removeState(int n, ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext) {
        if (n != -1) {
            applicationPoolSvcMsgContext.removeState(n);
        }
    }

    private void activateState(int n, SessionCookie sessionCookie, ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext) {
        if (n != -1) {
            EnvInfoProvider envInfoProvider = sessionCookie.getEnvInfoProvider();
            Hashtable hashtable = sessionCookie.getEnvironment();
            if (envInfoProvider != null) {
                envInfoProvider.getInfo("_info_type_session_environment_", hashtable);
            }
            applicationPoolSvcMsgContext.activateState(n, new SessionData(hashtable, sessionCookie.getUserData()), 0);
        }
    }

    private void prepareSession(ApplicationModule applicationModule, SessionCookie sessionCookie, ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext) {
        EnvInfoProvider envInfoProvider = sessionCookie.getEnvInfoProvider();
        if (envInfoProvider != null) {
            envInfoProvider.getInfo("_info_type_session_environment_", sessionCookie.getEnvironment());
        }
        applicationPoolSvcMsgContext.prepareSession(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateSessionCookieAvailable(SessionCookieInfo sessionCookieInfo) {
        Integer n = this.mLock;
        synchronized (n) {
            if (sessionCookieInfo != null && !sessionCookieInfo.mIsAvailable) {
                Class clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolImpl.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
                }
                throw new ApplicationPoolException(clazz, "30019", new Object[]{sessionCookieInfo.mCookie.getSessionId(), sessionCookieInfo.mCookie.getApplicationId()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSessionCookieAvailable(SessionCookie sessionCookie, boolean bl) {
        Integer n = this.mLock;
        synchronized (n) {
            SessionCookieInfo sessionCookieInfo;
            if (sessionCookie != null && (sessionCookieInfo = (SessionCookieInfo)sessionCookie.getInfoObject()) != null) {
                sessionCookieInfo.mIsAvailable = bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPoolMessage(ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext, SessionCookie sessionCookie, ApplicationModule applicationModule) {
        ApplicationModuleInfo applicationModuleInfo = null;
        Integer n = this.mLock;
        synchronized (n) {
            applicationModuleInfo = (ApplicationModuleInfo)this.mInstanceInfo.get((Object)applicationModule);
        }
        this.sendPoolMessage(applicationPoolSvcMsgContext, sessionCookie, sessionCookie != null ? (SessionCookieInfo)sessionCookie.getInfoObject() : null, applicationModule, applicationModuleInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendPoolMessage(ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext, SessionCookie sessionCookie, SessionCookieInfo sessionCookieInfo, ApplicationModule applicationModule, ApplicationModuleInfo applicationModuleInfo) {
        ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext2 = null;
        applicationPoolSvcMsgContext.getStatistics();
        if (sessionCookie != null) {
            applicationPoolSvcMsgContext.setIgnorePiggyback(sessionCookie.getIgnorePiggyback());
            applicationPoolSvcMsgContext.setBoundToWorkingSet(sessionCookie.getEnvironment("__jbo_bound_to_working_set__") != null);
            applicationPoolSvcMsgContext.setSessionCookie(sessionCookie);
        }
        try {
            applicationPoolSvcMsgContext2 = applicationModule.doPoolMessage(applicationPoolSvcMsgContext);
        }
        catch (RuntimeException runtimeException) {
            Integer n = this.mLock;
            synchronized (n) {
                if (!applicationPoolSvcMsgContext.isApplicationModuleRemoved()) {
                    if (sessionCookie != null) {
                        this.disassociateSessionCookie(applicationModule, applicationModuleInfo, sessionCookie, sessionCookieInfo, false);
                    }
                    applicationModuleInfo.mIsInstanceAlive = false;
                }
            }
            if (applicationPoolSvcMsgContext.isApplicationModuleRemoved()) throw runtimeException;
            this.removeDeadInstance(applicationModule);
            throw runtimeException;
        }
        if (applicationPoolSvcMsgContext2.getStatus() == 2 || applicationPoolSvcMsgContext2.getStatus() == 16) {
            EnvInfoProvider envInfoProvider = sessionCookie.getEnvInfoProvider();
            int n = -1;
            if (envInfoProvider != null) {
                n = envInfoProvider.getNumOfRetries();
            }
            if (applicationPoolSvcMsgContext2.getJDBCConnectCount() < n) {
                applicationPoolSvcMsgContext2.incrementJDBCConnectCount();
                if (applicationPoolSvcMsgContext2.getStatus() == 2) {
                    this.initMessageJDBCContext(sessionCookie, sessionCookie.getEnvInfoProvider(), applicationPoolSvcMsgContext2);
                    applicationPoolSvcMsgContext2.setJDBCConnectException(null);
                } else {
                    Hashtable hashtable = sessionCookie.getEnvironment();
                    try {
                        hashtable.put("jbo.lastexception", applicationPoolSvcMsgContext.getAuthException());
                        envInfoProvider.getInfo("_info_type_session_environment_", hashtable);
                        Object var23_12 = null;
                        hashtable.remove("jbo.lastexception");
                    }
                    catch (Throwable throwable) {
                        Object var23_13 = null;
                        hashtable.remove("jbo.lastexception");
                        throw throwable;
                    }
                    applicationPoolSvcMsgContext2.setAuthException(null);
                }
                applicationPoolSvcMsgContext2.setStatus(1);
                this.sendPoolMessage(applicationPoolSvcMsgContext2, sessionCookie, sessionCookieInfo, applicationModule, applicationModuleInfo);
                return;
            }
            Throwable throwable = null;
            if (applicationPoolSvcMsgContext2.getStatus() == 2) {
                throwable = applicationPoolSvcMsgContext2.getJDBCConnectException();
                applicationPoolSvcMsgContext.setJDBCConnectException(throwable);
            } else {
                throwable = applicationPoolSvcMsgContext2.getAuthException();
                applicationPoolSvcMsgContext.setAuthException((JboException)throwable);
            }
            Integer n2 = this.mLock;
            synchronized (n2) {
                if (!applicationPoolSvcMsgContext.isApplicationModuleRemoved() && sessionCookie != null) {
                    this.disassociateSessionCookie(applicationModule, applicationModuleInfo, sessionCookie, sessionCookieInfo, false);
                }
                if (!applicationPoolSvcMsgContext.isApplicationModuleRemoved()) {
                    this.removeDeadInstance(applicationModule);
                }
            }
            if (!(throwable instanceof RuntimeException)) throw new JboException(throwable);
            throw (RuntimeException)throwable;
        }
        if (applicationModuleInfo != null) {
            applicationModuleInfo.mConnectionMetadata = applicationPoolSvcMsgContext2.getRtnConnectionMetadata();
        }
        if (sessionCookie == null) {
            java.util.ArrayList arrayList = applicationPoolSvcMsgContext2.getRtnEventList();
            if (arrayList == null) {
                return;
            }
            int n = arrayList.size();
            int n3 = 0;
            while (n3 < n) {
                int n4 = (Integer)arrayList.get(n3);
                switch (n4) {
                    case 8: {
                        if (applicationModuleInfo == null) break;
                        applicationModuleInfo.mStatistics = applicationPoolSvcMsgContext2.getRtnAMStatistics();
                    }
                }
                ++n3;
            }
            return;
        }
        sessionCookieInfo.mConnectionMetadata = applicationPoolSvcMsgContext2.getRtnConnectionMetadata();
        sessionCookie.setMostRecentStackId(applicationPoolSvcMsgContext2.getRtnMostRecentStackId());
        sessionCookie.setActivated(false);
        java.util.ArrayList arrayList = applicationPoolSvcMsgContext2.getRtnEventList();
        if (arrayList == null) {
            return;
        }
        int n = arrayList.size();
        int n5 = 0;
        while (n5 < n) {
            int n6 = (Integer)arrayList.get(n5);
            switch (n6) {
                case 3: {
                    sessionCookie.setActivationRequired(true);
                }
                case 2: {
                    int n7 = sessionCookie.getPassivationId();
                    sessionCookie.setPassivationId(applicationPoolSvcMsgContext2.getRtnPassivationId());
                    if (n7 == sessionCookie.getPassivationId()) {
                        ((SessionCookieImpl)sessionCookie).mPrevPassivationId = n7;
                        sessionCookie.setPassivationId(-1);
                    }
                    this.logPoolEvent((byte)5);
                    break;
                }
                case 1: {
                    if (!applicationPoolSvcMsgContext2.isApplicationModuleConnected()) break;
                    this.connect(applicationModule, sessionCookie.getEnvironment());
                    break;
                }
                case 6: {
                    sessionCookie.setActivationRequired(false);
                    sessionCookie.setActivated(true);
                    this.logPoolEvent((byte)4);
                    break;
                }
                case 7: {
                    sessionCookie.setReservedPassivationId(applicationPoolSvcMsgContext2.getRtnReservedPassivationId());
                }
                case 8: {
                    if (applicationModuleInfo == null) break;
                    applicationModuleInfo.mStatistics = applicationPoolSvcMsgContext2.getRtnAMStatistics();
                }
            }
            ++n5;
        }
    }

    private void initMessageJDBCContext(SessionCookie sessionCookie, EnvInfoProvider envInfoProvider, ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext) {
        Hashtable hashtable;
        String string;
        if (!this.connectionRequired(sessionCookie)) {
            applicationPoolSvcMsgContext.setJDBCConnectionType((byte)2);
            return;
        }
        Properties properties = new Properties();
        if (applicationPoolSvcMsgContext.getStatus() == 2) {
            properties.put("jbo.lastexception", applicationPoolSvcMsgContext.getJDBCConnectException());
        }
        if ((string = (String)(hashtable = sessionCookie.getEnvironment()).get("DsName")) == null) {
            string = (String)hashtable.get("JDBCDataSource");
        }
        if (string != null && string.length() > 0) {
            String string2 = (String)hashtable.get("DsUserName");
            String string3 = (String)hashtable.get("DsPasswd");
            properties.put("JDBCDataSource", string);
            if (string2 != null) {
                properties.put("DsUserName", string2);
            }
            if (string3 != null) {
                properties.put("DsPasswd", string3);
            }
            if (envInfoProvider != null) {
                envInfoProvider.getInfo("_info_type_jdbc_properties_", properties);
            }
            applicationPoolSvcMsgContext.setJDBCConnectionType((byte)0);
            applicationPoolSvcMsgContext.setJDBCDataSourceName((String)properties.remove("JDBCDataSource"));
            applicationPoolSvcMsgContext.setJDBCDataSourceUser((String)properties.remove("DsUserName"));
            applicationPoolSvcMsgContext.setJDBCDataSourcePassword((String)properties.remove("DsPasswd"));
        } else {
            String string4;
            String string5;
            String string6 = (String)sessionCookie.getEnvironment("jbo.jdbc.username");
            String string7 = (String)sessionCookie.getEnvironment("jbo.jdbc.password");
            if (string6 != null) {
                properties.put("user", string6);
            }
            if (string7 != null) {
                properties.put("password", string7);
            }
            String string8 = (String)sessionCookie.getEnvironment("java.naming.security.principal");
            String string9 = (String)sessionCookie.getEnvironment("java.naming.security.credentials");
            if (string8 != null) {
                properties.put("java.naming.security.principal", string8);
            }
            if (string9 != null) {
                properties.put("java.naming.security.credentials", string9);
            }
            if ((string5 = (String)sessionCookie.getEnvironment(PropertyMetadata.ENV_SECURITY_ENFORCE.pName)) != null) {
                properties.put(PropertyMetadata.ENV_SECURITY_ENFORCE.pName, string5);
            }
            if (envInfoProvider != null) {
                this.queryConnectionInfo(envInfoProvider, properties);
            }
            if ((string4 = (String)properties.remove("jbo.jdbc.connectstring")) == null || string4.length() <= 0) {
                string4 = (String)sessionCookie.getEnvironment("jbo.jdbc.connectstring");
            }
            applicationPoolSvcMsgContext.setJDBCConnectionType((byte)1);
            applicationPoolSvcMsgContext.setJDBCConnectString(string4);
            properties.remove("jbo.lastexception");
            applicationPoolSvcMsgContext.setJDBCProperties(properties);
        }
    }

    private void queryConnectionInfo(EnvInfoProvider envInfoProvider, Properties properties) {
        String string;
        String string2;
        envInfoProvider.getInfo("_info_type_jdbc_properties_", properties);
        do {
            string2 = (String)properties.get("user");
            string = (String)properties.get("password");
        } while (!(string2 == null || string2.length() == 0 ? envInfoProvider.getInfo("user", properties) == null : string != null || envInfoProvider.getInfo("password", properties) == null));
    }

    private boolean connectionRequired(SessionCookie sessionCookie) {
        String string = (String)sessionCookie.getEnvironment("DsName");
        if (string == null) {
            string = (String)sessionCookie.getEnvironment("JDBCDataSource");
        }
        if (string == null || string.length() > 0) {
            String string2 = (String)sessionCookie.getEnvironment("jbo.jdbc.connectstring");
            return string2 != null && string2.length() > 0;
        }
        return true;
    }

    public String getEnvConfigurationName() {
        return (String)this.mEnvironment.get("jbo.configname");
    }

    public String getEnvAppModuleClassName() {
        return (String)this.mEnvironment.get("jbo.applicationmoduleclassname");
    }

    public long getTimeCreated() {
        return this.mTimeCreated;
    }

    protected boolean removeFromManager() {
        return super.removeFromManager() && this.mSessionCookieInfo.size() == 0;
    }

    protected Object getResourcePoolKey() {
        return this.getName();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class SessionCookieInfo {
        private SessionCookie mCookie;
        private SessionCookieInfo mCookieInfo;
        long mLastUpdate;
        private ApplicationModule mApplicationModule;
        private ConnectionMetadata mConnectionMetadata;
        boolean mIsReferencingState;
        private boolean mIsAvailable;

        private /* synthetic */ void $init$() {
            this.mApplicationModule = null;
            this.mConnectionMetadata = null;
            this.mIsReferencingState = false;
            this.mIsAvailable = true;
        }

        SessionCookieInfo() {
            this.$init$();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SessionCookieInfo(SessionCookie sessionCookie) {
            this.$init$();
            Integer n = ApplicationPoolImpl.this.mLock;
            synchronized (n) {
                this.mCookie = sessionCookie;
                this.mLastUpdate = System.currentTimeMillis();
                if (sessionCookie.getPassivationId() != -1) {
                    this.mIsReferencingState = true;
                    ApplicationPoolImpl applicationPoolImpl2 = ApplicationPoolImpl.this;
                    applicationPoolImpl2.mReferencingSessionCount = applicationPoolImpl2.mReferencingSessionCount + 1;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void resetState() {
            Integer n = ApplicationPoolImpl.this.mLock;
            synchronized (n) {
                if (this.mIsReferencingState) {
                    this.mIsReferencingState = false;
                    ApplicationPoolImpl applicationPoolImpl = ApplicationPoolImpl.this;
                    applicationPoolImpl.mReferencingSessionCount = applicationPoolImpl.mReferencingSessionCount - 1;
                }
            }
        }

        public final Date getLastUpdate() {
            return new Date(this.mLastUpdate);
        }

        void touch() {
            this.mLastUpdate = System.currentTimeMillis();
        }
    }

    public class ApplicationModuleInfo
    extends RecentlyUsedLinkedListElement {
        HashMap mReferencingSessionCookies;
        SessionCookie mReferencingSessionCookie;
        ConnectionMetadata mConnectionMetadata;
        long mSignature;
        AMStatistics mStatistics;
        int mId;
        boolean mIsInstanceAlive;
        boolean mPendingContext;
        boolean mCanFinalizeResource;
        final RecentlyUsedLinkedListElement mRefAvailListElement;
        final RecentlyUsedLinkedListElement mUnrefAvailListElement;

        ApplicationModuleInfo(ApplicationModule applicationModule) {
            super(applicationModule);
            this.$init$();
            int n = mAppModuleIdCounter + 1;
            mAppModuleIdCounter = n;
            this.mId = n;
            this.mRefAvailListElement = new RecentlyUsedLinkedListElement(applicationModule);
            this.mUnrefAvailListElement = new RecentlyUsedLinkedListElement(applicationModule);
            this.mStatistics = new AMStatistics();
            this.mStatistics.mID = this.mId;
        }

        private /* synthetic */ void $init$() {
            this.mReferencingSessionCookies = new HashMap();
            this.mReferencingSessionCookie = null;
            this.mConnectionMetadata = null;
            this.mSignature = -1;
            this.mStatistics = null;
            this.mIsInstanceAlive = true;
            this.mPendingContext = false;
            this.mCanFinalizeResource = true;
        }
    }
}

