/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import com.sun.java.util.collections.ArrayList;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JboEnvUtil;

public class WeakVectorImpl {
    private ArrayList mList;
    private int mLock;

    private /* synthetic */ void $init$() {
        this.mLock = 0;
    }

    public WeakVectorImpl(int n, int n2) {
        this.$init$();
        this.mList = new ArrayList(n);
    }

    public WeakVectorImpl(int n) {
        this.$init$();
        this.mList = new ArrayList(n);
    }

    public WeakVectorImpl() {
        this.$init$();
        this.mList = new ArrayList();
    }

    public final void lock() {
        ++this.mLock;
    }

    public final void unlock() {
        if (this.mLock == 0) {
            Diagnostic.ASSERT(false, "Lock count for WeakVectorImpl is about to go negative");
        }
        --this.mLock;
        if (this.mLock == 0) {
            this.trimToSize();
        }
    }

    public final void copyInto(Object[] objectArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length && n < this.mList.size()) {
            Object var5_5;
            block3: {
                block4: {
                    WeakReference weakReference = (WeakReference)this.mList.get(n);
                    var5_5 = null;
                    if (this.mLock != 0) break block3;
                    if (weakReference == null) break block4;
                    Object t = weakReference.get();
                    var5_5 = t;
                    if (t != null) break block3;
                }
                this.mList.remove(n);
                continue;
            }
            objectArray[n2] = var5_5;
            ++n2;
            ++n;
        }
    }

    public final void trimToSize() {
        if (this.mLock == 0) {
            int n = 0;
            while (n < this.mList.size()) {
                WeakReference weakReference = (WeakReference)this.mList.get(n);
                if (weakReference == null || weakReference.get() == null) {
                    this.mList.remove(n);
                    continue;
                }
                ++n;
            }
        }
        this.mList.trimToSize();
    }

    public final void ensureCapacity(int n) {
        this.mList.ensureCapacity(n);
    }

    public final void setSize(int n) {
        JboEnvUtil.setSizeInArrayList(this.mList, n);
    }

    public final int capacity() {
        return this.mList.size();
    }

    public final int size() {
        return this.mList.size();
    }

    public final boolean isEmpty() {
        return this.mList.isEmpty();
    }

    public final Enumeration elements() {
        return new WeakVectorImplEnumerator(this.mList);
    }

    public final boolean contains(Object object) {
        int n = 0;
        while (n < this.mList.size()) {
            WeakReference weakReference = (WeakReference)this.mList.get(n);
            Object object2 = null;
            if (weakReference != null) {
                Object t = weakReference.get();
                object2 = t;
                if (t != null && object2.equals(object)) {
                    return true;
                }
            }
            if (this.mLock == 0 && (weakReference == null || object2 == null)) {
                this.mList.remove(n);
                continue;
            }
            ++n;
        }
        return false;
    }

    public final void addElement(Object object) {
        block3: {
            if (this.mLock != 0) break block3;
            int n = 0;
            while (n < this.mList.size()) {
                block5: {
                    block4: {
                        WeakReference weakReference = (WeakReference)this.mList.get(n);
                        Object var4_4 = null;
                        if (weakReference == null) break block4;
                        Object t = weakReference.get();
                        var4_4 = t;
                        if (t != null) break block5;
                    }
                    this.mList.remove(n);
                    continue;
                }
                ++n;
            }
        }
        this.mList.add(new WeakReference<Object>(object));
    }

    public final void removeElementAt(int n) {
        if (this.mLock == 0) {
            this.mList.remove(n);
        } else {
            this.mList.set(n, null);
        }
    }

    public final boolean removeElement(Object object) {
        int n = 0;
        while (n < this.mList.size()) {
            WeakReference weakReference = (WeakReference)this.mList.get(n);
            Object object2 = null;
            if (this.mLock == 0 && (weakReference == null || (object2 = weakReference.get()) == null)) {
                this.mList.remove(n);
                continue;
            }
            if (object2 != null && object2.equals(object)) {
                if (this.mLock == 0) {
                    this.mList.remove(n);
                } else {
                    this.mList.set(n, null);
                }
                return true;
            }
            ++n;
        }
        return false;
    }

    public final void removeAllElements() {
        this.mList.clear();
    }

    public final String toString() {
        return this.mList.toString();
    }

    public final Object elementAt(int n) {
        WeakReference weakReference = (WeakReference)this.mList.get(n);
        if (weakReference == null) {
            return null;
        }
        return weakReference.get();
    }

    public final int indexOf(Object object, int n) {
        int n2 = n;
        while (n2 < this.mList.size()) {
            WeakReference weakReference = (WeakReference)this.mList.get(n2);
            Object object2 = null;
            if (this.mLock == 0 && (weakReference == null || (object2 = weakReference.get()) == null)) {
                this.mList.remove(n2);
                continue;
            }
            if (object2 != null && object2.equals(object)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public final int lastIndexOf(Object object, int n) {
        int n2 = n;
        while (n2 >= 0) {
            WeakReference weakReference = (WeakReference)this.mList.get(n2);
            Object object2 = null;
            if (this.mLock == 0 && (weakReference == null || (object2 = weakReference.get()) == null)) {
                this.mList.remove(n2);
                continue;
            }
            if (object2 != null && object2.equals(object)) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public final Object firstElement() {
        int n = 0;
        while (n < this.mList.size()) {
            Object var3_3;
            block7: {
                block6: {
                    WeakReference weakReference = (WeakReference)this.mList.get(0);
                    var3_3 = null;
                    if (weakReference == null) break block6;
                    Object t = weakReference.get();
                    var3_3 = t;
                    if (t != null) break block7;
                }
                if (this.mLock == 0) {
                    this.mList.remove(0);
                    continue;
                }
                ++n;
                continue;
            }
            if (var3_3 != null) {
                return var3_3;
            }
            ++n;
        }
        throw new NoSuchElementException();
    }

    public final Object lastElement() {
        int n = this.mList.size() - 1;
        while (n >= 0) {
            Object var3_3;
            block7: {
                block6: {
                    WeakReference weakReference = (WeakReference)this.mList.get(n);
                    var3_3 = null;
                    if (weakReference == null) break block6;
                    Object t = weakReference.get();
                    var3_3 = t;
                    if (t != null) break block7;
                }
                if (this.mLock == 0) {
                    this.mList.remove(n);
                    continue;
                }
                --n;
                continue;
            }
            if (var3_3 != null) {
                return var3_3;
            }
            --n;
        }
        throw new NoSuchElementException();
    }

    public void setElementAt(Object object, int n) {
        this.mList.set(n, new WeakReference<Object>(object));
    }

    public void insertElementAt(Object object, int n) {
        this.mList.add(n, new WeakReference<Object>(object));
    }

    public class WeakVectorImplEnumerator
    implements Enumeration {
        ArrayList mList;
        int mIndex;

        private /* synthetic */ void $init$() {
            this.mIndex = 0;
        }

        WeakVectorImplEnumerator(ArrayList arrayList) {
            this.$init$();
            this.mList = arrayList;
        }

        public synchronized boolean hasMoreElements() {
            boolean bl;
            boolean bl2 = bl = this.nextElement() != null;
            if (bl) {
                --this.mIndex;
            }
            return bl;
        }

        public synchronized Object nextElement() {
            while (this.mIndex < this.mList.size()) {
                Object t;
                WeakReference weakReference = (WeakReference)this.mList.get(this.mIndex);
                if (weakReference == null || (t = weakReference.get()) == null) {
                    if (WeakVectorImpl.this.mLock == 0) {
                        this.mList.remove(this.mIndex);
                        continue;
                    }
                    ++this.mIndex;
                    continue;
                }
                ++this.mIndex;
                return t;
            }
            return null;
        }
    }
}

