/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import oracle.jbo.common.PiggybackInputStream;
import oracle.jbo.common.PiggybackObjectOutputStream;
import oracle.jbo.common.SvcMsgResponse;
import oracle.svcmsg.ResponseValues;

public class SvcMsgResponseValues
extends SvcMsgResponse
implements ResponseValues {
    static final long serialVersionUID = -8316762600913461073L;
    private int[] mIntValues;
    private long[] mLongValues;
    private boolean[] mBooleanValues;
    private Object[] mObjectValues;

    public SvcMsgResponseValues(int n, String string) {
        super(n, string);
    }

    public int[] getIntValues() {
        return this.mIntValues;
    }

    public ResponseValues setIntValues(int[] nArray) {
        this.mIntValues = nArray;
        return this;
    }

    public long[] getLongValues() {
        return this.mLongValues;
    }

    public ResponseValues setLongValues(long[] lArray) {
        this.mLongValues = lArray;
        return this;
    }

    public boolean[] getBooleanValues() {
        return this.mBooleanValues;
    }

    public ResponseValues setBooleanValues(boolean[] blArray) {
        this.mBooleanValues = blArray;
        return this;
    }

    public Object[] getObjectValues() {
        return this.mObjectValues;
    }

    public ResponseValues setObjectValues(Object[] objectArray) {
        this.mObjectValues = objectArray;
        return this;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.isReference()) {
            ObjectOutputStream objectOutputStream2 = null;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if (objectOutputStream instanceof PiggybackObjectOutputStream) {
                PiggybackObjectOutputStream piggybackObjectOutputStream = (PiggybackObjectOutputStream)objectOutputStream;
                objectOutputStream2 = new PiggybackObjectOutputStream(byteArrayOutputStream, piggybackObjectOutputStream.getLocale(), piggybackObjectOutputStream.getApplicationModule(), piggybackObjectOutputStream.getMarshaller());
            } else {
                objectOutputStream2 = new ObjectOutputStream(byteArrayOutputStream);
            }
            objectOutputStream2.writeObject(this.mIntValues);
            objectOutputStream2.writeObject(this.mLongValues);
            objectOutputStream2.writeObject(this.mBooleanValues);
            objectOutputStream2.writeObject(this.mObjectValues);
            objectOutputStream2.flush();
            byteArrayOutputStream.flush();
            objectOutputStream.writeObject(byteArrayOutputStream.toByteArray());
            objectOutputStream2.close();
        } else {
            objectOutputStream.defaultWriteObject();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (this.isReference()) {
            byte[] byArray = (byte[])objectInputStream.readObject();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream2 = null;
            objectInputStream2 = objectInputStream instanceof PiggybackInputStream ? new PiggybackInputStream(((PiggybackInputStream)objectInputStream).getMarshaller(), byteArrayInputStream) : new ObjectInputStream(byteArrayInputStream);
            this.mIntValues = (int[])objectInputStream2.readObject();
            this.mLongValues = (long[])objectInputStream2.readObject();
            this.mBooleanValues = (boolean[])objectInputStream2.readObject();
            this.mObjectValues = (Object[])objectInputStream2.readObject();
        } else {
            objectInputStream.defaultReadObject();
        }
    }
}

