/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import com.sun.java.util.collections.HashMap;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import oracle.jbo.JboException;
import oracle.jbo.XMLInterface;
import oracle.jbo.common.Diagnostic;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLProcessor;
import oracle.xml.parser.v2.XSLStylesheet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JboXMLUtil {
    public static Node writeAndProcessXML(XMLInterface xMLInterface, int n, long l, XSLStylesheet xSLStylesheet) {
        Node node = xMLInterface.writeXML(n, l);
        if (xSLStylesheet != null) {
            XMLDocument xMLDocument = new XMLDocument();
            try {
                xMLDocument.appendChild(node);
            }
            catch (Exception exception) {
                xMLDocument.appendChild(xMLDocument.adoptNode(node));
            }
            xMLDocument = JboXMLUtil.processXSL(xMLDocument, xSLStylesheet);
            if (xMLDocument == null) {
                Diagnostic.ASSERT(false, "XSL Transformation returned a null document.");
            }
            if ((node = xMLDocument.getDocumentElement()) == null) {
                Diagnostic.ASSERT(false, "XSL Transformation returned a null document element.");
            }
            node.getParentNode().removeChild(node);
        }
        return node;
    }

    public static Node writeAndProcessXML(XMLInterface xMLInterface, long l, HashMap hashMap, XSLStylesheet xSLStylesheet) {
        Node node = xMLInterface.writeXML(l, hashMap);
        if (xSLStylesheet != null) {
            XMLDocument xMLDocument = new XMLDocument();
            try {
                xMLDocument.appendChild(node);
            }
            catch (Exception exception) {
                xMLDocument.appendChild(xMLDocument.adoptNode(node));
            }
            xMLDocument = JboXMLUtil.processXSL(xMLDocument, xSLStylesheet);
            if (xMLDocument == null) {
                Diagnostic.ASSERT(false, "XSL Transformation returned a null document.");
            }
            if ((node = xMLDocument.getDocumentElement()) == null) {
                Diagnostic.ASSERT(false, "XSL Transformation returned a null document element.");
            }
            node.getParentNode().removeChild(node);
        }
        return node;
    }

    public static void processAndReadXML(XMLInterface xMLInterface, Element element, int n, XSLStylesheet xSLStylesheet) {
        if (xSLStylesheet != null) {
            XMLDocument xMLDocument = new XMLDocument();
            element.getParentNode().removeChild(element);
            try {
                xMLDocument.appendChild((Node)element);
            }
            catch (Exception exception) {
                xMLDocument.appendChild(xMLDocument.adoptNode((Node)element));
            }
            xMLDocument = JboXMLUtil.processXSL(xMLDocument, xSLStylesheet);
            element = xMLDocument.getDocumentElement();
        }
        xMLInterface.readXML(element, n);
    }

    public static XMLDocument processXSL(XMLDocument xMLDocument, XSLStylesheet xSLStylesheet) {
        try {
            XSLProcessor xSLProcessor = new XSLProcessor();
            XMLDocument xMLDocument2 = new XMLDocument();
            XMLDocumentFragment xMLDocumentFragment = xSLProcessor.processXSL(xSLStylesheet, xMLDocument);
            try {
                xMLDocument2.appendChild((Node)xMLDocumentFragment);
            }
            catch (Exception exception) {
                xMLDocument2.appendChild(xMLDocument2.adoptNode((Node)xMLDocumentFragment));
            }
            XMLDocument xMLDocument3 = xMLDocument2;
            return xMLDocument3;
        }
        catch (XSLException xSLException) {
            throw new JboException(xSLException);
        }
    }

    public static Node getFirstChildByType(Node node, short s) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            if (nodeList.item(n2).getNodeType() == s) {
                return nodeList.item(n2);
            }
            ++n2;
        }
        return null;
    }

    public static Node getNextSiblingByType(Node node, short s) {
        Node node2 = node.getNextSibling();
        while (node2 != null && node2.getNodeType() != s) {
            node2 = node2.getNextSibling();
        }
        return node2;
    }

    public static String serializeStrings(String[] stringArray) {
        String string = null;
        if (stringArray != null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(stringArray[n]);
                ++n;
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String streamXMLNodeToString(Node node) {
        Node node2 = node.cloneNode(true);
        XMLDocument xMLDocument = new XMLDocument();
        xMLDocument.appendChild(xMLDocument.adoptNode(node2));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            xMLDocument.print((OutputStream)byteArrayOutputStream);
            if (Diagnostic.isOn()) {
                Diagnostic.println(byteArrayOutputStream.toString("UTF-8"));
            }
            String string = byteArrayOutputStream.toString("UTF-8");
            return string;
        }
        catch (Exception exception) {
            throw new JboException(exception);
        }
    }

    public static Element convertStringToElement(String string) {
        if (string != null) {
            DOMParser dOMParser = JboXMLUtil.createDOMParser(false);
            try {
                dOMParser.retainCDATASection(true);
                dOMParser.parse((Reader)new StringReader(string));
            }
            catch (Exception exception) {
                throw new JboException(exception);
            }
            Element element = dOMParser.getDocument().getDocumentElement();
            return element;
        }
        return null;
    }

    public static DOMParser createDOMParser(boolean bl) {
        DOMParser dOMParser = null;
        try {
            dOMParser = new DOMParser();
            dOMParser.setPreserveWhitespace(bl);
        }
        catch (Exception exception) {
            throw new JboException(exception);
        }
        return dOMParser;
    }
}

