/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import oracle.jbo.JboException;
import oracle.jbo.LocaleContext;
import oracle.jbo.common.JboMessage;

public class JboExceptionHelper {
    boolean mAppendCodes;
    String mErrorCode;
    JboMessage mEx;
    String mMsg;
    Object[] mErrorParams;
    ArrayList mDetails;
    LocaleContext mLocale;

    private /* synthetic */ void $init$() {
        this.mAppendCodes = true;
        this.mErrorCode = "";
    }

    public JboExceptionHelper(JboMessage jboMessage, String string, String string2, Object[] objectArray) {
        this.$init$();
        this.mEx = jboMessage;
        this.mMsg = string;
        if (string2 != null) {
            this.mErrorCode = string2;
        }
        this.mErrorParams = objectArray;
    }

    public String getMessage() {
        return this.getLocalizedMessage(this.mLocale != null ? this.mLocale.getLocale() : null);
    }

    public String getLocalizedMessage(Locale locale) {
        String string = this.getErrorMsgFormat(locale);
        Object[] objectArray = this.getErrorParameters();
        if (objectArray != null) {
            int n = objectArray.length - 1;
            while (n >= 0) {
                Object object = objectArray[n];
                if (!(object == null || object instanceof String || object instanceof Number || object instanceof Date)) {
                    objectArray[n] = object.toString();
                } else if (object == null) {
                    objectArray[n] = "" + object;
                }
                --n;
            }
        }
        String string2 = this.getErrorMsg(locale, objectArray);
        return this.mAppendCodes ? MessageFormat.format(string, this.getProductCode(), this.getErrorCode(), string2) : string2;
    }

    public String getBaseMessage() {
        return this.mMsg;
    }

    public String getLocalizedBaseMessage(Locale locale) {
        return this.mMsg;
    }

    public String getResourceName() {
        return null;
    }

    public Class getResourceClass() {
        return null;
    }

    public Object[] getErrorParameters() {
        return this.mErrorParams == null ? new Object[]{} : (Object[])this.mErrorParams.clone();
    }

    public void setErrorParameters(Object[] objectArray) {
        this.mErrorParams = objectArray;
    }

    public String getErrorCode() {
        return this.mErrorCode;
    }

    public String getProductCode() {
        return this.mEx.getProductCode();
    }

    protected String getErrorMsg(Locale locale, Object[] objectArray) {
        return MessageFormat.format(this.mMsg, objectArray);
    }

    protected String getErrorMsgFormat(Locale locale) {
        return this.mErrorCode.length() == 0 ? "{2}" : "{0}-{1}: {2}";
    }

    public Object[] getDetails() {
        if (this.mDetails != null) {
            return this.mDetails.toArray();
        }
        return new Object[0];
    }

    public String getDetailMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.mEx.getMessage());
        this.buildAllMessage(stringBuffer);
        return stringBuffer.toString();
    }

    void buildAllMessage(StringBuffer stringBuffer) {
        if (this.mDetails != null) {
            Iterator iterator = this.mDetails.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (object instanceof JboException) {
                    stringBuffer.append(((JboException)object).getDetailMessage());
                    continue;
                }
                if (!(object instanceof Exception)) continue;
                Exception exception = (Exception)object;
                stringBuffer.append(": ");
                stringBuffer.append(exception.getMessage());
            }
        }
    }

    public void setDetails(Object[] objectArray) {
        if (objectArray != null) {
            this.mDetails = new ArrayList();
            int n = 0;
            while (n < objectArray.length) {
                this.mDetails.add(objectArray[n]);
                ++n;
            }
        } else {
            this.mDetails = null;
        }
    }

    public void setDetailsList(ArrayList arrayList) {
        this.mDetails = arrayList;
    }

    public ArrayList getDetailsList() {
        return this.mDetails != null ? (ArrayList)this.mDetails.clone() : null;
    }

    public void addToDetails(Object object) {
        if (this.mDetails == null) {
            this.mDetails = new ArrayList();
        }
        this.mDetails.add(object);
    }

    public boolean isAppendCodes() {
        return this.mAppendCodes;
    }

    public void setAppendCodes(boolean bl) {
        this.mAppendCodes = bl;
    }

    public void setLocaleContext(LocaleContext localeContext) {
        this.mLocale = localeContext;
        ArrayList arrayList = this.mDetails;
        if (arrayList != null) {
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                Object object = arrayList.get(n2);
                if (object instanceof JboException) {
                    ((JboException)object).setLocaleContext(localeContext);
                }
                ++n2;
            }
        }
    }
}

