/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl;

import oracle.core.ojdl.LogMessage;

public class ECID
extends LogMessage.InstanceId {
    private static final int MAX_UNIQUE_LEN = 64;

    public ECID() {
        super(ECID.createUniqueId(), 0);
    }

    public ECID(String string, int n) {
        super(string, n);
        if (string == null) {
            throw new NullPointerException();
        }
        ECID.checkValid(string);
        if (n < 0) {
            throw new IllegalArgumentException("ECID: illegal sequenceNumber");
        }
    }

    public ECID increment() {
        return new ECID(this.getUniqueId(), this.getSequenceNumber() + 1);
    }

    public ECID decrement() {
        return new ECID(this.getUniqueId(), this.getSequenceNumber() - 1);
    }

    public static ECID parse(String string) {
        int n;
        int n2 = string.indexOf(44);
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid ECID: " + string);
        }
        String string2 = string.substring(0, n2);
        ECID.checkValid(string2);
        if (++n2 < string.length() && Character.isWhitespace(string.charAt(n2))) {
            ++n2;
        }
        try {
            n = Integer.parseInt(string.substring(n2));
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        if (n < 0) {
            throw new IllegalArgumentException("Invalid ECID: " + string);
        }
        return new ECID(string2, n);
    }

    public String toString() {
        return this.getUniqueId() + "," + this.getSequenceNumber();
    }

    private static void checkValid(String string) {
        if (string == null || string.length() == 0 || string.length() > 64 || string.indexOf(44) >= 0) {
            throw new IllegalArgumentException("Invalid ECID.uniqueId: " + string);
        }
    }

    private static String createUniqueId() {
        return Long.toString(System.currentTimeMillis());
    }
}

