/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.handlers;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.ValidityException;

public class EnumFieldHandler
implements FieldHandler {
    private static final Class[] STRING_ARGS = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EnumFieldHandler.class$("java.lang.String")) : class$java$lang$String};
    private static final String METHOD_NAME = "valueOf";
    private final Method _valueOf;
    private final FieldHandler _handler;
    static /* synthetic */ Class class$java$lang$String;

    public EnumFieldHandler(Class enumType, FieldHandler handler) {
        this._handler = handler;
        this._valueOf = this.getStaticValueOfMethod(enumType);
    }

    private Method getStaticValueOfMethod(Class type) {
        if (type == null) {
            String err = "The Class argument passed to the constructor of EnumMarshalDescriptor cannot be null.";
            throw new IllegalArgumentException(err);
        }
        Method method = null;
        try {
            method = type.getMethod(METHOD_NAME, STRING_ARGS);
        }
        catch (NoSuchMethodException nsme) {
            String err = type.getName() + " does not contain the required method: public static " + type.getName() + " valueOf(String);";
            throw new IllegalArgumentException(err);
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            String err = type.getName() + " public " + type.getName() + " valueOf(String); exists but is not static";
            throw new IllegalArgumentException(err);
        }
        return method;
    }

    public Object getValue(Object target) throws IllegalStateException {
        Object val = this._handler.getValue(target);
        if (val == null) {
            return val;
        }
        String[] result = null;
        if (val.getClass().isArray()) {
            int size = Array.getLength(val);
            String[] values = new String[size];
            for (int i = 0; i < size; ++i) {
                Object obj = Array.get(val, i);
                values[i] = obj.toString();
            }
            result = values;
        } else {
            result = val.toString();
        }
        return result;
    }

    public void setValue(Object target, Object value) throws IllegalStateException {
        Object[] args = new String[1];
        Object obj = null;
        if (value != null) {
            args[0] = value.toString();
            try {
                obj = this._valueOf.invoke(null, args);
            }
            catch (InvocationTargetException ite) {
                Throwable toss = ite.getTargetException();
                throw new IllegalStateException(toss.toString());
            }
            catch (IllegalAccessException iae) {
                throw new IllegalStateException(iae.toString());
            }
        }
        this._handler.setValue(target, obj);
    }

    public void resetValue(Object target) {
    }

    public void checkValidity(Object object) throws ValidityException, IllegalStateException {
    }

    public Object newInstance(Object parent) throws IllegalStateException {
        return "";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FieldHandler)) {
            return false;
        }
        return this._handler.getClass().isInstance(obj) || this.getClass().isInstance(obj);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

