/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.dbaccess.DBError;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;

public class OracleJdbc2SQLInput
implements SQLInput {
    private int index;
    private Datum[] attributes;
    private Map map;
    private OracleConnection conn;

    public OracleJdbc2SQLInput(Datum[] datumArray, Map map, OracleConnection oracleConnection) {
        this.attributes = datumArray;
        this.map = map;
        this.conn = oracleConnection;
        this.index = 0;
    }

    public ARRAY readARRAY() throws SQLException {
        block3: {
            try {
                if (this.attributes[this.index] == null) break block3;
                if (this.attributes[this.index] instanceof ARRAY) {
                    ARRAY aRRAY = (ARRAY)this.attributes[this.index];
                    Object var3_2 = null;
                    ++this.index;
                    return aRRAY;
                }
                DBError.check_error(4, null);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_3 = null;
        ++this.index;
        return null;
    }

    public Array readArray() throws SQLException {
        return this.readARRAY();
    }

    public InputStream readAsciiStream() throws SQLException {
        try {
            Datum datum = this.attributes[this.index];
            if (datum != null) {
                InputStream inputStream = datum.asciiStreamValue();
                Object var3_3 = null;
                ++this.index;
                return inputStream;
            }
            Object var3_4 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            ++this.index;
            throw throwable;
        }
        return null;
    }

    public BFILE readBFILE() throws SQLException {
        block3: {
            try {
                if (this.attributes[this.index] == null) break block3;
                if (this.attributes[this.index] instanceof BFILE) {
                    BFILE bFILE = (BFILE)this.attributes[this.index];
                    Object var3_2 = null;
                    ++this.index;
                    return bFILE;
                }
                DBError.check_error(4, null);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_3 = null;
        ++this.index;
        return null;
    }

    public BLOB readBLOB() throws SQLException {
        block3: {
            try {
                if (this.attributes[this.index] == null) break block3;
                if (this.attributes[this.index] instanceof BLOB) {
                    BLOB bLOB = (BLOB)this.attributes[this.index];
                    Object var3_2 = null;
                    ++this.index;
                    return bLOB;
                }
                DBError.check_error(4, null);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_3 = null;
        ++this.index;
        return null;
    }

    public BigDecimal readBigDecimal() throws SQLException {
        try {
            if (this.attributes[this.index] != null) {
                BigDecimal bigDecimal = this.attributes[this.index].bigDecimalValue();
                Object var3_2 = null;
                ++this.index;
                return bigDecimal;
            }
            Object var3_3 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            ++this.index;
            throw throwable;
        }
        return null;
    }

    public InputStream readBinaryStream() throws SQLException {
        try {
            Datum datum = this.attributes[this.index];
            if (datum != null) {
                InputStream inputStream = datum.binaryStreamValue();
                Object var3_3 = null;
                ++this.index;
                return inputStream;
            }
            Object var3_4 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            ++this.index;
            throw throwable;
        }
        return null;
    }

    public Blob readBlob() throws SQLException {
        return this.readBLOB();
    }

    public boolean readBoolean() throws SQLException {
        try {
            if (this.attributes[this.index] != null) {
                boolean bl = this.attributes[this.index].booleanValue();
                Object var3_2 = null;
                ++this.index;
                return bl;
            }
            Object var3_3 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            ++this.index;
            throw throwable;
        }
        return false;
    }

    public byte readByte() throws SQLException {
        try {
            if (this.attributes[this.index] != null) {
                byte by = this.attributes[this.index].byteValue();
                Object var3_2 = null;
                ++this.index;
                return by;
            }
            Object var3_3 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            ++this.index;
            throw throwable;
        }
        return 0;
    }

    public byte[] readBytes() throws SQLException {
        block3: {
            try {
                if (this.attributes[this.index] == null) break block3;
                if (this.attributes[this.index] instanceof RAW) {
                    byte[] byArray = ((RAW)this.attributes[this.index]).shareBytes();
                    Object var3_2 = null;
                    ++this.index;
                    return byArray;
                }
                DBError.check_error(4, null);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_3 = null;
        ++this.index;
        return null;
    }

    public CHAR readCHAR() throws SQLException {
        block3: {
            try {
                if (this.attributes[this.index] == null) break block3;
                if (this.attributes[this.index] instanceof CHAR) {
                    CHAR cHAR = (CHAR)this.attributes[this.index];
                    Object var3_2 = null;
                    ++this.index;
                    return cHAR;
                }
                DBError.check_error(4, null);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_3 = null;
        ++this.index;
        return null;
    }

    public CLOB readCLOB() throws SQLException {
        block3: {
            try {
                if (this.attributes[this.index] == null) break block3;
                if (this.attributes[this.index] instanceof CLOB) {
                    CLOB cLOB = (CLOB)this.attributes[this.index];
                    Object var3_2 = null;
                    ++this.index;
                    return cLOB;
                }
                DBError.check_error(4, null);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_3 = null;
        ++this.index;
        return null;
    }

    public Reader readCharacterStream() throws SQLException {
        try {
            Datum datum = this.attributes[this.index];
            if (datum != null) {
                Reader reader = datum.characterStreamValue();
                Object var3_3 = null;
                ++this.index;
                return reader;
            }
            Object var3_4 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            ++this.index;
            throw throwable;
        }
        return null;
    }

    public Clob readClob() throws SQLException {
        return this.readCLOB();
    }

    public DATE readDATE() throws SQLException {
        block3: {
            try {
                if (this.attributes[this.index] == null) break block3;
                if (this.attributes[this.index] instanceof DATE) {
                    DATE dATE = (DATE)this.attributes[this.index];
                    Object var3_2 = null;
                    ++this.index;
                    return dATE;
                }
                DBError.check_error(4, null);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_3 = null;
        ++this.index;
        return null;
    }

    public Date readDate() throws SQLException {
        try {
            if (this.attributes[this.index] != null) {
                Date date = this.attributes[this.index].dateValue();
                Object var3_2 = null;
                ++this.index;
                return date;
            }
            Object var3_3 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            ++this.index;
            throw throwable;
        }
        return null;
    }

    public double readDouble() throws SQLException {
        try {
            if (this.attributes[this.index] != null) {
                double d = this.attributes[this.index].doubleValue();
                Object var4_2 = null;
                ++this.index;
                return d;
            }
            Object var4_3 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ++this.index;
            throw throwable;
        }
        return 0.0;
    }

    public float readFloat() throws SQLException {
        try {
            if (this.attributes[this.index] != null) {
                float f = this.attributes[this.index].floatValue();
                Object var3_2 = null;
                ++this.index;
                return f;
            }
            Object var3_3 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            ++this.index;
            throw throwable;
        }
        return 0.0f;
    }

    public int readInt() throws SQLException {
        try {
            if (this.attributes[this.index] != null) {
                int n = this.attributes[this.index].intValue();
                Object var3_2 = null;
                ++this.index;
                return n;
            }
            Object var3_3 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            ++this.index;
            throw throwable;
        }
        return 0;
    }

    public long readLong() throws SQLException {
        try {
            if (this.attributes[this.index] != null) {
                long l = this.attributes[this.index].longValue();
                Object var4_2 = null;
                ++this.index;
                return l;
            }
            Object var4_3 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ++this.index;
            throw throwable;
        }
        return 0L;
    }

    public NUMBER readNUMBER() throws SQLException {
        block3: {
            try {
                if (this.attributes[this.index] == null) break block3;
                if (this.attributes[this.index] instanceof NUMBER) {
                    NUMBER nUMBER = (NUMBER)this.attributes[this.index];
                    Object var3_2 = null;
                    ++this.index;
                    return nUMBER;
                }
                DBError.check_error(4, null);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_3 = null;
        ++this.index;
        return null;
    }

    public Object readObject() throws SQLException {
        Datum datum = (Datum)this.readOracleObject();
        if (datum != null) {
            if (datum instanceof STRUCT) {
                return ((STRUCT)datum).toJdbc(this.map);
            }
            datum.toJdbc();
        }
        return null;
    }

    public Object readOracleObject() throws SQLException {
        return this.attributes[this.index++];
    }

    public RAW readRAW() throws SQLException {
        block3: {
            try {
                if (this.attributes[this.index] == null) break block3;
                if (this.attributes[this.index] instanceof RAW) {
                    RAW rAW = (RAW)this.attributes[this.index];
                    Object var3_2 = null;
                    ++this.index;
                    return rAW;
                }
                DBError.check_error(4, null);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_3 = null;
        ++this.index;
        return null;
    }

    public REF readREF() throws SQLException {
        block3: {
            try {
                if (this.attributes[this.index] == null) break block3;
                if (this.attributes[this.index] instanceof REF) {
                    REF rEF = (REF)this.attributes[this.index];
                    Object var3_2 = null;
                    ++this.index;
                    return rEF;
                }
                DBError.check_error(4, null);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_3 = null;
        ++this.index;
        return null;
    }

    public ROWID readROWID() throws SQLException {
        block3: {
            try {
                if (this.attributes[this.index] == null) break block3;
                if (this.attributes[this.index] instanceof ROWID) {
                    ROWID rOWID = (ROWID)this.attributes[this.index];
                    Object var3_2 = null;
                    ++this.index;
                    return rOWID;
                }
                DBError.check_error(4, null);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_3 = null;
        ++this.index;
        return null;
    }

    public Ref readRef() throws SQLException {
        return this.readREF();
    }

    public STRUCT readSTRUCT() throws SQLException {
        block3: {
            try {
                if (this.attributes[this.index] == null) break block3;
                if (this.attributes[this.index] instanceof STRUCT) {
                    STRUCT sTRUCT = (STRUCT)this.attributes[this.index];
                    Object var3_2 = null;
                    ++this.index;
                    return sTRUCT;
                }
                DBError.check_error(4, null);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                ++this.index;
                throw throwable;
            }
        }
        Object var3_3 = null;
        ++this.index;
        return null;
    }

    public short readShort() throws SQLException {
        long l = this.readLong();
        if (l > 65537L || l < -65538L) {
            DBError.check_error(26, "readShort");
        }
        return (short)l;
    }

    public String readString() throws SQLException {
        try {
            if (this.attributes[this.index] != null) {
                String string = this.attributes[this.index].stringValue();
                Object var3_2 = null;
                ++this.index;
                return string;
            }
            Object var3_3 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            ++this.index;
            throw throwable;
        }
        return null;
    }

    public Struct readStruct() throws SQLException {
        return this.readSTRUCT();
    }

    public Time readTime() throws SQLException {
        try {
            if (this.attributes[this.index] != null) {
                Time time = this.attributes[this.index].timeValue();
                Object var3_2 = null;
                ++this.index;
                return time;
            }
            Object var3_3 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            ++this.index;
            throw throwable;
        }
        return null;
    }

    public Timestamp readTimestamp() throws SQLException {
        try {
            if (this.attributes[this.index] != null) {
                Timestamp timestamp = this.attributes[this.index].timestampValue();
                Object var3_2 = null;
                ++this.index;
                return timestamp;
            }
            Object var3_3 = null;
            ++this.index;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            ++this.index;
            throw throwable;
        }
        return null;
    }

    public boolean wasNull() throws SQLException {
        if (this.index == 0) {
            DBError.throwSqlException(24);
        }
        return this.attributes[this.index - 1] == null;
    }
}

