/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jaxb;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import oracle.xml.jaxb.JaxbBindingSchema;
import oracle.xml.jaxb.JaxbConstants;
import oracle.xml.jaxb.JaxbError;
import oracle.xml.jaxb.JaxbProperty;
import oracle.xml.jaxb.JaxbUtil;
import oracle.xml.parser.v2.XMLError;

public class JaxbDefaultCustomization
implements JaxbConstants {
    private PrintWriter pw = null;
    private XMLError err = new JaxbError();
    private String outputDir = null;
    private String schemaLocation = null;
    private String bindingFile = null;
    private String indent = "";
    private static final String fsep = System.getProperty("file.separator");
    private static final String lsep = System.getProperty("line.separator");
    private static final String lsep2 = lsep + lsep;
    private static final String JAXB = "jaxb";
    private static final String ORAJAXB = "orajaxb";
    private Hashtable bindingSchema;

    public JaxbDefaultCustomization(String string) {
        this.bindingFile = string;
    }

    public void setError(XMLError xMLError) {
        this.err = xMLError;
    }

    public void setOutputDir(String string) {
        this.outputDir = string;
    }

    public void setSchemaLocation(String string) {
        this.schemaLocation = string;
    }

    public void setBindingSchema(Hashtable hashtable) {
        this.bindingSchema = hashtable;
    }

    public void generateCustomization() {
        JaxbBindingSchema jaxbBindingSchema = null;
        this.openFile();
        StringBuffer stringBuffer = new StringBuffer();
        this.generateSchemaStartBinding(stringBuffer);
        this.generateSchemaLocation(stringBuffer);
        Enumeration enumeration = this.bindingSchema.elements();
        while (enumeration.hasMoreElements()) {
            jaxbBindingSchema = (JaxbBindingSchema)enumeration.nextElement();
            if (!jaxbBindingSchema.isGlobal()) continue;
            if (jaxbBindingSchema.getType() == 3) {
                this.generateElementBinding(stringBuffer, jaxbBindingSchema);
                continue;
            }
            if (jaxbBindingSchema.getType() == 1) {
                this.generateComplexTypeBinding(stringBuffer, jaxbBindingSchema);
                continue;
            }
            if (jaxbBindingSchema.getType() == 2) {
                this.generateSimpleTypeBinding(stringBuffer, jaxbBindingSchema);
                continue;
            }
            if (jaxbBindingSchema.getType() != 5) continue;
            this.generateGroupBinding(stringBuffer, jaxbBindingSchema);
        }
        this.generateEndBinding(stringBuffer);
        this.pw.print(stringBuffer.toString());
        this.closeFile();
    }

    void generateSchemaStartBinding(StringBuffer stringBuffer) {
        stringBuffer.append(this.indent).append("<jaxb:bindings ").append("xmlns:jaxb=").append(JaxbUtil.quoteStringForXml("http://java.sun.com/xml/ns/jaxb")).append(lsep);
        this.pushIndent();
        stringBuffer.append(this.indent).append("xmlns:orajaxb=").append(JaxbUtil.quoteStringForXml("http://www.oracle.com/xml/ns/orajaxb")).append(lsep);
        stringBuffer.append(this.indent).append("xmlns:xs=").append(JaxbUtil.quoteStringForXml("http://www.w3.org/2001/XMLSchema")).append(lsep);
        stringBuffer.append(this.indent).append("version=").append(JaxbUtil.quoteStringForXml("1.0")).append(">").append(lsep2);
    }

    void generateSchemaLocation(StringBuffer stringBuffer) {
        stringBuffer.append(this.indent).append("<jaxb:bindings ").append("schemaLocation=").append(JaxbUtil.quoteStringForXml(this.schemaLocation)).append(" ").append("node=").append(JaxbUtil.quoteStringForXml("/xs:schema")).append("/>").append(lsep2);
    }

    void generateStartBinding(StringBuffer stringBuffer, String string, String string2, String string3) {
        stringBuffer.append(this.indent).append("<jaxb:bindings ").append("node=").append("\".//xs:").append(string).append("[@name='").append(string2).append("']\"").append(">").append(lsep);
        this.pushIndent();
        stringBuffer.append(this.indent).append("<orajaxb:namespace value=").append(JaxbUtil.quoteStringForXml(string3)).append("/>").append(lsep);
    }

    void generateEndBinding(StringBuffer stringBuffer) {
        this.popIndent();
        stringBuffer.append(this.indent).append("</jaxb:bindings>").append(lsep2);
    }

    void generateElementBinding(StringBuffer stringBuffer, JaxbBindingSchema jaxbBindingSchema) {
        JaxbProperty jaxbProperty;
        this.generateStartBinding(stringBuffer, "element", jaxbBindingSchema.getNodeName(), jaxbBindingSchema.getNamespace());
        this.generateClassStart(stringBuffer, jaxbBindingSchema);
        this.pushIndent();
        stringBuffer.append(this.indent).append("<orajaxb:package name=").append(JaxbUtil.quoteStringForXml(jaxbBindingSchema.getPackageName())).append("/>").append(lsep);
        String string = jaxbBindingSchema.getExtendsNode();
        if (string != null) {
            string = JaxbUtil.getActualExtendsNode(this.bindingSchema, jaxbBindingSchema, string);
            stringBuffer.append(this.indent).append("<orajaxb:extendsNode name=").append(JaxbUtil.quoteStringForXml(string)).append("/>").append(lsep);
        }
        if (jaxbBindingSchema.isAbstract()) {
            stringBuffer.append(this.indent).append("<orajaxb:isAbstract value=").append(JaxbUtil.quoteStringForXml("true")).append("/>").append(lsep);
        }
        if (jaxbBindingSchema.isNillable()) {
            stringBuffer.append(this.indent).append("<orajaxb:isNillable value=").append(JaxbUtil.quoteStringForXml("true")).append("/>").append(lsep);
        }
        if ((jaxbProperty = jaxbBindingSchema.getDataValueType()) != null) {
            this.generatePropertyTypeBinding(stringBuffer, jaxbProperty, false);
        }
        if (!jaxbBindingSchema.isGlobal()) {
            stringBuffer.append(this.indent).append("<orajaxb:isInnerInterface value=").append(JaxbUtil.quoteStringForXml("true"));
            if (jaxbBindingSchema.getWrapsChoice()) {
                stringBuffer.append(" choice=").append(JaxbUtil.quoteStringForXml("true"));
            }
            stringBuffer.append("/>").append(lsep);
            this.generateTypeBinding(stringBuffer, jaxbBindingSchema);
            this.generateEndBinding(stringBuffer);
        } else {
            this.popIndent();
            stringBuffer.append(this.indent).append("</jaxb:class>").append(lsep);
            this.generateEndBinding(stringBuffer);
        }
    }

    void generateGroupBinding(StringBuffer stringBuffer, JaxbBindingSchema jaxbBindingSchema) {
        boolean bl = false;
        Object var4_4 = null;
        this.generateStartBinding(stringBuffer, "group", jaxbBindingSchema.getNodeName(), jaxbBindingSchema.getNamespace());
        this.generateClassStart(stringBuffer, jaxbBindingSchema);
        this.pushIndent();
        stringBuffer.append(this.indent).append("<orajaxb:package name=").append(JaxbUtil.quoteStringForXml(jaxbBindingSchema.getPackageName())).append("/>").append(lsep);
        this.generateGroupCMBinding(stringBuffer, jaxbBindingSchema);
        this.generateEndBinding(stringBuffer);
    }

    void generateGroupCMBinding(StringBuffer stringBuffer, JaxbBindingSchema jaxbBindingSchema) {
        Vector vector;
        int n = 0;
        JaxbProperty jaxbProperty = null;
        this.popIndent();
        stringBuffer.append(this.indent).append("</jaxb:class>").append(lsep2);
        Vector vector2 = jaxbBindingSchema.getContentProperty();
        if (vector2 != null) {
            n = vector2.size();
            for (int i = 0; i < n; ++i) {
                jaxbProperty = (JaxbProperty)vector2.elementAt(i);
                this.generatePropertyBinding(stringBuffer, jaxbProperty, false, jaxbBindingSchema.getNodeName(), jaxbBindingSchema.getNamespace());
            }
        }
        if ((vector = jaxbBindingSchema.getInnerInterface()) != null) {
            n = vector.size();
            for (int i = 0; i < n; ++i) {
                jaxbBindingSchema = (JaxbBindingSchema)vector.elementAt(i);
                if (jaxbBindingSchema.getType() == 1) {
                    this.generateComplexTypeBinding(stringBuffer, jaxbBindingSchema);
                    continue;
                }
                this.generateElementBinding(stringBuffer, jaxbBindingSchema);
            }
        }
    }

    void generateClassStart(StringBuffer stringBuffer, JaxbBindingSchema jaxbBindingSchema) {
        if (jaxbBindingSchema.getCustomizationSet().get(0)) {
            stringBuffer.append(this.indent).append("<orajaxb:customization name=\"class\"/>").append(lsep);
        }
        stringBuffer.append(this.indent).append("<jaxb:class name=").append(JaxbUtil.quoteStringForXml(jaxbBindingSchema.getClassName())).append(">").append(lsep);
    }

    void generateComplexTypeBinding(StringBuffer stringBuffer, JaxbBindingSchema jaxbBindingSchema) {
        boolean bl = false;
        Object var4_4 = null;
        this.generateStartBinding(stringBuffer, "complexType", jaxbBindingSchema.getNodeName(), jaxbBindingSchema.getNamespace());
        this.generateClassStart(stringBuffer, jaxbBindingSchema);
        this.pushIndent();
        stringBuffer.append(this.indent).append("<orajaxb:package name=").append(JaxbUtil.quoteStringForXml(jaxbBindingSchema.getPackageName())).append("/>").append(lsep);
        String string = jaxbBindingSchema.getExtendsNode();
        if (string != null) {
            string = JaxbUtil.getActualExtendsNode(this.bindingSchema, jaxbBindingSchema, string);
            stringBuffer.append(this.indent).append("<orajaxb:extendsNode name=").append(JaxbUtil.quoteStringForXml(string)).append("/>").append(lsep);
        }
        if (jaxbBindingSchema.isAbstract()) {
            stringBuffer.append(this.indent).append("<orajaxb:isAbstract value=").append(JaxbUtil.quoteStringForXml("true")).append("/>").append(lsep);
        }
        if (!jaxbBindingSchema.isGlobal()) {
            stringBuffer.append(this.indent).append("<orajaxb:isInnerInterface value=").append(JaxbUtil.quoteStringForXml("true")).append("/>").append(lsep);
        }
        this.generateTypeBinding(stringBuffer, jaxbBindingSchema);
        this.generateEndBinding(stringBuffer);
    }

    void generateTypeBinding(StringBuffer stringBuffer, JaxbBindingSchema jaxbBindingSchema) {
        HashMap hashMap;
        Vector vector;
        Object object;
        HashMap hashMap2;
        int n = 0;
        JaxbProperty jaxbProperty = null;
        if (jaxbBindingSchema.isMixedContent()) {
            stringBuffer.append(this.indent).append("<orajaxb:isMixedContent value=").append(JaxbUtil.quoteStringForXml("true")).append("/>").append(lsep);
        }
        this.popIndent();
        stringBuffer.append(this.indent).append("</jaxb:class>").append(lsep2);
        JaxbProperty jaxbProperty2 = jaxbBindingSchema.getDataValueType();
        if (jaxbProperty2 != null) {
            this.generatePropertyTypeBinding(stringBuffer, jaxbProperty2, false);
        }
        if ((hashMap2 = jaxbBindingSchema.getAttrProperty()) != null) {
            object = hashMap2.keySet().iterator();
            while (object.hasNext()) {
                jaxbProperty = (JaxbProperty)hashMap2.get(object.next());
                this.generateAttrPropertyBinding(stringBuffer, jaxbProperty, false);
            }
        }
        if ((object = jaxbBindingSchema.getContentProperty()) != null) {
            n = ((Vector)object).size();
            for (int i = 0; i < n; ++i) {
                jaxbProperty = (JaxbProperty)((Vector)object).elementAt(i);
                this.generatePropertyBinding(stringBuffer, jaxbProperty, false, jaxbBindingSchema.getNodeName(), jaxbBindingSchema.getNamespace());
            }
        }
        if ((vector = jaxbBindingSchema.getInnerInterface()) != null) {
            n = vector.size();
            for (int i = 0; i < n; ++i) {
                jaxbBindingSchema = (JaxbBindingSchema)vector.elementAt(i);
                if (jaxbBindingSchema.isRefType()) continue;
                if (jaxbBindingSchema.getType() == 1) {
                    this.generateComplexTypeBinding(stringBuffer, jaxbBindingSchema);
                    continue;
                }
                this.generateElementBinding(stringBuffer, jaxbBindingSchema);
            }
        }
        if ((hashMap = jaxbBindingSchema.getFixedProperty()) != null) {
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                jaxbProperty = (JaxbProperty)hashMap.get(iterator.next());
                this.generatePropertyBinding(stringBuffer, jaxbProperty, true, jaxbBindingSchema.getNodeName(), jaxbBindingSchema.getNamespace());
            }
        }
    }

    void generateSimpleTypeBinding(StringBuffer stringBuffer, JaxbBindingSchema jaxbBindingSchema) {
        this.generateStartBinding(stringBuffer, "simpleType", jaxbBindingSchema.getNodeName(), jaxbBindingSchema.getNamespace());
        stringBuffer.append(this.indent).append("<jaxb:typesafeEnumClass name=").append(JaxbUtil.quoteStringForXml(jaxbBindingSchema.getClassName())).append(">").append(lsep);
        this.pushIndent();
        stringBuffer.append(this.indent).append("<orajaxb:package name=").append(JaxbUtil.quoteStringForXml(jaxbBindingSchema.getPackageName())).append("/>").append(lsep);
        JaxbProperty jaxbProperty = jaxbBindingSchema.getDataValueType();
        if (jaxbProperty != null) {
            this.generatePropertyTypeBinding(stringBuffer, jaxbProperty, false);
        }
        HashMap hashMap = jaxbBindingSchema.getEnumeration();
        String string = null;
        String string2 = null;
        if (hashMap != null) {
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                string2 = (String)hashMap.get(string);
                stringBuffer.append(this.indent).append("<jaxb:typesafeEnumMember ").append("name=").append(JaxbUtil.quoteStringForXml(JaxbUtil.constantName(string2))).append(" value=").append(JaxbUtil.quoteStringForXml(string)).append("/>").append(lsep);
            }
        }
        this.popIndent();
        stringBuffer.append(this.indent).append("</jaxb:typesafeEnumClass>").append(lsep);
        this.generateEndBinding(stringBuffer);
    }

    void generateAttrPropertyBinding(StringBuffer stringBuffer, JaxbProperty jaxbProperty, boolean bl) {
        String string;
        String string2 = jaxbProperty.getName();
        this.generateStartBinding(stringBuffer, "attribute", string2, jaxbProperty.getNamespace());
        String string3 = jaxbProperty.getCusName();
        if (string3 != null) {
            string2 = string3;
        }
        stringBuffer.append(this.indent).append("<jaxb:property name=").append(JaxbUtil.quoteStringForXml(string2));
        this.pushIndent();
        if (jaxbProperty.isCollectionType()) {
            stringBuffer.append(" ").append("collectionType=").append(JaxbUtil.quoteStringForXml(jaxbProperty.getCollectionType()));
        }
        if (bl && jaxbProperty.isFixedAttrAsConstantProperty()) {
            stringBuffer.append(" ").append("fixedAttributeAsConstantProperty").append("=").append(JaxbUtil.quoteStringForXml("true"));
        }
        if (jaxbProperty.isGenerateIsSetMethod()) {
            stringBuffer.append(" ").append("generateIsSetMethod").append("=").append(JaxbUtil.quoteStringForXml("true"));
        }
        stringBuffer.append(">").append(lsep);
        String string4 = jaxbProperty.getJavaType();
        String string5 = jaxbProperty.getXmlType();
        if (string4 != null) {
            stringBuffer.append(this.indent).append("<jaxb:baseType>").append(lsep);
            this.pushIndent();
            this.generatePropertyTypeBinding(stringBuffer, jaxbProperty, true);
            this.popIndent();
            stringBuffer.append(this.indent).append("</jaxb:baseType>").append(lsep);
        }
        if ((string = jaxbProperty.getDefaultValue()) != null) {
            stringBuffer.append(this.indent).append("<orajaxb:defaultValue value =").append(JaxbUtil.quoteStringForXml(string)).append("/>").append(lsep);
        }
        if (bl) {
            stringBuffer.append(this.indent).append("<orajaxb:fixedValue value =").append(JaxbUtil.quoteStringForXml(jaxbProperty.getFixedValue())).append("/>").append(lsep);
        }
        this.popIndent();
        stringBuffer.append(this.indent).append("</jaxb:property>").append(lsep);
        this.generateEndBinding(stringBuffer);
    }

    void generatePropertyBinding(StringBuffer stringBuffer, JaxbProperty jaxbProperty, boolean bl, String string, String string2) {
        String string3;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        int n = jaxbProperty.getType();
        if (n == 4) {
            string4 = "attribute";
            string5 = jaxbProperty.getName();
            string6 = jaxbProperty.getNamespace();
        } else if (n == 5) {
            string4 = "group";
            string5 = string;
            string6 = string2;
        } else {
            string4 = "element";
            string5 = jaxbProperty.getName();
            string6 = jaxbProperty.getNamespace();
        }
        this.generateStartBinding(stringBuffer, string4, string5, string6);
        stringBuffer.append(this.indent).append("<jaxb:property name=").append(JaxbUtil.quoteStringForXml(jaxbProperty.getCusName()));
        this.pushIndent();
        if (jaxbProperty.isCollectionType()) {
            stringBuffer.append(" ").append("collectionType=").append(JaxbUtil.quoteStringForXml(jaxbProperty.getCollectionType()));
        }
        if (bl && jaxbProperty.isFixedAttrAsConstantProperty()) {
            stringBuffer.append(" ").append("fixedAttributeAsConstantProperty").append("=").append(JaxbUtil.quoteStringForXml("true"));
        }
        if (jaxbProperty.isGenerateIsSetMethod()) {
            stringBuffer.append(" ").append("generateIsSetMethod").append("=").append(JaxbUtil.quoteStringForXml("true"));
        }
        stringBuffer.append(">").append(lsep);
        String string7 = jaxbProperty.getJavaType();
        String string8 = jaxbProperty.getXmlType();
        if (!string7.equals("")) {
            stringBuffer.append(this.indent).append("<jaxb:baseType>").append(lsep);
            this.pushIndent();
            this.generatePropertyTypeBinding(stringBuffer, jaxbProperty, true);
            this.popIndent();
            stringBuffer.append(this.indent).append("</jaxb:baseType>").append(lsep);
        }
        if ((string3 = jaxbProperty.getDefaultValue()) != null) {
            stringBuffer.append(this.indent).append("<orajaxb:defaultValue value =").append(JaxbUtil.quoteStringForXml(string3)).append("/>").append(lsep);
        }
        if (bl) {
            stringBuffer.append(this.indent).append("<orajaxb:fixedValue value =").append(JaxbUtil.quoteStringForXml(jaxbProperty.getFixedValue())).append("/>").append(lsep);
        }
        if (jaxbProperty.isInnerInterface()) {
            stringBuffer.append(this.indent).append("<orajaxb:isInnerInterface value=").append(JaxbUtil.quoteStringForXml("true")).append("/>").append(lsep);
        }
        this.popIndent();
        stringBuffer.append(this.indent).append("</jaxb:property>").append(lsep);
        this.generateEndBinding(stringBuffer);
    }

    private void generatePropertyTypeBinding(StringBuffer stringBuffer, JaxbProperty jaxbProperty, boolean bl) {
        String string;
        String string2 = bl ? JAXB : ORAJAXB;
        String string3 = jaxbProperty.getJavaType();
        stringBuffer.append(this.indent).append("<").append(string2).append(":javaType name=");
        Vector vector = jaxbProperty.getCandidateObjects();
        stringBuffer.append(JaxbUtil.quoteStringForXml(string3));
        if (bl) {
            stringBuffer.append("/>").append(lsep);
        }
        if (!(string = jaxbProperty.getXmlType()).equals("")) {
            if (JaxbUtil.isSchemaDataType(string)) {
                string = "xs:" + string;
            }
            if (bl) {
                stringBuffer.append(this.indent).append("<orajaxb:xmlType name=");
            } else {
                stringBuffer.append(" ").append("xmlType=");
            }
            stringBuffer.append(JaxbUtil.quoteStringForXml(string)).append("/>").append(lsep);
        } else if (!bl) {
            stringBuffer.append("/>").append(lsep);
        }
    }

    private void openFile() {
        try {
            File file = new File(this.outputDir);
            boolean bl = file.mkdirs();
            File file2 = new File(file, this.bindingFile);
            if (!bl && (bl = file2.exists())) {
                if (this.err instanceof JaxbError) {
                    ((JaxbError)this.err).addOverwrittenFile(file + fsep + file2);
                } else {
                    this.err.error1(32111, 2, file + fsep + file2);
                }
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8");
            this.pw = new PrintWriter(outputStreamWriter);
        }
        catch (Exception exception) {
            this.err.error0(32110, 0);
            this.err.error0(0, 0);
        }
    }

    private void closeFile() {
        this.pw.flush();
        this.pw.close();
    }

    private void pushIndent() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 3; ++i) {
            stringBuffer.append(" ");
        }
        this.indent = this.indent + stringBuffer.toString();
    }

    private void popIndent() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.indent.length() - 3;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        this.indent = stringBuffer.toString();
    }
}

