/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.differ;

import oracle.xml.differ.SViewConstants;
import oracle.xml.differ.XMLHandler;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

class XMLTokenizer
implements SViewConstants {
    protected XMLHandler tokenHandler;
    protected Node currentNode;
    protected String currentXMLToken = "";
    protected int currentXMLTokenType;
    protected int currentXMLDocumentPosition;
    protected int currentOffset;
    protected int currentTreeTraversalDepth;
    protected DocumentType dtd;
    protected boolean dispIntDTD;

    XMLTokenizer() {
    }

    private DocumentType findDTD(Node node) {
        do {
            if (node.getNodeType() != 9) continue;
            return ((Document)node).getDoctype();
        } while ((node = node.getParentNode()) != null);
        return null;
    }

    synchronized void tokenize(Node node) {
        this.init(node);
        this.traverseTree(node);
    }

    Node getCurrentNode() {
        return this.currentNode;
    }

    int getCurrentOffset() {
        return this.currentOffset;
    }

    int getCurrentTreeTraversalDepth() {
        return this.currentTreeTraversalDepth;
    }

    String getCurrentXMLToken() {
        return this.currentXMLToken;
    }

    int getCurrentXMLTokenType() {
        return this.currentXMLTokenType;
    }

    protected void handleAttribute(Attr attr) {
        int n;
        int n2;
        this.setCurrentNode(attr);
        this.setCurrentXMLDocumentPosition(5);
        this.setCurrentXMLToken(" ", 12);
        if (this.isErrorAncestor(attr)) {
            n2 = 49;
            n = 49;
        } else if (this.isErrorNode(attr)) {
            n2 = 50;
            n = 50;
        } else {
            n = 4;
            n2 = 5;
        }
        this.setCurrentXMLToken(attr.getName(), n);
        this.setCurrentXMLToken("=", 12);
        this.setCurrentXMLToken("\"" + attr.getValue() + "\"", n2);
        this.setCurrentXMLDocumentPosition(6);
    }

    protected void handleComment(Comment comment) {
        this.setCurrentNode(comment);
        this.setCurrentXMLDocumentPosition(15);
        this.setCurrentXMLToken(this.getTab() + "<!--", 12);
        this.setCurrentXMLToken(comment.getData(), 6);
        this.setCurrentXMLToken("-->", 12);
        this.setCurrentXMLDocumentPosition(16);
    }

    protected void handleDocument(Document document) {
        this.setCurrentNode(document);
        this.setCurrentXMLDocumentPosition(1);
        NodeList nodeList = document.getChildNodes();
        if (nodeList != null && nodeList.getLength() > 0) {
            ++this.currentTreeTraversalDepth;
            this.setCurrentXMLDocumentPosition(19);
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                this.traverseTree(node);
            }
            --this.currentTreeTraversalDepth;
            this.setCurrentXMLDocumentPosition(20);
        }
        this.setCurrentNode(document);
        this.setCurrentXMLDocumentPosition(2);
    }

    protected void handleElement(Element element) {
        int n;
        int n2;
        int n3;
        this.setCurrentNode(element);
        this.setCurrentXMLDocumentPosition(3);
        boolean bl = this.isEmptyElement(element);
        this.setCurrentXMLToken(this.getTab() + "<", 12);
        if (this.isErrorAncestor(element)) {
            n3 = 49;
            n2 = 49;
        } else if (this.isErrorNode(element)) {
            n3 = 50;
            n2 = 50;
        } else {
            n2 = 1;
            n3 = 2;
        }
        if (bl) {
            this.setCurrentXMLToken(element.getTagName(), 3);
        } else {
            this.setCurrentXMLToken(element.getTagName(), n2);
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap != null && namedNodeMap.getLength() > 0) {
            this.setCurrentXMLDocumentPosition(17);
            int n4 = namedNodeMap.getLength();
            for (n = 0; n < n4; ++n) {
                this.handleAttribute((Attr)namedNodeMap.item(n));
            }
            this.setCurrentXMLDocumentPosition(18);
        }
        this.setCurrentNode(element);
        if (bl) {
            this.setCurrentNode(element);
            this.setCurrentXMLToken("/>", 12);
            this.setCurrentXMLDocumentPosition(4);
            return;
        }
        this.setCurrentXMLToken(">", 12);
        NodeList nodeList = element.getChildNodes();
        if (nodeList != null && nodeList.getLength() > 0) {
            ++this.currentTreeTraversalDepth;
            this.setCurrentXMLDocumentPosition(19);
            n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                this.traverseTree(nodeList.item(i));
            }
            --this.currentTreeTraversalDepth;
            this.setCurrentXMLDocumentPosition(20);
        }
        this.setCurrentNode(element);
        this.setCurrentXMLToken(this.getTab() + "</", 12);
        this.setCurrentXMLToken(element.getTagName(), n3);
        this.setCurrentXMLToken(">", 12);
        this.setCurrentXMLDocumentPosition(4);
    }

    protected void handlePI(ProcessingInstruction processingInstruction) {
        this.setCurrentNode(processingInstruction);
        this.setCurrentXMLDocumentPosition(13);
        this.setCurrentXMLToken("<?", 12);
        this.setCurrentXMLToken(processingInstruction.getTarget(), 7);
        this.setCurrentXMLToken(" ", 12);
        this.setCurrentXMLToken(processingInstruction.getData(), 8);
        this.setCurrentXMLToken("?>", 12);
        this.setCurrentXMLDocumentPosition(14);
    }

    protected void handleText(Text text) {
        int n;
        this.setCurrentNode(text);
        String string = text.getNodeValue();
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = 0;
        int n3 = stringBuffer.length();
        while ((n3 = stringBuffer.length()) > 0) {
            if (stringBuffer.charAt(n3 - 1) == '\n') {
                stringBuffer.setLength(n3 - 1);
                break;
            }
            if (stringBuffer.charAt(n3 - 1) != ' ') break;
            stringBuffer.setLength(n3 - 1);
        }
        block1: do {
            n3 = stringBuffer.length();
            char[] cArray = new char[n3];
            if (n3 > 0) {
                stringBuffer.getChars(0, n3, cArray, 0);
            }
            for (n = n2; n < n3; ++n) {
                if (cArray[n] == '&') {
                    stringBuffer.insert(n + 1, "#38;");
                    n2 = n + 1;
                    continue block1;
                }
                if (cArray[n] != '<') continue;
                stringBuffer.setCharAt(n, '&');
                stringBuffer.insert(n + 1, "#60;");
                n2 = n + 1;
                continue block1;
            }
        } while (n < n3);
        string = stringBuffer.toString();
        if (text instanceof CDATASection) {
            this.setCurrentXMLDocumentPosition(9);
            this.setCurrentXMLToken(this.getTab() + "<![CDATA[", 12);
            this.setCurrentXMLToken(string, 10);
            this.setCurrentXMLToken("]]>", 12);
            this.setCurrentXMLDocumentPosition(10);
            return;
        }
        if (string.trim().equals("")) {
            this.setCurrentXMLDocumentPosition(11);
            this.setCurrentXMLToken(string, 11);
            this.setCurrentXMLDocumentPosition(12);
            return;
        }
        this.setCurrentXMLDocumentPosition(7);
        int n4 = this.isErrorAncestor(text) ? 49 : (this.isErrorNode(text) ? 50 : 9);
        this.setCurrentXMLToken(string, n4);
        this.setCurrentXMLDocumentPosition(8);
    }

    protected void handleDTD(DocumentType documentType) {
        if (!this.dispIntDTD) {
            return;
        }
        this.setCurrentNode(documentType);
        this.setCurrentXMLDocumentPosition(21);
        if (documentType.getInternalSubset() != "") {
            this.setCurrentXMLToken("\n" + documentType.getInternalSubset(), 24);
            this.setCurrentXMLToken("]>", 24);
        } else {
            this.setCurrentXMLToken(this.getTab() + "<!DOCTYPE ", 12);
            this.setCurrentXMLToken(documentType.getName(), 23);
            if (documentType.getPublicId() != null) {
                this.setCurrentXMLToken(" PUBLIC \"", 12);
                this.setCurrentXMLToken(documentType.getPublicId(), 23);
            }
            if (documentType.getSystemId() != null) {
                this.setCurrentXMLToken(" SYSTEM \"", 12);
                this.setCurrentXMLToken(documentType.getSystemId(), 23);
            }
            this.setCurrentXMLToken("\">\n", 12);
        }
        this.setCurrentXMLDocumentPosition(22);
    }

    protected void init(Node node) {
        this.currentTreeTraversalDepth = 0;
        this.currentOffset = 0;
        this.currentXMLToken = "";
        this.currentXMLDocumentPosition = 0;
        this.currentXMLTokenType = 0;
        this.dtd = this.findDTD(node);
    }

    protected boolean isEmptyElement(Element element) {
        return !element.hasChildNodes();
    }

    boolean isErrorAncestor(Node node) {
        return ((XMLNode)node).getProperty("oracle.xml.schemavalidator.parenterr") != null;
    }

    boolean isErrorNode(Node node) {
        return ((XMLNode)node).getProperty("oracle.xml.schemavalidator.nodeerr") != null;
    }

    protected void setCurrentNode(Node node) {
        this.currentNode = node;
        if (this.tokenHandler != null) {
            this.tokenHandler.handleNode(this.currentNode, this.currentTreeTraversalDepth);
        }
    }

    protected void setCurrentXMLDocumentPosition(int n) {
        this.currentXMLDocumentPosition = n;
        if (this.tokenHandler != null) {
            this.tokenHandler.handleXMLDocumentPosition(this.currentXMLDocumentPosition, this.currentOffset);
        }
    }

    protected void setCurrentXMLToken(String string, int n) {
        if (string == null) {
            return;
        }
        this.currentXMLToken = string;
        this.currentXMLTokenType = n;
        this.currentOffset += string.length();
        if (this.tokenHandler != null) {
            this.tokenHandler.handleXMLToken(this.currentXMLToken, this.currentXMLTokenType, this.currentOffset);
        }
    }

    synchronized void setXMLHandler(XMLHandler xMLHandler) {
        this.tokenHandler = xMLHandler;
    }

    protected void traverseTree(Node node) {
        switch (node.getNodeType()) {
            case 9: {
                this.handleDocument((Document)node);
                return;
            }
            case 1: {
                this.handleElement((Element)node);
                return;
            }
            case 3: {
                this.handleText((Text)node);
                return;
            }
            case 4: {
                this.handleText((Text)node);
                return;
            }
            case 7: {
                this.handlePI((ProcessingInstruction)node);
                return;
            }
            case 8: {
                this.handleComment((Comment)node);
                return;
            }
            case 2: {
                this.handleAttribute((Attr)node);
                return;
            }
            case 10: {
                this.handleDTD((DocumentType)node);
                return;
            }
        }
    }

    protected String getTab() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        for (int i = 0; i < this.currentTreeTraversalDepth - 1; ++i) {
            stringBuffer.append("   ");
        }
        return stringBuffer.toString();
    }

    void setIntDTDDisp(boolean bl) {
        this.dispIntDTD = bl;
    }
}

