/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.share.sort;

import java.util.Random;
import oracle.bali.share.sort.Comparator;

public abstract class Sort {
    private static final int _INSERTION_LIMIT = 9;
    private static final Random _RANDOM = new Random();

    private static int _getRandomPartionIndex(int n, int n2) {
        int n3 = _RANDOM.nextInt();
        if ((n3 %= n2 - n + 1) < 0) {
            n3 = -n3;
        }
        return n3 + n;
    }

    private static void _insertionSort(int[] nArray, int n, int n2) {
        int n3 = n + 1;
        while (n3 <= n2) {
            int n4;
            int n5;
            int n6 = n3;
            while ((n5 = nArray[n6]) < (n4 = nArray[n6 - 1])) {
                nArray[n6] = n4;
                nArray[n6 - 1] = n5;
                if (--n6 != n) continue;
            }
            ++n3;
        }
    }

    private static void _insertionSort(Object[] objectArray, int n, int n2, Comparator comparator) {
        int n3 = n + 1;
        while (n3 <= n2) {
            Object object;
            Object object2;
            int n4 = n3;
            while (comparator.compare(object2 = objectArray[n4], object = objectArray[n4 - 1]) < 0) {
                objectArray[n4] = object;
                objectArray[n4 - 1] = object2;
                if (--n4 != n) continue;
            }
            ++n3;
        }
    }

    private static void _insertionSort(Object[] objectArray, int[] nArray, int n, int n2, Comparator comparator) {
        int n3 = n + 1;
        while (n3 <= n2) {
            int n4;
            int n5;
            int n6 = n3;
            while (comparator.compare(objectArray[n5 = nArray[n6]], objectArray[n4 = nArray[n6 - 1]]) < 0) {
                nArray[n6] = n4;
                nArray[n6 - 1] = n5;
                if (--n6 != n) continue;
            }
            ++n3;
        }
    }

    private static void _qSort(int[] nArray, int n, int n2) {
        if (n2 - n > 9) {
            int n3 = Sort._qSortPartition(nArray, n, n2);
            Sort._qSort(nArray, n, n3);
            Sort._qSort(nArray, n3 + 1, n2);
        } else {
            Sort._insertionSort(nArray, n, n2);
        }
    }

    private static void _qSort(Object[] objectArray, int n, int n2, Comparator comparator) {
        if (n2 - n > 9) {
            int n3 = Sort._qSortPartition(objectArray, n, n2, comparator);
            Sort._qSort(objectArray, n, n3, comparator);
            Sort._qSort(objectArray, n3 + 1, n2, comparator);
        } else {
            Sort._insertionSort(objectArray, n, n2, comparator);
        }
    }

    private static void _qSort(Object[] objectArray, int[] nArray, int n, int n2, Comparator comparator) {
        if (n2 - n > 9) {
            int n3 = Sort._qSortPartition(objectArray, nArray, n, n2, comparator);
            Sort._qSort(objectArray, nArray, n, n3, comparator);
            Sort._qSort(objectArray, nArray, n3 + 1, n2, comparator);
        } else {
            Sort._insertionSort(objectArray, nArray, n, n2, comparator);
        }
    }

    private static int _qSortPartition(int[] nArray, int n, int n2) {
        int n3 = Sort._getRandomPartionIndex(n, n2);
        int n4 = nArray[n];
        nArray[n] = nArray[n3];
        nArray[n3] = n4;
        int n5 = nArray[n];
        int n6 = n - 1;
        int n7 = n2 + 1;
        while (true) {
            if (nArray[--n7] > n5) {
                continue;
            }
            while (nArray[++n6] < n5) {
            }
            if (n6 >= n7) break;
            n4 = nArray[n6];
            nArray[n6] = nArray[n7];
            nArray[n7] = n4;
        }
        return n7;
    }

    private static int _qSortPartition(Object[] objectArray, int n, int n2, Comparator comparator) {
        int n3 = Sort._getRandomPartionIndex(n, n2);
        Object object = objectArray[n];
        objectArray[n] = objectArray[n3];
        objectArray[n3] = object;
        Object object2 = objectArray[n];
        int n4 = n - 1;
        int n5 = n2 + 1;
        while (true) {
            if (comparator.compare(objectArray[--n5], object2) > 0) {
                continue;
            }
            while (comparator.compare(objectArray[++n4], object2) < 0) {
            }
            if (n4 >= n5) break;
            object = objectArray[n4];
            objectArray[n4] = objectArray[n5];
            objectArray[n5] = object;
        }
        return n5;
    }

    private static int _qSortPartition(Object[] objectArray, int[] nArray, int n, int n2, Comparator comparator) {
        int n3 = Sort._getRandomPartionIndex(n, n2);
        int n4 = nArray[n];
        nArray[n] = nArray[n3];
        nArray[n3] = n4;
        Object object = objectArray[nArray[n]];
        int n5 = n - 1;
        int n6 = n2 + 1;
        while (true) {
            if (comparator.compare(objectArray[nArray[--n6]], object) > 0) {
                continue;
            }
            while (comparator.compare(objectArray[nArray[++n5]], object) < 0) {
            }
            if (n5 >= n6) break;
            n4 = nArray[n5];
            nArray[n5] = nArray[n6];
            nArray[n6] = n4;
        }
        return n6;
    }

    private static void _reverse(int[] nArray, int n) {
        int n2 = 0;
        int n3 = n - 1;
        while (n2 < n3) {
            int n4 = nArray[n2];
            nArray[n2] = nArray[n3];
            nArray[n3] = n4;
            ++n2;
            --n3;
        }
    }

    public static int[] indirectQSort(Object[] objectArray, int n, Comparator comparator) {
        if (objectArray != null && n > 0) {
            if (n > objectArray.length) {
                throw new IllegalArgumentException();
            }
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = n2;
                ++n2;
            }
            Sort._qSort(objectArray, nArray, 0, n - 1, comparator);
            return nArray;
        }
        return new int[0];
    }

    public static void qSort(int[] nArray, int n, boolean bl) {
        if (nArray != null && n > 0) {
            if (n > nArray.length) {
                throw new IllegalArgumentException();
            }
            Sort._qSort(nArray, 0, n - 1);
            if (!bl) {
                Sort._reverse(nArray, n);
            }
        }
    }

    public static void qSort(Object[] objectArray, int n, Comparator comparator) {
        if (objectArray != null && n > 0) {
            if (n > objectArray.length) {
                throw new IllegalArgumentException();
            }
            Sort._qSort(objectArray, 0, n - 1, comparator);
        }
    }
}

