/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.ref;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Map;
import sqlj.runtime.AsciiStream;
import sqlj.runtime.BinaryStream;
import sqlj.runtime.CharacterStream;
import sqlj.runtime.SQLNullException;
import sqlj.runtime.UnicodeStream;
import sqlj.runtime.error.ProfileRefErrors;
import sqlj.runtime.profile.RTResultSet;

public class JdbcRTResultSet
implements RTResultSet {
    protected ResultSet rs;
    private boolean m_isClosed = false;
    private boolean m_isValidRow = false;
    private Map m_typeMap = null;
    private PreparedStatement m_ops = null;
    static /* synthetic */ Class class$java$sql$SQLData;

    public JdbcRTResultSet(ResultSet resultSet, PreparedStatement preparedStatement, Object object) {
        this.rs = resultSet;
        this.m_ops = preparedStatement;
        this.m_typeMap = (Map)object;
    }

    public JdbcRTResultSet(ResultSet resultSet) {
        this(resultSet, null, null);
    }

    public ResultSet getJDBCResultSet() {
        return this.rs;
    }

    public boolean next() throws SQLException {
        this.m_isValidRow = this.rs.next();
        return this.m_isValidRow;
    }

    public String getCursorName() throws SQLException {
        return this.rs.getCursorName();
    }

    public int findColumn(String string) throws SQLException {
        return this.rs.findColumn(string);
    }

    public String getString(int n) throws SQLException {
        return this.rs.getString(n);
    }

    public byte[] getBytes(int n) throws SQLException {
        return this.rs.getBytes(n);
    }

    public Blob getBlob(int n) throws SQLException {
        return this.rs.getBlob(n);
    }

    public Clob getClob(int n) throws SQLException {
        return this.rs.getClob(n);
    }

    public Ref getRef(int n) throws SQLException {
        return this.rs.getRef(n);
    }

    public Date getDate(int n) throws SQLException {
        return this.rs.getDate(n);
    }

    public Time getTime(int n) throws SQLException {
        return this.rs.getTime(n);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.rs.getTimestamp(n);
    }

    public boolean getBooleanNoNull(int n) throws SQLException {
        boolean bl = this.rs.getBoolean(n);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return bl;
    }

    public byte getByteNoNull(int n) throws SQLException {
        byte by = this.rs.getByte(n);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return by;
    }

    public short getShortNoNull(int n) throws SQLException {
        short s = this.rs.getShort(n);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return s;
    }

    public int getIntNoNull(int n) throws SQLException {
        int n2 = this.rs.getInt(n);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return n2;
    }

    public long getLongNoNull(int n) throws SQLException {
        long l = this.rs.getLong(n);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return l;
    }

    public float getFloatNoNull(int n) throws SQLException {
        float f = this.rs.getFloat(n);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return f;
    }

    public double getDoubleNoNull(int n) throws SQLException {
        double d = this.rs.getDouble(n);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return d;
    }

    public Boolean getBooleanWrapper(int n) throws SQLException {
        boolean bl = this.rs.getBoolean(n);
        return this.rs.wasNull() ? null : new Boolean(bl);
    }

    public Byte getByteWrapper(int n) throws SQLException {
        byte by = this.rs.getByte(n);
        return this.rs.wasNull() ? null : new Byte(by);
    }

    public Short getShortWrapper(int n) throws SQLException {
        short s = this.rs.getShort(n);
        return this.rs.wasNull() ? null : new Short(s);
    }

    public Integer getIntWrapper(int n) throws SQLException {
        int n2 = this.rs.getInt(n);
        return this.rs.wasNull() ? null : new Integer(n2);
    }

    public Long getLongWrapper(int n) throws SQLException {
        long l = this.rs.getLong(n);
        return this.rs.wasNull() ? null : new Long(l);
    }

    public Float getFloatWrapper(int n) throws SQLException {
        float f = this.rs.getFloat(n);
        return this.rs.wasNull() ? null : new Float(f);
    }

    public Double getDoubleWrapper(int n) throws SQLException {
        double d = this.rs.getDouble(n);
        return this.rs.wasNull() ? null : new Double(d);
    }

    public AsciiStream getAsciiStreamWrapper(int n) throws SQLException {
        InputStream inputStream = this.rs.getAsciiStream(n);
        return inputStream == null || this.rs.wasNull() ? null : new AsciiStream(inputStream);
    }

    public BinaryStream getBinaryStreamWrapper(int n) throws SQLException {
        InputStream inputStream = this.rs.getBinaryStream(n);
        return inputStream == null || this.rs.wasNull() ? null : new BinaryStream(inputStream);
    }

    public CharacterStream getCharacterStreamWrapper(int n) throws SQLException {
        Reader reader = this.rs.getCharacterStream(n);
        return reader == null || this.rs.wasNull() ? null : new CharacterStream(reader);
    }

    public UnicodeStream getUnicodeStreamWrapper(int n) throws SQLException {
        InputStream inputStream = this.rs.getUnicodeStream(n);
        return inputStream == null || this.rs.wasNull() ? null : new UnicodeStream(inputStream);
    }

    public Object getObject(int n, Class clazz) throws SQLException {
        if ((class$java$sql$SQLData == null ? (class$java$sql$SQLData = JdbcRTResultSet.class$("java.sql.SQLData")) : class$java$sql$SQLData).isAssignableFrom(clazz)) {
            if (this.m_typeMap != null && this.m_typeMap.containsValue(clazz)) {
                return this.rs.getObject(n, this.m_typeMap);
            }
            try {
                String string = (String)clazz.getField("_SQL_NAME").get(null);
                Hashtable hashtable = new Hashtable(1);
                hashtable.put(string, clazz);
                return this.rs.getObject(n, hashtable);
            }
            catch (Exception exception) {
                ProfileRefErrors.raise_INCOMPATIBLE_TYPE(clazz, class$java$sql$SQLData == null ? (class$java$sql$SQLData = JdbcRTResultSet.class$("java.sql.SQLData")) : class$java$sql$SQLData);
            }
        } else {
            Object object;
            Object object2 = object = this.m_typeMap == null ? this.rs.getObject(n) : this.rs.getObject(n, this.m_typeMap);
            if (object == null || clazz.isAssignableFrom(object.getClass())) {
                return object;
            }
            ProfileRefErrors.raise_INCOMPATIBLE_TYPE(clazz, object.getClass());
        }
        return null;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.rs.getBigDecimal(n, 0);
    }

    public int getFetchSize() throws SQLException {
        return this.rs.getFetchSize();
    }

    public void setFetchSize(int n) throws SQLException {
        this.rs.setFetchSize(n);
    }

    public int getSensitivity() throws SQLException {
        int n = this.rs.getType();
        return n == 1005 || n == 1004 ? n : 1006;
    }

    public boolean absolute(int n) throws SQLException {
        return this.rs.absolute(n);
    }

    public void afterLast() throws SQLException {
        this.rs.afterLast();
    }

    public void beforeFirst() throws SQLException {
        this.rs.beforeFirst();
    }

    public boolean first() throws SQLException {
        return this.rs.first();
    }

    public int getFetchDirection() throws SQLException {
        return this.rs.getFetchDirection();
    }

    public boolean isAfterLast() throws SQLException {
        return this.rs.isAfterLast();
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.rs.isBeforeFirst();
    }

    public boolean isFirst() throws SQLException {
        return this.rs.isFirst();
    }

    public boolean isLast() throws SQLException {
        return this.rs.isLast();
    }

    public boolean last() throws SQLException {
        return this.rs.last();
    }

    public boolean previous() throws SQLException {
        return this.rs.previous();
    }

    public boolean relative(int n) throws SQLException {
        return this.rs.relative(n);
    }

    public void setFetchDirection(int n) throws SQLException {
        this.rs.setFetchDirection(n);
    }

    public int getColumnCount() throws SQLException {
        return this.rs.getMetaData().getColumnCount();
    }

    public boolean isValidRow() throws SQLException {
        return this.m_isValidRow;
    }

    public boolean isClosed() throws SQLException {
        return this.m_isClosed;
    }

    public void close() throws SQLException {
        if (!this.m_isClosed) {
            this.m_isClosed = true;
            this.rs.close();
            if (this.m_ops != null) {
                this.m_ops.close();
                this.m_ops = null;
            }
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.rs.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.rs.clearWarnings();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

