/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.utils;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public final class SimpleStringBuffer {
    private char[] mValue;
    private int mLength;

    public SimpleStringBuffer() {
        this(16);
    }

    public SimpleStringBuffer(int n) {
        this.mValue = new char[n];
    }

    public SimpleStringBuffer(String string) {
        this(string.length() + 16);
        this.append(string);
    }

    public int length() {
        return this.mLength;
    }

    public int capacity() {
        return this.mValue.length;
    }

    public void ensureCapacity(int n) {
        if (n > this.mValue.length) {
            int n2 = (this.mValue.length + 1) * 2;
            if (n > n2) {
                n2 = n;
            }
            char[] cArray = new char[n2];
            System.arraycopy(this.mValue, 0, cArray, 0, this.mLength);
            this.mValue = cArray;
        }
    }

    private void printStackTrace(Throwable throwable) {
        PrintWriter printWriter = null;
        try {
            try {
                printWriter = new PrintWriter(new FileWriter("SimpleStringBuffer.log", true));
                throwable.printStackTrace(printWriter);
                printWriter.flush();
                printWriter.close();
            }
            catch (IOException iOException) {
                throw new Error("Could not write to SimpleStringBuffer's debug file : " + iOException);
            }
            Object var5_3 = null;
            if (printWriter != null) {
                printWriter.close();
            }
        }
        catch (Throwable throwable2) {
            Object var5_4 = null;
            if (printWriter != null) {
                printWriter.close();
            }
            throw throwable2;
        }
    }

    public void setLength(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n > this.mValue.length) {
            this.ensureCapacity(n);
        }
        if (this.mLength < n) {
            while (this.mLength < n) {
                this.mValue[this.mLength] = '\u0000';
                ++this.mLength;
            }
        } else {
            this.mLength = n;
        }
    }

    public char charAt(int n) {
        if (n < 0 || n >= this.mLength) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.mValue[n];
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0 || n >= this.mLength) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0 || n2 > this.mLength) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n < n2) {
            System.arraycopy(this.mValue, n, cArray, n3, n2 - n);
        }
    }

    public void setCharAt(int n, char c) {
        if (n < 0 || n >= this.mLength) {
            throw new StringIndexOutOfBoundsException(n);
        }
        this.mValue[n] = c;
    }

    public SimpleStringBuffer append(Object object) {
        return this.append(String.valueOf(object));
    }

    public SimpleStringBuffer append(String string) {
        int n;
        int n2;
        if (string == null) {
            string = String.valueOf(string);
        }
        if ((n2 = this.mLength + (n = string.length())) > this.mValue.length) {
            this.ensureCapacity(n2);
        }
        string.getChars(0, n, this.mValue, this.mLength);
        this.mLength = n2;
        return this;
    }

    public SimpleStringBuffer append(char[] cArray) {
        int n = cArray.length;
        int n2 = this.mLength + n;
        if (n2 > this.mValue.length) {
            this.ensureCapacity(n2);
        }
        System.arraycopy(cArray, 0, this.mValue, this.mLength, n);
        this.mLength = n2;
        return this;
    }

    public SimpleStringBuffer append(char[] cArray, int n, int n2) {
        int n3 = this.mLength + n2;
        if (n3 > this.mValue.length) {
            this.ensureCapacity(n3);
        }
        System.arraycopy(cArray, n, this.mValue, this.mLength, n2);
        this.mLength = n3;
        return this;
    }

    public SimpleStringBuffer append(boolean bl) {
        return this.append(String.valueOf(bl));
    }

    public SimpleStringBuffer append(char c) {
        int n = this.mLength + 1;
        if (n > this.mValue.length) {
            this.ensureCapacity(n);
        }
        this.mValue[this.mLength++] = c;
        return this;
    }

    public SimpleStringBuffer append(int n) {
        return this.append(String.valueOf(n));
    }

    public SimpleStringBuffer append(long l) {
        return this.append(String.valueOf(l));
    }

    public SimpleStringBuffer append(float f) {
        return this.append(String.valueOf(f));
    }

    public SimpleStringBuffer append(double d) {
        return this.append(String.valueOf(d));
    }

    public SimpleStringBuffer insert(int n, Object object) {
        return this.insert(n, String.valueOf(object));
    }

    public SimpleStringBuffer insert(int n, String string) {
        if (n < 0 || n > this.mLength) {
            throw new StringIndexOutOfBoundsException();
        }
        int n2 = string.length();
        int n3 = this.mLength + n2;
        if (n3 > this.mValue.length) {
            this.ensureCapacity(n3);
        }
        System.arraycopy(this.mValue, n, this.mValue, n + n2, this.mLength - n);
        string.getChars(0, n2, this.mValue, n);
        this.mLength = n3;
        return this;
    }

    public SimpleStringBuffer insert(int n, char[] cArray) {
        if (n < 0 || n > this.mLength) {
            throw new StringIndexOutOfBoundsException();
        }
        int n2 = cArray.length;
        int n3 = this.mLength + n2;
        if (n3 > this.mValue.length) {
            this.ensureCapacity(n3);
        }
        System.arraycopy(this.mValue, n, this.mValue, n + n2, this.mLength - n);
        System.arraycopy(cArray, 0, this.mValue, n, n2);
        this.mLength = n3;
        return this;
    }

    public SimpleStringBuffer insert(int n, boolean bl) {
        return this.insert(n, String.valueOf(bl));
    }

    public SimpleStringBuffer insert(int n, char c) {
        int n2 = this.mLength + 1;
        if (n2 > this.mValue.length) {
            this.ensureCapacity(n2);
        }
        System.arraycopy(this.mValue, n, this.mValue, n + 1, this.mLength - n);
        this.mValue[n] = c;
        this.mLength = n2;
        return this;
    }

    public SimpleStringBuffer insert(int n, int n2) {
        return this.insert(n, String.valueOf(n2));
    }

    public SimpleStringBuffer insert(int n, long l) {
        return this.insert(n, String.valueOf(l));
    }

    public SimpleStringBuffer insert(int n, float f) {
        return this.insert(n, String.valueOf(f));
    }

    public SimpleStringBuffer insert(int n, double d) {
        return this.insert(n, String.valueOf(d));
    }

    public SimpleStringBuffer delete(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.mLength) {
            n2 = this.mLength;
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        if (n3 > 0) {
            System.arraycopy(this.mValue, n + n3, this.mValue, n, this.mLength - n2);
            this.mLength -= n3;
        }
        return this;
    }

    public SimpleStringBuffer deleteCharAt(int n) {
        if (n < 0 || n >= this.mLength) {
            throw new StringIndexOutOfBoundsException();
        }
        System.arraycopy(this.mValue, n + 1, this.mValue, n, this.mLength - n - 1);
        --this.mLength;
        return this;
    }

    public SimpleStringBuffer replace(int n, int n2, String string) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.mLength) {
            n2 = this.mLength;
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException();
        }
        int n3 = string.length();
        int n4 = this.mLength + n3 - (n2 - n);
        if (n4 > this.mValue.length) {
            this.ensureCapacity(n4);
        }
        System.arraycopy(this.mValue, n2, this.mValue, n + n3, this.mLength - n2);
        string.getChars(0, n3, this.mValue, n);
        this.mLength = n4;
        return this;
    }

    public String toString() {
        return new String(this.getValue(), 0, this.length());
    }

    public char[] getValue() {
        return this.mValue;
    }
}

