/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.chooser.font.FontPane;
import oracle.bali.inspector.ExtendedPropertyEditor;

public class FontEditor
extends PropertyEditorSupport
implements ExtendedPropertyEditor {
    private static final String _KEY_STRING = "FONT_EDITOR_STRING";
    private static final Border _sBORDER = new EmptyBorder(8, 8, 8, 8);
    private FontPane _customFontPane;
    private FontPane _tearOffFontPane;
    private JPanel _customEditor;
    private JPanel _tearOffEditor;
    private PropertyChangeListener _listener;

    public void setValue(Object object) {
        Font font = (Font)object;
        super.setValue(font);
        if (this._customFontPane != null) {
            this._customFontPane.setCurrentFont(font);
        }
        if (this._tearOffFontPane != null) {
            this._tearOffFontPane.setCurrentFont(font);
        }
    }

    public boolean isPaintable() {
        return true;
    }

    public final void paintValue(Graphics graphics, Rectangle rectangle) {
        this.paintValue(this.getValue(), graphics, Locale.getDefault(), rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public String getJavaInitializationString() {
        Font font = this._getFont();
        return "new java.awt.Font(\"" + font.getFamily() + "\", " + font.getStyle() + ", " + font.getSize() + ")";
    }

    public final String getAsText() {
        return null;
    }

    public final void setAsText(String string) throws IllegalArgumentException {
    }

    public Component getCustomEditor() {
        if (this._customEditor == null) {
            FontPane fontPane = new FontPane();
            fontPane.setStyleButtonMask(3);
            fontPane.setAlignmentButtonMask(0);
            fontPane.setColorComponentMask(0);
            if (this._listener == null) {
                this._listener = new Listener();
            }
            fontPane.addPropertyChangeListener(this._listener);
            this._customFontPane = fontPane;
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(_sBORDER);
            jPanel.add("Center", (Component)fontPane);
            this._customEditor = jPanel;
        }
        return this._customEditor;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Object textToValue(String string, Locale locale) throws IllegalArgumentException {
        return null;
    }

    public String valueToText(Object object, Locale locale) {
        return "null";
    }

    public void paintValue(Object object, Graphics graphics, Locale locale, int n, int n2, int n3, int n4) {
        Font font = graphics.getFont();
        Font font2 = (Font)object;
        if (font2 == null) {
            font2 = font;
        }
        if (font2 != null) {
            graphics.setFont(font2);
            FontMetrics fontMetrics = graphics.getFontMetrics(font2);
            int n5 = fontMetrics.getAscent();
            int n6 = n5 + fontMetrics.getDescent();
            String string = ResourceBundle.getBundle("oracle.bali.inspector.resource.InspectorBundle", locale).getString(_KEY_STRING);
            graphics.drawString(string, n, n2 + (n4 - n6) / 2 + n5);
        }
        graphics.setFont(font);
    }

    public boolean supportsSmallCustomEditor() {
        return true;
    }

    public Component getSmallCustomEditor() {
        if (this._tearOffEditor == null) {
            FontPane fontPane = new FontPane();
            fontPane.setStyleButtonMask(3);
            fontPane.setAlignmentButtonMask(0);
            fontPane.setColorComponentMask(0);
            fontPane.setPreviewAreaVisible(false);
            if (this._listener == null) {
                this._listener = new Listener();
            }
            fontPane.addPropertyChangeListener(this._listener);
            this._tearOffFontPane = fontPane;
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(_sBORDER);
            jPanel.add("Center", (Component)fontPane);
            this._tearOffEditor = jPanel;
        }
        return this._tearOffEditor;
    }

    public FontPane getTearOffFontPane() {
        Component component = this.getSmallCustomEditor();
        return this._tearOffFontPane;
    }

    public FontPane getAdvancedFontPane() {
        Component component = this.getCustomEditor();
        return this._customFontPane;
    }

    private Font _getFont() {
        return (Font)this.getValue();
    }

    private void _setValue(Object object) {
        super.setValue(object);
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Font font = null;
            font = propertyChangeEvent.getSource() == FontEditor.this._customFontPane ? FontEditor.this._customFontPane.getCurrentFont() : FontEditor.this._tearOffFontPane.getCurrentFont();
            FontEditor.this._setValue(font);
        }
    }
}

