/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.mom.xml;

import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.Collator;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.mom.DefinitionManager;
import oracle.jbo.mom.xml.DTAttrsHolder;
import oracle.jbo.mom.xml.DTDVersion;
import oracle.jbo.mom.xml.DefPersistable;
import oracle.jbo.mom.xml.DefPersistenceException;
import oracle.jbo.mom.xml.DefWriter;
import oracle.jbo.mom.xml.PersistentDefinition;
import oracle.xml.parser.v2.AttrDecl;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.ElementDecl;

public class XMLOutputStream
implements DefWriter {
    public static String NEW_LINE;
    public static final String LT_STR = "&#60;";
    public static final String GT_STR = "&#62;";
    public static final String AMP_STR = "&#38;";
    public static final String APOS_STR = "&#39;";
    public static final String QUOT_STR = "&#34;";
    public static final String SPACE_STR = " ";
    public static final int MAX_CONT_STRING_SIZE = 255;
    public static final int MAX_STRING_LINE = 60;
    public static final int LT = 60;
    public static final int GT = 62;
    public static final int AMP = 38;
    public static final int APOS = 39;
    public static final int QUOT = 34;
    public static final int SPACE_CHAR = 32;
    public static final int NEW_LINE_CHAR = 10;
    protected String mIndentStr;
    protected StringBuffer mBuffer;
    private OutputStreamWriter mFOS;
    private String mXMLFileName;
    protected DTAttrsHolder mDTAttrs;
    private static boolean mDefAttributes;
    private DTD mDTD;
    private ElementDecl mCurElemDecl;
    private String mIanaEncoding;
    private String mJdkEncoding;
    private DefinitionManager mDefMgr;
    private boolean mDoneTrace;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    private /* synthetic */ void $init$() {
        this.mIndentStr = "";
        this.mBuffer = null;
        this.mFOS = null;
        this.mXMLFileName = null;
        this.mDTAttrs = null;
        this.mDTD = null;
        this.mCurElemDecl = null;
        this.mIanaEncoding = "ISO-8859-1";
        this.mJdkEncoding = null;
        this.mDoneTrace = false;
    }

    static {
        mDefAttributes = false;
        NEW_LINE = System.getProperty("line.separator");
        if (NEW_LINE == null) {
            NEW_LINE = "\r\n";
        }
    }

    public XMLOutputStream(DefinitionManager definitionManager) {
        this.$init$();
        this.mDefMgr = definitionManager;
        if (this.mDTD == null) {
            try {
                this.mDTD = definitionManager.getJboDTD();
            }
            catch (Exception exception) {
                this.mDTD = null;
            }
        }
    }

    public void prologue(DefPersistable defPersistable) {
        this.saveDesignTimeAttrs();
        this.mDTAttrs = new DTAttrsHolder();
        String string = defPersistable.getFullName();
        if (string != null) {
            string = this.stripParentName(string);
        }
        String string2 = defPersistable.getXMLElementTag();
        if (this.mDTD != null) {
            this.mCurElemDecl = this.mDTD.findElementDecl(string2);
        }
        this.mBuffer.append(this.mIndentStr).append("<").append(string2);
        this.setIndentation();
        if (string != null && string.length() > 0) {
            this.mBuffer.append(NEW_LINE).append(this.mIndentStr).append("Name=\"").append(string).append("\"");
        }
    }

    public void prologue(PersistentDefinition persistentDefinition) {
        if (this.mDTAttrs == null) {
            this.mDTAttrs = new DTAttrsHolder();
        } else {
            this.mDTAttrs.writeToXML(this);
            this.mDTAttrs = new DTAttrsHolder();
        }
        String string = persistentDefinition.getXMLElementTag();
        this.mBuffer.append(this.mIndentStr).append("<").append(string);
        this.setIndentation();
    }

    public void epilogue(DefPersistable defPersistable) {
        this.saveDesignTimeAttrs();
        this.resetIndentation();
        this.mBuffer.append(this.mIndentStr).append("</").append(defPersistable.getXMLElementTag());
        this.mBuffer.append(">").append(NEW_LINE);
    }

    protected void saveDesignTimeAttrs() {
        if (this.mDTAttrs != null) {
            this.mDTAttrs.writeToXML(this);
            this.mDTAttrs = null;
        }
    }

    public void epilogue(PersistentDefinition persistentDefinition) {
        this.resetIndentation();
        this.mBuffer.append(this.mIndentStr).append("</").append(persistentDefinition.getXMLElementTag());
        this.mBuffer.append(">").append(NEW_LINE);
    }

    public boolean writeObject(String string, Object object) {
        if (object instanceof DefPersistable) {
            try {
                ((DefPersistable)object).writeObject(this);
                boolean bl = true;
                return bl;
            }
            catch (DefPersistenceException defPersistenceException) {
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public boolean writeTable(DefPersistable defPersistable, String string, HashMap hashMap) {
        return this.writeTable(defPersistable, string, "Property", "Name", "Value", hashMap);
    }

    public boolean writeTable(DefPersistable defPersistable, String string, Hashtable hashtable) {
        return this.writeTable(defPersistable, string, "Property", "Name", "Value", JboEnvUtil.convertHashTableToHashMap(hashtable));
    }

    public boolean writeTable(DefPersistable defPersistable, String string, String string2, String string3, String string4, Hashtable hashtable) {
        return this.writeTable(defPersistable, string, string2, string3, string4, JboEnvUtil.convertHashTableToHashMap(hashtable));
    }

    public boolean writeTable(DefPersistable defPersistable, String string, String string2, String string3, String string4, HashMap hashMap) {
        if (hashMap == null || hashMap.size() <= 0) {
            return true;
        }
        this.mBuffer.append(this.mIndentStr).append("<").append(string).append(">").append(NEW_LINE);
        this.setIndentation();
        Object[] objectArray = hashMap.keySet().toArray();
        Arrays.sort(objectArray, Collator.getInstance());
        int n = 0;
        while (n < objectArray.length) {
            String string5 = (String)objectArray[n];
            string5 = this.checkSpecialChars(string5);
            String string6 = (String)hashMap.get((Object)string5);
            string6 = this.checkSpecialChars(string6);
            this.mBuffer.append(this.mIndentStr).append("<").append(string2).append(SPACE_STR).append(string3).append(" =\"").append(string5).append("\" ").append(string4).append(" =\"").append(string6).append("\" />").append(NEW_LINE);
            ++n;
        }
        this.resetIndentation();
        this.mBuffer.append(this.mIndentStr).append("</").append(string).append(">").append(NEW_LINE);
        return true;
    }

    protected String checkSpecialChars(String string) {
        string = this.checkSpecialChar(string, '&', "&amp;");
        string = this.checkSpecialChar(string, '\"', "&quot;");
        string = this.checkSpecialChar(string, '>', "&gt;");
        string = this.checkSpecialChar(string, '<', "&lt;");
        string = this.checkSpecialChar(string, '\n', "&#xa;");
        string = this.checkSpecialChar(string, '\t', "&#x9;");
        string = this.checkSpecialChar(string, '\r', "&#xd;");
        return string;
    }

    protected String checkSpecialChar(String string, char c, String string2) {
        int n = string.indexOf(c);
        if (n < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        if (n == 0) {
            stringBuffer.append(string2);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "" + c, false);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            stringBuffer.append(string3);
            if (!stringTokenizer.hasMoreTokens() && !string.endsWith(string3 + c)) continue;
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public boolean writeString(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        string2 = XMLOutputStream.createEscapes(string2, false);
        if (string.charAt(0) == '_') {
            this.mDTAttrs.insert(string, string2);
            return true;
        }
        if (this.isDefaultValue(string, string2)) {
            return true;
        }
        this.doWriteString(string, string2);
        return true;
    }

    protected void doWriteString(String string, String string2) {
        this.mBuffer.append(NEW_LINE).append(this.mIndentStr).append(string).append("=\"").append(string2).append("\"");
    }

    protected boolean isDefaultValue(String string, String string2) {
        String string3;
        AttrDecl attrDecl;
        return this.mDTD != null && this.mCurElemDecl != null && (attrDecl = this.mCurElemDecl.findAttrDecl(string)) != null && (string3 = attrDecl.getDefaultValue()) != null && string3.equals(string2);
    }

    public boolean writeUserString(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        string2 = XMLOutputStream.createEscapes(string2, true);
        if (string.charAt(0) == '_') {
            this.mDTAttrs.insert(string, string2);
            return true;
        }
        this.mBuffer.append(NEW_LINE).append(this.mIndentStr).append(string).append("=\"").append(string2).append("\"");
        return true;
    }

    public boolean writeStringArray(String string, Iterator iterator) {
        if (string == null || iterator == null) {
            return false;
        }
        if (string.charAt(0) == '_') {
            this.mDTAttrs.insert(string, iterator);
        } else {
            this.mBuffer.append(this.mIndentStr).append("<AttrArray Name=\"").append(string).append("\">").append(NEW_LINE);
            this.setIndentation();
            while (iterator.hasNext()) {
                String string2 = "";
                Object object = iterator.next();
                if (object instanceof DefPersistable) {
                    string2 = ((DefPersistable)object).getFullName();
                } else if (object != null) {
                    string2 = object.toString();
                }
                string2 = XMLOutputStream.createEscapes(string2, false);
                this.mBuffer.append(this.mIndentStr).append("<Item Value=\"").append(string2).append("\" />").append(NEW_LINE);
            }
            this.resetIndentation();
            this.mBuffer.append(this.mIndentStr).append("</AttrArray>").append(NEW_LINE);
        }
        return true;
    }

    public boolean writeStringArray(String string, Enumeration enumeration) {
        if (string == null || enumeration == null) {
            return false;
        }
        if (string.charAt(0) == '_') {
            this.mDTAttrs.insert(string, enumeration);
        } else {
            this.mBuffer.append(this.mIndentStr).append("<AttrArray Name=\"").append(string).append("\">").append(NEW_LINE);
            this.setIndentation();
            while (enumeration.hasMoreElements()) {
                String string2 = "";
                Object e = enumeration.nextElement();
                if (e instanceof DefPersistable) {
                    string2 = ((DefPersistable)e).getFullName();
                } else if (e != null) {
                    string2 = e.toString();
                }
                this.mBuffer.append(this.mIndentStr).append("<Item Value=\"").append(string2).append("\" />").append(NEW_LINE);
            }
            this.resetIndentation();
            this.mBuffer.append(this.mIndentStr).append("</AttrArray>").append(NEW_LINE);
        }
        return true;
    }

    public boolean writeInt(String string, int n) {
        String string2 = String.valueOf(n);
        return this.writeString(string, string2);
    }

    public boolean writeShort(String string, short s) {
        String string2 = String.valueOf(s);
        return this.writeString(string, string2);
    }

    public boolean writeLong(String string, long l) {
        String string2 = String.valueOf(l);
        return this.writeString(string, string2);
    }

    public boolean writeFloat(String string, float f) {
        String string2 = String.valueOf(f);
        return this.writeString(string, string2);
    }

    public boolean writeDouble(String string, double d) {
        String string2 = String.valueOf(d);
        return this.writeString(string, string2);
    }

    public boolean writeBoolean(String string, boolean bl) {
        String string2 = String.valueOf(bl);
        return this.writeString(string, string2);
    }

    public boolean writeByte(String string, byte by) {
        String string2 = String.valueOf(by);
        return this.writeString(string, string2);
    }

    public boolean writeChar(String string, char c) {
        return true;
    }

    public void openConnection(String string, String string2) throws DefPersistenceException {
        try {
            this.mXMLFileName = string;
            this.mFOS = new FileWriter(string);
            this.mBuffer = new StringBuffer(1024);
            this.writeFileHeader(string2);
        }
        catch (IOException iOException) {
            throw new DefPersistenceException(iOException);
        }
    }

    public void closeConnection() throws DefPersistenceException {
        block5: {
            try {
                if (this.isConnectionOpen()) {
                    if (this.mBuffer.length() > 0) {
                        this.mFOS.write(this.mBuffer.toString());
                        this.mFOS.flush();
                        this.mFOS.close();
                        this.mFOS = null;
                    }
                    break block5;
                }
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = XMLOutputStream.class$("oracle.jbo.CSMessageBundle");
                }
                throw new DefPersistenceException(clazz, "25307", null);
            }
            catch (IOException iOException) {
                throw new DefPersistenceException(iOException);
            }
        }
    }

    public boolean isConnectionOpen() {
        return this.mFOS != null;
    }

    public Object getConnection() {
        return this.mFOS;
    }

    public void commit() throws DefPersistenceException {
        if (!this.isConnectionOpen()) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = XMLOutputStream.class$("oracle.jbo.CSMessageBundle");
            }
            throw new DefPersistenceException(clazz, "25307", null);
        }
        this.closeConnection();
        this.openConnection(this.mXMLFileName, "JboPackage");
    }

    public void rollback() throws DefPersistenceException {
        if (!this.isConnectionOpen()) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = XMLOutputStream.class$("oracle.jbo.CSMessageBundle");
            }
            throw new DefPersistenceException(clazz, "25307", null);
        }
        this.openConnection(this.mXMLFileName, "JboPackage");
    }

    public void setIndentation() {
        this.mIndentStr = this.mIndentStr + "   ";
    }

    public void resetIndentation() {
        int n = this.mIndentStr.length();
        if (n > 3) {
            this.mIndentStr = this.mIndentStr.substring(0, n - 3);
        } else if (n == 3) {
            this.mIndentStr = "";
        }
    }

    public void writeFileHeader(String string) throws DefPersistenceException {
        this.mBuffer.append("<?xml version='1.0' encoding='").append(this.getIanaEncoding()).append("' ?>").append(NEW_LINE).append("<!DOCTYPE ").append(string).append(" SYSTEM \"").append(DTDVersion.getLatestXMLVersion(this.mDefMgr)).append("\">").append(NEW_LINE).append(NEW_LINE);
        if (!this.mDoneTrace) {
            String string2 = this.mBuffer.toString();
            this.mDoneTrace = true;
        }
    }

    public void writeObject(DefPersistable defPersistable) throws DefPersistenceException {
        this.prologue(defPersistable);
        defPersistable.writeContents(this);
        this.mBuffer.append(" >").append(NEW_LINE);
        try {
            defPersistable.writeChildren(this);
        }
        catch (Exception exception) {
            System.out.println("ERROR: " + exception.toString() + " occurred while writing children of " + defPersistable.getClass().getName() + SPACE_STR + defPersistable.getFullName());
        }
        this.epilogue(defPersistable);
    }

    public void writeObject(PersistentDefinition persistentDefinition) throws DefPersistenceException {
        this.prologue(persistentDefinition);
        persistentDefinition.writeContents(this);
        this.mBuffer.append(" >").append(NEW_LINE);
        try {
            persistentDefinition.writeChildren(this);
        }
        catch (Exception exception) {
            System.out.println("ERROR: " + exception.toString() + " occurred while writing children of " + persistentDefinition.getClass().getName());
        }
        this.epilogue(persistentDefinition);
    }

    public void writeUserObject(String string, String string2) throws DefPersistenceException {
        this.mBuffer.append(this.mIndentStr).append("<").append(string).append("><![CDATA[").append(NEW_LINE);
        this.mBuffer.append(string2);
        this.mBuffer.append(NEW_LINE).append(this.mIndentStr).append("]]></").append(string);
        this.mBuffer.append(">").append(NEW_LINE);
    }

    public void writeComment(String string) throws DefPersistenceException {
        if (string != null && string.length() > 0) {
            int n = string.lastIndexOf(10);
            if (n == string.length() - 1) {
                string = string.substring(0, n);
            }
            this.mBuffer.append(this.mIndentStr).append("<!--").append(string).append("-->").append(NEW_LINE).append(NEW_LINE);
        }
    }

    private String stripParentName(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public void saveAs(String string) throws DefPersistenceException {
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(this.mBuffer.toString());
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new DefPersistenceException(iOException);
        }
    }

    public void saveAsRunTimeXML(String string) throws DefPersistenceException {
        try {
            FileWriter fileWriter = new FileWriter(string);
            StringBuffer stringBuffer = XMLOutputStream.removeDesignTime(this.mBuffer);
            fileWriter.write(stringBuffer.toString());
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new DefPersistenceException(iOException);
        }
    }

    public static StringBuffer removeDesignTime(StringBuffer stringBuffer) {
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), " \t\r\n", true);
        StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.length());
        String string = null;
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (string.equalsIgnoreCase("<DesignTime>")) {
                bl = true;
            } else if (string.equalsIgnoreCase("</DesignTime>")) {
                bl = false;
                continue;
            }
            if (bl) continue;
            stringBuffer2.append(string);
        }
        return stringBuffer2;
    }

    public void saveToOutputStream(OutputStream outputStream) throws DefPersistenceException {
        try {
            OutputStreamWriter outputStreamWriter = null;
            outputStreamWriter = this.mJdkEncoding != null ? new OutputStreamWriter(outputStream, this.mJdkEncoding) : new OutputStreamWriter(outputStream);
            outputStreamWriter.write(this.mBuffer.toString());
            outputStreamWriter.flush();
        }
        catch (IOException iOException) {
            throw new DefPersistenceException(iOException);
        }
    }

    public void openConnection(String string) throws DefPersistenceException {
        try {
            this.mBuffer = new StringBuffer(1024);
            this.writeFileHeader(string);
        }
        catch (Exception exception) {
            throw new DefPersistenceException(exception);
        }
    }

    public String breakStr(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, SPACE_STR);
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ((n += string2.length()) > 60) {
                stringBuffer.append(NEW_LINE);
                n = 0;
            }
            stringBuffer.append(SPACE_STR).append(string2);
        }
        return stringBuffer.toString();
    }

    protected static String createEscapes(String string, boolean bl) {
        char c = '\u0000';
        int n = 0;
        boolean bl2 = false;
        int n2 = string.length();
        if (n2 >= 255) {
            bl2 = true;
        }
        StringBuffer stringBuffer = new StringBuffer(n2 + 255);
        int n3 = 0;
        while (n3 < n2) {
            ++n;
            c = string.charAt(n3);
            switch (c) {
                case '\"': {
                    stringBuffer.append(QUOT_STR);
                    break;
                }
                case '\'': {
                    stringBuffer.append(APOS_STR);
                    break;
                }
                case '<': {
                    stringBuffer.append(LT_STR);
                    break;
                }
                case '>': {
                    stringBuffer.append(GT_STR);
                    break;
                }
                case '&': {
                    stringBuffer.append(AMP_STR);
                    break;
                }
                case '\n': {
                    stringBuffer.append(NEW_LINE);
                    n = 0;
                    break;
                }
                case ' ': {
                    if (bl2 && !bl && n > 60) {
                        stringBuffer.append(NEW_LINE);
                        n = 0;
                        break;
                    }
                    stringBuffer.append(SPACE_STR);
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static URL createURL(String string) throws IOException {
        URL uRL = null;
        try {
            File file = new File(string);
            String string2 = file.getAbsolutePath();
            String string3 = System.getProperty("file.separator");
            if (string3.length() == 1) {
                char c = string3.charAt(0);
                if (c != '/') {
                    string2 = string2.replace(c, '/');
                }
                if (string2.charAt(0) != '/') {
                    string2 = '/' + string2;
                }
            }
            string2 = "file://" + string2;
            uRL = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Cannot create url for: " + string);
            malformedURLException.printStackTrace();
        }
        Diagnostic.println("URL for XML file is: '" + uRL + "'");
        return uRL;
    }

    public void saveToOutputStream(Writer writer) throws DefPersistenceException {
        try {
            writer.write(this.mBuffer.toString());
            writer.flush();
        }
        catch (IOException iOException) {
            throw new DefPersistenceException(iOException);
        }
    }

    public String getIanaEncoding() {
        return this.mIanaEncoding;
    }

    public void setIanaEncoding(String string) {
        this.mIanaEncoding = string;
    }

    public String getJdkEncoding() {
        return this.mJdkEncoding;
    }

    public void setJdkEncoding(String string) {
        this.mJdkEncoding = string;
    }

    public char[] toCharArray() {
        return this.mBuffer.toString().toCharArray();
    }

    public boolean writeStringArrayElement(String string, Iterator iterator) {
        if (string == null || iterator == null) {
            return false;
        }
        if (string.charAt(0) == '_') {
            this.mDTAttrs.insert(string, iterator);
        } else {
            this.mBuffer.append(this.mIndentStr).append("<").append(string).append(">").append(NEW_LINE);
            this.setIndentation();
            while (iterator.hasNext()) {
                String string2 = "";
                Object object = iterator.next();
                if (object instanceof DefPersistable) {
                    string2 = ((DefPersistable)object).getFullName();
                } else if (object != null) {
                    string2 = object.toString();
                }
                this.mBuffer.append(this.mIndentStr).append("<Item Value=\"").append(string2).append("\" />").append(NEW_LINE);
            }
            this.resetIndentation();
            this.mBuffer.append(this.mIndentStr).append("</" + string + ">").append(NEW_LINE);
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

