/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo;

import oracle.jbo.JboEvent;
import oracle.jbo.JboException;
import oracle.jbo.NavigatableRowIterator;
import oracle.jbo.Row;
import oracle.jbo.RowSetIterator;

public class NavigationEvent
extends JboEvent {
    static final long serialVersionUID = -3897260159324375339L;
    private Row dstRow;
    private Row srcRow;

    public NavigationEvent(NavigatableRowIterator navigatableRowIterator, Row row, Row row2) {
        super(navigatableRowIterator);
        this.dstRow = row2;
        this.srcRow = row;
    }

    public final Row getRow() {
        return this.dstRow;
    }

    public final int getRowIndex() {
        return this.getSource() != null ? ((NavigatableRowIterator)this.getSource()).getRangeIndexOf(this.dstRow) : -1;
    }

    public final Row getPreviousRow() {
        return this.srcRow;
    }

    public final int getPreviousRowIndex() {
        int n = -1;
        try {
            if (this.getSource() != null) {
                n = ((NavigatableRowIterator)this.getSource()).getRangeIndexOf(this.srcRow);
            }
        }
        catch (JboException jboException) {
            n = -1;
        }
        return n;
    }

    public String toString() {
        if (this.getSource() instanceof RowSetIterator) {
            return "[NavigationEvent: " + ((RowSetIterator)this.getSource()).getName() + " From " + this.getPreviousRowIndex() + " to " + this.getRowIndex() + "]";
        }
        return "[NavigationEvent: From " + this.getPreviousRowIndex() + " to " + this.getRowIndex() + "]";
    }
}

