/*
 * Decompiled with CFR 0.152.
 */
package oracle.ord.im;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import oracle.ord.im.OrdMultipartWrapper;

public class OrdMultipartFilter
implements Filter {
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String MP_FORM_DATA_ENTITY = "multipart/form-data";
    private FilterConfig m_config = null;
    private int m_maxMemory = -1;
    private String m_tempDir = null;

    public void destroy() {
        this.m_config = null;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        String string = httpServletRequest.getHeader(CONTENT_TYPE_HEADER);
        if (string == null || !string.startsWith(MP_FORM_DATA_ENTITY)) {
            filterChain.doFilter(servletRequest, servletResponse);
        } else {
            OrdMultipartWrapper ordMultipartWrapper = new OrdMultipartWrapper(httpServletRequest, this.m_maxMemory, this.m_tempDir);
            filterChain.doFilter((ServletRequest)ordMultipartWrapper, servletResponse);
            ordMultipartWrapper.release();
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.m_config = filterConfig;
        this.m_tempDir = this.m_config.getInitParameter("tempDir");
        String string = this.m_config.getInitParameter("maxMemeory");
        if (string != null) {
            this.m_maxMemory = Integer.parseInt(string);
        }
    }
}

