/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.jsp;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.ResourceBundle;
import oracle.jsp.parse.Jsp2JavaParms;
import oracle.jsp.provider.JspCompileException;
import oracle.jsp.provider.JspCompiler;
import oracle.jsp.provider.JspResourceProvider;
import oracle.ojc.compiler.Compiler;
import oracle.ojc.compiler.SystemLog;
import oracle.ojc.interfaces.Log;

public class JspOjcCompiler
implements JspCompiler {
    public static final String COMPILE_PATH = "classpath";
    private String classPath;
    private boolean needsInit = true;
    private static final ResourceBundle m_JspOjcCompilerResourceBundle;
    private static /* synthetic */ Class class$oracle$jdevimpl$jsp$JspOjcCompilerRes;

    public void init(Hashtable initParams) {
        if (this.needsInit) {
            this.classPath = (String)initParams.get(COMPILE_PATH);
            this.needsInit = false;
        }
    }

    public synchronized long compile(String source, int language, String encoding, JspResourceProvider provider, JspResourceProvider appClassProvider, Jsp2JavaParms params) throws JspCompileException {
        if (language != 0) {
            throw new JspCompileException(m_JspOjcCompilerResourceBundle.getString("bad_lang"));
        }
        ByteArrayOutputStream compileOut = new ByteArrayOutputStream();
        if ((source = provider.translateToAbsolutePath(source)) == null) {
            throw new JspCompileException(m_JspOjcCompilerResourceBundle.getString("no_files_rep"));
        }
        String appClassPath = this.generateAppClassPath(appClassProvider);
        String tagFileRepositoryRoot = null;
        if (params != null && params.tagFileRepository != null) {
            tagFileRepositoryRoot = params.tagFileRepository.getRepositoryRoot();
            appClassPath = appClassPath == null ? tagFileRepositoryRoot : appClassPath + File.pathSeparator + tagFileRepositoryRoot;
        }
        int index = 0;
        String[] argv = new String[encoding != null ? 7 : 5];
        if (encoding != null) {
            argv[index++] = "-encoding";
            argv[index++] = encoding;
        }
        argv[index++] = "-g";
        argv[index++] = "-classpath";
        argv[index] = System.getProperty("java.class.path");
        if (this.classPath != null) {
            int n = index;
            argv[n] = argv[n] + File.pathSeparator + this.classPath;
        }
        if (appClassPath != null) {
            int n = index;
            argv[n] = argv[n] + File.pathSeparator + appClassPath;
        }
        int n = ++index;
        ++index;
        argv[n] = source;
        PrintStream stdOut = System.out;
        System.setOut(new PrintStream(compileOut, true));
        try {
            Compiler.main((String[])argv, (Log)new SystemLog());
        }
        catch (Throwable t) {
            // empty catch block
        }
        System.setOut(stdOut);
        String cs = compileOut.toString();
        if (cs.indexOf(m_JspOjcCompilerResourceBundle.getString("error")) != -1) {
            throw new JspCompileException(JspOjcCompiler.formatCompilerErrors(source, cs));
        }
        return new File(JspOjcCompiler.stripExtension(source) + ".class").lastModified();
    }

    public long compile(String source, int language, String encoding, JspResourceProvider provider, JspResourceProvider appClassProvider) throws JspCompileException {
        return this.compile(source, language, encoding, provider, appClassProvider, null);
    }

    private static String stripExtension(String s) {
        return s.substring(0, s.lastIndexOf(46));
    }

    private String generateAppClassPath(JspResourceProvider provider) {
        String classPath = null;
        try {
            classPath = provider.getAbsolutePath("/WEB-INF/classes");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String[] theJars = provider.listClassRepositories("/WEB-INF/lib");
        if (theJars == null) {
            return classPath;
        }
        int i = 0;
        while (i < theJars.length) {
            String jarPath = null;
            try {
                jarPath = provider.getAbsolutePath("/WEB-INF/lib/" + theJars[i]);
                classPath = classPath == null ? jarPath : classPath + File.pathSeparator + jarPath;
            }
            catch (Throwable t) {
                // empty catch block
            }
            ++i;
        }
        return classPath;
    }

    private static String formatCompilerErrors(String fName, String compilerOutput) {
        int nextI;
        int estLength = 2 * compilerOutput.length();
        StringBuffer formattedString = new StringBuffer(estLength);
        formattedString.append("<H3>");
        formattedString.append(m_JspOjcCompilerResourceBundle.getString("compile_error_hdr"));
        formattedString.append(fName);
        formattedString.append("</H3>\n<TABLE BORDER=1><TR><TH>");
        formattedString.append(m_JspOjcCompilerResourceBundle.getString("line_number_heading"));
        formattedString.append("</TH><TH>");
        formattedString.append(m_JspOjcCompilerResourceBundle.getString("error_heading"));
        formattedString.append("</TH></TR>\n");
        int currI = 0;
        String error = m_JspOjcCompilerResourceBundle.getString("error");
        String errors = m_JspOjcCompilerResourceBundle.getString("errors");
        while ((nextI = JspOjcCompiler.findEndOfErrorStatement(compilerOutput, currI)) != -1) {
            if (nextI != currI) {
                int startL = compilerOutput.indexOf(58, currI);
                while (startL != -1 && !Character.isDigit(compilerOutput.charAt(startL + 1))) {
                    startL = compilerOutput.indexOf(58, startL + 1);
                }
                if (startL != -1) {
                    int endL = compilerOutput.indexOf(58, startL + 1);
                    String line = compilerOutput.substring(startL + 1, endL);
                    int startM = compilerOutput.indexOf(58, endL + 1);
                    String message = JspOjcCompiler.formatErrorMessage(compilerOutput.substring(startM + 1, nextI).trim());
                    formattedString.append("<TR><TD VALIGN=TOP><CENTER>");
                    formattedString.append(line);
                    formattedString.append("<CENTER></TD><TD VALIGN=TOP><PRE>");
                    formattedString.append(message);
                    formattedString.append("</PRE></TD></TR>\n");
                } else {
                    String message = JspOjcCompiler.formatErrorMessage(compilerOutput.substring(currI, nextI).trim());
                    int length = message.length();
                    int i = 0;
                    while (i < length && Character.isDigit(message.charAt(i))) {
                        ++i;
                    }
                    while (i < length && Character.isWhitespace(message.charAt(i))) {
                        ++i;
                    }
                    String rest = message.substring(i);
                    if (!rest.equals(error) && !rest.equals(errors)) {
                        formattedString.append("<TR><TD COLSPAN=2 VALIGN=TOP><PRE>");
                        formattedString.append(message);
                        formattedString.append("</PRE></TD></TR>\n");
                    }
                }
            }
            currI = nextI + 1;
        }
        formattedString.append("</TABLE>\n");
        return formattedString.toString();
    }

    private static int findEndOfErrorStatement(String compilerOutput, int currI) {
        int nextArrow = compilerOutput.indexOf(94, currI);
        if (nextArrow != -1) {
            return compilerOutput.indexOf(10, nextArrow);
        }
        return compilerOutput.indexOf(10, currI);
    }

    private static String formatErrorMessage(String message) {
        StringBuffer sb = new StringBuffer(message);
        int i = 0;
        while (i < sb.length()) {
            char c = sb.charAt(i);
            String replace = null;
            switch (c) {
                case '&': {
                    replace = "&amp;";
                    break;
                }
                case '>': {
                    replace = "&gt;";
                    break;
                }
                case '<': {
                    replace = "&lt;";
                    break;
                }
                case '\"': {
                    replace = "&quot;";
                    break;
                }
            }
            if (replace != null) {
                sb.replace(i, i + 1, replace);
                i += replace.length() - 1;
            }
            ++i;
        }
        return sb.toString();
    }

    static {
        Class clazz = class$oracle$jdevimpl$jsp$JspOjcCompilerRes;
        if (clazz == null) {
            clazz = class$oracle$jdevimpl$jsp$JspOjcCompilerRes = JspOjcCompiler.class$("oracle.jdevimpl.jsp.JspOjcCompilerRes");
        }
        m_JspOjcCompilerResourceBundle = ResourceBundle.getBundle(clazz.getName());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

