/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel.quadros;

import br.gov.rs.tce.adf.util.DataBindingHelper;
import br.gov.rs.tce.adf.util.TCETable;
import br.gov.rs.tce.pad.beans.DetalheTotal;
import br.gov.rs.tce.pad.beans.Parametro;
import br.gov.rs.tce.pad.beans.QuadroContas;
import br.gov.rs.tce.pad.beans.QuadroTotal;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.excecao.ConfiguracaoException;
import br.gov.rs.tce.pad.resource.PadImage;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.PadWizardHelper;
import br.gov.rs.tce.pad.visao.panel.quadros.PainelQuadroTotal;
import br.gov.rs.tce.pad.visao.panel.quadros.TabelaAjusteListener;
import br.gov.rs.tce.pad.visao.panel.quadros.TelaQuadro;
import br.gov.rs.tce.pad.visao.panel.quadros.TelaQuadroComum;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.jbo.uicli.controls.JUPanel;
import oracle.jbo.uicli.controls.JUStatusBar;
import oracle.jbo.uicli.jui.JUTableBinding;
import oracle.jdeveloper.layout.XYConstraints;
import oracle.jdeveloper.layout.XYLayout;

public class QuadroAjusteValores
extends TelaQuadroComum
implements JUPanel,
TelaQuadro {
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel pnlRodape = new JPanel();
    private JPanel pnlTopo = new JPanel();
    private JButton btnPopup = new JButton();
    private XYLayout xYLayout1 = new XYLayout();
    private JUStatusBar sbNumRegistros = null;
    private JPanel pnlCentro = new JPanel();
    private JScrollPane spTabela = new JScrollPane();
    private BorderLayout borderLayoutCentro = new BorderLayout();
    private TCETable tblAjusteValores = new TCETable();
    private PainelQuadroTotal pnlTotal = new PainelQuadroTotal();
    private JLabel lblTitulo = new JLabel();
    private JLabel lblTituloTabela = null;
    private JPanel pnlSuperior = new JPanel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private JPanel pnlEspacoTopo = new JPanel();
    private JScrollPane spSuperior = new JScrollPane();
    private TCETable tblQuadroTopo = new TCETable();
    private TabelaAjusteListener listenerAjustesTotal = new TabelaAjusteListener();
    private XYLayout xYLayout2 = new XYLayout();

    @Override
    protected void jbInit() throws Exception {
        this.spSuperior.setHorizontalScrollBarPolicy(31);
        this.spSuperior.setPreferredSize(new Dimension(603, 30));
        this.setLayout(this.borderLayout1);
        this.pnlRodape.setSize(new Dimension(620, 20));
        this.pnlRodape.setPreferredSize(new Dimension(620, 22));
        this.pnlRodape.setLayout((LayoutManager)this.xYLayout1);
        this.pnlTopo.setSize(new Dimension(620, 16));
        this.pnlTopo.setPreferredSize(new Dimension(620, 16));
        this.btnPopup.setIcon(PadImage.createImageIcon("imagens/icone_selecao.png"));
        this.btnPopup.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.btnPopup.setPreferredSize(new Dimension(20, 20));
        this.btnPopup.setSize(new Dimension(22, 25));
        this.btnPopup.setToolTipText("Clique para selecionar as contas");
        this.btnPopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuadroAjusteValores.this.btnPopup_actionPerformed(e);
            }
        });
        this.pnlCentro.setLayout(this.borderLayoutCentro);
        this.pnlSuperior.setLayout(this.borderLayout2);
        this.tblAjusteValores.setAutoResizeMode(0);
        this.tblAjusteValores.setFont(new Font("SansSerif", 0, 10));
        this.pnlTotal.setMinimumSize(new Dimension(300, 20));
        this.pnlTotal.setSize(new Dimension(600, 14));
        this.pnlRodape.add((Component)this.btnPopup, new XYConstraints(550, 0, 23, 22));
        this.add((Component)this.pnlRodape, "South");
        this.pnlTopo.add((Component)this.lblTitulo, new XYConstraints(10, 0, 610, 15));
        this.add((Component)this.pnlTopo, "North");
        this.spTabela.getViewport().add((Component)this.tblAjusteValores, null);
        this.pnlCentro.add((Component)this.spTabela, "Center");
        this.pnlCentro.add((Component)this.pnlTotal, "South");
        this.pnlSuperior.add((Component)this.pnlEspacoTopo, "East");
        this.spSuperior.getViewport().add((Component)this.tblQuadroTopo, null);
        this.pnlSuperior.add((Component)this.spSuperior, "Center");
        this.pnlCentro.add((Component)this.pnlSuperior, "North");
        this.add((Component)this.pnlCentro, "Center");
        this.tblQuadroTopo.setFont(new Font("SansSerif", 0, 10));
        this.pnlTopo.setLayout((LayoutManager)this.xYLayout2);
        this.lblTitulo.setText("Titulo quadro");
        this.tblQuadroTopo.setAutoscrolls(false);
        this.spSuperior.setHorizontalScrollBarPolicy(31);
        this.spSuperior.setVerticalScrollBarPolicy(21);
        this.spTabela.setVerticalScrollBarPolicy(22);
        this.spTabela.setHorizontalScrollBarPolicy(31);
        this.tblQuadroTopo.setAutoResizeMode(0);
        this.pnlEspacoTopo.setSize(new Dimension(16, 30));
        this.pnlEspacoTopo.setPreferredSize(new Dimension(17, 10));
        this.pnlSuperior.setPreferredSize(new Dimension(600, 30));
        this.ajustaTamanhoColunas(this.tblAjusteValores, this.getColunasQuadro(), this.getTamanhoColunas());
        this.ajustaTamanhoColunas(this.tblQuadroTopo, this.getColunasQuadro(), new int[0]);
        super.jbInit();
        this.lblTitulo.setFont(new Font("Tahoma", 1, 11));
        this.tblAjusteValores.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                QuadroAjusteValores.this.tblAjusteValores_mouseClicked(e);
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                QuadroAjusteValores.this.tblAjusteValores.clearSelection();
            }
        });
    }

    @Override
    protected void inicializaPropriedadesTela(Remessa remessa, QuadroContas quadroContas) {
        this.tblAjusteValores.getTableHeader().setReorderingAllowed(false);
        this.tblQuadroTopo.getTableHeader().setReorderingAllowed(false);
        this.tblAjusteValores.getTableHeader().setDefaultRenderer(DEFAULT_HEADER_CELL_RENDERER);
        this.tblQuadroTopo.getTableHeader().setDefaultRenderer(DEFAULT_HEADER_CELL_RENDERER);
        if (quadroContas != null) {
            String tituloQuadro;
            if (quadroContas.getAlturaQuadro() > 0) {
                this.setSize((int)this.getSize().getWidth(), quadroContas.getAlturaQuadro());
                this.setPreferredSize(this.getSize());
            }
            if ((tituloQuadro = quadroContas.getTituloFormatado(remessa)) != null) {
                this.lblTitulo.setText(tituloQuadro);
                int numeroLinhas = this.lblTitulo.getText().split("\n").length + this.lblTitulo.getText().split("<br>").length - 1;
                if (numeroLinhas > 1) {
                    this.pnlTopo.remove(this.lblTitulo);
                    this.pnlTopo.add((Component)this.lblTitulo, new XYConstraints(0, 0, 610, 15 * numeroLinhas));
                    this.pnlTopo.setSize(new Dimension(620, 16 * numeroLinhas));
                    this.pnlTopo.setPreferredSize(new Dimension(620, 16 * numeroLinhas));
                }
            }
            this.pnlTopo.setVisible(tituloQuadro != null && tituloQuadro.length() > 5);
            QuadroContas qSuperior = quadroContas.getQuadroContasSuperior();
            if (qSuperior != null && qSuperior.getAlturaQuadro() > 0) {
                this.pnlSuperior.setSize((int)this.pnlSuperior.getSize().getWidth(), qSuperior.getAlturaQuadro());
                this.pnlSuperior.setPreferredSize(this.pnlSuperior.getSize());
            }
            this.pnlSuperior.setVisible(qSuperior != null);
            this.btnPopup.setVisible(quadroContas.getTelaPopup() != null);
            this.pnlRodape.setVisible(this.btnPopup.isVisible());
            this.pnlTotal.setVisible(quadroContas.getQuadroTotal() != null);
            QuadroAjusteValores.desabilitaReziseColunasJTable(this.tblAjusteValores);
            QuadroAjusteValores.desabilitaReziseColunasJTable(this.tblQuadroTopo);
        }
    }

    @Override
    protected void initializaDataBindingsEspecificos(BindingContext bindCtx, QuadroContas quadroContas) {
        TabelaAjusteListener newAjusteListener;
        this.inicializaBindingQuadroSuperior(bindCtx, quadroContas.getQuadroContasSuperior());
        this.inicializaBindingQuadro(quadroContas, this.tblAjusteValores, this.sbNumRegistros);
        this.pnlTotal.setPanelBinding(this._panelBinding);
        this.listenerAjustesTotal.setListenerBindingContext(bindCtx);
        Parametro paramClasse = this._quadroContas.getParametroPorNome("classe-listener-total");
        if (paramClasse != null && (newAjusteListener = this.criaClasseListener(paramClasse)) != null) {
            this.listenerAjustesTotal = newAjusteListener;
        }
        this.inicializaBindingQuadroTotal(bindCtx, quadroContas.getQuadroTotal());
        this.inicializaListenerAjustesTabela(this.listenerAjustesTotal);
        QuadroAjusteValores.inicializaTableRenderers(this.tblAjusteValores, quadroContas, quadroContas.getControlBindingName(), this._panelBinding);
        QuadroAjusteValores.configuraColunasDesabilitadas(bindCtx, this.tblAjusteValores, quadroContas);
        if (quadroContas.getQuadroContasSuperior() != null) {
            QuadroAjusteValores.inicializaTableRenderers(this.tblQuadroTopo, quadroContas, quadroContas.getQuadroContasSuperior().getControlBindingName(), this._panelBinding);
        }
    }

    private void inicializaListenerAjustesTabela(TabelaAjusteListener listener) {
        this.tblQuadroTopo.getModel().addTableModelListener(listener);
        this.tblAjusteValores.getModel().addTableModelListener(listener);
    }

    protected void adicionaNomeVOTotal(String nomeVO) {
        this.listenerAjustesTotal.adicionaNomeVOTotal(nomeVO);
    }

    private void inicializaBindingQuadroSuperior(BindingContext bindCtx, QuadroContas quadroSuperior) {
        if (quadroSuperior != null) {
            String nomeViewObject = quadroSuperior.getNomeViewObject();
            if (nomeViewObject == null) {
                throw new IllegalArgumentException("Nome do viewObject \u00e9 nulo para o quadro: " + quadroSuperior.getNome());
            }
            DCIteratorBinding iter = DataBindingHelper.adicionaIteratorBinding(this._bindingContext, this._panelBinding, DataBindingHelper.criaNomeIteratorDef(quadroSuperior.getNome()), "ContasModuleDataControl", nomeViewObject, this._iteratorNames);
            String quadroControlBindingName = DataBindingHelper.criaNomeTableDef(quadroSuperior.getNome());
            quadroSuperior.setControlBindingName(quadroControlBindingName);
            JUTableBinding tableBinding = DataBindingHelper.adicionaTableBinding(this._bindingContext, this._panelBinding, quadroControlBindingName, quadroSuperior.getColunasQuadroArray(), iter.getName(), this._tableControlNames);
            this.tblQuadroTopo.setModel((TableModel)this.getPanelBinding().bindUIControl(quadroControlBindingName, (Object)this.tblQuadroTopo));
        }
    }

    private void inicializaBindingQuadroTotal(BindingContext bindCtx, QuadroTotal quadroTotal) {
        if (quadroTotal != null) {
            this.pnlTotal.inicializaBindingQuadroTotal(bindCtx, quadroTotal, this._iteratorNames, this._tableControlNames);
            this.adicionaNomeVOTotal(quadroTotal.getNomeViewObject());
            DetalheTotal detalhe = quadroTotal.getDetalheTotal();
            if (detalhe != null) {
                this.adicionaNomeVOTotal(detalhe.getNomeViewObject());
            }
        }
    }

    @Override
    protected void ajustaLabelsQuadro(Remessa remessa, QuadroContas quadro) throws IllegalArgumentException {
        QuadroTotal qTotal;
        if (quadro.getQuadroContasSuperior() != null) {
            String titulo = quadro.getQuadroContasSuperior().getTitulo();
            if (titulo != null) {
                this.lblTituloTabela = new JLabel(titulo);
                this.lblTituloTabela.setFont(new Font("Tahoma", 1, 11));
                this.tblAjusteValores.setCustomHeader(this.lblTituloTabela);
            } else {
                JTableHeader header = this.tblAjusteValores.getTableHeader();
                header.setVisible(false);
                this.spTabela.setColumnHeaderView(null);
                this.spTabela.setColumnHeader(null);
            }
        }
        TableColumnModel modeloColunasQuadro = this.tblAjusteValores.getTableHeader().getColumnModel();
        if (quadro.hasTituloColunas()) {
            String[] titulos = quadro.getTituloColunasArray();
            if (titulos.length != modeloColunasQuadro.getColumnCount()) {
                throw new IllegalArgumentException("O numero de t\u00edtulos de colunas do quadro [" + titulos.length + "] n\u00e3o corresponde ao n\u00famero de colunas exibidas no quadro [" + modeloColunasQuadro.getColumnCount() + "] [quadro=" + quadro.getNome() + "]");
            }
            for (int i = 0; i < titulos.length; ++i) {
                TableColumn coluna = modeloColunasQuadro.getColumn(i);
                coluna.setHeaderValue(titulos[i]);
            }
        }
        if ((qTotal = quadro.getQuadroTotal()) != null) {
            this.pnlTotal.ajustaLabelsQuadro(remessa, qTotal);
        }
    }

    @Override
    public void finalizaTelaEspecifico() {
    }

    private TabelaAjusteListener criaClasseListener(Parametro paramClasse) {
        if (paramClasse != null) {
            String nomeClasseListener = paramClasse.getValor();
            try {
                Class<?> classeListener = Class.forName(nomeClasseListener);
                TabelaAjusteListener listenerAjusteTotal = (TabelaAjusteListener)classeListener.newInstance();
                listenerAjusteTotal.setListenerBindingContext(this._bindingContext);
                return listenerAjusteTotal;
            }
            catch (ClassNotFoundException e) {
                throw new ConfiguracaoException("Classe de Listener Total do Quadro " + this._quadroContas.getNome() + " n\u00e3o foi encontrada: " + nomeClasseListener);
            }
            catch (InstantiationException e) {
                throw new ConfiguracaoException("Classe de Listener Total do Quadro " + this._quadroContas.getNome() + " n\u00e3o foi instanciada com sucesso: " + nomeClasseListener);
            }
            catch (IllegalAccessException iae) {
                throw new ConfiguracaoException("Classe de Listener Total do Quadro " + this._quadroContas.getNome() + " n\u00e3o foi instanciada com sucesso: " + nomeClasseListener);
            }
        }
        return null;
    }

    private void tblAjusteValores_mouseClicked(MouseEvent mouseEvent) {
        Parametro paramClasse;
        if (mouseEvent.getClickCount() >= 1 && (paramClasse = this._quadroContas.getParametroPorNome("classe-popup-quadro")) != null) {
            String nomeClassePopup = paramClasse.getValor();
            try {
                Class<?> classePopup = Class.forName(nomeClassePopup);
                JDialog popup = (JDialog)classePopup.getConstructor(JFrame.class).newInstance(PadWizardHelper.getInstance().getForm());
                popup.setModal(true);
                ((PadModelo)((Object)popup)).setBindingContext(this._bindingContext);
                popup.setLocationRelativeTo(this);
                popup.show();
            }
            catch (InvocationTargetException e) {
                throw new ConfiguracaoException("Classe da popup do Quadro " + this._quadroContas.getNome() + " n\u00e3o foi pode ser instanciada: " + nomeClassePopup);
            }
            catch (NoSuchMethodException e) {
                throw new ConfiguracaoException("Classe da popup do Quadro " + this._quadroContas.getNome() + " n\u00e3o foi pode ser instanciada: " + nomeClassePopup);
            }
            catch (ClassNotFoundException e) {
                throw new ConfiguracaoException("Classe da popup do Quadro " + this._quadroContas.getNome() + " n\u00e3o foi encontrada: " + nomeClassePopup);
            }
            catch (InstantiationException e) {
                throw new ConfiguracaoException("Classe da popup do Quadro " + this._quadroContas.getNome() + " n\u00e3o foi instanciada com sucesso: " + nomeClassePopup);
            }
            catch (IllegalAccessException iae) {
                throw new ConfiguracaoException("Classe da popup do Quadro " + this._quadroContas.getNome() + " n\u00e3o foi instanciada com sucesso: " + nomeClassePopup);
            }
        }
    }
}

