/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel.action;

import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.beans.remessa.RemessaInfo;
import br.gov.rs.tce.pad.excecao.PADActionException;
import br.gov.rs.tce.pad.modelo.ConstantesArquivos;
import br.gov.rs.tce.pad.modelo.RemessaControle;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.util.CompactacaoHelper;
import br.gov.rs.tce.pad.util.CopiaArquivoEvent;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.PadWizardForm;
import br.gov.rs.tce.pad.visao.PadWizardHelper;
import br.gov.rs.tce.pad.visao.action.PadAbstractAction;
import br.gov.rs.tce.pad.visao.panel.TelaUC077A;
import java.awt.Component;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.adf.model.BindingContext;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;

public class ActionAvancarUC077A
extends PadAbstractAction {
    private String resposta = null;
    private int sequencia = 1;

    @Override
    public boolean executaAction(PadModelo tela, BindingContext binding) throws PADActionException {
        Row r;
        System.out.println("Action Avan\u00e7ar da TelaUC077A executada...");
        boolean retorno = false;
        ServicoPAD ser = ActionAvancarUC077A.getServicoPADAppModule(binding);
        ViewObject vo = ser.findViewObject("EntIndiretasDaEntidade");
        Remessa remessaPrincipal = this.getRemessaPrincipal(binding);
        Integer cdEntidadeOri = remessaPrincipal.getCdEntidade();
        String cnpjOri = remessaPrincipal.getCnpjEntidade();
        TelaUC077A t = (TelaUC077A)tela;
        if (!t.validaTela()) {
            return false;
        }
        this.resposta = t.getArquivo();
        if (this.resposta != null && vo != null && (r = vo.getCurrentRow()) != null) {
            String cdEntidade = "" + r.getAttribute("CdEntidade");
            String cnpj = "" + r.getAttribute("Cnpj");
            String cdOrgao = "" + r.getAttribute("CodOrgao");
            PadWizardForm form = PadWizardHelper.getInstance().getForm();
            File f = new File(this.resposta);
            try {
                Integer cdOrgaoi = 1;
                try {
                    cdOrgaoi = Integer.parseInt(cdOrgao);
                }
                catch (Exception e) {
                    System.out.println("erro convertendo cd_entidade para inteiro");
                }
                Remessa remessa = ActionAvancarUC077A.getRemessaDataControl(binding);
                remessa.setCnpjEntidade(cnpj);
                remessa.setCdRemessa(1);
                remessa.setCdEntidade(cdOrgaoi);
                ser.deletaRemessa(remessa);
                this.setSequencia(1);
                RemessaControle ctrl = new RemessaControle(remessa, new File(ConstantesArquivos.PATH_GRAVACAO_DESKTOP));
                NotificaEventos notifica = new NotificaEventos(form);
                RemessaInfo remInfo = ctrl.recuperaArquivosRemessa(f, notifica);
                if (remInfo == null) {
                    return false;
                }
                if (!remessa.getCnpjEntidade().equals(remInfo.getCnpjEntidade())) {
                    retorno = false;
                    log.info((Object)("remessa.getCnpjEntidade() == " + remessa.getCnpjEntidade() + " ; remInfo.getCnpjEntidade() == " + remInfo.getCnpjEntidade()));
                    ActionAvancarUC077A.exibeMensagemAviso("Entidade encontrada no sistema n\u00e3o corresponde a entidade indireta da Remessa", form);
                } else if (remessa.getPeriodoInformacoes() != remInfo.getPeriodoInformacoes().intValue()) {
                    retorno = false;
                    ActionAvancarUC077A.exibeMensagemAviso("Periodo de informa\u00e7\u00f5es da indireta n\u00e3o \u00e9 o mesmo da Prefeitura", form);
                } else if (!remessa.getTipoEntrega().equals(remInfo.getTipoEntrega())) {
                    retorno = false;
                    ActionAvancarUC077A.exibeMensagemAviso("Tipo de periodicidade de entrega da indireta n\u00e3o \u00e9 o mesmo da Prefeitura", form);
                } else {
                    ctrl.consolidacaoPrefeitura(ser);
                    retorno = true;
                    r.setAttribute("StatusConsolidacao", (Object)1);
                    ser.getTransaction().executeCommand("update remessas set remessa_principal = 'N' where cd_entidade != " + remessaPrincipal.getCdEntidade());
                    ser.getTransaction().commit();
                    ser.insereCodigosBarraRemessa(remInfo);
                    ser.getTransaction().commit();
                    retorno = true;
                }
                remessa.setCdEntidade(cdEntidadeOri);
                remessa.setCnpjEntidade(cnpjOri);
            }
            catch (Exception e) {
                e.printStackTrace();
                ser.getTransaction().rollback();
                retorno = false;
                try {
                    ser.getTransaction().executeCommand("update remessas set remessa_principal = 'N' where cd_entidade != " + remessaPrincipal.getCdEntidade());
                    ser.getTransaction().commit();
                }
                catch (Exception ex) {
                    log.error((Object)ex);
                }
                log.error((Object)"erro no actionavancarUC077A ", (Throwable)e);
                ActionAvancarUC077A.exibeMensagemAviso("Ocorreu um erro inesperado na consolidacao. Repita o processo para a entidade indireta.", form);
            }
        }
        return retorno;
    }

    public void setSequencia(int sequencia) {
        this.sequencia = sequencia;
    }

    public int getSequencia() {
        return this.sequencia;
    }

    class NotificaEventos
    implements ChangeListener {
        Component _form;

        NotificaEventos(Component form) {
            this._form = form;
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            CopiaArquivoEvent copia = (CopiaArquivoEvent)event;
            TelaUC077A tela = new TelaUC077A();
            CompactacaoHelper comp = (CompactacaoHelper)event.getSource();
            switch (copia.getSituacao()) {
                case -5: {
                    JOptionPane.showMessageDialog(this._form, "Arquivo de remessa n\u00e3o \u00e9 valido. Insira o arquivo com a Remessa e ap\u00f3s clique em \"Consolidar\".", "Informa\u00e7\u00e3o", 2);
                    comp.setSituacao(false);
                    break;
                }
                case -3: {
                    ActionAvancarUC077A.this.setSequencia(ActionAvancarUC077A.this.getSequencia() + 1);
                    File f = null;
                    f = ActionAvancarUC077A.this.getSequencia() >= 10 ? new File(ActionAvancarUC077A.this.resposta.substring(0, ActionAvancarUC077A.this.resposta.length() - 2) + ActionAvancarUC077A.this.getSequencia()) : new File(ActionAvancarUC077A.this.resposta.substring(0, ActionAvancarUC077A.this.resposta.length() - 2) + "0" + ActionAvancarUC077A.this.getSequencia());
                    if (f.exists()) {
                        comp.setSituacao(true);
                        ActionAvancarUC077A.this.resposta = f.getAbsolutePath();
                        tela.setArquivo(ActionAvancarUC077A.this.resposta);
                        break;
                    }
                    if (ActionAvancarUC077A.this.resposta.startsWith("C")) {
                        JOptionPane.showMessageDialog(this._form, "Seq\u00fc\u00eancia de arquivo de remessa n\u00e3o localizado no caminho informado. \n\rVoc\u00ea deve colocar todos os arquivos da remessa da entidade no mesmo diret\u00f3rio.", "Informa\u00e7\u00e3o", 0);
                        comp.setSituacao(false);
                        break;
                    }
                    comp.setSituacao(JOptionPane.showConfirmDialog(this._form, copia.getMensagem(), "Informa\u00e7\u00e3o", 2) == 0);
                    break;
                }
                case -7: {
                    JOptionPane.showConfirmDialog(this._form, "Disquete ou Cd n\u00e3o localizados. Favor inserir midia.", "Informa\u00e7\u00e3o", 2);
                    comp.setSituacao(false);
                }
            }
        }
    }
}

