/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel.action;

import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.excecao.FormatoInvalidoException;
import br.gov.rs.tce.pad.excecao.PADActionException;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.util.ValidaCNPJ;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.action.PadAbstractAction;
import br.gov.rs.tce.pad.visao.panel.TelaUC039B;
import oracle.adf.model.BindingContext;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;

public class ActionAvancarUC039B
extends PadAbstractAction {
    @Override
    public boolean executaAction(PadModelo tela, BindingContext binding) throws PADActionException {
        TelaUC039B _tela = (TelaUC039B)tela;
        if (!this.validaCNPJ(_tela)) {
            return false;
        }
        Remessa remessa = ActionAvancarUC039B.getRemessaSemAnoBiDataControl(binding);
        ServicoPAD ser = ActionAvancarUC039B.getServicoPADAppModule(binding);
        ViewObject voRemessa = ser.findViewObject("DadosRemessaCamara");
        Row remessaRow = voRemessa.getCurrentRow();
        if (!_tela.validaCampos()) {
            return false;
        }
        ActionAvancarUC039B.getServicoPADAppModule(binding).getTransaction().commit();
        return true;
    }

    private boolean validaCNPJ(TelaUC039B _tela) {
        boolean retorno = true;
        try {
            if (_tela.getCnpjEntidade().equals("")) {
                ActionAvancarUC039B.exibeMensagemAviso("O CNPJ precisa ser informado.", _tela);
                retorno = false;
            }
            if (!ValidaCNPJ.validaCnpj(_tela.getCnpjEntidade())) {
                ActionAvancarUC039B.exibeMensagemAviso("O CNPJ informado \u00e9 inv\u00e1lido.", _tela);
                retorno = false;
            }
        }
        catch (FormatoInvalidoException e) {
            retorno = false;
            e.printStackTrace();
            ActionAvancarUC039B.exibeMensagemAviso("O CNPJ informado \u00e9 inv\u00e1lido.", _tela);
            return retorno;
        }
        return retorno;
    }
}

