/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel;

import br.gov.rs.tce.pad.util.ValidaCNPJ;
import br.gov.rs.tce.pad.visao.panel.CusteioBean;
import br.gov.rs.tce.pad.visao.panel.CusteioTableModel;
import br.gov.rs.tce.pad.visao.panel.TelaUC228B;
import br.gov.rs.tce.pad.visao.swing.DecimalInputVerifier;
import br.gov.rs.tce.pad.visao.util.SpringUtilities;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

class CusteioDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    JLabel lCnpj = new JLabel("CNPJ");
    JLabel lNomeOrgao = new JLabel("\u00d3rg\u00e3o");
    JLabel lCodigoND = new JLabel("C\u00f3d. Natureza Despesa");
    JLabel lValor = new JLabel("Valor");
    JLabel lDescricao = new JLabel("Descri\u00e7\u00e3o");
    JLabel lJustificativa = new JLabel("Justificativa");
    JTextField tfCnpj = new JTextField();
    JTextField tfNomeOrgao = new JTextField();
    JTextField tfCodigoND = new JTextField();
    JTextField tfValor = new JTextField();
    JTextArea tfDescricao = new JTextArea();
    JTextArea tfJustificativa = new JTextArea();
    JButton btnOk = new JButton("Salvar");
    JButton btnCancel = new JButton("Cancelar");
    CusteioTableModel tableModel;
    Integer editRow;

    CusteioDialog(CusteioTableModel tableModel) {
        System.out.println("tableModel==" + tableModel);
        this.tableModel = tableModel;
        this.setModal(true);
        this.setTitle("Edi\u00e7\u00e3o de Custeio");
        this.tfValor.setInputVerifier(new DecimalInputVerifier(TelaUC228B.nf));
        SpringLayout layout = new SpringLayout();
        Container contentPane = this.getContentPane();
        JPanel p = new JPanel(layout);
        contentPane.add(p);
        this.lCnpj.setLabelFor(this.tfCnpj);
        p.add(this.lCnpj);
        p.add(this.tfCnpj);
        this.lNomeOrgao.setLabelFor(this.tfNomeOrgao);
        p.add(this.lNomeOrgao);
        p.add(this.tfNomeOrgao);
        this.lCodigoND.setLabelFor(this.tfCodigoND);
        p.add(this.lCodigoND);
        p.add(this.tfCodigoND);
        this.lValor.setLabelFor(this.tfValor);
        p.add(this.lValor);
        p.add(this.tfValor);
        this.lDescricao.setLabelFor(this.tfDescricao);
        p.add(this.lDescricao);
        JScrollPane spDescricao = new JScrollPane(this.tfDescricao);
        p.add(spDescricao);
        this.lJustificativa.setLabelFor(this.tfJustificativa);
        p.add(this.lJustificativa);
        JScrollPane spJustificativa = new JScrollPane(this.tfJustificativa);
        p.add(spJustificativa);
        JPanel panelBtns = p;
        panelBtns.add(this.btnCancel);
        panelBtns.add(this.btnOk);
        this.btnOk.addActionListener(this);
        this.btnCancel.addActionListener(this);
        int numPairs = 7;
        SpringUtilities.makeCompactGrid(p, numPairs, 2, 6, 6, 6, 6);
        this.setSize(500, 300);
        this.setLocationRelativeTo(null);
    }

    void setBean(CusteioBean bean, Integer currentRow) {
        if (bean != null) {
            this.tfCnpj.setText(bean.cnpj);
            this.tfNomeOrgao.setText(bean.nomeOrgao);
            this.tfCodigoND.setText(bean.codigoND);
            this.tfValor.setText(TelaUC228B.nf.format(bean.valor));
            this.tfDescricao.setText(bean.descricao);
            this.tfJustificativa.setText(bean.justificativa);
            this.editRow = currentRow;
        } else {
            this.tfCnpj.setText("");
            this.tfNomeOrgao.setText("");
            this.tfCodigoND.setText("");
            this.tfValor.setText("");
            this.tfDescricao.setText("");
            this.tfJustificativa.setText("");
            this.editRow = null;
        }
    }

    CusteioBean getBean() {
        CusteioBean cb = new CusteioBean();
        cb.cnpj = this.tfCnpj.getText();
        cb.nomeOrgao = this.tfNomeOrgao.getText();
        cb.codigoND = this.tfCodigoND.getText();
        String valorStr = this.tfValor.getText();
        try {
            cb.valor = valorStr != null && !valorStr.equals("") ? Double.valueOf(TelaUC228B.nf.parse(valorStr).doubleValue()) : Double.valueOf(0.0);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Valor inv\u00e1lido: " + valorStr);
        }
        cb.descricao = this.tfDescricao.getText();
        cb.justificativa = this.tfJustificativa.getText();
        return cb;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.btnOk)) {
            CusteioBean cb = null;
            try {
                cb = this.getBean();
            }
            catch (IllegalArgumentException ex) {
                String message = "Error: parse: " + ex;
                TelaUC228B.log.warn((Object)message);
                JOptionPane.showMessageDialog(this, ex.getMessage(), "Custeio", 2);
                return;
            }
            boolean valido = ValidaCNPJ.validaCnpjSemExcecao(cb.cnpj);
            if (!valido) {
                JOptionPane.showMessageDialog(this, "CNPJ '" + cb.cnpj + "' inv\u00e1lido", "Custeio", 2);
                return;
            }
            cb.cnpj = ValidaCNPJ.formataCnpj(cb.cnpj);
            if (!TelaUC228B.validaCodigoND.validaPadrao(cb.codigoND)) {
                JOptionPane.showMessageDialog(this, "C\u00f3digo de Natureza de Despesa '" + cb.codigoND + "' inv\u00e1lido\nInforme C\u00f3digo de Natureza de Despesa com 8 d\u00edgitos", "Custeio", 2);
                return;
            }
            cb.codigoND = TelaUC228B.validaCodigoND.formataPadrao(cb.codigoND);
            if (cb.nomeOrgao.length() <= 3) {
                JOptionPane.showMessageDialog(this, "Nome do \u00d3rg\u00e3o '" + cb.nomeOrgao + "' inv\u00e1lido", "Custeio", 2);
                return;
            }
            if (cb.descricao.length() > 500) {
                JOptionPane.showMessageDialog(this, "Descri\u00e7\u00e3o do Custeio n\u00e3o pode ter mais que 500 caracteres", "Custeio", 2);
                return;
            }
            if (cb.justificativa.length() > 500) {
                JOptionPane.showMessageDialog(this, "Justificativa para o Custeio n\u00e3o pode ter mais que 500 caracteres", "Custeio", 2);
                return;
            }
            if (this.editRow == null) {
                this.tableModel.add(cb);
            } else {
                this.tableModel.update(this.editRow, cb);
            }
            this.setVisible(false);
        } else if (e.getSource().equals(this.btnCancel)) {
            this.setVisible(false);
        } else {
            String message = "Error: unknown button " + e.getSource();
            TelaUC228B.log.warn((Object)message);
            JOptionPane.showMessageDialog(this, message, "Custeio", 2);
        }
    }
}

