/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.util;

import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.beans.types.MesList;
import java.util.Arrays;

public class RemessaUtil {
    public static boolean ehGrupoEntregaDC(int grupoBusca) {
        Arrays.sort(Remessa.GRUPOS_RELATORIO_DC);
        return Arrays.binarySearch(Remessa.GRUPOS_RELATORIO_DC, grupoBusca) >= 0;
    }

    public static boolean ehMesEntregaLRF(int mes, String tipoEntrega) {
        if (!MesList.ehMesPar(mes)) {
            return false;
        }
        int periodo = mes / 2;
        if ((periodo == 4 || periodo == 2) && tipoEntrega.equals("Q")) {
            return true;
        }
        if (periodo == 3 && tipoEntrega.equals("S")) {
            return true;
        }
        return periodo == 6;
    }

    public static boolean ehMesQuePodeHaverEntregaLRF(int mes) {
        if (!MesList.ehMesPar(mes)) {
            return false;
        }
        int periodo = mes / 2;
        if (periodo == 4 || periodo == 2) {
            return true;
        }
        if (periodo == 3) {
            return true;
        }
        return periodo == 6;
    }

    public static boolean ehDezembro(int mes) {
        return mes == 12;
    }

    public static boolean ehMesPar(int mes) {
        return mes % 2 == 0;
    }

    public static boolean ehMesQuadrimestre(int mes) {
        return mes % 4 == 0;
    }

    public static boolean ehMesSemestre(int mes) {
        return mes % 6 == 0;
    }

    public static boolean ehEntidadePublica(String tipoSetor) {
        return tipoSetor.equals("P") || tipoSetor.equals("C") || tipoSetor.equals("A") || tipoSetor.equals("F") || tipoSetor.equals("M");
    }

    public static boolean ehEntidadePublicaQueConsolida(String tipoSetor) {
        return tipoSetor.equals("P") || tipoSetor.equals("A") || tipoSetor.equals("F") || tipoSetor.equals("M");
    }

    public static boolean ehIndiretaQueConsolida(String tipoSetor) {
        return tipoSetor.equals("A") || tipoSetor.equals("F") || tipoSetor.equals("M");
    }
}

